indexing

	description:

		"Filesystem's directories"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 1999-2001, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 12:49:51 $"
	revision: "$Revision: 1.20 $"

class KL_DIRECTORY

inherit

	KI_DIRECTORY

	KL_SHARED_FILE_SYSTEM
		export {NONE} all end

	KL_IMPORTED_STRING_ROUTINES
		export {NONE} all end

















creation

	make

feature {NONE} -- Initialization

	make (a_name: STRING) is
			-- Create a new directory object.
			-- (`a_name' should follow the pathname convention
			-- of the underlying platform. For pathname conversion
			-- use KI_FILE_SYSTEM.pathname_from_file_system.)
		do
			name := a_name




			string_name := STRING_.as_string (a_name)







		end

feature -- Access

	name: STRING
			-- Directory name;
			-- Note: If `name' is a UC_STRING or descendant, then
			-- the bytes of its associated UTF unicode encoding will
			-- be used.

	last_entry: STRING
			-- Last entry (file or subdirectory name) read
			-- (Note: this query returns the new object after
			-- each call to `read_entry'.)

	filenames: ARRAY [STRING] is
			-- Names of readable files in current directory;
			-- Void if current directory could not be searched
		local
			a_name: STRING
			an_array: ARRAY [STRING]
			i, nb, k: INTEGER
		do
			if is_closed then
				open_read
				if is_open_read then
					k := 10
					create an_array.make (1, k)
					from read_entry until end_of_input loop
						a_name := last_entry
						tmp_file.reset (file_system.pathname (string_name, a_name))
						if tmp_file.is_readable then
							nb := nb + 1
							if nb > k then
								k := k + 10
								an_array.resize (1, k)
							end
							an_array.put (a_name, nb)
						end
						read_entry
					end
					close
					create Result.make (1, nb)
					from i := 1 until i > nb loop
						Result.put (an_array.item (i), i)
						i := i + 1
					end
				end
			else
				tmp_directory.reset (string_name)
				Result := tmp_directory.filenames
			end
		end

	directory_names: ARRAY [STRING] is
			-- Names of readable subdirectories in current directory;
			-- Void if current directory could not be searched
			-- (Do not include parent and current directory names.)
		local
			a_name: STRING
			an_array: ARRAY [STRING]
			i, nb, k: INTEGER
		do
			if is_closed then
				open_read
				if is_open_read then
					k := 10
					create an_array.make (1, k)
					from read_entry until end_of_input loop
						a_name := last_entry
						if
							not STRING_.same_string (a_name, file_system.relative_current_directory) and then
							not STRING_.same_string (a_name, file_system.relative_parent_directory)
						then
							tmp_directory.reset (file_system.pathname (string_name, a_name))
							if tmp_directory.is_readable then
								nb := nb + 1
								if nb > k then
									k := k + 10
									an_array.resize (1, k)
								end
								an_array.put (a_name, nb)
							end
						end
						read_entry
					end
					close
					create Result.make (1, nb)
					from i := 1 until i > nb loop
						Result.put (an_array.item (i), i)
						i := i + 1
					end
				end
			else
				tmp_directory.reset (string_name)
				Result := tmp_directory.directory_names
			end
		end

feature -- Status report

	is_open_read: BOOLEAN is
			-- Has directory been opened in read mode?
		do




			Result := basic_directory.is_connected

		end


	is_closed: BOOLEAN is
			-- Is directory closed?
		do

			Result := not basic_directory.is_connected



		end


	end_of_input: BOOLEAN
			-- Have all entries been read?

	exists: BOOLEAN is
			-- Does directory physically exist on disk?
			-- (Note that with SmallEiffel this routine
			-- actually returns `is_readable'.)
		do
			if string_name.count > 0 then










				Result := is_readable




			end
		end

	is_readable: BOOLEAN is
			-- Can directory be opened in read mode?
		do
			if string_name.count > 0 then









				if is_open_read then
					Result := True
				else
					open_read
					if is_open_read then
						Result := True
						close
					end
				end

			end
		end

feature -- Basic operations

	open_read is
			-- Try to open directory in read mode. Set `is_open_read'
			-- to true and is ready to read first entry in directory
			-- if operation was successful.
		local
			rescued: BOOLEAN
		do
			if not rescued then
				if string_name.count > 0 then
					entry_buffer := Void
					end_of_input := False

















					basic_directory.connect_to (string_name)




				end
			elseif not is_closed then
				close
			end
		rescue
			if not rescued then
				rescued := True
				retry
			end
		end

	close is
			-- Close directory if it is closable,
			-- let it open otherwise.
		local
			rescued: BOOLEAN
		do
			if not rescued then

				basic_directory.disconnect









				entry_buffer := Void
				last_entry := Void
			end
		rescue
			if not rescued then
				rescued := True
				retry
			end
		end

	create_directory is
			-- Create current directory on disk.
			-- Do nothing if the directory could not
			-- be created, if it already existed or if
			-- `name' is a nested directory name and
			-- the parent directory does not exist.
		local
			rescued: BOOLEAN

			b: BOOLEAN

		do
			if not rescued then
				if string_name.count > 0 then

					b := basic_directory.create_new_directory (string_name)









				end
			end
		rescue
			if not rescued then
				rescued := True
				retry
			end
		end

	recursive_create_directory is
			-- Create current directory on disk.
			-- Create its parent directories if they do not exist yet.
			-- Do nothing if the directory could not be created,
			-- if it already existed or `name' is a nested directory
			-- name and its parent directory does not exist and 
			-- could not be created.
		local
			a_dirname: STRING
			a_pathname: STRING
			a_dir: KL_DIRECTORY
		do
			create_directory
			if not exists then
				a_pathname := file_system.canonical_pathname (string_name)
				a_dirname := file_system.dirname (a_pathname)
				if not STRING_.same_string (a_dirname, a_pathname) then
					create a_dir.make (a_dirname)
					if not a_dir.exists then
						a_dir.recursive_create_directory
						if a_dir.exists then
							create_directory
						end
					end
				end
			end
		end

	delete is
			-- Delete current directory.
			-- Do nothing if the directory could not
			-- be deleted, if it did not exist or if
			-- it is not empty.
		local
			rescued: BOOLEAN

			b: BOOLEAN

		do
			if not rescued then
				if string_name.count > 0 then

					b := basic_directory.remove_directory (string_name)













				end
			end
		rescue
			if not rescued then
				rescued := True
				retry
			end
		end

	recursive_delete is
			-- Delete current directory, its files
			-- and its subdirectories recursively.
			-- Do nothing if the directory could not
			-- be deleted, if it did not exist.
		local
			rescued: BOOLEAN

			a_name: STRING
			a_dir: KL_DIRECTORY
			a_pathname: STRING

		do
			if not rescued then
				if string_name.count > 0 then

					open_read
					if is_open_read then
						from read_entry until end_of_input loop
							a_name := last_entry
							if
								not STRING_.same_string (a_name, file_system.relative_current_directory) and then
								not STRING_.same_string (a_name, file_system.relative_parent_directory)
							then
								a_pathname := file_system.pathname (string_name, a_name)
								if file_system.is_file_readable (a_pathname) then
									file_system.delete_file (a_pathname)
								else
									create a_dir.make (a_pathname)
									a_dir.recursive_delete
								end
							end
							read_entry
						end
						close
					end
					delete






				end
			end
		rescue
			if not rescued then
				rescued := True
				retry
			end
		end

feature -- Input

	read_entry is
			-- Read next entry in directory.
			-- Make result available in `last_entry'.
		do
			if entry_buffer /= Void then
				last_entry := entry_buffer.item
				entry_buffer := entry_buffer.right
			elseif old_end_of_input then
				end_of_input := True
			else





				basic_directory.read_entry
				last_entry := clone (basic_directory.last_entry)





				end_of_input := old_end_of_input
			end
		end

	unread_entry (an_entry: STRING) is
			-- Put `an_entry' back in input stream.
			-- This entry will be read first by the next
			-- call to a read routine.
		local
			a_cell: like entry_buffer
		do
			create a_cell.make (an_entry)
			if entry_buffer /= Void then
				a_cell.put_right (entry_buffer)
			end
			entry_buffer := a_cell
			last_entry := an_entry
			end_of_input := False
		end

feature {NONE} -- Implementation


	string_name: STRING
			-- Name of directory (STRING version)


	entry_buffer: KL_LINKABLE [STRING]
			-- Unread entries

	old_end_of_input: BOOLEAN is
			-- Have all entries been read
			-- (do not take `unread_entry' into account)?
		do




			Result := basic_directory.end_of_input




		end

	tmp_file: KL_TEXT_INPUT_FILE is
			-- Temporary file object
		once
			create Result.make (dummy_name)
		ensure
			file_not_void: Result /= Void
			file_closed: Result.is_closed
		end

	tmp_directory: KL_DIRECTORY is
			-- Temporary directory object
		once
			create Result.make (dummy_name)
		ensure
			directory_not_void: Result /= Void
			directory_closed: Result.is_closed
		end

	dummy_name: STRING is "dummy"
			-- Dummy name








	basic_directory: BASIC_DIRECTORY
			-- Internal data







invariant


	string_name_not_void: string_name /= Void

	string_name_is_string: string_name.same_type ("")
	no_void_bufferred_entry: entry_buffer /= Void implies entry_buffer.item /= Void




end
