indexing

	description:

		"Routines that ought to be in class DOUBLE"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 2003, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/26 20:04:54 $"
	revision: "$Revision: 1.10 $"

class KL_DOUBLE_ROUTINES














inherit
	MATH
		rename
			log as old_log,
			exp as old_exp
		export
			{NONE} all
		end


feature -- Logarithms

	log (d: DOUBLE): DOUBLE is
			-- Natural logarithm of `d'
		require
			d_positive: d > 0.0
		do










			Result := old_log (d.truncated_to_real)

		end

	log10 (d: DOUBLE): DOUBLE is
			-- Base 10 logarithm of `d'
		require
			d_positive: d > 0.0
		do










			Result := log (d) / log (10.0)

		end

feature -- Exponent

	exp (d: DOUBLE): DOUBLE is
			-- Inverse of the natural logarithm
		do







			Result := old_exp (d.truncated_to_real)

		end

	nth_root (d, n: DOUBLE): DOUBLE is
			-- `n'-th root of `d'
		require

			divisible: (1.0).divisible (n.truncated_to_real)



		do

			Result := d ^ (1.0 / n)




		end















end
