indexing

	description:

		"Eiffel expressions followed by a comma"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:03:24 $"
	revision: "$Revision: 1.7 $"

class ET_EXPRESSION_COMMA

inherit

	ET_EXPRESSION_ITEM

creation

	make

feature {NONE} -- Initialization

	make (an_expression: like expression; a_comma: like comma) is
			-- Create a new expression-comma.
		require
			an_expression_not_void: an_expression /= Void
			a_comma_not_void: a_comma /= Void
		do
			expression := an_expression
			comma := a_comma
		ensure
			expression_set: expression = an_expression
			comma_set: comma = a_comma
		end

feature -- Access

	expression: ET_EXPRESSION
			-- Expression in comma-separated list

	comma: ET_SYMBOL
			-- Comma separator

	position: ET_POSITION is
			-- Position of first character of
			-- current node in source code
		do
			Result := expression.position
		end

	break: ET_BREAK is
			-- Break which appears just after current node
		do
			Result := comma.break
		end

feature -- Processing

	process (a_processor: ET_AST_PROCESSOR) is
			-- Process current node.
		do
			a_processor.process_expression_comma (Current)
		end

invariant

	comma_not_void: comma /= Void

end
