indexing

	description:

		"Eiffel 'like identifier' or 'like *.identifier' types"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2003, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/06/08 05:41:15 $"
	revision: "$Revision: 1.13 $"

deferred class ET_LIKE_IDENTIFIER

inherit

	ET_LIKE_TYPE

feature -- Status report

	is_like_argument: BOOLEAN is
			-- Is this type a 'like argument' (rather than a
			-- 'like feature' or a 'like *.feature')?
		deferred
		end

feature -- Access

	name: ET_FEATURE_NAME is
			-- Name of the feature associated with current type
		deferred
		ensure
			name_not_void: Result /= Void
		end

	seed: INTEGER is
			-- Feature ID of one of the seeds of the
			-- feature associated with current type;
			-- 0 if not resolved yet
		deferred
		ensure
			seed_positive: Result >= 0
		end

end
