indexing

	description:

		"Echo commands"

	library: "Gobo Eiffel Ant"
	copyright: "Copyright (c) 2001, Sven Ehrke and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:14:21 $"
	revision: "$Revision: 1.14 $"

class GEANT_ECHO_COMMAND

inherit

	GEANT_COMMAND

creation

	make

feature -- Status report

	is_executable: BOOLEAN is
			-- Can command be executed?
		do
			Result := message /= Void
		ensure then
			message_not_void: Result implies message /= Void
		end

feature -- Access

	message: STRING
			-- Message to be echoed

feature -- Setting

	set_message (a_message: like message) is
			-- Set `message' to `a_message'.
		require
			a_message_not_void: a_message /= Void
		do
			message := a_message
		ensure
			message_set: message = a_message
		end

feature -- Execution

	execute is
			-- Execute command.
		do
			project.trace (<<"  [echo] ">>)
			project.log (<<message>>)
			exit_code := 0
		end

end
