indexing

	description:

		"Test 'gexace'"

	copyright: "Copyright (c) 2001-2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/02/07 13:24:21 $"
	revision: "$Revision: 1.4 $"

deferred class TEST_GEXACE

inherit

	TOOL_TEST_CASE

feature -- Access

	program_name: STRING is "gexace"
			-- Program name

feature -- Test

	test_gexace is
			-- Test 'gexace'.
		local
			gexace_exe: STRING
			xace_filename: STRING
			ace_filename: STRING
		do
			compile_program
			gexace_exe := program_exe
				-- Test <option name="recursive" value="true"/>
			xace_filename := file_system.pathname (sample_dirname, "system1.xace")
			ace_filename := file_system.pathname (sample_dirname, "ise1.ace")
			assert_execute (gexace_exe + " --system=ise " + xace_filename + output_log)
			if file_system.file_count (output_log_filename) = 0 then
				assert ("no_output_log1", True)
			elseif file_system.same_text_files (freeise_log_filename, output_log_filename) then
					-- Free version of ISE Eiffel?
				assert ("freeise_no_output_log", True)
			else
				assert_equal ("no_output_log2", 0, file_system.file_count (output_log_filename))
			end
			assert_equal ("no_error_log1", 0, file_system.file_count (error_log_filename))
			assert_files_equal ("diff1", ace_filename, "ise.ace")
		end

feature {NONE} -- Implementation

	sample_dirname: STRING is
			-- Name of directory where sample files are located
		once
			Result := file_system.nested_pathname ("${GOBO}", <<"test", "src", "gexace", "data">>)
			Result := Execution_environment.interpreted_string (Result)
		ensure
			sample_dirname_not_void: Result /= Void
			sample_dirname_not_empty: Result.count > 0
		end

end
