indexing
	
	description:
	
		"Test namespace resolution"
		
	library: "Gobo Eiffel XML Library"
	copyright: "Copyright (c) 2002, Eric Bezault and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2003/07/23 01:21:46 $"
	revision: "$Revision: 1.1 $"
	
deferred class XM_TEST_NO_NAMESPACE

inherit

	TS_TEST_CASE
	
	XM_CALLBACKS_FILTER_FACTORY
	
	KL_SHARED_STANDARD_FILES

feature -- Test

	test_regular is
		do
			assert_name ("basic", "<a/>",<<"a">>)
			assert_name ("namspaced", "<a:bc d:ef='z'/>", <<"a:bc", "d:ef">>)
		end
		
	test_element_single is
		do
			assert_name ("single colon", "<:/>", <<":">>)
			assert_name ("front", "<:ab></:ab>", <<":ab">>)
			assert_name ("back", "<c:></c:>", <<"c:">>)
			assert_name ("both", "<:abc:/>", <<":abc:">>)
		end
	
	test_element_multiple is
		do
			assert_name ("front", "<:ab:c></:ab:c>", <<":ab:c">>)
			assert_name ("back", "<ee:c:></ee:c:>", <<"ee:c:">>)
			assert_name ("both", "<:abc:de:/>", <<":abc:de:">>)
			assert_name ("three out", "<:abc:de:fgh:/>", <<":abc:de:fgh:">>)
			assert_name ("three in", "<abc:de:fgh></abc:de:fgh>", <<"abc:de:fgh">>)
		end

	test_attribute is
		do
			assert_name ("attr simple", "<: :='a'/>", <<":",":">>)
			assert_name ("attr middle", "<a:bcd e:fg='a'/>", <<"a:bcd","e:fg">>)
			assert_name ("attr front back", "<:a:bc ef:gh:='a'></:a:bc>", <<":a:bc","ef:gh:">>)
		end

feature {NONE} -- Implementation

	assert_name (a_name: STRING; a_in: STRING; a_ns: ARRAY[STRING]) is
			-- Test that an XML document sequence of local part 
			-- events (excluding xmlns, flattened) is correct when
			-- namespace parsing is disabled.
		require
			a_name_not_void: a_name /= Void
			a_in_not_void: a_in /= Void
			a_ns_not_void: a_ns /= Void
		local
			a_parser: XM_EIFFEL_PARSER
			a_checker: XM_NO_NAMESPACE_CHECKER
		do
			create a_parser.make
			a_parser.disable_namespaces -- this is what is being tested!
			
			create a_checker.make_null
			a_checker.set (a_ns)
			a_parser.set_callbacks (standard_callbacks_pipe (<<a_checker>>))
			a_parser.parse_from_string (a_in)
			
			--debug ("xml_parser")
				if not a_parser.is_correct then
					std.output.put_string (a_parser.last_error_description)
					std.output.put_new_line
				end
				if a_checker.has_failed then
					std.output.put_string ("failed: "+ a_checker.failed)
					std.output.put_new_line
				end
			--end
			
			assert ("parsing ok for "+a_name, a_parser.is_correct)
			assert (a_name, not a_checker.has_failed)
		end
		
end
