// Code generated by smithy-go-codegen DO NOT EDIT.

package chimesdkmediapipelines

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/chimesdkmediapipelines/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the status of a media insights pipeline.
func (c *Client) UpdateMediaInsightsPipelineStatus(ctx context.Context, params *UpdateMediaInsightsPipelineStatusInput, optFns ...func(*Options)) (*UpdateMediaInsightsPipelineStatusOutput, error) {
	if params == nil {
		params = &UpdateMediaInsightsPipelineStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateMediaInsightsPipelineStatus", params, optFns, c.addOperationUpdateMediaInsightsPipelineStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateMediaInsightsPipelineStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateMediaInsightsPipelineStatusInput struct {

	// The unique identifier of the resource to be updated. Valid values include the ID
	// and ARN of the media insights pipeline.
	//
	// This member is required.
	Identifier *string

	// The requested status of the media insights pipeline.
	//
	// This member is required.
	UpdateStatus types.MediaPipelineStatusUpdate

	noSmithyDocumentSerde
}

type UpdateMediaInsightsPipelineStatusOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateMediaInsightsPipelineStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateMediaInsightsPipelineStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateMediaInsightsPipelineStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateMediaInsightsPipelineStatusValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateMediaInsightsPipelineStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateMediaInsightsPipelineStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "chime",
		OperationName: "UpdateMediaInsightsPipelineStatus",
	}
}
