// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// The credentials required to access the external Dataview from the S3 location.
type AwsCredentials struct {

	// The unique identifier for the security credentials.
	AccessKeyId *string

	// The Epoch time when the current credentials expire.
	Expiration int64

	// The secret access key that can be used to sign requests.
	SecretAccessKey *string

	// The token that users must pass to use the credentials.
	SessionToken *string

	noSmithyDocumentSerde
}

// The structure with error messages.
type ChangesetErrorInfo struct {

	// The category of the error.
	//
	// * VALIDATION – The inputs to this request are
	// invalid.
	//
	// * SERVICE_QUOTA_EXCEEDED – Service quotas have been exceeded. Please
	// contact AWS support to increase quotas.
	//
	// * ACCESS_DENIED – Missing required
	// permission to perform this request.
	//
	// * RESOURCE_NOT_FOUND – One or more inputs
	// to this request were not found.
	//
	// * THROTTLING – The system temporarily lacks
	// sufficient resources to process the request.
	//
	// * INTERNAL_SERVICE_EXCEPTION – An
	// internal service error has occurred.
	//
	// * CANCELLED – Cancelled.
	//
	// *
	// USER_RECOVERABLE – A user recoverable error has occurred.
	ErrorCategory ErrorCategory

	// The text of the error message.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// A Changeset is unit of data in a Dataset.
type ChangesetSummary struct {

	// Beginning time from which the Changeset is active. The value is determined as
	// epoch time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	ActiveFromTimestamp *int64

	// Time until which the Changeset is active. The value is determined as epoch time
	// in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM
	// UTC is specified as 1635768000000.
	ActiveUntilTimestamp *int64

	// Type that indicates how a Changeset is applied to a Dataset.
	//
	// * REPLACE –
	// Changeset is considered as a replacement to all prior loaded Changesets.
	//
	// *
	// APPEND – Changeset is considered as an addition to the end of all prior loaded
	// Changesets.
	//
	// * MODIFY – Changeset is considered as a replacement to a specific
	// prior ingested Changeset.
	ChangeType ChangeType

	// The ARN identifier of the Changeset.
	ChangesetArn *string

	// The unique identifier for a Changeset.
	ChangesetId *string

	// The timestamp at which the Changeset was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreateTime int64

	// The unique identifier for the FinSpace Dataset in which the Changeset is
	// created.
	DatasetId *string

	// The structure with error messages.
	ErrorInfo *ChangesetErrorInfo

	// Options that define the structure of the source file(s).
	FormatParams map[string]string

	// Options that define the location of the data being ingested.
	SourceParams map[string]string

	// Status of the Changeset ingestion.
	//
	// * PENDING – Changeset is pending
	// creation.
	//
	// * FAILED – Changeset creation has failed.
	//
	// * SUCCESS – Changeset
	// creation has succeeded.
	//
	// * RUNNING – Changeset creation is running.
	//
	// *
	// STOP_REQUESTED – User requested Changeset creation to stop.
	Status IngestionStatus

	// The unique identifier of the updated Changeset.
	UpdatedByChangesetId *string

	// The unique identifier of the Changeset that is updated.
	UpdatesChangesetId *string

	noSmithyDocumentSerde
}

// The definition of a column in a tabular Dataset.
type ColumnDefinition struct {

	// Description for a column.
	ColumnDescription *string

	// The name of a column.
	ColumnName *string

	// Data type of a column.
	//
	// * STRING – A String data type. CHAR – A char data type.
	// INTEGER – An integer data type. TINYINT – A tinyint data type. SMALLINT – A
	// smallint data type. BIGINT – A bigint data type. FLOAT – A float data type.
	// DOUBLE – A double data type. DATE – A date data type. DATETIME – A datetime data
	// type. BOOLEAN – A boolean data type. BINARY – A binary data type.
	DataType ColumnDataType

	noSmithyDocumentSerde
}

// Short term API credentials.
type Credentials struct {

	// The access key identifier.
	AccessKeyId *string

	// The access key.
	SecretAccessKey *string

	// The session token.
	SessionToken *string

	noSmithyDocumentSerde
}

// The structure for a Dataset.
type Dataset struct {

	// The unique resource identifier for a Dataset.
	Alias *string

	// The timestamp at which the Dataset was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreateTime int64

	// The ARN identifier of the Dataset.
	DatasetArn *string

	// Description for a Dataset.
	DatasetDescription *string

	// An identifier for a Dataset.
	DatasetId *string

	// Display title for a Dataset.
	DatasetTitle *string

	// The format in which Dataset data is structured.
	//
	// * TABULAR – Data is structured
	// in a tabular format.
	//
	// * NON_TABULAR – Data is structured in a non-tabular
	// format.
	Kind DatasetKind

	// The last time that the Dataset was modified. The value is determined as epoch
	// time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTime int64

	// Contact information for a Dataset owner.
	OwnerInfo *DatasetOwnerInfo

	// Definition for a schema on a tabular Dataset.
	SchemaDefinition *SchemaUnion

	noSmithyDocumentSerde
}

// A structure for Dataset owner info.
type DatasetOwnerInfo struct {

	// Email address for the Dataset owner.
	Email *string

	// The name of the Dataset owner.
	Name *string

	// Phone number for the Dataset owner.
	PhoneNumber *string

	noSmithyDocumentSerde
}

// Structure for the Dataview destination type parameters.
type DataViewDestinationTypeParams struct {

	// Destination type for a Dataview.
	//
	// * GLUE_TABLE – Glue table destination type.
	//
	// *
	// S3 – S3 destination type.
	//
	// This member is required.
	DestinationType *string

	// Dataview export file format.
	//
	// * PARQUET – Parquet export file format.
	//
	// *
	// DELIMITED_TEXT – Delimited text export file format.
	S3DestinationExportFileFormat ExportFileFormat

	// Format Options for S3 Destination type. Here is an example of how you could
	// specify the s3DestinationExportFileFormatOptions
	//     { "header": "true",
	// "delimiter": ",", "compression": "gzip" }
	S3DestinationExportFileFormatOptions map[string]string

	noSmithyDocumentSerde
}

// The structure with error messages.
type DataViewErrorInfo struct {

	// The category of the error.
	//
	// * VALIDATION – The inputs to this request are
	// invalid.
	//
	// * SERVICE_QUOTA_EXCEEDED – Service quotas have been exceeded. Please
	// contact AWS support to increase quotas.
	//
	// * ACCESS_DENIED – Missing required
	// permission to perform this request.
	//
	// * RESOURCE_NOT_FOUND – One or more inputs
	// to this request were not found.
	//
	// * THROTTLING – The system temporarily lacks
	// sufficient resources to process the request.
	//
	// * INTERNAL_SERVICE_EXCEPTION – An
	// internal service error has occurred.
	//
	// * CANCELLED – Cancelled.
	//
	// *
	// USER_RECOVERABLE – A user recoverable error has occurred.
	ErrorCategory ErrorCategory

	// The text of the error message.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Structure for the summary of a Dataview.
type DataViewSummary struct {

	// Time range to use for the Dataview. The value is determined as epoch time in
	// milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM
	// UTC is specified as 1635768000000.
	AsOfTimestamp *int64

	// The flag to indicate Dataview should be updated automatically.
	AutoUpdate bool

	// The timestamp at which the Dataview was created in FinSpace. The value is
	// determined as epoch time in milliseconds. For example, the value for Monday,
	// November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
	CreateTime int64

	// The ARN identifier of the Dataview.
	DataViewArn *string

	// The unique identifier for the Dataview.
	DataViewId *string

	// Th unique identifier for the Dataview Dataset.
	DatasetId *string

	// Information about the Dataview destination.
	DestinationTypeProperties *DataViewDestinationTypeParams

	// The structure with error messages.
	ErrorInfo *DataViewErrorInfo

	// The last time that a Dataview was modified. The value is determined as epoch
	// time in milliseconds. For example, the value for Monday, November 1, 2021
	// 12:00:00 PM UTC is specified as 1635768000000.
	LastModifiedTime int64

	// Ordered set of column names used to partition data.
	PartitionColumns []string

	// Columns to be used for sorting the data.
	SortColumns []string

	// The status of a Dataview creation.
	//
	// * RUNNING – Dataview creation is running.
	//
	// *
	// STARTING – Dataview creation is starting.
	//
	// * FAILED – Dataview creation has
	// failed.
	//
	// * CANCELLED – Dataview creation has been cancelled.
	//
	// * TIMEOUT –
	// Dataview creation has timed out.
	//
	// * SUCCESS – Dataview creation has
	// succeeded.
	//
	// * PENDING – Dataview creation is pending.
	//
	// * FAILED_CLEANUP_FAILED –
	// Dataview creation failed and resource cleanup failed.
	Status DataViewStatus

	noSmithyDocumentSerde
}

// The structure for a permission group.
type PermissionGroup struct {

	// Indicates the permissions that are granted to a specific group for accessing the
	// FinSpace application. When assigning application permissions, be aware that the
	// permission ManageUsersAndGroups allows users to grant themselves or others
	// access to any functionality in their FinSpace environment's application. It
	// should only be granted to trusted users.
	//
	// * CreateDataset – Group members can
	// create new datasets.
	//
	// * ManageClusters – Group members can manage Apache Spark
	// clusters from FinSpace notebooks.
	//
	// * ManageUsersAndGroups – Group members can
	// manage users and permission groups. This is a privileged permission that allows
	// users to grant themselves or others access to any functionality in the
	// application. It should only be granted to trusted users.
	//
	// * ManageAttributeSets
	// – Group members can manage attribute sets.
	//
	// * ViewAuditData – Group members can
	// view audit data.
	//
	// * AccessNotebooks – Group members will have access to FinSpace
	// notebooks.
	//
	// * GetTemporaryCredentials – Group members can get temporary API
	// credentials.
	ApplicationPermissions []ApplicationPermission

	// The timestamp at which the group was created in FinSpace. The value is
	// determined as epoch time in milliseconds.
	CreateTime int64

	// A brief description for the permission group.
	Description *string

	// Describes the last time the permission group was updated. The value is
	// determined as epoch time in milliseconds.
	LastModifiedTime int64

	// Indicates the status of the user account within a permission group.
	//
	// *
	// ADDITION_IN_PROGRESS – The user account is currently being added to the
	// permission group.
	//
	// * ADDITION_SUCCESS – The user account is successfully added
	// to the permission group.
	//
	// * REMOVAL_IN_PROGRESS – The user is currently being
	// removed from the permission group.
	MembershipStatus PermissionGroupMembershipStatus

	// The name of the permission group.
	Name *string

	// The unique identifier for the permission group.
	PermissionGroupId *string

	noSmithyDocumentSerde
}

// The structure of a permission group associated with a user account.
type PermissionGroupByUser struct {

	// Indicates the status of the user account within a permission group.
	//
	// *
	// ADDITION_IN_PROGRESS – The user account is currently being added to the
	// permission group.
	//
	// * ADDITION_SUCCESS – The user account is successfully added
	// to the permission group.
	//
	// * REMOVAL_IN_PROGRESS – The user is currently being
	// removed from the permission group.
	MembershipStatus PermissionGroupMembershipStatus

	// The name of the permission group.
	Name *string

	// The unique identifier for the permission group.
	PermissionGroupId *string

	noSmithyDocumentSerde
}

// Permission group parameters for Dataset permissions. Here is an example of how
// you could specify the PermissionGroupParams:  { "permissionGroupId":
// "0r6fCRtSTUk4XPfXQe3M0g", "datasetPermissions": [ {"permission":
// "ViewDatasetDetails"}, {"permission": "AddDatasetData"}, {"permission":
// "EditDatasetMetadata"}, {"permission": "DeleteDataset"} ] }
type PermissionGroupParams struct {

	// List of resource permissions.
	DatasetPermissions []ResourcePermission

	// The unique identifier for the PermissionGroup.
	PermissionGroupId *string

	noSmithyDocumentSerde
}

// Resource permission for a dataset. When you create a dataset, all the other
// members of the same user group inherit access to the dataset. You can only
// create a dataset if your user group has application permission for Create
// Datasets. The following is a list of valid dataset permissions that you can
// apply:
//
// * ViewDatasetDetails
//
// * ReadDatasetDetails
//
// * AddDatasetData
//
// *
// CreateDataView
//
// * EditDatasetMetadata
//
// * DeleteDataset
//
// For more information on
// the dataset permissions, see Supported Dataset Permissions
// (https://docs.aws.amazon.com/finspace/latest/userguide/managing-user-permissions.html#supported-dataset-permissions)
// in the FinSpace User Guide.
type ResourcePermission struct {

	// Permission for a resource.
	Permission *string

	noSmithyDocumentSerde
}

// The location of an external Dataview in an S3 bucket.
type S3Location struct {

	// The name of the S3 bucket.
	//
	// This member is required.
	Bucket *string

	// The path of the folder, within the S3 bucket that contains the Dataset.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// Definition for a schema on a tabular Dataset.
type SchemaDefinition struct {

	// List of column definitions.
	Columns []ColumnDefinition

	// List of column names used for primary key.
	PrimaryKeyColumns []string

	noSmithyDocumentSerde
}

// A union of schema types.
type SchemaUnion struct {

	// The configuration for a schema on a tabular Dataset.
	TabularSchemaConfig *SchemaDefinition

	noSmithyDocumentSerde
}

// The details of the user account.
type User struct {

	// Indicates whether the user can use the GetProgrammaticAccessCredentials API to
	// obtain credentials that can then be used to access other FinSpace Data API
	// operations.
	//
	// * ENABLED – The user has permissions to use the APIs.
	//
	// * DISABLED –
	// The user does not have permissions to use any APIs.
	ApiAccess ApiAccess

	// The ARN identifier of an AWS user or role that is allowed to call the
	// GetProgrammaticAccessCredentials API to obtain a credentials token for a
	// specific FinSpace user. This must be an IAM role within your FinSpace account.
	ApiAccessPrincipalArn *string

	// The timestamp at which the user account was created in FinSpace. The value is
	// determined as epoch time in milliseconds.
	CreateTime int64

	// The email address of the user. The email address serves as a uniquer identifier
	// for each user and cannot be changed after it's created.
	EmailAddress *string

	// The first name of the user.
	FirstName *string

	// Describes the last time the user account was disabled. The value is determined
	// as epoch time in milliseconds.
	LastDisabledTime int64

	// Describes the last time the user account was enabled. The value is determined as
	// epoch time in milliseconds.
	LastEnabledTime int64

	// Describes the last time that the user logged into their account. The value is
	// determined as epoch time in milliseconds.
	LastLoginTime int64

	// Describes the last time the user account was updated. The value is determined as
	// epoch time in milliseconds.
	LastModifiedTime int64

	// The last name of the user.
	LastName *string

	// The current status of the user account.
	//
	// * CREATING – The user account creation
	// is in progress.
	//
	// * ENABLED – The user account is created and is currently
	// active.
	//
	// * DISABLED – The user account is currently inactive.
	Status UserStatus

	// Indicates the type of user.
	//
	// * SUPER_USER – A user with permission to all the
	// functionality and data in FinSpace.
	//
	// * APP_USER – A user with specific
	// permissions in FinSpace. The users are assigned permissions by adding them to a
	// permission group.
	Type UserType

	// The unique identifier for the user.
	UserId *string

	noSmithyDocumentSerde
}

// The structure of a user account associated with a permission group.
type UserByPermissionGroup struct {

	// Indicates whether the user can access FinSpace API operations.
	//
	// * ENABLED – The
	// user has permissions to use the API operations.
	//
	// * DISABLED – The user does not
	// have permissions to use any API operations.
	ApiAccess ApiAccess

	// The IAM ARN identifier that is attached to FinSpace API calls.
	ApiAccessPrincipalArn *string

	// The email address of the user. The email address serves as a unique identifier
	// for each user and cannot be changed after it's created.
	EmailAddress *string

	// The first name of the user.
	FirstName *string

	// The last name of the user.
	LastName *string

	// Indicates the status of the user account within a permission group.
	//
	// *
	// ADDITION_IN_PROGRESS – The user account is currently being added to the
	// permission group.
	//
	// * ADDITION_SUCCESS – The user account is successfully added
	// to the permission group.
	//
	// * REMOVAL_IN_PROGRESS – The user is currently being
	// removed from the permission group.
	MembershipStatus PermissionGroupMembershipStatus

	// The current status of the user account.
	//
	// * CREATING – The user account creation
	// is in progress.
	//
	// * ENABLED – The user account is created and is currently
	// active.
	//
	// * DISABLED – The user account is currently inactive.
	Status UserStatus

	// Indicates the type of user.
	//
	// * SUPER_USER – A user with permission to all the
	// functionality and data in FinSpace.
	//
	// * APP_USER – A user with specific
	// permissions in FinSpace. The users are assigned permissions by adding them to a
	// permission group.
	Type UserType

	// The unique identifier for the user.
	UserId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
