// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisvideo

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/kinesisvideo/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Describes a stream’s edge configuration that was set using the
// StartEdgeConfigurationUpdate API. Use this API to get the status of the
// configuration if the configuration is in sync with the Edge Agent.
func (c *Client) DescribeEdgeConfiguration(ctx context.Context, params *DescribeEdgeConfigurationInput, optFns ...func(*Options)) (*DescribeEdgeConfigurationOutput, error) {
	if params == nil {
		params = &DescribeEdgeConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeEdgeConfiguration", params, optFns, c.addOperationDescribeEdgeConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeEdgeConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeEdgeConfigurationInput struct {

	// The Amazon Resource Name (ARN) of the stream. Specify either the StreamNameor
	// the StreamARN.
	StreamARN *string

	// The name of the stream whose edge configuration you want to update. Specify
	// either the StreamName or the StreamARN.
	StreamName *string

	noSmithyDocumentSerde
}

type DescribeEdgeConfigurationOutput struct {

	// The timestamp at which a stream’s edge configuration was first created.
	CreationTime *time.Time

	// A description of the stream's edge configuration that will be used to sync with
	// the Edge Agent IoT Greengrass component. The Edge Agent component will run on an
	// IoT Hub Device setup at your premise.
	EdgeConfig *types.EdgeConfig

	// A description of the generated failure status.
	FailedStatusDetails *string

	// The timestamp at which a stream’s edge configuration was last updated.
	LastUpdatedTime *time.Time

	// The Amazon Resource Name (ARN) of the stream.
	StreamARN *string

	// The name of the stream from which the edge configuration was updated.
	StreamName *string

	// The latest status of the edge configuration update.
	SyncStatus types.SyncStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeEdgeConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeEdgeConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeEdgeConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeEdgeConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeEdgeConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "kinesisvideo",
		OperationName: "DescribeEdgeConfiguration",
	}
}
