// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Amazon SageMaker AutoML job that uses non-tabular data such as images
// or text for Computer Vision or Natural Language Processing problems. Find the
// resulting model after you run an AutoML job V2 by calling DescribeAutoMLJobV2
// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html).
// To create an AutoMLJob using tabular data, see CreateAutoMLJob
// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html).
// This API action is callable through SageMaker Canvas only. Calling it directly
// from the CLI or an SDK results in an error.
func (c *Client) CreateAutoMLJobV2(ctx context.Context, params *CreateAutoMLJobV2Input, optFns ...func(*Options)) (*CreateAutoMLJobV2Output, error) {
	if params == nil {
		params = &CreateAutoMLJobV2Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAutoMLJobV2", params, optFns, c.addOperationCreateAutoMLJobV2Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAutoMLJobV2Output)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAutoMLJobV2Input struct {

	// An array of channel objects describing the input data and their location. Each
	// channel is a named input source. Similar to InputDataConfig
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig)
	// supported by CreateAutoMLJob. The supported formats depend on the problem
	// type:
	//
	// * ImageClassification: S3Prefix, ManifestFile, AugmentedManifestFile
	//
	// *
	// TextClassification: S3Prefix
	//
	// This member is required.
	AutoMLJobInputDataConfig []types.AutoMLJobChannel

	// Identifies an Autopilot job. The name must be unique to your account and is case
	// insensitive.
	//
	// This member is required.
	AutoMLJobName *string

	// Defines the configuration settings of one of the supported problem types.
	//
	// This member is required.
	AutoMLProblemTypeConfig types.AutoMLProblemTypeConfig

	// Provides information about encryption and the Amazon S3 output path needed to
	// store artifacts from an AutoML job.
	//
	// This member is required.
	OutputDataConfig *types.AutoMLOutputDataConfig

	// The ARN of the role that is used to access the data.
	//
	// This member is required.
	RoleArn *string

	// Specifies a metric to minimize or maximize as the objective of a job. For
	// CreateAutoMLJobV2
	// (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html),
	// only Accuracy is supported.
	AutoMLJobObjective *types.AutoMLJobObjective

	// This structure specifies how to split the data into train and validation
	// datasets. If you are using the V1 API (for example CreateAutoMLJob) or the V2
	// API for Natural Language Processing problems (for example CreateAutoMLJobV2 with
	// a TextClassificationJobConfig problem type), the validation and training
	// datasets must contain the same headers. Also, for V1 API jobs, the validation
	// dataset must be less than 2 GB in size.
	DataSplitConfig *types.AutoMLDataSplitConfig

	// Specifies how to generate the endpoint name for an automatic one-click Autopilot
	// model deployment.
	ModelDeployConfig *types.ModelDeployConfig

	// The security configuration for traffic encryption or Amazon VPC settings.
	SecurityConfig *types.AutoMLSecurityConfig

	// An array of key-value pairs. You can use tags to categorize your Amazon Web
	// Services resources in different ways, such as by purpose, owner, or environment.
	// For more information, see Tagging Amazon Web ServicesResources
	// (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html). Tag keys must
	// be unique per resource.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateAutoMLJobV2Output struct {

	// The unique ARN assigned to the AutoMLJob when it is created.
	//
	// This member is required.
	AutoMLJobArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAutoMLJobV2Middlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateAutoMLJobV2{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateAutoMLJobV2{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateAutoMLJobV2ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAutoMLJobV2(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateAutoMLJobV2(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "sagemaker",
		OperationName: "CreateAutoMLJobV2",
	}
}
