// Code generated by smithy-go-codegen DO NOT EDIT.

package alexaforbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/alexaforbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all categories in the Alexa skill store.
//
// Deprecated: Alexa For Business is no longer supported
func (c *Client) ListSkillsStoreCategories(ctx context.Context, params *ListSkillsStoreCategoriesInput, optFns ...func(*Options)) (*ListSkillsStoreCategoriesOutput, error) {
	if params == nil {
		params = &ListSkillsStoreCategoriesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSkillsStoreCategories", params, optFns, c.addOperationListSkillsStoreCategoriesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSkillsStoreCategoriesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSkillsStoreCategoriesInput struct {

	// The maximum number of categories returned, per paginated calls.
	MaxResults *int32

	// The tokens used for pagination.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSkillsStoreCategoriesOutput struct {

	// The list of categories.
	CategoryList []types.Category

	// The tokens used for pagination.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSkillsStoreCategoriesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListSkillsStoreCategories{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListSkillsStoreCategories{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSkillsStoreCategories"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSkillsStoreCategories(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSkillsStoreCategoriesAPIClient is a client that implements the
// ListSkillsStoreCategories operation.
type ListSkillsStoreCategoriesAPIClient interface {
	ListSkillsStoreCategories(context.Context, *ListSkillsStoreCategoriesInput, ...func(*Options)) (*ListSkillsStoreCategoriesOutput, error)
}

var _ ListSkillsStoreCategoriesAPIClient = (*Client)(nil)

// ListSkillsStoreCategoriesPaginatorOptions is the paginator options for
// ListSkillsStoreCategories
type ListSkillsStoreCategoriesPaginatorOptions struct {
	// The maximum number of categories returned, per paginated calls.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSkillsStoreCategoriesPaginator is a paginator for ListSkillsStoreCategories
type ListSkillsStoreCategoriesPaginator struct {
	options   ListSkillsStoreCategoriesPaginatorOptions
	client    ListSkillsStoreCategoriesAPIClient
	params    *ListSkillsStoreCategoriesInput
	nextToken *string
	firstPage bool
}

// NewListSkillsStoreCategoriesPaginator returns a new
// ListSkillsStoreCategoriesPaginator
func NewListSkillsStoreCategoriesPaginator(client ListSkillsStoreCategoriesAPIClient, params *ListSkillsStoreCategoriesInput, optFns ...func(*ListSkillsStoreCategoriesPaginatorOptions)) *ListSkillsStoreCategoriesPaginator {
	if params == nil {
		params = &ListSkillsStoreCategoriesInput{}
	}

	options := ListSkillsStoreCategoriesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSkillsStoreCategoriesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSkillsStoreCategoriesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSkillsStoreCategories page.
func (p *ListSkillsStoreCategoriesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSkillsStoreCategoriesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListSkillsStoreCategories(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListSkillsStoreCategories(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSkillsStoreCategories",
	}
}
