// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Provides summary information about the hierarchy groups for the specified
// Amazon Connect instance. For more information about agent hierarchies, see Set
// Up Agent Hierarchies (https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html)
// in the Amazon Connect Administrator Guide.
func (c *Client) ListUserHierarchyGroups(ctx context.Context, params *ListUserHierarchyGroupsInput, optFns ...func(*Options)) (*ListUserHierarchyGroupsOutput, error) {
	if params == nil {
		params = &ListUserHierarchyGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListUserHierarchyGroups", params, optFns, c.addOperationListUserHierarchyGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListUserHierarchyGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListUserHierarchyGroupsInput struct {

	// The identifier of the Amazon Connect instance. You can find the instance ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of results to return per page. The default MaxResult size is
	// 100.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListUserHierarchyGroupsOutput struct {

	// If there are additional results, this is the token for the next set of results.
	NextToken *string

	// Information about the hierarchy groups.
	UserHierarchyGroupSummaryList []types.HierarchyGroupSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListUserHierarchyGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListUserHierarchyGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListUserHierarchyGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListUserHierarchyGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListUserHierarchyGroupsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListUserHierarchyGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListUserHierarchyGroupsAPIClient is a client that implements the
// ListUserHierarchyGroups operation.
type ListUserHierarchyGroupsAPIClient interface {
	ListUserHierarchyGroups(context.Context, *ListUserHierarchyGroupsInput, ...func(*Options)) (*ListUserHierarchyGroupsOutput, error)
}

var _ ListUserHierarchyGroupsAPIClient = (*Client)(nil)

// ListUserHierarchyGroupsPaginatorOptions is the paginator options for
// ListUserHierarchyGroups
type ListUserHierarchyGroupsPaginatorOptions struct {
	// The maximum number of results to return per page. The default MaxResult size is
	// 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListUserHierarchyGroupsPaginator is a paginator for ListUserHierarchyGroups
type ListUserHierarchyGroupsPaginator struct {
	options   ListUserHierarchyGroupsPaginatorOptions
	client    ListUserHierarchyGroupsAPIClient
	params    *ListUserHierarchyGroupsInput
	nextToken *string
	firstPage bool
}

// NewListUserHierarchyGroupsPaginator returns a new
// ListUserHierarchyGroupsPaginator
func NewListUserHierarchyGroupsPaginator(client ListUserHierarchyGroupsAPIClient, params *ListUserHierarchyGroupsInput, optFns ...func(*ListUserHierarchyGroupsPaginatorOptions)) *ListUserHierarchyGroupsPaginator {
	if params == nil {
		params = &ListUserHierarchyGroupsInput{}
	}

	options := ListUserHierarchyGroupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListUserHierarchyGroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListUserHierarchyGroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListUserHierarchyGroups page.
func (p *ListUserHierarchyGroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListUserHierarchyGroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListUserHierarchyGroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListUserHierarchyGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListUserHierarchyGroups",
	}
}
