// Code generated by smithy-go-codegen DO NOT EDIT.

package networkmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets the network routes of the specified global network.
func (c *Client) GetNetworkRoutes(ctx context.Context, params *GetNetworkRoutesInput, optFns ...func(*Options)) (*GetNetworkRoutesOutput, error) {
	if params == nil {
		params = &GetNetworkRoutesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetNetworkRoutes", params, optFns, c.addOperationGetNetworkRoutesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetNetworkRoutesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetNetworkRoutesInput struct {

	// The ID of the global network.
	//
	// This member is required.
	GlobalNetworkId *string

	// The ID of the route table.
	//
	// This member is required.
	RouteTableIdentifier *types.RouteTableIdentifier

	// Filter by route table destination. Possible Values:
	// TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.
	DestinationFilters map[string][]string

	// An exact CIDR block.
	ExactCidrMatches []string

	// The most specific route that matches the traffic (longest prefix match).
	LongestPrefixMatches []string

	// The IDs of the prefix lists.
	PrefixListIds []string

	// The route states.
	States []types.RouteState

	// The routes with a subnet that match the specified CIDR filter.
	SubnetOfMatches []string

	// The routes with a CIDR that encompasses the CIDR filter. Example: If you
	// specify 10.0.1.0/30, then the result returns 10.0.1.0/29.
	SupernetOfMatches []string

	// The route types.
	Types []types.RouteType

	noSmithyDocumentSerde
}

type GetNetworkRoutesOutput struct {

	// Describes a core network segment edge.
	CoreNetworkSegmentEdge *types.CoreNetworkSegmentEdgeIdentifier

	// The network routes.
	NetworkRoutes []types.NetworkRoute

	// The ARN of the route table.
	RouteTableArn *string

	// The route table creation time.
	RouteTableTimestamp *time.Time

	// The route table type.
	RouteTableType types.RouteTableType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetNetworkRoutesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetNetworkRoutes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetNetworkRoutes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetNetworkRoutes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetNetworkRoutesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetNetworkRoutes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetNetworkRoutes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetNetworkRoutes",
	}
}
