// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// You don't have permissions to perform the requested operation. The user or role
// that is making the request must have at least one IAM permissions policy
// attached that grants the required permissions. For more information, see Access
// Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html) in the
// IAM User Guide.
type AccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation that you attempted requires you to have the
// iam:CreateServiceLinkedRole for organizations.amazonaws.com permission so that
// Organizations can create the required service-linked role. You don't have that
// permission.
type AccessDeniedForDependencyException struct {
	Message *string

	ErrorCodeOverride *string

	Reason AccessDeniedForDependencyExceptionReason

	noSmithyDocumentSerde
}

func (e *AccessDeniedForDependencyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedForDependencyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedForDependencyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDeniedForDependencyException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDeniedForDependencyException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You attempted to close an account that is already closed.
type AccountAlreadyClosedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccountAlreadyClosedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccountAlreadyClosedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccountAlreadyClosedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccountAlreadyClosedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccountAlreadyClosedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified account is already a delegated administrator for this Amazon Web
// Services service.
type AccountAlreadyRegisteredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccountAlreadyRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccountAlreadyRegisteredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccountAlreadyRegisteredException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccountAlreadyRegisteredException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccountAlreadyRegisteredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// We can't find an Amazon Web Services account with the AccountId that you
// specified, or the account whose credentials you used to make this request isn't
// a member of an organization.
type AccountNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccountNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccountNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccountNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccountNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccountNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified account is not a delegated administrator for this Amazon Web
// Services service.
type AccountNotRegisteredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccountNotRegisteredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccountNotRegisteredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccountNotRegisteredException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccountNotRegisteredException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccountNotRegisteredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't invite an existing account to your organization until you verify that
// you own the email address associated with the management account. For more
// information, see Email address verification (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_create.html#about-email-verification)
// in the Organizations User Guide.
type AccountOwnerNotVerifiedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccountOwnerNotVerifiedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccountOwnerNotVerifiedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccountOwnerNotVerifiedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccountOwnerNotVerifiedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccountOwnerNotVerifiedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This account is already a member of an organization. An account can belong to
// only one organization at a time.
type AlreadyInOrganizationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AlreadyInOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AlreadyInOrganizationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AlreadyInOrganizationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AlreadyInOrganizationException"
	}
	return *e.ErrorCodeOverride
}
func (e *AlreadyInOrganizationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your account isn't a member of an organization. To make this request, you must
// use the credentials of an account that belongs to an organization.
type AWSOrganizationsNotInUseException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AWSOrganizationsNotInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AWSOrganizationsNotInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AWSOrganizationsNotInUseException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AWSOrganizationsNotInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *AWSOrganizationsNotInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// We can't find an organizational unit (OU) or Amazon Web Services account with
// the ChildId that you specified.
type ChildNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ChildNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ChildNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ChildNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ChildNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ChildNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The target of the operation is currently being modified by a different request.
// Try again later.
type ConcurrentModificationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConcurrentModificationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConcurrentModificationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConcurrentModificationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConcurrentModificationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request failed because it conflicts with the current state of the specified
// resource.
type ConflictException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConflictException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConflictException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Performing this operation violates a minimum or maximum value limit. For
// example, attempting to remove the last service control policy (SCP) from an OU
// or root, inviting or creating too many accounts to the organization, or
// attaching too many policies to an account, OU, or root. This exception includes
// a reason that contains additional information about the violated limit: Some of
// the reasons in the following list might not be applicable to this specific API
// or operation.
//   - ACCOUNT_CANNOT_LEAVE_ORGANIZATION: You attempted to remove the management
//     account from the organization. You can't remove the management account. Instead,
//     after you remove all member accounts, delete the organization itself.
//   - ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION: You attempted to remove an
//     account from the organization that doesn't yet have enough information to exist
//     as a standalone account. This account requires you to first complete phone
//     verification. Follow the steps at Removing a member account from your
//     organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#orgs_manage_accounts_remove-from-master)
//     in the Organizations User Guide.
//   - ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//     accounts that you can create in one day.
//   - ACCOUNT_CREATION_NOT_COMPLETE: Your account setup isn't complete or your
//     account isn't fully active. You must complete the account setup before you
//     create an organization.
//   - ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the
//     number of accounts in an organization. If you need more accounts, contact
//     Amazon Web Services Support (https://console.aws.amazon.com/support/home#/) to
//     request an increase in your limit. Or the number of invitations that you tried
//     to send would cause you to exceed the limit of accounts in your organization.
//     Send fewer invitations or contact Amazon Web Services Support to request an
//     increase in the number of accounts. Deleted and closed accounts still count
//     toward your limit. If you get this exception when running a command immediately
//     after creating the organization, wait one hour and try again. After an hour, if
//     the command continues to fail with this error, contact Amazon Web Services
//     Support (https://console.aws.amazon.com/support/home#/) .
//   - CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR: You cannot
//     register a suspended account as a delegated administrator.
//   - CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR: You attempted to
//     register the management account of the organization as a delegated administrator
//     for an Amazon Web Services service integrated with Organizations. You can
//     designate only a member account as a delegated administrator.
//   - CANNOT_CLOSE_MANAGEMENT_ACCOUNT: You attempted to close the management
//     account. To close the management account for the organization, you must first
//     either remove or close all member accounts in the organization. Follow standard
//     account closure process using root credentials.
//   - CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG: You attempted to remove an
//     account that is registered as a delegated administrator for a service integrated
//     with your organization. To complete this operation, you must first deregister
//     this account as a delegated administrator.
//   - CLOSE_ACCOUNT_QUOTA_EXCEEDED: You have exceeded close account quota for the
//     past 30 days.
//   - CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED: You attempted to exceed the number
//     of accounts that you can close at a time.
//   - CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION: To create an
//     organization in the specified region, you must enable all features mode.
//   - DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE: You attempted to register
//     an Amazon Web Services account as a delegated administrator for an Amazon Web
//     Services service that already has a delegated administrator. To complete this
//     operation, you must first deregister any existing delegated administrators for
//     this service.
//   - EMAIL_VERIFICATION_CODE_EXPIRED: The email verification code is only valid
//     for a limited period of time. You must resubmit the request and generate a new
//     verfication code.
//   - HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//     handshakes that you can send in one day.
//   - INVALID_PAYMENT_INSTRUMENT: You cannot remove an account because no
//     supported payment method is associated with the account. Amazon Web Services
//     does not support cards issued by financial institutions in Russia or Belarus.
//     For more information, see Managing your Amazon Web Services payments (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-general.html)
//     .
//   - MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE: To create an account in
//     this organization, you first must migrate the organization's management account
//     to the marketplace that corresponds to the management account's address. For
//     example, accounts with India addresses must be associated with the AISPL
//     marketplace. All accounts in an organization must be associated with the same
//     marketplace.
//   - MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE: Applies only to the Amazon Web
//     Services Regions in China. To create an organization, the master must have a
//     valid business license. For more information, contact customer support.
//   - MASTER_ACCOUNT_MISSING_CONTACT_INFO: To complete this operation, you must
//     first provide a valid contact address and phone number for the management
//     account. Then try the operation again.
//   - MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED: To complete this operation, the
//     management account must have an associated account in the Amazon Web Services
//     GovCloud (US-West) Region. For more information, see Organizations (https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
//     in the Amazon Web Services GovCloud User Guide.
//   - MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To create an organization with
//     this management account, you first must associate a valid payment instrument,
//     such as a credit card, with the account. For more information, see
//     Considerations before removing an account from an organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html)
//     in the Organizations User Guide.
//   - MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED: You attempted to
//     register more delegated administrators than allowed for the service principal.
//   - MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to exceed the
//     number of policies of a certain type that can be attached to an entity at one
//     time.
//   - MAX_TAG_LIMIT_EXCEEDED: You have exceeded the number of tags allowed on
//     this resource.
//   - MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED: To complete this operation with
//     this member account, you first must associate a valid payment instrument, such
//     as a credit card, with the account. For more information, see Considerations
//     before removing an account from an organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_account-before-remove.html)
//     in the Organizations User Guide.
//   - MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED: You attempted to detach a policy
//     from an entity that would cause the entity to have fewer than the minimum number
//     of policies of a certain type required.
//   - ORGANIZATION_NOT_IN_ALL_FEATURES_MODE: You attempted to perform an
//     operation that requires the organization to be configured to support all
//     features. An organization that supports only consolidated billing features can't
//     perform this operation.
//   - OU_DEPTH_LIMIT_EXCEEDED: You attempted to create an OU tree that is too
//     many levels deep.
//   - OU_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of OUs that
//     you can have in an organization.
//   - POLICY_CONTENT_LIMIT_EXCEEDED: You attempted to create a policy that is
//     larger than the maximum size.
//   - POLICY_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the number of
//     policies that you can have in an organization.
//   - SERVICE_ACCESS_NOT_ENABLED: You attempted to register a delegated
//     administrator before you enabled service access. Call the
//     EnableAWSServiceAccess API first.
//   - TAG_POLICY_VIOLATION: You attempted to create or update a resource with
//     tags that are not compliant with the tag policy requirements for this account.
//   - WAIT_PERIOD_ACTIVE: After you create an Amazon Web Services account, there
//     is a waiting period before you can remove it from the organization. If you get
//     an error that indicates that a wait period is required, try again in a few days.
type ConstraintViolationException struct {
	Message *string

	ErrorCodeOverride *string

	Reason ConstraintViolationExceptionReason

	noSmithyDocumentSerde
}

func (e *ConstraintViolationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConstraintViolationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConstraintViolationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConstraintViolationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConstraintViolationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// We can't find an create account request with the CreateAccountRequestId that
// you specified.
type CreateAccountStatusNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CreateAccountStatusNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CreateAccountStatusNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CreateAccountStatusNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CreateAccountStatusNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *CreateAccountStatusNotFoundException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// We can't find the destination container (a root or OU) with the ParentId that
// you specified.
type DestinationParentNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DestinationParentNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DestinationParentNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DestinationParentNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DestinationParentNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *DestinationParentNotFoundException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// That account is already present in the specified destination.
type DuplicateAccountException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicateAccountException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateAccountException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateAccountException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicateAccountException"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateAccountException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A handshake with the same action and target already exists. For example, if you
// invited an account to join your organization, the invited account might already
// have a pending invitation from this organization. If you intend to resend an
// invitation to an account, ensure that existing handshakes that might be
// considered duplicates are canceled or declined.
type DuplicateHandshakeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicateHandshakeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateHandshakeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateHandshakeException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicateHandshakeException"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateHandshakeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An OU with the same name already exists.
type DuplicateOrganizationalUnitException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicateOrganizationalUnitException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicateOrganizationalUnitException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicateOrganizationalUnitException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicateOrganizationalUnitException"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicateOrganizationalUnitException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The selected policy is already attached to the specified target.
type DuplicatePolicyAttachmentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicatePolicyAttachmentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicatePolicyAttachmentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicatePolicyAttachmentException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicatePolicyAttachmentException"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicatePolicyAttachmentException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A policy with the same name already exists.
type DuplicatePolicyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicatePolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicatePolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicatePolicyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DuplicatePolicyException"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicatePolicyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// If you ran this action on the management account, this policy type is not
// enabled. If you ran the action on a member account, the account doesn't have an
// effective policy of this type. Contact the administrator of your organization
// about attaching a policy of this type to the account.
type EffectivePolicyNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EffectivePolicyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EffectivePolicyNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EffectivePolicyNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EffectivePolicyNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *EffectivePolicyNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Organizations couldn't perform the operation because your organization hasn't
// finished initializing. This can take up to an hour. Try again later. If after
// one hour you continue to receive this error, contact Amazon Web Services Support (https://console.aws.amazon.com/support/home#/)
// .
type FinalizingOrganizationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FinalizingOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FinalizingOrganizationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FinalizingOrganizationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FinalizingOrganizationException"
	}
	return *e.ErrorCodeOverride
}
func (e *FinalizingOrganizationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified handshake is already in the requested state. For example, you
// can't accept a handshake that was already accepted.
type HandshakeAlreadyInStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *HandshakeAlreadyInStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HandshakeAlreadyInStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HandshakeAlreadyInStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HandshakeAlreadyInStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *HandshakeAlreadyInStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation would violate the constraint identified in the reason
// code. Some of the reasons in the following list might not be applicable to this
// specific API or operation:
//   - ACCOUNT_NUMBER_LIMIT_EXCEEDED: You attempted to exceed the limit on the
//     number of accounts in an organization. Note that deleted and closed accounts
//     still count toward your limit. If you get this exception immediately after
//     creating the organization, wait one hour and try again. If after an hour it
//     continues to fail with this error, contact Amazon Web Services Support (https://console.aws.amazon.com/support/home#/)
//     .
//   - ALREADY_IN_AN_ORGANIZATION: The handshake request is invalid because the
//     invited account is already a member of an organization.
//   - HANDSHAKE_RATE_LIMIT_EXCEEDED: You attempted to exceed the number of
//     handshakes that you can send in one day.
//   - INVITE_DISABLED_DURING_ENABLE_ALL_FEATURES: You can't issue new invitations
//     to join an organization while it's in the process of enabling all features. You
//     can resume inviting accounts after you finalize the process when all accounts
//     have agreed to the change.
//   - ORGANIZATION_ALREADY_HAS_ALL_FEATURES: The handshake request is invalid
//     because the organization has already enabled all features.
//   - ORGANIZATION_IS_ALREADY_PENDING_ALL_FEATURES_MIGRATION: The handshake
//     request is invalid because the organization has already started the process to
//     enable all features.
//   - ORGANIZATION_FROM_DIFFERENT_SELLER_OF_RECORD: The request failed because
//     the account is from a different marketplace than the accounts in the
//     organization. For example, accounts with India addresses must be associated with
//     the AISPL marketplace. All accounts in an organization must be from the same
//     marketplace.
//   - ORGANIZATION_MEMBERSHIP_CHANGE_RATE_LIMIT_EXCEEDED: You attempted to change
//     the membership of an account too quickly after its previous change.
//   - PAYMENT_INSTRUMENT_REQUIRED: You can't complete the operation with an
//     account that doesn't have a payment instrument, such as a credit card,
//     associated with it.
type HandshakeConstraintViolationException struct {
	Message *string

	ErrorCodeOverride *string

	Reason HandshakeConstraintViolationExceptionReason

	noSmithyDocumentSerde
}

func (e *HandshakeConstraintViolationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HandshakeConstraintViolationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HandshakeConstraintViolationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HandshakeConstraintViolationException"
	}
	return *e.ErrorCodeOverride
}
func (e *HandshakeConstraintViolationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// We can't find a handshake with the HandshakeId that you specified.
type HandshakeNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *HandshakeNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HandshakeNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HandshakeNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "HandshakeNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *HandshakeNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't perform the operation on the handshake in its current state. For
// example, you can't cancel a handshake that was already accepted or accept a
// handshake that was already declined.
type InvalidHandshakeTransitionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidHandshakeTransitionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidHandshakeTransitionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidHandshakeTransitionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidHandshakeTransitionException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidHandshakeTransitionException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested operation failed because you provided invalid values for one or
// more of the request parameters. This exception includes a reason that contains
// additional information about the violated limit: Some of the reasons in the
// following list might not be applicable to this specific API or operation.
//   - DUPLICATE_TAG_KEY: Tag keys must be unique among the tags attached to the
//     same entity.
//   - IMMUTABLE_POLICY: You specified a policy that is managed by Amazon Web
//     Services and can't be modified.
//   - INPUT_REQUIRED: You must include a value for all required parameters.
//   - INVALID_EMAIL_ADDRESS_TARGET: You specified an invalid email address for
//     the invited account owner.
//   - INVALID_ENUM: You specified an invalid value.
//   - INVALID_ENUM_POLICY_TYPE: You specified an invalid policy type string.
//   - INVALID_FULL_NAME_TARGET: You specified a full name that contains invalid
//     characters.
//   - INVALID_LIST_MEMBER: You provided a list to a parameter that contains at
//     least one invalid value.
//   - INVALID_PAGINATION_TOKEN: Get the value for the NextToken parameter from the
//     response to a previous call of the operation.
//   - INVALID_PARTY_TYPE_TARGET: You specified the wrong type of entity (account,
//     organization, or email) as a party.
//   - INVALID_PATTERN: You provided a value that doesn't match the required
//     pattern.
//   - INVALID_PATTERN_TARGET_ID: You specified a policy target ID that doesn't
//     match the required pattern.
//   - INVALID_ROLE_NAME: You provided a role name that isn't valid. A role name
//     can't begin with the reserved prefix AWSServiceRoleFor .
//   - INVALID_SYNTAX_ORGANIZATION_ARN: You specified an invalid Amazon Resource
//     Name (ARN) for the organization.
//   - INVALID_SYNTAX_POLICY_ID: You specified an invalid policy ID.
//   - INVALID_SYSTEM_TAGS_PARAMETER: You specified a tag key that is a system
//     tag. You can’t add, edit, or delete system tag keys because they're reserved for
//     Amazon Web Services use. System tags don’t count against your tags per resource
//     limit.
//   - MAX_FILTER_LIMIT_EXCEEDED: You can specify only one filter parameter for
//     the operation.
//   - MAX_LENGTH_EXCEEDED: You provided a string parameter that is longer than
//     allowed.
//   - MAX_VALUE_EXCEEDED: You provided a numeric parameter that has a larger
//     value than allowed.
//   - MIN_LENGTH_EXCEEDED: You provided a string parameter that is shorter than
//     allowed.
//   - MIN_VALUE_EXCEEDED: You provided a numeric parameter that has a smaller
//     value than allowed.
//   - MOVING_ACCOUNT_BETWEEN_DIFFERENT_ROOTS: You can move an account only
//     between entities in the same root.
//   - TARGET_NOT_SUPPORTED: You can't perform the specified operation on that
//     target entity.
//   - UNRECOGNIZED_SERVICE_PRINCIPAL: You specified a service principal that
//     isn't recognized.
type InvalidInputException struct {
	Message *string

	ErrorCodeOverride *string

	Reason InvalidInputExceptionReason

	noSmithyDocumentSerde
}

func (e *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInputException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInputException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInputException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInputException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The provided policy document doesn't meet the requirements of the specified
// policy type. For example, the syntax might be incorrect. For details about
// service control policy syntax, see SCP syntax (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html)
// in the Organizations User Guide.
type MalformedPolicyDocumentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MalformedPolicyDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MalformedPolicyDocumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MalformedPolicyDocumentException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MalformedPolicyDocumentException"
	}
	return *e.ErrorCodeOverride
}
func (e *MalformedPolicyDocumentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't remove a management account from an organization. If you want the
// management account to become a member account in another organization, you must
// first delete the current organization of the management account.
type MasterCannotLeaveOrganizationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MasterCannotLeaveOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MasterCannotLeaveOrganizationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MasterCannotLeaveOrganizationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MasterCannotLeaveOrganizationException"
	}
	return *e.ErrorCodeOverride
}
func (e *MasterCannotLeaveOrganizationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified OU is not empty. Move all accounts to another root or to other
// OUs, remove all child OUs, and try the operation again.
type OrganizationalUnitNotEmptyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OrganizationalUnitNotEmptyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationalUnitNotEmptyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationalUnitNotEmptyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OrganizationalUnitNotEmptyException"
	}
	return *e.ErrorCodeOverride
}
func (e *OrganizationalUnitNotEmptyException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// We can't find an OU with the OrganizationalUnitId that you specified.
type OrganizationalUnitNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OrganizationalUnitNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationalUnitNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationalUnitNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OrganizationalUnitNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *OrganizationalUnitNotFoundException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The organization isn't empty. To delete an organization, you must first remove
// all accounts except the management account.
type OrganizationNotEmptyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OrganizationNotEmptyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OrganizationNotEmptyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OrganizationNotEmptyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OrganizationNotEmptyException"
	}
	return *e.ErrorCodeOverride
}
func (e *OrganizationNotEmptyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// We can't find a root or OU with the ParentId that you specified.
type ParentNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ParentNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ParentNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ParentNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ParentNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ParentNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Changes to the effective policy are in progress, and its contents can't be
// returned. Try the operation again later.
type PolicyChangesInProgressException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PolicyChangesInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PolicyChangesInProgressException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PolicyChangesInProgressException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PolicyChangesInProgressException"
	}
	return *e.ErrorCodeOverride
}
func (e *PolicyChangesInProgressException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The policy is attached to one or more entities. You must detach it from all
// roots, OUs, and accounts before performing this operation.
type PolicyInUseException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PolicyInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PolicyInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PolicyInUseException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PolicyInUseException"
	}
	return *e.ErrorCodeOverride
}
func (e *PolicyInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The policy isn't attached to the specified target in the specified root.
type PolicyNotAttachedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PolicyNotAttachedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PolicyNotAttachedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PolicyNotAttachedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PolicyNotAttachedException"
	}
	return *e.ErrorCodeOverride
}
func (e *PolicyNotAttachedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// We can't find a policy with the PolicyId that you specified.
type PolicyNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PolicyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PolicyNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PolicyNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PolicyNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *PolicyNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified policy type is already enabled in the specified root.
type PolicyTypeAlreadyEnabledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PolicyTypeAlreadyEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PolicyTypeAlreadyEnabledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PolicyTypeAlreadyEnabledException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PolicyTypeAlreadyEnabledException"
	}
	return *e.ErrorCodeOverride
}
func (e *PolicyTypeAlreadyEnabledException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't use the specified policy type with the feature set currently enabled
// for this organization. For example, you can enable SCPs only after you enable
// all features in the organization. For more information, see Managing
// Organizations policies (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#enable_policies_on_root)
// in the Organizations User Guide.
type PolicyTypeNotAvailableForOrganizationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PolicyTypeNotAvailableForOrganizationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PolicyTypeNotAvailableForOrganizationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PolicyTypeNotAvailableForOrganizationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PolicyTypeNotAvailableForOrganizationException"
	}
	return *e.ErrorCodeOverride
}
func (e *PolicyTypeNotAvailableForOrganizationException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified policy type isn't currently enabled in this root. You can't
// attach policies of the specified type to entities in a root until you enable
// that type in the root. For more information, see Enabling all features in your
// organization (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
// in the Organizations User Guide.
type PolicyTypeNotEnabledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PolicyTypeNotEnabledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PolicyTypeNotEnabledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PolicyTypeNotEnabledException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PolicyTypeNotEnabledException"
	}
	return *e.ErrorCodeOverride
}
func (e *PolicyTypeNotEnabledException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// We can't find a resource policy request with the parameter that you specified.
type ResourcePolicyNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourcePolicyNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourcePolicyNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourcePolicyNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourcePolicyNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourcePolicyNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// We can't find a root with the RootId that you specified.
type RootNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RootNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RootNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RootNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "RootNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *RootNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Organizations can't complete your request because of an internal service error.
// Try again later.
type ServiceException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceException"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// We can't find a source root or OU with the ParentId that you specified.
type SourceParentNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SourceParentNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SourceParentNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SourceParentNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SourceParentNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *SourceParentNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// We can't find a root, OU, account, or policy with the TargetId that you
// specified.
type TargetNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TargetNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TargetNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TargetNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TargetNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *TargetNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have sent too many requests in too short a period of time. The quota helps
// protect against denial-of-service attacks. Try again later. For information
// about quotas that affect Organizations, see Quotas for Organizations (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_reference_limits.html)
// in the Organizations User Guide.
type TooManyRequestsException struct {
	Message *string

	ErrorCodeOverride *string

	Type *string

	noSmithyDocumentSerde
}

func (e *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyRequestsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyRequestsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyRequestsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyRequestsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This action isn't available in the current Amazon Web Services Region.
type UnsupportedAPIEndpointException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedAPIEndpointException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedAPIEndpointException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedAPIEndpointException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedAPIEndpointException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedAPIEndpointException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
