// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package lookoutforvisioniface provides an interface to enable mocking the Amazon Lookout for Vision service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package lookoutforvisioniface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/lookoutforvision"
)

// LookoutForVisionAPI provides an interface to enable mocking the
// lookoutforvision.LookoutForVision service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Lookout for Vision.
//    func myFunc(svc lookoutforvisioniface.LookoutForVisionAPI) bool {
//        // Make svc.CreateDataset request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := lookoutforvision.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockLookoutForVisionClient struct {
//        lookoutforvisioniface.LookoutForVisionAPI
//    }
//    func (m *mockLookoutForVisionClient) CreateDataset(input *lookoutforvision.CreateDatasetInput) (*lookoutforvision.CreateDatasetOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockLookoutForVisionClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type LookoutForVisionAPI interface {
	CreateDataset(*lookoutforvision.CreateDatasetInput) (*lookoutforvision.CreateDatasetOutput, error)
	CreateDatasetWithContext(aws.Context, *lookoutforvision.CreateDatasetInput, ...request.Option) (*lookoutforvision.CreateDatasetOutput, error)
	CreateDatasetRequest(*lookoutforvision.CreateDatasetInput) (*request.Request, *lookoutforvision.CreateDatasetOutput)

	CreateModel(*lookoutforvision.CreateModelInput) (*lookoutforvision.CreateModelOutput, error)
	CreateModelWithContext(aws.Context, *lookoutforvision.CreateModelInput, ...request.Option) (*lookoutforvision.CreateModelOutput, error)
	CreateModelRequest(*lookoutforvision.CreateModelInput) (*request.Request, *lookoutforvision.CreateModelOutput)

	CreateProject(*lookoutforvision.CreateProjectInput) (*lookoutforvision.CreateProjectOutput, error)
	CreateProjectWithContext(aws.Context, *lookoutforvision.CreateProjectInput, ...request.Option) (*lookoutforvision.CreateProjectOutput, error)
	CreateProjectRequest(*lookoutforvision.CreateProjectInput) (*request.Request, *lookoutforvision.CreateProjectOutput)

	DeleteDataset(*lookoutforvision.DeleteDatasetInput) (*lookoutforvision.DeleteDatasetOutput, error)
	DeleteDatasetWithContext(aws.Context, *lookoutforvision.DeleteDatasetInput, ...request.Option) (*lookoutforvision.DeleteDatasetOutput, error)
	DeleteDatasetRequest(*lookoutforvision.DeleteDatasetInput) (*request.Request, *lookoutforvision.DeleteDatasetOutput)

	DeleteModel(*lookoutforvision.DeleteModelInput) (*lookoutforvision.DeleteModelOutput, error)
	DeleteModelWithContext(aws.Context, *lookoutforvision.DeleteModelInput, ...request.Option) (*lookoutforvision.DeleteModelOutput, error)
	DeleteModelRequest(*lookoutforvision.DeleteModelInput) (*request.Request, *lookoutforvision.DeleteModelOutput)

	DeleteProject(*lookoutforvision.DeleteProjectInput) (*lookoutforvision.DeleteProjectOutput, error)
	DeleteProjectWithContext(aws.Context, *lookoutforvision.DeleteProjectInput, ...request.Option) (*lookoutforvision.DeleteProjectOutput, error)
	DeleteProjectRequest(*lookoutforvision.DeleteProjectInput) (*request.Request, *lookoutforvision.DeleteProjectOutput)

	DescribeDataset(*lookoutforvision.DescribeDatasetInput) (*lookoutforvision.DescribeDatasetOutput, error)
	DescribeDatasetWithContext(aws.Context, *lookoutforvision.DescribeDatasetInput, ...request.Option) (*lookoutforvision.DescribeDatasetOutput, error)
	DescribeDatasetRequest(*lookoutforvision.DescribeDatasetInput) (*request.Request, *lookoutforvision.DescribeDatasetOutput)

	DescribeModel(*lookoutforvision.DescribeModelInput) (*lookoutforvision.DescribeModelOutput, error)
	DescribeModelWithContext(aws.Context, *lookoutforvision.DescribeModelInput, ...request.Option) (*lookoutforvision.DescribeModelOutput, error)
	DescribeModelRequest(*lookoutforvision.DescribeModelInput) (*request.Request, *lookoutforvision.DescribeModelOutput)

	DescribeProject(*lookoutforvision.DescribeProjectInput) (*lookoutforvision.DescribeProjectOutput, error)
	DescribeProjectWithContext(aws.Context, *lookoutforvision.DescribeProjectInput, ...request.Option) (*lookoutforvision.DescribeProjectOutput, error)
	DescribeProjectRequest(*lookoutforvision.DescribeProjectInput) (*request.Request, *lookoutforvision.DescribeProjectOutput)

	DetectAnomalies(*lookoutforvision.DetectAnomaliesInput) (*lookoutforvision.DetectAnomaliesOutput, error)
	DetectAnomaliesWithContext(aws.Context, *lookoutforvision.DetectAnomaliesInput, ...request.Option) (*lookoutforvision.DetectAnomaliesOutput, error)
	DetectAnomaliesRequest(*lookoutforvision.DetectAnomaliesInput) (*request.Request, *lookoutforvision.DetectAnomaliesOutput)

	ListDatasetEntries(*lookoutforvision.ListDatasetEntriesInput) (*lookoutforvision.ListDatasetEntriesOutput, error)
	ListDatasetEntriesWithContext(aws.Context, *lookoutforvision.ListDatasetEntriesInput, ...request.Option) (*lookoutforvision.ListDatasetEntriesOutput, error)
	ListDatasetEntriesRequest(*lookoutforvision.ListDatasetEntriesInput) (*request.Request, *lookoutforvision.ListDatasetEntriesOutput)

	ListDatasetEntriesPages(*lookoutforvision.ListDatasetEntriesInput, func(*lookoutforvision.ListDatasetEntriesOutput, bool) bool) error
	ListDatasetEntriesPagesWithContext(aws.Context, *lookoutforvision.ListDatasetEntriesInput, func(*lookoutforvision.ListDatasetEntriesOutput, bool) bool, ...request.Option) error

	ListModels(*lookoutforvision.ListModelsInput) (*lookoutforvision.ListModelsOutput, error)
	ListModelsWithContext(aws.Context, *lookoutforvision.ListModelsInput, ...request.Option) (*lookoutforvision.ListModelsOutput, error)
	ListModelsRequest(*lookoutforvision.ListModelsInput) (*request.Request, *lookoutforvision.ListModelsOutput)

	ListModelsPages(*lookoutforvision.ListModelsInput, func(*lookoutforvision.ListModelsOutput, bool) bool) error
	ListModelsPagesWithContext(aws.Context, *lookoutforvision.ListModelsInput, func(*lookoutforvision.ListModelsOutput, bool) bool, ...request.Option) error

	ListProjects(*lookoutforvision.ListProjectsInput) (*lookoutforvision.ListProjectsOutput, error)
	ListProjectsWithContext(aws.Context, *lookoutforvision.ListProjectsInput, ...request.Option) (*lookoutforvision.ListProjectsOutput, error)
	ListProjectsRequest(*lookoutforvision.ListProjectsInput) (*request.Request, *lookoutforvision.ListProjectsOutput)

	ListProjectsPages(*lookoutforvision.ListProjectsInput, func(*lookoutforvision.ListProjectsOutput, bool) bool) error
	ListProjectsPagesWithContext(aws.Context, *lookoutforvision.ListProjectsInput, func(*lookoutforvision.ListProjectsOutput, bool) bool, ...request.Option) error

	StartModel(*lookoutforvision.StartModelInput) (*lookoutforvision.StartModelOutput, error)
	StartModelWithContext(aws.Context, *lookoutforvision.StartModelInput, ...request.Option) (*lookoutforvision.StartModelOutput, error)
	StartModelRequest(*lookoutforvision.StartModelInput) (*request.Request, *lookoutforvision.StartModelOutput)

	StopModel(*lookoutforvision.StopModelInput) (*lookoutforvision.StopModelOutput, error)
	StopModelWithContext(aws.Context, *lookoutforvision.StopModelInput, ...request.Option) (*lookoutforvision.StopModelOutput, error)
	StopModelRequest(*lookoutforvision.StopModelInput) (*request.Request, *lookoutforvision.StopModelOutput)

	UpdateDatasetEntries(*lookoutforvision.UpdateDatasetEntriesInput) (*lookoutforvision.UpdateDatasetEntriesOutput, error)
	UpdateDatasetEntriesWithContext(aws.Context, *lookoutforvision.UpdateDatasetEntriesInput, ...request.Option) (*lookoutforvision.UpdateDatasetEntriesOutput, error)
	UpdateDatasetEntriesRequest(*lookoutforvision.UpdateDatasetEntriesInput) (*request.Request, *lookoutforvision.UpdateDatasetEntriesOutput)
}

var _ LookoutForVisionAPI = (*lookoutforvision.LookoutForVision)(nil)
