// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddApplicationCloudWatchLoggingOption = "AddApplicationCloudWatchLoggingOption"

// AddApplicationCloudWatchLoggingOptionRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationCloudWatchLoggingOption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationCloudWatchLoggingOption for more information on using the AddApplicationCloudWatchLoggingOption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationCloudWatchLoggingOptionRequest method.
//    req, resp := client.AddApplicationCloudWatchLoggingOptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationCloudWatchLoggingOption
func (c *KinesisAnalyticsV2) AddApplicationCloudWatchLoggingOptionRequest(input *AddApplicationCloudWatchLoggingOptionInput) (req *request.Request, output *AddApplicationCloudWatchLoggingOptionOutput) {
	op := &request.Operation{
		Name:       opAddApplicationCloudWatchLoggingOption,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationCloudWatchLoggingOptionInput{}
	}

	output = &AddApplicationCloudWatchLoggingOptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddApplicationCloudWatchLoggingOption API operation for Amazon Kinesis Analytics.
//
// Adds an Amazon CloudWatch log stream to monitor application configuration
// errors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationCloudWatchLoggingOption for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
//   * InvalidApplicationConfigurationException
//   The user-provided application configuration is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationCloudWatchLoggingOption
func (c *KinesisAnalyticsV2) AddApplicationCloudWatchLoggingOption(input *AddApplicationCloudWatchLoggingOptionInput) (*AddApplicationCloudWatchLoggingOptionOutput, error) {
	req, out := c.AddApplicationCloudWatchLoggingOptionRequest(input)
	return out, req.Send()
}

// AddApplicationCloudWatchLoggingOptionWithContext is the same as AddApplicationCloudWatchLoggingOption with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationCloudWatchLoggingOption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) AddApplicationCloudWatchLoggingOptionWithContext(ctx aws.Context, input *AddApplicationCloudWatchLoggingOptionInput, opts ...request.Option) (*AddApplicationCloudWatchLoggingOptionOutput, error) {
	req, out := c.AddApplicationCloudWatchLoggingOptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddApplicationInput = "AddApplicationInput"

// AddApplicationInputRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationInput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationInput for more information on using the AddApplicationInput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationInputRequest method.
//    req, resp := client.AddApplicationInputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInput
func (c *KinesisAnalyticsV2) AddApplicationInputRequest(input *AddApplicationInputInput) (req *request.Request, output *AddApplicationInputOutput) {
	op := &request.Operation{
		Name:       opAddApplicationInput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationInputInput{}
	}

	output = &AddApplicationInputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddApplicationInput API operation for Amazon Kinesis Analytics.
//
// Adds a streaming source to your SQL-based Kinesis Data Analytics application.
//
// You can add a streaming source when you create an application, or you can
// use this operation to add a streaming source after you create an application.
// For more information, see CreateApplication.
//
// Any configuration update, including adding a streaming source using this
// operation, results in a new version of the application. You can use the DescribeApplication
// operation to find the current application version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationInput for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * CodeValidationException
//   The user-provided application code (query) is not valid. This can be a simple
//   syntax error.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInput
func (c *KinesisAnalyticsV2) AddApplicationInput(input *AddApplicationInputInput) (*AddApplicationInputOutput, error) {
	req, out := c.AddApplicationInputRequest(input)
	return out, req.Send()
}

// AddApplicationInputWithContext is the same as AddApplicationInput with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationInput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) AddApplicationInputWithContext(ctx aws.Context, input *AddApplicationInputInput, opts ...request.Option) (*AddApplicationInputOutput, error) {
	req, out := c.AddApplicationInputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddApplicationInputProcessingConfiguration = "AddApplicationInputProcessingConfiguration"

// AddApplicationInputProcessingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationInputProcessingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationInputProcessingConfiguration for more information on using the AddApplicationInputProcessingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationInputProcessingConfigurationRequest method.
//    req, resp := client.AddApplicationInputProcessingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInputProcessingConfiguration
func (c *KinesisAnalyticsV2) AddApplicationInputProcessingConfigurationRequest(input *AddApplicationInputProcessingConfigurationInput) (req *request.Request, output *AddApplicationInputProcessingConfigurationOutput) {
	op := &request.Operation{
		Name:       opAddApplicationInputProcessingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationInputProcessingConfigurationInput{}
	}

	output = &AddApplicationInputProcessingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddApplicationInputProcessingConfiguration API operation for Amazon Kinesis Analytics.
//
// Adds an InputProcessingConfiguration to a SQL-based Kinesis Data Analytics
// application. An input processor pre-processes records on the input stream
// before the application's SQL code executes. Currently, the only input processor
// available is Amazon Lambda (https://docs.aws.amazon.com/lambda/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationInputProcessingConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInputProcessingConfiguration
func (c *KinesisAnalyticsV2) AddApplicationInputProcessingConfiguration(input *AddApplicationInputProcessingConfigurationInput) (*AddApplicationInputProcessingConfigurationOutput, error) {
	req, out := c.AddApplicationInputProcessingConfigurationRequest(input)
	return out, req.Send()
}

// AddApplicationInputProcessingConfigurationWithContext is the same as AddApplicationInputProcessingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationInputProcessingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) AddApplicationInputProcessingConfigurationWithContext(ctx aws.Context, input *AddApplicationInputProcessingConfigurationInput, opts ...request.Option) (*AddApplicationInputProcessingConfigurationOutput, error) {
	req, out := c.AddApplicationInputProcessingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddApplicationOutput = "AddApplicationOutput"

// AddApplicationOutputRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationOutput for more information on using the AddApplicationOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationOutputRequest method.
//    req, resp := client.AddApplicationOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationOutput
func (c *KinesisAnalyticsV2) AddApplicationOutputRequest(input *AddApplicationOutputInput) (req *request.Request, output *AddApplicationOutputOutput) {
	op := &request.Operation{
		Name:       opAddApplicationOutput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationOutputInput{}
	}

	output = &AddApplicationOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddApplicationOutput API operation for Amazon Kinesis Analytics.
//
// Adds an external destination to your SQL-based Kinesis Data Analytics application.
//
// If you want Kinesis Data Analytics to deliver data from an in-application
// stream within your application to an external destination (such as an Kinesis
// data stream, a Kinesis Data Firehose delivery stream, or an Amazon Lambda
// function), you add the relevant configuration to your application using this
// operation. You can configure one or more outputs for your application. Each
// output configuration maps an in-application stream and an external destination.
//
// You can use one of the output configurations to deliver data from your in-application
// error stream to an external destination so that you can analyze the errors.
//
// Any configuration update, including adding a streaming source using this
// operation, results in a new version of the application. You can use the DescribeApplication
// operation to find the current application version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationOutput for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationOutput
func (c *KinesisAnalyticsV2) AddApplicationOutput(input *AddApplicationOutputInput) (*AddApplicationOutputOutput, error) {
	req, out := c.AddApplicationOutputRequest(input)
	return out, req.Send()
}

// AddApplicationOutputWithContext is the same as AddApplicationOutput with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) AddApplicationOutputWithContext(ctx aws.Context, input *AddApplicationOutputInput, opts ...request.Option) (*AddApplicationOutputOutput, error) {
	req, out := c.AddApplicationOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddApplicationReferenceDataSource = "AddApplicationReferenceDataSource"

// AddApplicationReferenceDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationReferenceDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationReferenceDataSource for more information on using the AddApplicationReferenceDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationReferenceDataSourceRequest method.
//    req, resp := client.AddApplicationReferenceDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationReferenceDataSource
func (c *KinesisAnalyticsV2) AddApplicationReferenceDataSourceRequest(input *AddApplicationReferenceDataSourceInput) (req *request.Request, output *AddApplicationReferenceDataSourceOutput) {
	op := &request.Operation{
		Name:       opAddApplicationReferenceDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationReferenceDataSourceInput{}
	}

	output = &AddApplicationReferenceDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddApplicationReferenceDataSource API operation for Amazon Kinesis Analytics.
//
// Adds a reference data source to an existing SQL-based Kinesis Data Analytics
// application.
//
// Kinesis Data Analytics reads reference data (that is, an Amazon S3 object)
// and creates an in-application table within your application. In the request,
// you provide the source (S3 bucket name and object key name), name of the
// in-application table to create, and the necessary mapping information that
// describes how data in an Amazon S3 object maps to columns in the resulting
// in-application table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationReferenceDataSource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationReferenceDataSource
func (c *KinesisAnalyticsV2) AddApplicationReferenceDataSource(input *AddApplicationReferenceDataSourceInput) (*AddApplicationReferenceDataSourceOutput, error) {
	req, out := c.AddApplicationReferenceDataSourceRequest(input)
	return out, req.Send()
}

// AddApplicationReferenceDataSourceWithContext is the same as AddApplicationReferenceDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationReferenceDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) AddApplicationReferenceDataSourceWithContext(ctx aws.Context, input *AddApplicationReferenceDataSourceInput, opts ...request.Option) (*AddApplicationReferenceDataSourceOutput, error) {
	req, out := c.AddApplicationReferenceDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddApplicationVpcConfiguration = "AddApplicationVpcConfiguration"

// AddApplicationVpcConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the AddApplicationVpcConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddApplicationVpcConfiguration for more information on using the AddApplicationVpcConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddApplicationVpcConfigurationRequest method.
//    req, resp := client.AddApplicationVpcConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationVpcConfiguration
func (c *KinesisAnalyticsV2) AddApplicationVpcConfigurationRequest(input *AddApplicationVpcConfigurationInput) (req *request.Request, output *AddApplicationVpcConfigurationOutput) {
	op := &request.Operation{
		Name:       opAddApplicationVpcConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddApplicationVpcConfigurationInput{}
	}

	output = &AddApplicationVpcConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddApplicationVpcConfiguration API operation for Amazon Kinesis Analytics.
//
// Adds a Virtual Private Cloud (VPC) configuration to the application. Applications
// can use VPCs to store and access resources securely.
//
// Note the following about VPC configurations for Kinesis Data Analytics applications:
//
//    * VPC configurations are not supported for SQL applications.
//
//    * When a VPC is added to a Kinesis Data Analytics application, the application
//    can no longer be accessed from the Internet directly. To enable Internet
//    access to the application, add an Internet gateway to your VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation AddApplicationVpcConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidApplicationConfigurationException
//   The user-provided application configuration is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationVpcConfiguration
func (c *KinesisAnalyticsV2) AddApplicationVpcConfiguration(input *AddApplicationVpcConfigurationInput) (*AddApplicationVpcConfigurationOutput, error) {
	req, out := c.AddApplicationVpcConfigurationRequest(input)
	return out, req.Send()
}

// AddApplicationVpcConfigurationWithContext is the same as AddApplicationVpcConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See AddApplicationVpcConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) AddApplicationVpcConfigurationWithContext(ctx aws.Context, input *AddApplicationVpcConfigurationInput, opts ...request.Option) (*AddApplicationVpcConfigurationOutput, error) {
	req, out := c.AddApplicationVpcConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplication
func (c *KinesisAnalyticsV2) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for Amazon Kinesis Analytics.
//
// Creates a Kinesis Data Analytics application. For information about creating
// a Kinesis Data Analytics application, see Creating an Application (https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//   * CodeValidationException
//   The user-provided application code (query) is not valid. This can be a simple
//   syntax error.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * LimitExceededException
//   The number of allowed resources has been exceeded.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
//   * TooManyTagsException
//   Application created with too many tags, or too many tags added to an application.
//   Note that the maximum number of application tags includes system tags. The
//   maximum number of user-defined application tags is 50.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplication
func (c *KinesisAnalyticsV2) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplicationPresignedUrl = "CreateApplicationPresignedUrl"

// CreateApplicationPresignedUrlRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplicationPresignedUrl operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplicationPresignedUrl for more information on using the CreateApplicationPresignedUrl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationPresignedUrlRequest method.
//    req, resp := client.CreateApplicationPresignedUrlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationPresignedUrl
func (c *KinesisAnalyticsV2) CreateApplicationPresignedUrlRequest(input *CreateApplicationPresignedUrlInput) (req *request.Request, output *CreateApplicationPresignedUrlOutput) {
	op := &request.Operation{
		Name:       opCreateApplicationPresignedUrl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationPresignedUrlInput{}
	}

	output = &CreateApplicationPresignedUrlOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplicationPresignedUrl API operation for Amazon Kinesis Analytics.
//
// Creates and returns a URL that you can use to connect to an application's
// extension. Currently, the only available extension is the Apache Flink dashboard.
//
// The IAM role or user used to call this API defines the permissions to access
// the extension. After the presigned URL is created, no additional permission
// is required to access this URL. IAM authorization policies for this API are
// also enforced for every HTTP request that attempts to connect to the extension.
//
// You control the amount of time that the URL will be valid using the SessionExpirationDurationInSeconds
// parameter. If you do not provide this parameter, the returned URL is valid
// for twelve hours.
//
// The URL that you get from a call to CreateApplicationPresignedUrl must be
// used within 3 minutes to be valid. If you first try to use the URL after
// the 3-minute limit expires, the service returns an HTTP 403 Forbidden error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation CreateApplicationPresignedUrl for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationPresignedUrl
func (c *KinesisAnalyticsV2) CreateApplicationPresignedUrl(input *CreateApplicationPresignedUrlInput) (*CreateApplicationPresignedUrlOutput, error) {
	req, out := c.CreateApplicationPresignedUrlRequest(input)
	return out, req.Send()
}

// CreateApplicationPresignedUrlWithContext is the same as CreateApplicationPresignedUrl with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplicationPresignedUrl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) CreateApplicationPresignedUrlWithContext(ctx aws.Context, input *CreateApplicationPresignedUrlInput, opts ...request.Option) (*CreateApplicationPresignedUrlOutput, error) {
	req, out := c.CreateApplicationPresignedUrlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplicationSnapshot = "CreateApplicationSnapshot"

// CreateApplicationSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplicationSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplicationSnapshot for more information on using the CreateApplicationSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationSnapshotRequest method.
//    req, resp := client.CreateApplicationSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationSnapshot
func (c *KinesisAnalyticsV2) CreateApplicationSnapshotRequest(input *CreateApplicationSnapshotInput) (req *request.Request, output *CreateApplicationSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateApplicationSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationSnapshotInput{}
	}

	output = &CreateApplicationSnapshotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateApplicationSnapshot API operation for Amazon Kinesis Analytics.
//
// Creates a snapshot of the application's state data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation CreateApplicationSnapshot for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * LimitExceededException
//   The number of allowed resources has been exceeded.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
//   * InvalidApplicationConfigurationException
//   The user-provided application configuration is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationSnapshot
func (c *KinesisAnalyticsV2) CreateApplicationSnapshot(input *CreateApplicationSnapshotInput) (*CreateApplicationSnapshotOutput, error) {
	req, out := c.CreateApplicationSnapshotRequest(input)
	return out, req.Send()
}

// CreateApplicationSnapshotWithContext is the same as CreateApplicationSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplicationSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) CreateApplicationSnapshotWithContext(ctx aws.Context, input *CreateApplicationSnapshotInput, opts ...request.Option) (*CreateApplicationSnapshotOutput, error) {
	req, out := c.CreateApplicationSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplication
func (c *KinesisAnalyticsV2) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for Amazon Kinesis Analytics.
//
// Deletes the specified application. Kinesis Data Analytics halts application
// execution and deletes the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
//   * InvalidApplicationConfigurationException
//   The user-provided application configuration is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplication
func (c *KinesisAnalyticsV2) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationCloudWatchLoggingOption = "DeleteApplicationCloudWatchLoggingOption"

// DeleteApplicationCloudWatchLoggingOptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationCloudWatchLoggingOption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationCloudWatchLoggingOption for more information on using the DeleteApplicationCloudWatchLoggingOption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationCloudWatchLoggingOptionRequest method.
//    req, resp := client.DeleteApplicationCloudWatchLoggingOptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationCloudWatchLoggingOption
func (c *KinesisAnalyticsV2) DeleteApplicationCloudWatchLoggingOptionRequest(input *DeleteApplicationCloudWatchLoggingOptionInput) (req *request.Request, output *DeleteApplicationCloudWatchLoggingOptionOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationCloudWatchLoggingOption,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationCloudWatchLoggingOptionInput{}
	}

	output = &DeleteApplicationCloudWatchLoggingOptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApplicationCloudWatchLoggingOption API operation for Amazon Kinesis Analytics.
//
// Deletes an Amazon CloudWatch log stream from an Kinesis Data Analytics application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplicationCloudWatchLoggingOption for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
//   * InvalidApplicationConfigurationException
//   The user-provided application configuration is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationCloudWatchLoggingOption
func (c *KinesisAnalyticsV2) DeleteApplicationCloudWatchLoggingOption(input *DeleteApplicationCloudWatchLoggingOptionInput) (*DeleteApplicationCloudWatchLoggingOptionOutput, error) {
	req, out := c.DeleteApplicationCloudWatchLoggingOptionRequest(input)
	return out, req.Send()
}

// DeleteApplicationCloudWatchLoggingOptionWithContext is the same as DeleteApplicationCloudWatchLoggingOption with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationCloudWatchLoggingOption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DeleteApplicationCloudWatchLoggingOptionWithContext(ctx aws.Context, input *DeleteApplicationCloudWatchLoggingOptionInput, opts ...request.Option) (*DeleteApplicationCloudWatchLoggingOptionOutput, error) {
	req, out := c.DeleteApplicationCloudWatchLoggingOptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationInputProcessingConfiguration = "DeleteApplicationInputProcessingConfiguration"

// DeleteApplicationInputProcessingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationInputProcessingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationInputProcessingConfiguration for more information on using the DeleteApplicationInputProcessingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationInputProcessingConfigurationRequest method.
//    req, resp := client.DeleteApplicationInputProcessingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationInputProcessingConfiguration
func (c *KinesisAnalyticsV2) DeleteApplicationInputProcessingConfigurationRequest(input *DeleteApplicationInputProcessingConfigurationInput) (req *request.Request, output *DeleteApplicationInputProcessingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationInputProcessingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInputProcessingConfigurationInput{}
	}

	output = &DeleteApplicationInputProcessingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApplicationInputProcessingConfiguration API operation for Amazon Kinesis Analytics.
//
// Deletes an InputProcessingConfiguration from an input.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplicationInputProcessingConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationInputProcessingConfiguration
func (c *KinesisAnalyticsV2) DeleteApplicationInputProcessingConfiguration(input *DeleteApplicationInputProcessingConfigurationInput) (*DeleteApplicationInputProcessingConfigurationOutput, error) {
	req, out := c.DeleteApplicationInputProcessingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteApplicationInputProcessingConfigurationWithContext is the same as DeleteApplicationInputProcessingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationInputProcessingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DeleteApplicationInputProcessingConfigurationWithContext(ctx aws.Context, input *DeleteApplicationInputProcessingConfigurationInput, opts ...request.Option) (*DeleteApplicationInputProcessingConfigurationOutput, error) {
	req, out := c.DeleteApplicationInputProcessingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationOutput = "DeleteApplicationOutput"

// DeleteApplicationOutputRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationOutput for more information on using the DeleteApplicationOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationOutputRequest method.
//    req, resp := client.DeleteApplicationOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationOutput
func (c *KinesisAnalyticsV2) DeleteApplicationOutputRequest(input *DeleteApplicationOutputInput) (req *request.Request, output *DeleteApplicationOutputOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationOutput,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationOutputInput{}
	}

	output = &DeleteApplicationOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApplicationOutput API operation for Amazon Kinesis Analytics.
//
// Deletes the output destination configuration from your SQL-based Kinesis
// Data Analytics application's configuration. Kinesis Data Analytics will no
// longer write data from the corresponding in-application stream to the external
// output destination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplicationOutput for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationOutput
func (c *KinesisAnalyticsV2) DeleteApplicationOutput(input *DeleteApplicationOutputInput) (*DeleteApplicationOutputOutput, error) {
	req, out := c.DeleteApplicationOutputRequest(input)
	return out, req.Send()
}

// DeleteApplicationOutputWithContext is the same as DeleteApplicationOutput with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DeleteApplicationOutputWithContext(ctx aws.Context, input *DeleteApplicationOutputInput, opts ...request.Option) (*DeleteApplicationOutputOutput, error) {
	req, out := c.DeleteApplicationOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationReferenceDataSource = "DeleteApplicationReferenceDataSource"

// DeleteApplicationReferenceDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationReferenceDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationReferenceDataSource for more information on using the DeleteApplicationReferenceDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationReferenceDataSourceRequest method.
//    req, resp := client.DeleteApplicationReferenceDataSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationReferenceDataSource
func (c *KinesisAnalyticsV2) DeleteApplicationReferenceDataSourceRequest(input *DeleteApplicationReferenceDataSourceInput) (req *request.Request, output *DeleteApplicationReferenceDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationReferenceDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationReferenceDataSourceInput{}
	}

	output = &DeleteApplicationReferenceDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApplicationReferenceDataSource API operation for Amazon Kinesis Analytics.
//
// Deletes a reference data source configuration from the specified SQL-based
// Kinesis Data Analytics application's configuration.
//
// If the application is running, Kinesis Data Analytics immediately removes
// the in-application table that you created using the AddApplicationReferenceDataSource
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplicationReferenceDataSource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationReferenceDataSource
func (c *KinesisAnalyticsV2) DeleteApplicationReferenceDataSource(input *DeleteApplicationReferenceDataSourceInput) (*DeleteApplicationReferenceDataSourceOutput, error) {
	req, out := c.DeleteApplicationReferenceDataSourceRequest(input)
	return out, req.Send()
}

// DeleteApplicationReferenceDataSourceWithContext is the same as DeleteApplicationReferenceDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationReferenceDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DeleteApplicationReferenceDataSourceWithContext(ctx aws.Context, input *DeleteApplicationReferenceDataSourceInput, opts ...request.Option) (*DeleteApplicationReferenceDataSourceOutput, error) {
	req, out := c.DeleteApplicationReferenceDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationSnapshot = "DeleteApplicationSnapshot"

// DeleteApplicationSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationSnapshot for more information on using the DeleteApplicationSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationSnapshotRequest method.
//    req, resp := client.DeleteApplicationSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationSnapshot
func (c *KinesisAnalyticsV2) DeleteApplicationSnapshotRequest(input *DeleteApplicationSnapshotInput) (req *request.Request, output *DeleteApplicationSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationSnapshotInput{}
	}

	output = &DeleteApplicationSnapshotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationSnapshot API operation for Amazon Kinesis Analytics.
//
// Deletes a snapshot of application state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplicationSnapshot for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
//   * ResourceNotFoundException
//   Specified application can't be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationSnapshot
func (c *KinesisAnalyticsV2) DeleteApplicationSnapshot(input *DeleteApplicationSnapshotInput) (*DeleteApplicationSnapshotOutput, error) {
	req, out := c.DeleteApplicationSnapshotRequest(input)
	return out, req.Send()
}

// DeleteApplicationSnapshotWithContext is the same as DeleteApplicationSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DeleteApplicationSnapshotWithContext(ctx aws.Context, input *DeleteApplicationSnapshotInput, opts ...request.Option) (*DeleteApplicationSnapshotOutput, error) {
	req, out := c.DeleteApplicationSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationVpcConfiguration = "DeleteApplicationVpcConfiguration"

// DeleteApplicationVpcConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationVpcConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationVpcConfiguration for more information on using the DeleteApplicationVpcConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationVpcConfigurationRequest method.
//    req, resp := client.DeleteApplicationVpcConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationVpcConfiguration
func (c *KinesisAnalyticsV2) DeleteApplicationVpcConfigurationRequest(input *DeleteApplicationVpcConfigurationInput) (req *request.Request, output *DeleteApplicationVpcConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationVpcConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationVpcConfigurationInput{}
	}

	output = &DeleteApplicationVpcConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApplicationVpcConfiguration API operation for Amazon Kinesis Analytics.
//
// Removes a VPC configuration from a Kinesis Data Analytics application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DeleteApplicationVpcConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidApplicationConfigurationException
//   The user-provided application configuration is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationVpcConfiguration
func (c *KinesisAnalyticsV2) DeleteApplicationVpcConfiguration(input *DeleteApplicationVpcConfigurationInput) (*DeleteApplicationVpcConfigurationOutput, error) {
	req, out := c.DeleteApplicationVpcConfigurationRequest(input)
	return out, req.Send()
}

// DeleteApplicationVpcConfigurationWithContext is the same as DeleteApplicationVpcConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationVpcConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DeleteApplicationVpcConfigurationWithContext(ctx aws.Context, input *DeleteApplicationVpcConfigurationInput, opts ...request.Option) (*DeleteApplicationVpcConfigurationOutput, error) {
	req, out := c.DeleteApplicationVpcConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplication = "DescribeApplication"

// DescribeApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplication for more information on using the DescribeApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationRequest method.
//    req, resp := client.DescribeApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplication
func (c *KinesisAnalyticsV2) DescribeApplicationRequest(input *DescribeApplicationInput) (req *request.Request, output *DescribeApplicationOutput) {
	op := &request.Operation{
		Name:       opDescribeApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationInput{}
	}

	output = &DescribeApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplication API operation for Amazon Kinesis Analytics.
//
// Returns information about a specific Kinesis Data Analytics application.
//
// If you want to retrieve a list of all applications in your account, use the
// ListApplications operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DescribeApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplication
func (c *KinesisAnalyticsV2) DescribeApplication(input *DescribeApplicationInput) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	return out, req.Send()
}

// DescribeApplicationWithContext is the same as DescribeApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DescribeApplicationWithContext(ctx aws.Context, input *DescribeApplicationInput, opts ...request.Option) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicationSnapshot = "DescribeApplicationSnapshot"

// DescribeApplicationSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicationSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicationSnapshot for more information on using the DescribeApplicationSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationSnapshotRequest method.
//    req, resp := client.DescribeApplicationSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationSnapshot
func (c *KinesisAnalyticsV2) DescribeApplicationSnapshotRequest(input *DescribeApplicationSnapshotInput) (req *request.Request, output *DescribeApplicationSnapshotOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicationSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationSnapshotInput{}
	}

	output = &DescribeApplicationSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicationSnapshot API operation for Amazon Kinesis Analytics.
//
// Returns information about a snapshot of application state data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DescribeApplicationSnapshot for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationSnapshot
func (c *KinesisAnalyticsV2) DescribeApplicationSnapshot(input *DescribeApplicationSnapshotInput) (*DescribeApplicationSnapshotOutput, error) {
	req, out := c.DescribeApplicationSnapshotRequest(input)
	return out, req.Send()
}

// DescribeApplicationSnapshotWithContext is the same as DescribeApplicationSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicationSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DescribeApplicationSnapshotWithContext(ctx aws.Context, input *DescribeApplicationSnapshotInput, opts ...request.Option) (*DescribeApplicationSnapshotOutput, error) {
	req, out := c.DescribeApplicationSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicationVersion = "DescribeApplicationVersion"

// DescribeApplicationVersionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicationVersion for more information on using the DescribeApplicationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicationVersionRequest method.
//    req, resp := client.DescribeApplicationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationVersion
func (c *KinesisAnalyticsV2) DescribeApplicationVersionRequest(input *DescribeApplicationVersionInput) (req *request.Request, output *DescribeApplicationVersionOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationVersionInput{}
	}

	output = &DescribeApplicationVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicationVersion API operation for Amazon Kinesis Analytics.
//
// Provides a detailed description of a specified version of the application.
// To see a list of all the versions of an application, invoke the ListApplicationVersions
// operation.
//
// This operation is supported only for Amazon Kinesis Data Analytics for Apache
// Flink.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DescribeApplicationVersion for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationVersion
func (c *KinesisAnalyticsV2) DescribeApplicationVersion(input *DescribeApplicationVersionInput) (*DescribeApplicationVersionOutput, error) {
	req, out := c.DescribeApplicationVersionRequest(input)
	return out, req.Send()
}

// DescribeApplicationVersionWithContext is the same as DescribeApplicationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DescribeApplicationVersionWithContext(ctx aws.Context, input *DescribeApplicationVersionInput, opts ...request.Option) (*DescribeApplicationVersionOutput, error) {
	req, out := c.DescribeApplicationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDiscoverInputSchema = "DiscoverInputSchema"

// DiscoverInputSchemaRequest generates a "aws/request.Request" representing the
// client's request for the DiscoverInputSchema operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DiscoverInputSchema for more information on using the DiscoverInputSchema
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DiscoverInputSchemaRequest method.
//    req, resp := client.DiscoverInputSchemaRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DiscoverInputSchema
func (c *KinesisAnalyticsV2) DiscoverInputSchemaRequest(input *DiscoverInputSchemaInput) (req *request.Request, output *DiscoverInputSchemaOutput) {
	op := &request.Operation{
		Name:       opDiscoverInputSchema,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DiscoverInputSchemaInput{}
	}

	output = &DiscoverInputSchemaOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DiscoverInputSchema API operation for Amazon Kinesis Analytics.
//
// Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating
// sample records on the specified streaming source (Kinesis data stream or
// Kinesis Data Firehose delivery stream) or Amazon S3 object. In the response,
// the operation returns the inferred schema and also the sample records that
// the operation used to infer the schema.
//
// You can use the inferred schema when configuring a streaming source for your
// application. When you create an application using the Kinesis Data Analytics
// console, the console uses this operation to infer a schema and show it in
// the console user interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation DiscoverInputSchema for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * UnableToDetectSchemaException
//   The data format is not valid. Kinesis Data Analytics cannot detect the schema
//   for the given streaming source.
//
//   * ResourceProvisionedThroughputExceededException
//   Discovery failed to get a record from the streaming source because of the
//   Kinesis Streams ProvisionedThroughputExceededException. For more information,
//   see GetRecords (http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetRecords.html)
//   in the Amazon Kinesis Streams API Reference.
//
//   * ServiceUnavailableException
//   The service cannot complete the request.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DiscoverInputSchema
func (c *KinesisAnalyticsV2) DiscoverInputSchema(input *DiscoverInputSchemaInput) (*DiscoverInputSchemaOutput, error) {
	req, out := c.DiscoverInputSchemaRequest(input)
	return out, req.Send()
}

// DiscoverInputSchemaWithContext is the same as DiscoverInputSchema with the addition of
// the ability to pass a context and additional request options.
//
// See DiscoverInputSchema for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) DiscoverInputSchemaWithContext(ctx aws.Context, input *DiscoverInputSchemaInput, opts ...request.Option) (*DiscoverInputSchemaOutput, error) {
	req, out := c.DiscoverInputSchemaRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplicationSnapshots = "ListApplicationSnapshots"

// ListApplicationSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationSnapshots for more information on using the ListApplicationSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationSnapshotsRequest method.
//    req, resp := client.ListApplicationSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationSnapshots
func (c *KinesisAnalyticsV2) ListApplicationSnapshotsRequest(input *ListApplicationSnapshotsInput) (req *request.Request, output *ListApplicationSnapshotsOutput) {
	op := &request.Operation{
		Name:       opListApplicationSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListApplicationSnapshotsInput{}
	}

	output = &ListApplicationSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationSnapshots API operation for Amazon Kinesis Analytics.
//
// Lists information about the current application snapshots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation ListApplicationSnapshots for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationSnapshots
func (c *KinesisAnalyticsV2) ListApplicationSnapshots(input *ListApplicationSnapshotsInput) (*ListApplicationSnapshotsOutput, error) {
	req, out := c.ListApplicationSnapshotsRequest(input)
	return out, req.Send()
}

// ListApplicationSnapshotsWithContext is the same as ListApplicationSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) ListApplicationSnapshotsWithContext(ctx aws.Context, input *ListApplicationSnapshotsInput, opts ...request.Option) (*ListApplicationSnapshotsOutput, error) {
	req, out := c.ListApplicationSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplicationVersions = "ListApplicationVersions"

// ListApplicationVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationVersions for more information on using the ListApplicationVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationVersionsRequest method.
//    req, resp := client.ListApplicationVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationVersions
func (c *KinesisAnalyticsV2) ListApplicationVersionsRequest(input *ListApplicationVersionsInput) (req *request.Request, output *ListApplicationVersionsOutput) {
	op := &request.Operation{
		Name:       opListApplicationVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListApplicationVersionsInput{}
	}

	output = &ListApplicationVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationVersions API operation for Amazon Kinesis Analytics.
//
// Lists all the versions for the specified application, including versions
// that were rolled back. The response also includes a summary of the configuration
// associated with each version.
//
// To get the complete description of a specific application version, invoke
// the DescribeApplicationVersion operation.
//
// This operation is supported only for Amazon Kinesis Data Analytics for Apache
// Flink.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation ListApplicationVersions for usage and error information.
//
// Returned Error Types:
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationVersions
func (c *KinesisAnalyticsV2) ListApplicationVersions(input *ListApplicationVersionsInput) (*ListApplicationVersionsOutput, error) {
	req, out := c.ListApplicationVersionsRequest(input)
	return out, req.Send()
}

// ListApplicationVersionsWithContext is the same as ListApplicationVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) ListApplicationVersionsWithContext(ctx aws.Context, input *ListApplicationVersionsInput, opts ...request.Option) (*ListApplicationVersionsOutput, error) {
	req, out := c.ListApplicationVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications
func (c *KinesisAnalyticsV2) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for Amazon Kinesis Analytics.
//
// Returns a list of Kinesis Data Analytics applications in your account. For
// each application, the response includes the application name, Amazon Resource
// Name (ARN), and status.
//
// If you want detailed information about a specific application, use DescribeApplication.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications
func (c *KinesisAnalyticsV2) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListTagsForResource
func (c *KinesisAnalyticsV2) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Kinesis Analytics.
//
// Retrieves the list of key-value tags assigned to the application. For more
// information, see Using Tagging (https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListTagsForResource
func (c *KinesisAnalyticsV2) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRollbackApplication = "RollbackApplication"

// RollbackApplicationRequest generates a "aws/request.Request" representing the
// client's request for the RollbackApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RollbackApplication for more information on using the RollbackApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RollbackApplicationRequest method.
//    req, resp := client.RollbackApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RollbackApplication
func (c *KinesisAnalyticsV2) RollbackApplicationRequest(input *RollbackApplicationInput) (req *request.Request, output *RollbackApplicationOutput) {
	op := &request.Operation{
		Name:       opRollbackApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RollbackApplicationInput{}
	}

	output = &RollbackApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RollbackApplication API operation for Amazon Kinesis Analytics.
//
// Reverts the application to the previous running version. You can roll back
// an application if you suspect it is stuck in a transient status.
//
// You can roll back an application only if it is in the UPDATING or AUTOSCALING
// status.
//
// When you rollback an application, it loads state data from the last successful
// snapshot. If the application has no snapshots, Kinesis Data Analytics rejects
// the rollback request.
//
// This action is not supported for Kinesis Data Analytics for SQL applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation RollbackApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RollbackApplication
func (c *KinesisAnalyticsV2) RollbackApplication(input *RollbackApplicationInput) (*RollbackApplicationOutput, error) {
	req, out := c.RollbackApplicationRequest(input)
	return out, req.Send()
}

// RollbackApplicationWithContext is the same as RollbackApplication with the addition of
// the ability to pass a context and additional request options.
//
// See RollbackApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) RollbackApplicationWithContext(ctx aws.Context, input *RollbackApplicationInput, opts ...request.Option) (*RollbackApplicationOutput, error) {
	req, out := c.RollbackApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartApplication = "StartApplication"

// StartApplicationRequest generates a "aws/request.Request" representing the
// client's request for the StartApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartApplication for more information on using the StartApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartApplicationRequest method.
//    req, resp := client.StartApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StartApplication
func (c *KinesisAnalyticsV2) StartApplicationRequest(input *StartApplicationInput) (req *request.Request, output *StartApplicationOutput) {
	op := &request.Operation{
		Name:       opStartApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartApplicationInput{}
	}

	output = &StartApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartApplication API operation for Amazon Kinesis Analytics.
//
// Starts the specified Kinesis Data Analytics application. After creating an
// application, you must exclusively call this operation to start your application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation StartApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * InvalidApplicationConfigurationException
//   The user-provided application configuration is not valid.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StartApplication
func (c *KinesisAnalyticsV2) StartApplication(input *StartApplicationInput) (*StartApplicationOutput, error) {
	req, out := c.StartApplicationRequest(input)
	return out, req.Send()
}

// StartApplicationWithContext is the same as StartApplication with the addition of
// the ability to pass a context and additional request options.
//
// See StartApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) StartApplicationWithContext(ctx aws.Context, input *StartApplicationInput, opts ...request.Option) (*StartApplicationOutput, error) {
	req, out := c.StartApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopApplication = "StopApplication"

// StopApplicationRequest generates a "aws/request.Request" representing the
// client's request for the StopApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopApplication for more information on using the StopApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopApplicationRequest method.
//    req, resp := client.StopApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StopApplication
func (c *KinesisAnalyticsV2) StopApplicationRequest(input *StopApplicationInput) (req *request.Request, output *StopApplicationOutput) {
	op := &request.Operation{
		Name:       opStopApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopApplicationInput{}
	}

	output = &StopApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopApplication API operation for Amazon Kinesis Analytics.
//
// Stops the application from processing data. You can stop an application only
// if it is in the running status, unless you set the Force parameter to true.
//
// You can use the DescribeApplication operation to find the application status.
//
// Kinesis Data Analytics takes a snapshot when the application is stopped,
// unless Force is set to true.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation StopApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
//   * InvalidApplicationConfigurationException
//   The user-provided application configuration is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StopApplication
func (c *KinesisAnalyticsV2) StopApplication(input *StopApplicationInput) (*StopApplicationOutput, error) {
	req, out := c.StopApplicationRequest(input)
	return out, req.Send()
}

// StopApplicationWithContext is the same as StopApplication with the addition of
// the ability to pass a context and additional request options.
//
// See StopApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) StopApplicationWithContext(ctx aws.Context, input *StopApplicationInput, opts ...request.Option) (*StopApplicationOutput, error) {
	req, out := c.StopApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/TagResource
func (c *KinesisAnalyticsV2) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Kinesis Analytics.
//
// Adds one or more key-value tags to a Kinesis Data Analytics application.
// Note that the maximum number of application tags includes system tags. The
// maximum number of user-defined application tags is 50. For more information,
// see Using Tagging (https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * TooManyTagsException
//   Application created with too many tags, or too many tags added to an application.
//   Note that the maximum number of application tags includes system tags. The
//   maximum number of user-defined application tags is 50.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/TagResource
func (c *KinesisAnalyticsV2) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UntagResource
func (c *KinesisAnalyticsV2) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Kinesis Analytics.
//
// Removes one or more tags from a Kinesis Data Analytics application. For more
// information, see Using Tagging (https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * TooManyTagsException
//   Application created with too many tags, or too many tags added to an application.
//   Note that the maximum number of application tags includes system tags. The
//   maximum number of user-defined application tags is 50.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UntagResource
func (c *KinesisAnalyticsV2) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplication
func (c *KinesisAnalyticsV2) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplication API operation for Amazon Kinesis Analytics.
//
// Updates an existing Kinesis Data Analytics application. Using this operation,
// you can update application code, input configuration, and output configuration.
//
// Kinesis Data Analytics updates the ApplicationVersionId each time you update
// your application.
//
// You cannot update the RuntimeEnvironment of an existing application. If you
// need to update an application's RuntimeEnvironment, you must delete the application
// and create it again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//   * CodeValidationException
//   The user-provided application code (query) is not valid. This can be a simple
//   syntax error.
//
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * InvalidRequestException
//   The request JSON is not valid for the operation.
//
//   * InvalidApplicationConfigurationException
//   The user-provided application configuration is not valid.
//
//   * LimitExceededException
//   The number of allowed resources has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplication
func (c *KinesisAnalyticsV2) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplicationMaintenanceConfiguration = "UpdateApplicationMaintenanceConfiguration"

// UpdateApplicationMaintenanceConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplicationMaintenanceConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplicationMaintenanceConfiguration for more information on using the UpdateApplicationMaintenanceConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationMaintenanceConfigurationRequest method.
//    req, resp := client.UpdateApplicationMaintenanceConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplicationMaintenanceConfiguration
func (c *KinesisAnalyticsV2) UpdateApplicationMaintenanceConfigurationRequest(input *UpdateApplicationMaintenanceConfigurationInput) (req *request.Request, output *UpdateApplicationMaintenanceConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplicationMaintenanceConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationMaintenanceConfigurationInput{}
	}

	output = &UpdateApplicationMaintenanceConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplicationMaintenanceConfiguration API operation for Amazon Kinesis Analytics.
//
// Updates the maintenance configuration of the Kinesis Data Analytics application.
//
// You can invoke this operation on an application that is in one of the two
// following states: READY or RUNNING. If you invoke it when the application
// is in a state other than these two states, it throws a ResourceInUseException.
// The service makes use of the updated configuration the next time it schedules
// maintenance for the application. If you invoke this operation after the service
// schedules maintenance, the service will apply the configuration update the
// next time it schedules maintenance for the application. This means that you
// might not see the maintenance configuration update applied to the maintenance
// process that follows a successful invocation of this operation, but to the
// following maintenance process instead.
//
// To see the current maintenance configuration of your application, invoke
// the DescribeApplication operation.
//
// For information about application maintenance, see Kinesis Data Analytics
// for Apache Flink Maintenance (https://docs.aws.amazon.com/kinesisanalytics/latest/java/maintenance.html).
//
// This operation is supported only for Amazon Kinesis Data Analytics for Apache
// Flink.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Analytics's
// API operation UpdateApplicationMaintenanceConfiguration for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Specified application can't be found.
//
//   * ResourceInUseException
//   The application is not available for this operation.
//
//   * InvalidArgumentException
//   The specified input parameter value is not valid.
//
//   * ConcurrentModificationException
//   Exception thrown as a result of concurrent modifications to an application.
//   This error can be the result of attempting to modify an application without
//   using the current application ID.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplicationMaintenanceConfiguration
func (c *KinesisAnalyticsV2) UpdateApplicationMaintenanceConfiguration(input *UpdateApplicationMaintenanceConfigurationInput) (*UpdateApplicationMaintenanceConfigurationOutput, error) {
	req, out := c.UpdateApplicationMaintenanceConfigurationRequest(input)
	return out, req.Send()
}

// UpdateApplicationMaintenanceConfigurationWithContext is the same as UpdateApplicationMaintenanceConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplicationMaintenanceConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisAnalyticsV2) UpdateApplicationMaintenanceConfigurationWithContext(ctx aws.Context, input *UpdateApplicationMaintenanceConfigurationInput, opts ...request.Option) (*UpdateApplicationMaintenanceConfigurationOutput, error) {
	req, out := c.UpdateApplicationMaintenanceConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddApplicationCloudWatchLoggingOptionInput struct {
	_ struct{} `type:"structure"`

	// The Kinesis Data Analytics application name.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Provides the Amazon CloudWatch log stream Amazon Resource Name (ARN).
	//
	// CloudWatchLoggingOption is a required field
	CloudWatchLoggingOption *CloudWatchLoggingOption `type:"structure" required:"true"`

	// A value you use to implement strong concurrency for application updates.
	// You must provide the CurrentApplicationVersionId or the ConditionalToken.
	// You get the application's current ConditionalToken using DescribeApplication.
	// For better concurrency support, use the ConditionalToken parameter instead
	// of CurrentApplicationVersionId.
	ConditionalToken *string `min:"1" type:"string"`

	// The version ID of the Kinesis Data Analytics application. You must provide
	// the CurrentApplicationVersionId or the ConditionalToken.You can retrieve
	// the application version ID using DescribeApplication. For better concurrency
	// support, use the ConditionalToken parameter instead of CurrentApplicationVersionId.
	CurrentApplicationVersionId *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationCloudWatchLoggingOptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationCloudWatchLoggingOptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationCloudWatchLoggingOptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationCloudWatchLoggingOptionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CloudWatchLoggingOption == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLoggingOption"))
	}
	if s.ConditionalToken != nil && len(*s.ConditionalToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConditionalToken", 1))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.CloudWatchLoggingOption != nil {
		if err := s.CloudWatchLoggingOption.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLoggingOption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationCloudWatchLoggingOptionInput) SetApplicationName(v string) *AddApplicationCloudWatchLoggingOptionInput {
	s.ApplicationName = &v
	return s
}

// SetCloudWatchLoggingOption sets the CloudWatchLoggingOption field's value.
func (s *AddApplicationCloudWatchLoggingOptionInput) SetCloudWatchLoggingOption(v *CloudWatchLoggingOption) *AddApplicationCloudWatchLoggingOptionInput {
	s.CloudWatchLoggingOption = v
	return s
}

// SetConditionalToken sets the ConditionalToken field's value.
func (s *AddApplicationCloudWatchLoggingOptionInput) SetConditionalToken(v string) *AddApplicationCloudWatchLoggingOptionInput {
	s.ConditionalToken = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationCloudWatchLoggingOptionInput) SetCurrentApplicationVersionId(v int64) *AddApplicationCloudWatchLoggingOptionInput {
	s.CurrentApplicationVersionId = &v
	return s
}

type AddApplicationCloudWatchLoggingOptionOutput struct {
	_ struct{} `type:"structure"`

	// The application's ARN.
	ApplicationARN *string `min:"1" type:"string"`

	// The new version ID of the Kinesis Data Analytics application. Kinesis Data
	// Analytics updates the ApplicationVersionId each time you change the CloudWatch
	// logging options.
	ApplicationVersionId *int64 `min:"1" type:"long"`

	// The descriptions of the current CloudWatch logging options for the Kinesis
	// Data Analytics application.
	CloudWatchLoggingOptionDescriptions []*CloudWatchLoggingOptionDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationCloudWatchLoggingOptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationCloudWatchLoggingOptionOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *AddApplicationCloudWatchLoggingOptionOutput) SetApplicationARN(v string) *AddApplicationCloudWatchLoggingOptionOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *AddApplicationCloudWatchLoggingOptionOutput) SetApplicationVersionId(v int64) *AddApplicationCloudWatchLoggingOptionOutput {
	s.ApplicationVersionId = &v
	return s
}

// SetCloudWatchLoggingOptionDescriptions sets the CloudWatchLoggingOptionDescriptions field's value.
func (s *AddApplicationCloudWatchLoggingOptionOutput) SetCloudWatchLoggingOptionDescriptions(v []*CloudWatchLoggingOptionDescription) *AddApplicationCloudWatchLoggingOptionOutput {
	s.CloudWatchLoggingOptionDescriptions = v
	return s
}

type AddApplicationInputInput struct {
	_ struct{} `type:"structure"`

	// The name of your existing application to which you want to add the streaming
	// source.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The current version of your application. You must provide the ApplicationVersionID
	// or the ConditionalToken.You can use the DescribeApplication operation to
	// find the current application version.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The Input to add.
	//
	// Input is a required field
	Input *Input `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationInputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationInputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationInputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationInputInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.Input == nil {
		invalidParams.Add(request.NewErrParamRequired("Input"))
	}
	if s.Input != nil {
		if err := s.Input.Validate(); err != nil {
			invalidParams.AddNested("Input", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationInputInput) SetApplicationName(v string) *AddApplicationInputInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationInputInput) SetCurrentApplicationVersionId(v int64) *AddApplicationInputInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetInput sets the Input field's value.
func (s *AddApplicationInputInput) SetInput(v *Input) *AddApplicationInputInput {
	s.Input = v
	return s
}

type AddApplicationInputOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	ApplicationARN *string `min:"1" type:"string"`

	// Provides the current application version.
	ApplicationVersionId *int64 `min:"1" type:"long"`

	// Describes the application input configuration.
	InputDescriptions []*InputDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationInputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationInputOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *AddApplicationInputOutput) SetApplicationARN(v string) *AddApplicationInputOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *AddApplicationInputOutput) SetApplicationVersionId(v int64) *AddApplicationInputOutput {
	s.ApplicationVersionId = &v
	return s
}

// SetInputDescriptions sets the InputDescriptions field's value.
func (s *AddApplicationInputOutput) SetInputDescriptions(v []*InputDescription) *AddApplicationInputOutput {
	s.InputDescriptions = v
	return s
}

type AddApplicationInputProcessingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to which you want to add the input processing
	// configuration.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The version of the application to which you want to add the input processing
	// configuration. You can use the DescribeApplication operation to get the current
	// application version. If the version specified is not the current version,
	// the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The ID of the input configuration to add the input processing configuration
	// to. You can get a list of the input IDs for an application using the DescribeApplication
	// operation.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`

	// The InputProcessingConfiguration to add to the application.
	//
	// InputProcessingConfiguration is a required field
	InputProcessingConfiguration *InputProcessingConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationInputProcessingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationInputProcessingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationInputProcessingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationInputProcessingConfigurationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}
	if s.InputProcessingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InputProcessingConfiguration"))
	}
	if s.InputProcessingConfiguration != nil {
		if err := s.InputProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationInputProcessingConfigurationInput) SetApplicationName(v string) *AddApplicationInputProcessingConfigurationInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationInputProcessingConfigurationInput) SetCurrentApplicationVersionId(v int64) *AddApplicationInputProcessingConfigurationInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetInputId sets the InputId field's value.
func (s *AddApplicationInputProcessingConfigurationInput) SetInputId(v string) *AddApplicationInputProcessingConfigurationInput {
	s.InputId = &v
	return s
}

// SetInputProcessingConfiguration sets the InputProcessingConfiguration field's value.
func (s *AddApplicationInputProcessingConfigurationInput) SetInputProcessingConfiguration(v *InputProcessingConfiguration) *AddApplicationInputProcessingConfigurationInput {
	s.InputProcessingConfiguration = v
	return s
}

type AddApplicationInputProcessingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	ApplicationARN *string `min:"1" type:"string"`

	// Provides the current application version.
	ApplicationVersionId *int64 `min:"1" type:"long"`

	// The input ID that is associated with the application input. This is the ID
	// that Kinesis Data Analytics assigns to each input configuration that you
	// add to your application.
	InputId *string `min:"1" type:"string"`

	// The description of the preprocessor that executes on records in this input
	// before the application's code is run.
	InputProcessingConfigurationDescription *InputProcessingConfigurationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationInputProcessingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationInputProcessingConfigurationOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *AddApplicationInputProcessingConfigurationOutput) SetApplicationARN(v string) *AddApplicationInputProcessingConfigurationOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *AddApplicationInputProcessingConfigurationOutput) SetApplicationVersionId(v int64) *AddApplicationInputProcessingConfigurationOutput {
	s.ApplicationVersionId = &v
	return s
}

// SetInputId sets the InputId field's value.
func (s *AddApplicationInputProcessingConfigurationOutput) SetInputId(v string) *AddApplicationInputProcessingConfigurationOutput {
	s.InputId = &v
	return s
}

// SetInputProcessingConfigurationDescription sets the InputProcessingConfigurationDescription field's value.
func (s *AddApplicationInputProcessingConfigurationOutput) SetInputProcessingConfigurationDescription(v *InputProcessingConfigurationDescription) *AddApplicationInputProcessingConfigurationOutput {
	s.InputProcessingConfigurationDescription = v
	return s
}

type AddApplicationOutputInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to which you want to add the output configuration.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The version of the application to which you want to add the output configuration.
	// You can use the DescribeApplication operation to get the current application
	// version. If the version specified is not the current version, the ConcurrentModificationException
	// is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// An array of objects, each describing one output configuration. In the output
	// configuration, you specify the name of an in-application stream, a destination
	// (that is, a Kinesis data stream, a Kinesis Data Firehose delivery stream,
	// or an Amazon Lambda function), and record the formation to use when writing
	// to the destination.
	//
	// Output is a required field
	Output *Output `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationOutputInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.Output == nil {
		invalidParams.Add(request.NewErrParamRequired("Output"))
	}
	if s.Output != nil {
		if err := s.Output.Validate(); err != nil {
			invalidParams.AddNested("Output", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationOutputInput) SetApplicationName(v string) *AddApplicationOutputInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationOutputInput) SetCurrentApplicationVersionId(v int64) *AddApplicationOutputInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *AddApplicationOutputInput) SetOutput(v *Output) *AddApplicationOutputInput {
	s.Output = v
	return s
}

type AddApplicationOutputOutput struct {
	_ struct{} `type:"structure"`

	// The application Amazon Resource Name (ARN).
	ApplicationARN *string `min:"1" type:"string"`

	// The updated application version ID. Kinesis Data Analytics increments this
	// ID when the application is updated.
	ApplicationVersionId *int64 `min:"1" type:"long"`

	// Describes the application output configuration. For more information, see
	// Configuring Application Output (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
	OutputDescriptions []*OutputDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationOutputOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *AddApplicationOutputOutput) SetApplicationARN(v string) *AddApplicationOutputOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *AddApplicationOutputOutput) SetApplicationVersionId(v int64) *AddApplicationOutputOutput {
	s.ApplicationVersionId = &v
	return s
}

// SetOutputDescriptions sets the OutputDescriptions field's value.
func (s *AddApplicationOutputOutput) SetOutputDescriptions(v []*OutputDescription) *AddApplicationOutputOutput {
	s.OutputDescriptions = v
	return s
}

type AddApplicationReferenceDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The version of the application for which you are adding the reference data
	// source. You can use the DescribeApplication operation to get the current
	// application version. If the version specified is not the current version,
	// the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The reference data source can be an object in your Amazon S3 bucket. Kinesis
	// Data Analytics reads the object and copies the data into the in-application
	// table that is created. You provide an S3 bucket, object key name, and the
	// resulting in-application table that is created.
	//
	// ReferenceDataSource is a required field
	ReferenceDataSource *ReferenceDataSource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationReferenceDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationReferenceDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationReferenceDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationReferenceDataSourceInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.ReferenceDataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceDataSource"))
	}
	if s.ReferenceDataSource != nil {
		if err := s.ReferenceDataSource.Validate(); err != nil {
			invalidParams.AddNested("ReferenceDataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationReferenceDataSourceInput) SetApplicationName(v string) *AddApplicationReferenceDataSourceInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationReferenceDataSourceInput) SetCurrentApplicationVersionId(v int64) *AddApplicationReferenceDataSourceInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetReferenceDataSource sets the ReferenceDataSource field's value.
func (s *AddApplicationReferenceDataSourceInput) SetReferenceDataSource(v *ReferenceDataSource) *AddApplicationReferenceDataSourceInput {
	s.ReferenceDataSource = v
	return s
}

type AddApplicationReferenceDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The application Amazon Resource Name (ARN).
	ApplicationARN *string `min:"1" type:"string"`

	// The updated application version ID. Kinesis Data Analytics increments this
	// ID when the application is updated.
	ApplicationVersionId *int64 `min:"1" type:"long"`

	// Describes reference data sources configured for the application.
	ReferenceDataSourceDescriptions []*ReferenceDataSourceDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationReferenceDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationReferenceDataSourceOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *AddApplicationReferenceDataSourceOutput) SetApplicationARN(v string) *AddApplicationReferenceDataSourceOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *AddApplicationReferenceDataSourceOutput) SetApplicationVersionId(v int64) *AddApplicationReferenceDataSourceOutput {
	s.ApplicationVersionId = &v
	return s
}

// SetReferenceDataSourceDescriptions sets the ReferenceDataSourceDescriptions field's value.
func (s *AddApplicationReferenceDataSourceOutput) SetReferenceDataSourceDescriptions(v []*ReferenceDataSourceDescription) *AddApplicationReferenceDataSourceOutput {
	s.ReferenceDataSourceDescriptions = v
	return s
}

type AddApplicationVpcConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// A value you use to implement strong concurrency for application updates.
	// You must provide the ApplicationVersionID or the ConditionalToken. You get
	// the application's current ConditionalToken using DescribeApplication. For
	// better concurrency support, use the ConditionalToken parameter instead of
	// CurrentApplicationVersionId.
	ConditionalToken *string `min:"1" type:"string"`

	// The version of the application to which you want to add the VPC configuration.
	// You must provide the CurrentApplicationVersionId or the ConditionalToken.
	// You can use the DescribeApplication operation to get the current application
	// version. If the version specified is not the current version, the ConcurrentModificationException
	// is returned. For better concurrency support, use the ConditionalToken parameter
	// instead of CurrentApplicationVersionId.
	CurrentApplicationVersionId *int64 `min:"1" type:"long"`

	// Description of the VPC to add to the application.
	//
	// VpcConfiguration is a required field
	VpcConfiguration *VpcConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationVpcConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationVpcConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddApplicationVpcConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddApplicationVpcConfigurationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.ConditionalToken != nil && len(*s.ConditionalToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConditionalToken", 1))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.VpcConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcConfiguration"))
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *AddApplicationVpcConfigurationInput) SetApplicationName(v string) *AddApplicationVpcConfigurationInput {
	s.ApplicationName = &v
	return s
}

// SetConditionalToken sets the ConditionalToken field's value.
func (s *AddApplicationVpcConfigurationInput) SetConditionalToken(v string) *AddApplicationVpcConfigurationInput {
	s.ConditionalToken = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *AddApplicationVpcConfigurationInput) SetCurrentApplicationVersionId(v int64) *AddApplicationVpcConfigurationInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *AddApplicationVpcConfigurationInput) SetVpcConfiguration(v *VpcConfiguration) *AddApplicationVpcConfigurationInput {
	s.VpcConfiguration = v
	return s
}

type AddApplicationVpcConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the application.
	ApplicationARN *string `min:"1" type:"string"`

	// Provides the current application version. Kinesis Data Analytics updates
	// the ApplicationVersionId each time you update the application.
	ApplicationVersionId *int64 `min:"1" type:"long"`

	// The parameters of the new VPC configuration.
	VpcConfigurationDescription *VpcConfigurationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationVpcConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddApplicationVpcConfigurationOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *AddApplicationVpcConfigurationOutput) SetApplicationARN(v string) *AddApplicationVpcConfigurationOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *AddApplicationVpcConfigurationOutput) SetApplicationVersionId(v int64) *AddApplicationVpcConfigurationOutput {
	s.ApplicationVersionId = &v
	return s
}

// SetVpcConfigurationDescription sets the VpcConfigurationDescription field's value.
func (s *AddApplicationVpcConfigurationOutput) SetVpcConfigurationDescription(v *VpcConfigurationDescription) *AddApplicationVpcConfigurationOutput {
	s.VpcConfigurationDescription = v
	return s
}

// Describes code configuration for an application.
type ApplicationCodeConfiguration struct {
	_ struct{} `type:"structure"`

	// The location and type of the application code.
	CodeContent *CodeContent `type:"structure"`

	// Specifies whether the code content is in text or zip format.
	//
	// CodeContentType is a required field
	CodeContentType *string `type:"string" required:"true" enum:"CodeContentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationCodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationCodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationCodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationCodeConfiguration"}
	if s.CodeContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("CodeContentType"))
	}
	if s.CodeContent != nil {
		if err := s.CodeContent.Validate(); err != nil {
			invalidParams.AddNested("CodeContent", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeContent sets the CodeContent field's value.
func (s *ApplicationCodeConfiguration) SetCodeContent(v *CodeContent) *ApplicationCodeConfiguration {
	s.CodeContent = v
	return s
}

// SetCodeContentType sets the CodeContentType field's value.
func (s *ApplicationCodeConfiguration) SetCodeContentType(v string) *ApplicationCodeConfiguration {
	s.CodeContentType = &v
	return s
}

// Describes code configuration for an application.
type ApplicationCodeConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes details about the location and format of the application code.
	CodeContentDescription *CodeContentDescription `type:"structure"`

	// Specifies whether the code content is in text or zip format.
	//
	// CodeContentType is a required field
	CodeContentType *string `type:"string" required:"true" enum:"CodeContentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationCodeConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationCodeConfigurationDescription) GoString() string {
	return s.String()
}

// SetCodeContentDescription sets the CodeContentDescription field's value.
func (s *ApplicationCodeConfigurationDescription) SetCodeContentDescription(v *CodeContentDescription) *ApplicationCodeConfigurationDescription {
	s.CodeContentDescription = v
	return s
}

// SetCodeContentType sets the CodeContentType field's value.
func (s *ApplicationCodeConfigurationDescription) SetCodeContentType(v string) *ApplicationCodeConfigurationDescription {
	s.CodeContentType = &v
	return s
}

// Describes code configuration updates for an application. This is supported
// for a Flink-based Kinesis Data Analytics application or a SQL-based Kinesis
// Data Analytics application.
type ApplicationCodeConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to the code content type.
	CodeContentTypeUpdate *string `type:"string" enum:"CodeContentType"`

	// Describes updates to the code content of an application.
	CodeContentUpdate *CodeContentUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationCodeConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationCodeConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationCodeConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationCodeConfigurationUpdate"}
	if s.CodeContentUpdate != nil {
		if err := s.CodeContentUpdate.Validate(); err != nil {
			invalidParams.AddNested("CodeContentUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeContentTypeUpdate sets the CodeContentTypeUpdate field's value.
func (s *ApplicationCodeConfigurationUpdate) SetCodeContentTypeUpdate(v string) *ApplicationCodeConfigurationUpdate {
	s.CodeContentTypeUpdate = &v
	return s
}

// SetCodeContentUpdate sets the CodeContentUpdate field's value.
func (s *ApplicationCodeConfigurationUpdate) SetCodeContentUpdate(v *CodeContentUpdate) *ApplicationCodeConfigurationUpdate {
	s.CodeContentUpdate = v
	return s
}

// Specifies the creation parameters for a Kinesis Data Analytics application.
type ApplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// The code location and type parameters for a Flink-based Kinesis Data Analytics
	// application.
	ApplicationCodeConfiguration *ApplicationCodeConfiguration `type:"structure"`

	// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
	// application.
	ApplicationSnapshotConfiguration *ApplicationSnapshotConfiguration `type:"structure"`

	// Describes execution properties for a Flink-based Kinesis Data Analytics application.
	EnvironmentProperties *EnvironmentProperties `type:"structure"`

	// The creation and update parameters for a Flink-based Kinesis Data Analytics
	// application.
	FlinkApplicationConfiguration *FlinkApplicationConfiguration `type:"structure"`

	// The creation and update parameters for a SQL-based Kinesis Data Analytics
	// application.
	SqlApplicationConfiguration *SqlApplicationConfiguration `type:"structure"`

	// The array of descriptions of VPC configurations available to the application.
	VpcConfigurations []*VpcConfiguration `type:"list"`

	// The configuration parameters for a Kinesis Data Analytics Studio notebook.
	ZeppelinApplicationConfiguration *ZeppelinApplicationConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationConfiguration"}
	if s.ApplicationCodeConfiguration != nil {
		if err := s.ApplicationCodeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ApplicationCodeConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ApplicationSnapshotConfiguration != nil {
		if err := s.ApplicationSnapshotConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSnapshotConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.EnvironmentProperties != nil {
		if err := s.EnvironmentProperties.Validate(); err != nil {
			invalidParams.AddNested("EnvironmentProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.FlinkApplicationConfiguration != nil {
		if err := s.FlinkApplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FlinkApplicationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SqlApplicationConfiguration != nil {
		if err := s.SqlApplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SqlApplicationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfigurations != nil {
		for i, v := range s.VpcConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VpcConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ZeppelinApplicationConfiguration != nil {
		if err := s.ZeppelinApplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ZeppelinApplicationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationCodeConfiguration sets the ApplicationCodeConfiguration field's value.
func (s *ApplicationConfiguration) SetApplicationCodeConfiguration(v *ApplicationCodeConfiguration) *ApplicationConfiguration {
	s.ApplicationCodeConfiguration = v
	return s
}

// SetApplicationSnapshotConfiguration sets the ApplicationSnapshotConfiguration field's value.
func (s *ApplicationConfiguration) SetApplicationSnapshotConfiguration(v *ApplicationSnapshotConfiguration) *ApplicationConfiguration {
	s.ApplicationSnapshotConfiguration = v
	return s
}

// SetEnvironmentProperties sets the EnvironmentProperties field's value.
func (s *ApplicationConfiguration) SetEnvironmentProperties(v *EnvironmentProperties) *ApplicationConfiguration {
	s.EnvironmentProperties = v
	return s
}

// SetFlinkApplicationConfiguration sets the FlinkApplicationConfiguration field's value.
func (s *ApplicationConfiguration) SetFlinkApplicationConfiguration(v *FlinkApplicationConfiguration) *ApplicationConfiguration {
	s.FlinkApplicationConfiguration = v
	return s
}

// SetSqlApplicationConfiguration sets the SqlApplicationConfiguration field's value.
func (s *ApplicationConfiguration) SetSqlApplicationConfiguration(v *SqlApplicationConfiguration) *ApplicationConfiguration {
	s.SqlApplicationConfiguration = v
	return s
}

// SetVpcConfigurations sets the VpcConfigurations field's value.
func (s *ApplicationConfiguration) SetVpcConfigurations(v []*VpcConfiguration) *ApplicationConfiguration {
	s.VpcConfigurations = v
	return s
}

// SetZeppelinApplicationConfiguration sets the ZeppelinApplicationConfiguration field's value.
func (s *ApplicationConfiguration) SetZeppelinApplicationConfiguration(v *ZeppelinApplicationConfiguration) *ApplicationConfiguration {
	s.ZeppelinApplicationConfiguration = v
	return s
}

// Describes details about the application code and starting parameters for
// a Kinesis Data Analytics application.
type ApplicationConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The details about the application code for a Flink-based Kinesis Data Analytics
	// application.
	ApplicationCodeConfigurationDescription *ApplicationCodeConfigurationDescription `type:"structure"`

	// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
	// application.
	ApplicationSnapshotConfigurationDescription *ApplicationSnapshotConfigurationDescription `type:"structure"`

	// Describes execution properties for a Flink-based Kinesis Data Analytics application.
	EnvironmentPropertyDescriptions *EnvironmentPropertyDescriptions `type:"structure"`

	// The details about a Flink-based Kinesis Data Analytics application.
	FlinkApplicationConfigurationDescription *FlinkApplicationConfigurationDescription `type:"structure"`

	// The details about the starting properties for a Kinesis Data Analytics application.
	RunConfigurationDescription *RunConfigurationDescription `type:"structure"`

	// The details about inputs, outputs, and reference data sources for a SQL-based
	// Kinesis Data Analytics application.
	SqlApplicationConfigurationDescription *SqlApplicationConfigurationDescription `type:"structure"`

	// The array of descriptions of VPC configurations available to the application.
	VpcConfigurationDescriptions []*VpcConfigurationDescription `type:"list"`

	// The configuration parameters for a Kinesis Data Analytics Studio notebook.
	ZeppelinApplicationConfigurationDescription *ZeppelinApplicationConfigurationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationConfigurationDescription) GoString() string {
	return s.String()
}

// SetApplicationCodeConfigurationDescription sets the ApplicationCodeConfigurationDescription field's value.
func (s *ApplicationConfigurationDescription) SetApplicationCodeConfigurationDescription(v *ApplicationCodeConfigurationDescription) *ApplicationConfigurationDescription {
	s.ApplicationCodeConfigurationDescription = v
	return s
}

// SetApplicationSnapshotConfigurationDescription sets the ApplicationSnapshotConfigurationDescription field's value.
func (s *ApplicationConfigurationDescription) SetApplicationSnapshotConfigurationDescription(v *ApplicationSnapshotConfigurationDescription) *ApplicationConfigurationDescription {
	s.ApplicationSnapshotConfigurationDescription = v
	return s
}

// SetEnvironmentPropertyDescriptions sets the EnvironmentPropertyDescriptions field's value.
func (s *ApplicationConfigurationDescription) SetEnvironmentPropertyDescriptions(v *EnvironmentPropertyDescriptions) *ApplicationConfigurationDescription {
	s.EnvironmentPropertyDescriptions = v
	return s
}

// SetFlinkApplicationConfigurationDescription sets the FlinkApplicationConfigurationDescription field's value.
func (s *ApplicationConfigurationDescription) SetFlinkApplicationConfigurationDescription(v *FlinkApplicationConfigurationDescription) *ApplicationConfigurationDescription {
	s.FlinkApplicationConfigurationDescription = v
	return s
}

// SetRunConfigurationDescription sets the RunConfigurationDescription field's value.
func (s *ApplicationConfigurationDescription) SetRunConfigurationDescription(v *RunConfigurationDescription) *ApplicationConfigurationDescription {
	s.RunConfigurationDescription = v
	return s
}

// SetSqlApplicationConfigurationDescription sets the SqlApplicationConfigurationDescription field's value.
func (s *ApplicationConfigurationDescription) SetSqlApplicationConfigurationDescription(v *SqlApplicationConfigurationDescription) *ApplicationConfigurationDescription {
	s.SqlApplicationConfigurationDescription = v
	return s
}

// SetVpcConfigurationDescriptions sets the VpcConfigurationDescriptions field's value.
func (s *ApplicationConfigurationDescription) SetVpcConfigurationDescriptions(v []*VpcConfigurationDescription) *ApplicationConfigurationDescription {
	s.VpcConfigurationDescriptions = v
	return s
}

// SetZeppelinApplicationConfigurationDescription sets the ZeppelinApplicationConfigurationDescription field's value.
func (s *ApplicationConfigurationDescription) SetZeppelinApplicationConfigurationDescription(v *ZeppelinApplicationConfigurationDescription) *ApplicationConfigurationDescription {
	s.ZeppelinApplicationConfigurationDescription = v
	return s
}

// Describes updates to an application's configuration.
type ApplicationConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to an application's code configuration.
	ApplicationCodeConfigurationUpdate *ApplicationCodeConfigurationUpdate `type:"structure"`

	// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
	// application.
	ApplicationSnapshotConfigurationUpdate *ApplicationSnapshotConfigurationUpdate `type:"structure"`

	// Describes updates to the environment properties for a Flink-based Kinesis
	// Data Analytics application.
	EnvironmentPropertyUpdates *EnvironmentPropertyUpdates `type:"structure"`

	// Describes updates to a Flink-based Kinesis Data Analytics application's configuration.
	FlinkApplicationConfigurationUpdate *FlinkApplicationConfigurationUpdate `type:"structure"`

	// Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
	SqlApplicationConfigurationUpdate *SqlApplicationConfigurationUpdate `type:"structure"`

	// Updates to the array of descriptions of VPC configurations available to the
	// application.
	VpcConfigurationUpdates []*VpcConfigurationUpdate `type:"list"`

	// Updates to the configuration of a Kinesis Data Analytics Studio notebook.
	ZeppelinApplicationConfigurationUpdate *ZeppelinApplicationConfigurationUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationConfigurationUpdate"}
	if s.ApplicationCodeConfigurationUpdate != nil {
		if err := s.ApplicationCodeConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ApplicationCodeConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.ApplicationSnapshotConfigurationUpdate != nil {
		if err := s.ApplicationSnapshotConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSnapshotConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.EnvironmentPropertyUpdates != nil {
		if err := s.EnvironmentPropertyUpdates.Validate(); err != nil {
			invalidParams.AddNested("EnvironmentPropertyUpdates", err.(request.ErrInvalidParams))
		}
	}
	if s.FlinkApplicationConfigurationUpdate != nil {
		if err := s.FlinkApplicationConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("FlinkApplicationConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.SqlApplicationConfigurationUpdate != nil {
		if err := s.SqlApplicationConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("SqlApplicationConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfigurationUpdates != nil {
		for i, v := range s.VpcConfigurationUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VpcConfigurationUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ZeppelinApplicationConfigurationUpdate != nil {
		if err := s.ZeppelinApplicationConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ZeppelinApplicationConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationCodeConfigurationUpdate sets the ApplicationCodeConfigurationUpdate field's value.
func (s *ApplicationConfigurationUpdate) SetApplicationCodeConfigurationUpdate(v *ApplicationCodeConfigurationUpdate) *ApplicationConfigurationUpdate {
	s.ApplicationCodeConfigurationUpdate = v
	return s
}

// SetApplicationSnapshotConfigurationUpdate sets the ApplicationSnapshotConfigurationUpdate field's value.
func (s *ApplicationConfigurationUpdate) SetApplicationSnapshotConfigurationUpdate(v *ApplicationSnapshotConfigurationUpdate) *ApplicationConfigurationUpdate {
	s.ApplicationSnapshotConfigurationUpdate = v
	return s
}

// SetEnvironmentPropertyUpdates sets the EnvironmentPropertyUpdates field's value.
func (s *ApplicationConfigurationUpdate) SetEnvironmentPropertyUpdates(v *EnvironmentPropertyUpdates) *ApplicationConfigurationUpdate {
	s.EnvironmentPropertyUpdates = v
	return s
}

// SetFlinkApplicationConfigurationUpdate sets the FlinkApplicationConfigurationUpdate field's value.
func (s *ApplicationConfigurationUpdate) SetFlinkApplicationConfigurationUpdate(v *FlinkApplicationConfigurationUpdate) *ApplicationConfigurationUpdate {
	s.FlinkApplicationConfigurationUpdate = v
	return s
}

// SetSqlApplicationConfigurationUpdate sets the SqlApplicationConfigurationUpdate field's value.
func (s *ApplicationConfigurationUpdate) SetSqlApplicationConfigurationUpdate(v *SqlApplicationConfigurationUpdate) *ApplicationConfigurationUpdate {
	s.SqlApplicationConfigurationUpdate = v
	return s
}

// SetVpcConfigurationUpdates sets the VpcConfigurationUpdates field's value.
func (s *ApplicationConfigurationUpdate) SetVpcConfigurationUpdates(v []*VpcConfigurationUpdate) *ApplicationConfigurationUpdate {
	s.VpcConfigurationUpdates = v
	return s
}

// SetZeppelinApplicationConfigurationUpdate sets the ZeppelinApplicationConfigurationUpdate field's value.
func (s *ApplicationConfigurationUpdate) SetZeppelinApplicationConfigurationUpdate(v *ZeppelinApplicationConfigurationUpdate) *ApplicationConfigurationUpdate {
	s.ZeppelinApplicationConfigurationUpdate = v
	return s
}

// Describes the application, including the application Amazon Resource Name
// (ARN), status, latest version, and input and output configurations.
type ApplicationDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the application.
	//
	// ApplicationARN is a required field
	ApplicationARN *string `min:"1" type:"string" required:"true"`

	// Describes details about the application code and starting parameters for
	// a Kinesis Data Analytics application.
	ApplicationConfigurationDescription *ApplicationConfigurationDescription `type:"structure"`

	// The description of the application.
	ApplicationDescription *string `type:"string"`

	// The details of the maintenance configuration for the application.
	ApplicationMaintenanceConfigurationDescription *ApplicationMaintenanceConfigurationDescription `type:"structure"`

	// To create a Kinesis Data Analytics Studio notebook, you must set the mode
	// to INTERACTIVE. However, for a Kinesis Data Analytics for Apache Flink application,
	// the mode is optional.
	ApplicationMode *string `type:"string" enum:"ApplicationMode"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The status of the application.
	//
	// ApplicationStatus is a required field
	ApplicationStatus *string `type:"string" required:"true" enum:"ApplicationStatus"`

	// Provides the current application version. Kinesis Data Analytics updates
	// the ApplicationVersionId each time you update the application.
	//
	// ApplicationVersionId is a required field
	ApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// If you reverted the application using RollbackApplication, the application
	// version when RollbackApplication was called.
	ApplicationVersionRolledBackFrom *int64 `min:"1" type:"long"`

	// The version to which you want to roll back the application.
	ApplicationVersionRolledBackTo *int64 `min:"1" type:"long"`

	// The previous application version before the latest application update. RollbackApplication
	// reverts the application to this version.
	ApplicationVersionUpdatedFrom *int64 `min:"1" type:"long"`

	// Describes the application Amazon CloudWatch logging options.
	CloudWatchLoggingOptionDescriptions []*CloudWatchLoggingOptionDescription `type:"list"`

	// A value you use to implement strong concurrency for application updates.
	ConditionalToken *string `min:"1" type:"string"`

	// The current timestamp when the application was created.
	CreateTimestamp *time.Time `type:"timestamp"`

	// The current timestamp when the application was last updated.
	LastUpdateTimestamp *time.Time `type:"timestamp"`

	// The runtime environment for the application (SQL-1_0, FLINK-1_6, FLINK-1_8,
	// or FLINK-1_11).
	//
	// RuntimeEnvironment is a required field
	RuntimeEnvironment *string `type:"string" required:"true" enum:"RuntimeEnvironment"`

	// Specifies the IAM role that the application uses to access external resources.
	ServiceExecutionRole *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationDetail) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *ApplicationDetail) SetApplicationARN(v string) *ApplicationDetail {
	s.ApplicationARN = &v
	return s
}

// SetApplicationConfigurationDescription sets the ApplicationConfigurationDescription field's value.
func (s *ApplicationDetail) SetApplicationConfigurationDescription(v *ApplicationConfigurationDescription) *ApplicationDetail {
	s.ApplicationConfigurationDescription = v
	return s
}

// SetApplicationDescription sets the ApplicationDescription field's value.
func (s *ApplicationDetail) SetApplicationDescription(v string) *ApplicationDetail {
	s.ApplicationDescription = &v
	return s
}

// SetApplicationMaintenanceConfigurationDescription sets the ApplicationMaintenanceConfigurationDescription field's value.
func (s *ApplicationDetail) SetApplicationMaintenanceConfigurationDescription(v *ApplicationMaintenanceConfigurationDescription) *ApplicationDetail {
	s.ApplicationMaintenanceConfigurationDescription = v
	return s
}

// SetApplicationMode sets the ApplicationMode field's value.
func (s *ApplicationDetail) SetApplicationMode(v string) *ApplicationDetail {
	s.ApplicationMode = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ApplicationDetail) SetApplicationName(v string) *ApplicationDetail {
	s.ApplicationName = &v
	return s
}

// SetApplicationStatus sets the ApplicationStatus field's value.
func (s *ApplicationDetail) SetApplicationStatus(v string) *ApplicationDetail {
	s.ApplicationStatus = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *ApplicationDetail) SetApplicationVersionId(v int64) *ApplicationDetail {
	s.ApplicationVersionId = &v
	return s
}

// SetApplicationVersionRolledBackFrom sets the ApplicationVersionRolledBackFrom field's value.
func (s *ApplicationDetail) SetApplicationVersionRolledBackFrom(v int64) *ApplicationDetail {
	s.ApplicationVersionRolledBackFrom = &v
	return s
}

// SetApplicationVersionRolledBackTo sets the ApplicationVersionRolledBackTo field's value.
func (s *ApplicationDetail) SetApplicationVersionRolledBackTo(v int64) *ApplicationDetail {
	s.ApplicationVersionRolledBackTo = &v
	return s
}

// SetApplicationVersionUpdatedFrom sets the ApplicationVersionUpdatedFrom field's value.
func (s *ApplicationDetail) SetApplicationVersionUpdatedFrom(v int64) *ApplicationDetail {
	s.ApplicationVersionUpdatedFrom = &v
	return s
}

// SetCloudWatchLoggingOptionDescriptions sets the CloudWatchLoggingOptionDescriptions field's value.
func (s *ApplicationDetail) SetCloudWatchLoggingOptionDescriptions(v []*CloudWatchLoggingOptionDescription) *ApplicationDetail {
	s.CloudWatchLoggingOptionDescriptions = v
	return s
}

// SetConditionalToken sets the ConditionalToken field's value.
func (s *ApplicationDetail) SetConditionalToken(v string) *ApplicationDetail {
	s.ConditionalToken = &v
	return s
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *ApplicationDetail) SetCreateTimestamp(v time.Time) *ApplicationDetail {
	s.CreateTimestamp = &v
	return s
}

// SetLastUpdateTimestamp sets the LastUpdateTimestamp field's value.
func (s *ApplicationDetail) SetLastUpdateTimestamp(v time.Time) *ApplicationDetail {
	s.LastUpdateTimestamp = &v
	return s
}

// SetRuntimeEnvironment sets the RuntimeEnvironment field's value.
func (s *ApplicationDetail) SetRuntimeEnvironment(v string) *ApplicationDetail {
	s.RuntimeEnvironment = &v
	return s
}

// SetServiceExecutionRole sets the ServiceExecutionRole field's value.
func (s *ApplicationDetail) SetServiceExecutionRole(v string) *ApplicationDetail {
	s.ServiceExecutionRole = &v
	return s
}

// The details of the maintenance configuration for the application.
type ApplicationMaintenanceConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The end time for the maintenance window.
	//
	// ApplicationMaintenanceWindowEndTime is a required field
	ApplicationMaintenanceWindowEndTime *string `min:"5" type:"string" required:"true"`

	// The start time for the maintenance window.
	//
	// ApplicationMaintenanceWindowStartTime is a required field
	ApplicationMaintenanceWindowStartTime *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationMaintenanceConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationMaintenanceConfigurationDescription) GoString() string {
	return s.String()
}

// SetApplicationMaintenanceWindowEndTime sets the ApplicationMaintenanceWindowEndTime field's value.
func (s *ApplicationMaintenanceConfigurationDescription) SetApplicationMaintenanceWindowEndTime(v string) *ApplicationMaintenanceConfigurationDescription {
	s.ApplicationMaintenanceWindowEndTime = &v
	return s
}

// SetApplicationMaintenanceWindowStartTime sets the ApplicationMaintenanceWindowStartTime field's value.
func (s *ApplicationMaintenanceConfigurationDescription) SetApplicationMaintenanceWindowStartTime(v string) *ApplicationMaintenanceConfigurationDescription {
	s.ApplicationMaintenanceWindowStartTime = &v
	return s
}

// Describes the updated maintenance configuration for the application.
type ApplicationMaintenanceConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// The updated start time for the maintenance window.
	//
	// ApplicationMaintenanceWindowStartTimeUpdate is a required field
	ApplicationMaintenanceWindowStartTimeUpdate *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationMaintenanceConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationMaintenanceConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationMaintenanceConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationMaintenanceConfigurationUpdate"}
	if s.ApplicationMaintenanceWindowStartTimeUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationMaintenanceWindowStartTimeUpdate"))
	}
	if s.ApplicationMaintenanceWindowStartTimeUpdate != nil && len(*s.ApplicationMaintenanceWindowStartTimeUpdate) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationMaintenanceWindowStartTimeUpdate", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationMaintenanceWindowStartTimeUpdate sets the ApplicationMaintenanceWindowStartTimeUpdate field's value.
func (s *ApplicationMaintenanceConfigurationUpdate) SetApplicationMaintenanceWindowStartTimeUpdate(v string) *ApplicationMaintenanceConfigurationUpdate {
	s.ApplicationMaintenanceWindowStartTimeUpdate = &v
	return s
}

// Specifies the method and snapshot to use when restarting an application using
// previously saved application state.
type ApplicationRestoreConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies how the application should be restored.
	//
	// ApplicationRestoreType is a required field
	ApplicationRestoreType *string `type:"string" required:"true" enum:"ApplicationRestoreType"`

	// The identifier of an existing snapshot of application state to use to restart
	// an application. The application uses this value if RESTORE_FROM_CUSTOM_SNAPSHOT
	// is specified for the ApplicationRestoreType.
	SnapshotName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationRestoreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationRestoreConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationRestoreConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationRestoreConfiguration"}
	if s.ApplicationRestoreType == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationRestoreType"))
	}
	if s.SnapshotName != nil && len(*s.SnapshotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationRestoreType sets the ApplicationRestoreType field's value.
func (s *ApplicationRestoreConfiguration) SetApplicationRestoreType(v string) *ApplicationRestoreConfiguration {
	s.ApplicationRestoreType = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *ApplicationRestoreConfiguration) SetSnapshotName(v string) *ApplicationRestoreConfiguration {
	s.SnapshotName = &v
	return s
}

// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
// application.
type ApplicationSnapshotConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
	// application.
	//
	// SnapshotsEnabled is a required field
	SnapshotsEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSnapshotConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSnapshotConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationSnapshotConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationSnapshotConfiguration"}
	if s.SnapshotsEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotsEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotsEnabled sets the SnapshotsEnabled field's value.
func (s *ApplicationSnapshotConfiguration) SetSnapshotsEnabled(v bool) *ApplicationSnapshotConfiguration {
	s.SnapshotsEnabled = &v
	return s
}

// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
// application.
type ApplicationSnapshotConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics
	// application.
	//
	// SnapshotsEnabled is a required field
	SnapshotsEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSnapshotConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSnapshotConfigurationDescription) GoString() string {
	return s.String()
}

// SetSnapshotsEnabled sets the SnapshotsEnabled field's value.
func (s *ApplicationSnapshotConfigurationDescription) SetSnapshotsEnabled(v bool) *ApplicationSnapshotConfigurationDescription {
	s.SnapshotsEnabled = &v
	return s
}

// Describes updates to whether snapshots are enabled for a Flink-based Kinesis
// Data Analytics application.
type ApplicationSnapshotConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to whether snapshots are enabled for an application.
	//
	// SnapshotsEnabledUpdate is a required field
	SnapshotsEnabledUpdate *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSnapshotConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSnapshotConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationSnapshotConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplicationSnapshotConfigurationUpdate"}
	if s.SnapshotsEnabledUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotsEnabledUpdate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotsEnabledUpdate sets the SnapshotsEnabledUpdate field's value.
func (s *ApplicationSnapshotConfigurationUpdate) SetSnapshotsEnabledUpdate(v bool) *ApplicationSnapshotConfigurationUpdate {
	s.SnapshotsEnabledUpdate = &v
	return s
}

// Provides application summary information, including the application Amazon
// Resource Name (ARN), name, and status.
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the application.
	//
	// ApplicationARN is a required field
	ApplicationARN *string `min:"1" type:"string" required:"true"`

	// For a Kinesis Data Analytics for Apache Flink application, the mode is STREAMING.
	// For a Kinesis Data Analytics Studio notebook, it is INTERACTIVE.
	ApplicationMode *string `type:"string" enum:"ApplicationMode"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The status of the application.
	//
	// ApplicationStatus is a required field
	ApplicationStatus *string `type:"string" required:"true" enum:"ApplicationStatus"`

	// Provides the current application version.
	//
	// ApplicationVersionId is a required field
	ApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The runtime environment for the application.
	//
	// RuntimeEnvironment is a required field
	RuntimeEnvironment *string `type:"string" required:"true" enum:"RuntimeEnvironment"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *ApplicationSummary) SetApplicationARN(v string) *ApplicationSummary {
	s.ApplicationARN = &v
	return s
}

// SetApplicationMode sets the ApplicationMode field's value.
func (s *ApplicationSummary) SetApplicationMode(v string) *ApplicationSummary {
	s.ApplicationMode = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ApplicationSummary) SetApplicationName(v string) *ApplicationSummary {
	s.ApplicationName = &v
	return s
}

// SetApplicationStatus sets the ApplicationStatus field's value.
func (s *ApplicationSummary) SetApplicationStatus(v string) *ApplicationSummary {
	s.ApplicationStatus = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *ApplicationSummary) SetApplicationVersionId(v int64) *ApplicationSummary {
	s.ApplicationVersionId = &v
	return s
}

// SetRuntimeEnvironment sets the RuntimeEnvironment field's value.
func (s *ApplicationSummary) SetRuntimeEnvironment(v string) *ApplicationSummary {
	s.RuntimeEnvironment = &v
	return s
}

// The summary of the application version.
type ApplicationVersionSummary struct {
	_ struct{} `type:"structure"`

	// The status of the application.
	//
	// ApplicationStatus is a required field
	ApplicationStatus *string `type:"string" required:"true" enum:"ApplicationStatus"`

	// The ID of the application version. Kinesis Data Analytics updates the ApplicationVersionId
	// each time you update the application.
	//
	// ApplicationVersionId is a required field
	ApplicationVersionId *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationVersionSummary) GoString() string {
	return s.String()
}

// SetApplicationStatus sets the ApplicationStatus field's value.
func (s *ApplicationVersionSummary) SetApplicationStatus(v string) *ApplicationVersionSummary {
	s.ApplicationStatus = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *ApplicationVersionSummary) SetApplicationVersionId(v int64) *ApplicationVersionSummary {
	s.ApplicationVersionId = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, provides additional mapping
// information when the record format uses delimiters, such as CSV. For example,
// the following sample records use CSV format, where the records use the '\n'
// as the row delimiter and a comma (",") as the column delimiter:
//
// "name1", "address1"
//
// "name2", "address2"
type CSVMappingParameters struct {
	_ struct{} `type:"structure"`

	// The column delimiter. For example, in a CSV format, a comma (",") is the
	// typical column delimiter.
	//
	// RecordColumnDelimiter is a required field
	RecordColumnDelimiter *string `min:"1" type:"string" required:"true"`

	// The row delimiter. For example, in a CSV format, '\n' is the typical row
	// delimiter.
	//
	// RecordRowDelimiter is a required field
	RecordRowDelimiter *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CSVMappingParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CSVMappingParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CSVMappingParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CSVMappingParameters"}
	if s.RecordColumnDelimiter == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordColumnDelimiter"))
	}
	if s.RecordColumnDelimiter != nil && len(*s.RecordColumnDelimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordColumnDelimiter", 1))
	}
	if s.RecordRowDelimiter == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordRowDelimiter"))
	}
	if s.RecordRowDelimiter != nil && len(*s.RecordRowDelimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordRowDelimiter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordColumnDelimiter sets the RecordColumnDelimiter field's value.
func (s *CSVMappingParameters) SetRecordColumnDelimiter(v string) *CSVMappingParameters {
	s.RecordColumnDelimiter = &v
	return s
}

// SetRecordRowDelimiter sets the RecordRowDelimiter field's value.
func (s *CSVMappingParameters) SetRecordRowDelimiter(v string) *CSVMappingParameters {
	s.RecordRowDelimiter = &v
	return s
}

// The configuration parameters for the default Amazon Glue database. You use
// this database for SQL queries that you write in a Kinesis Data Analytics
// Studio notebook.
type CatalogConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration parameters for the default Amazon Glue database. You use
	// this database for Apache Flink SQL queries and table API transforms that
	// you write in a Kinesis Data Analytics Studio notebook.
	//
	// GlueDataCatalogConfiguration is a required field
	GlueDataCatalogConfiguration *GlueDataCatalogConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CatalogConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CatalogConfiguration"}
	if s.GlueDataCatalogConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("GlueDataCatalogConfiguration"))
	}
	if s.GlueDataCatalogConfiguration != nil {
		if err := s.GlueDataCatalogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GlueDataCatalogConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlueDataCatalogConfiguration sets the GlueDataCatalogConfiguration field's value.
func (s *CatalogConfiguration) SetGlueDataCatalogConfiguration(v *GlueDataCatalogConfiguration) *CatalogConfiguration {
	s.GlueDataCatalogConfiguration = v
	return s
}

// The configuration parameters for the default Amazon Glue database. You use
// this database for Apache Flink SQL queries and table API transforms that
// you write in a Kinesis Data Analytics Studio notebook.
type CatalogConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The configuration parameters for the default Amazon Glue database. You use
	// this database for SQL queries that you write in a Kinesis Data Analytics
	// Studio notebook.
	//
	// GlueDataCatalogConfigurationDescription is a required field
	GlueDataCatalogConfigurationDescription *GlueDataCatalogConfigurationDescription `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogConfigurationDescription) GoString() string {
	return s.String()
}

// SetGlueDataCatalogConfigurationDescription sets the GlueDataCatalogConfigurationDescription field's value.
func (s *CatalogConfigurationDescription) SetGlueDataCatalogConfigurationDescription(v *GlueDataCatalogConfigurationDescription) *CatalogConfigurationDescription {
	s.GlueDataCatalogConfigurationDescription = v
	return s
}

// Updates to the configuration parameters for the default Amazon Glue database.
// You use this database for SQL queries that you write in a Kinesis Data Analytics
// Studio notebook.
type CatalogConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Updates to the configuration parameters for the default Amazon Glue database.
	// You use this database for SQL queries that you write in a Kinesis Data Analytics
	// Studio notebook.
	//
	// GlueDataCatalogConfigurationUpdate is a required field
	GlueDataCatalogConfigurationUpdate *GlueDataCatalogConfigurationUpdate `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CatalogConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CatalogConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CatalogConfigurationUpdate"}
	if s.GlueDataCatalogConfigurationUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("GlueDataCatalogConfigurationUpdate"))
	}
	if s.GlueDataCatalogConfigurationUpdate != nil {
		if err := s.GlueDataCatalogConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("GlueDataCatalogConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlueDataCatalogConfigurationUpdate sets the GlueDataCatalogConfigurationUpdate field's value.
func (s *CatalogConfigurationUpdate) SetGlueDataCatalogConfigurationUpdate(v *GlueDataCatalogConfigurationUpdate) *CatalogConfigurationUpdate {
	s.GlueDataCatalogConfigurationUpdate = v
	return s
}

// Describes an application's checkpointing configuration. Checkpointing is
// the process of persisting application state for fault tolerance. For more
// information, see Checkpoints for Fault Tolerance (https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance)
// in the Apache Flink Documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
type CheckpointConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes the interval in milliseconds between checkpoint operations.
	//
	// If CheckpointConfiguration.ConfigurationType is DEFAULT, the application
	// will use a CheckpointInterval value of 60000, even if this value is set to
	// another value using this API or in application code.
	CheckpointInterval *int64 `min:"1" type:"long"`

	// Describes whether checkpointing is enabled for a Flink-based Kinesis Data
	// Analytics application.
	//
	// If CheckpointConfiguration.ConfigurationType is DEFAULT, the application
	// will use a CheckpointingEnabled value of true, even if this value is set
	// to another value using this API or in application code.
	CheckpointingEnabled *bool `type:"boolean"`

	// Describes whether the application uses Kinesis Data Analytics' default checkpointing
	// behavior. You must set this property to CUSTOM in order to set the CheckpointingEnabled,
	// CheckpointInterval, or MinPauseBetweenCheckpoints parameters.
	//
	// If this value is set to DEFAULT, the application will use the following values,
	// even if they are set to other values using APIs or application code:
	//
	//    * CheckpointingEnabled: true
	//
	//    * CheckpointInterval: 60000
	//
	//    * MinPauseBetweenCheckpoints: 5000
	//
	// ConfigurationType is a required field
	ConfigurationType *string `type:"string" required:"true" enum:"ConfigurationType"`

	// Describes the minimum time in milliseconds after a checkpoint operation completes
	// that a new checkpoint operation can start. If a checkpoint operation takes
	// longer than the CheckpointInterval, the application otherwise performs continual
	// checkpoint operations. For more information, see Tuning Checkpointing (https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/large_state_tuning.html#tuning-checkpointing)
	// in the Apache Flink Documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
	//
	// If CheckpointConfiguration.ConfigurationType is DEFAULT, the application
	// will use a MinPauseBetweenCheckpoints value of 5000, even if this value is
	// set using this API or in application code.
	MinPauseBetweenCheckpoints *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckpointConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckpointConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CheckpointConfiguration"}
	if s.CheckpointInterval != nil && *s.CheckpointInterval < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CheckpointInterval", 1))
	}
	if s.ConfigurationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckpointInterval sets the CheckpointInterval field's value.
func (s *CheckpointConfiguration) SetCheckpointInterval(v int64) *CheckpointConfiguration {
	s.CheckpointInterval = &v
	return s
}

// SetCheckpointingEnabled sets the CheckpointingEnabled field's value.
func (s *CheckpointConfiguration) SetCheckpointingEnabled(v bool) *CheckpointConfiguration {
	s.CheckpointingEnabled = &v
	return s
}

// SetConfigurationType sets the ConfigurationType field's value.
func (s *CheckpointConfiguration) SetConfigurationType(v string) *CheckpointConfiguration {
	s.ConfigurationType = &v
	return s
}

// SetMinPauseBetweenCheckpoints sets the MinPauseBetweenCheckpoints field's value.
func (s *CheckpointConfiguration) SetMinPauseBetweenCheckpoints(v int64) *CheckpointConfiguration {
	s.MinPauseBetweenCheckpoints = &v
	return s
}

// Describes checkpointing parameters for a Flink-based Kinesis Data Analytics
// application.
type CheckpointConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes the interval in milliseconds between checkpoint operations.
	//
	// If CheckpointConfiguration.ConfigurationType is DEFAULT, the application
	// will use a CheckpointInterval value of 60000, even if this value is set to
	// another value using this API or in application code.
	CheckpointInterval *int64 `min:"1" type:"long"`

	// Describes whether checkpointing is enabled for a Flink-based Kinesis Data
	// Analytics application.
	//
	// If CheckpointConfiguration.ConfigurationType is DEFAULT, the application
	// will use a CheckpointingEnabled value of true, even if this value is set
	// to another value using this API or in application code.
	CheckpointingEnabled *bool `type:"boolean"`

	// Describes whether the application uses the default checkpointing behavior
	// in Kinesis Data Analytics.
	//
	// If this value is set to DEFAULT, the application will use the following values,
	// even if they are set to other values using APIs or application code:
	//
	//    * CheckpointingEnabled: true
	//
	//    * CheckpointInterval: 60000
	//
	//    * MinPauseBetweenCheckpoints: 5000
	ConfigurationType *string `type:"string" enum:"ConfigurationType"`

	// Describes the minimum time in milliseconds after a checkpoint operation completes
	// that a new checkpoint operation can start.
	//
	// If CheckpointConfiguration.ConfigurationType is DEFAULT, the application
	// will use a MinPauseBetweenCheckpoints value of 5000, even if this value is
	// set using this API or in application code.
	MinPauseBetweenCheckpoints *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckpointConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckpointConfigurationDescription) GoString() string {
	return s.String()
}

// SetCheckpointInterval sets the CheckpointInterval field's value.
func (s *CheckpointConfigurationDescription) SetCheckpointInterval(v int64) *CheckpointConfigurationDescription {
	s.CheckpointInterval = &v
	return s
}

// SetCheckpointingEnabled sets the CheckpointingEnabled field's value.
func (s *CheckpointConfigurationDescription) SetCheckpointingEnabled(v bool) *CheckpointConfigurationDescription {
	s.CheckpointingEnabled = &v
	return s
}

// SetConfigurationType sets the ConfigurationType field's value.
func (s *CheckpointConfigurationDescription) SetConfigurationType(v string) *CheckpointConfigurationDescription {
	s.ConfigurationType = &v
	return s
}

// SetMinPauseBetweenCheckpoints sets the MinPauseBetweenCheckpoints field's value.
func (s *CheckpointConfigurationDescription) SetMinPauseBetweenCheckpoints(v int64) *CheckpointConfigurationDescription {
	s.MinPauseBetweenCheckpoints = &v
	return s
}

// Describes updates to the checkpointing parameters for a Flink-based Kinesis
// Data Analytics application.
type CheckpointConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to the interval in milliseconds between checkpoint operations.
	//
	// If CheckpointConfiguration.ConfigurationType is DEFAULT, the application
	// will use a CheckpointInterval value of 60000, even if this value is set to
	// another value using this API or in application code.
	CheckpointIntervalUpdate *int64 `min:"1" type:"long"`

	// Describes updates to whether checkpointing is enabled for an application.
	//
	// If CheckpointConfiguration.ConfigurationType is DEFAULT, the application
	// will use a CheckpointingEnabled value of true, even if this value is set
	// to another value using this API or in application code.
	CheckpointingEnabledUpdate *bool `type:"boolean"`

	// Describes updates to whether the application uses the default checkpointing
	// behavior of Kinesis Data Analytics. You must set this property to CUSTOM
	// in order to set the CheckpointingEnabled, CheckpointInterval, or MinPauseBetweenCheckpoints
	// parameters.
	//
	// If this value is set to DEFAULT, the application will use the following values,
	// even if they are set to other values using APIs or application code:
	//
	//    * CheckpointingEnabled: true
	//
	//    * CheckpointInterval: 60000
	//
	//    * MinPauseBetweenCheckpoints: 5000
	ConfigurationTypeUpdate *string `type:"string" enum:"ConfigurationType"`

	// Describes updates to the minimum time in milliseconds after a checkpoint
	// operation completes that a new checkpoint operation can start.
	//
	// If CheckpointConfiguration.ConfigurationType is DEFAULT, the application
	// will use a MinPauseBetweenCheckpoints value of 5000, even if this value is
	// set using this API or in application code.
	MinPauseBetweenCheckpointsUpdate *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckpointConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CheckpointConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckpointConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CheckpointConfigurationUpdate"}
	if s.CheckpointIntervalUpdate != nil && *s.CheckpointIntervalUpdate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CheckpointIntervalUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckpointIntervalUpdate sets the CheckpointIntervalUpdate field's value.
func (s *CheckpointConfigurationUpdate) SetCheckpointIntervalUpdate(v int64) *CheckpointConfigurationUpdate {
	s.CheckpointIntervalUpdate = &v
	return s
}

// SetCheckpointingEnabledUpdate sets the CheckpointingEnabledUpdate field's value.
func (s *CheckpointConfigurationUpdate) SetCheckpointingEnabledUpdate(v bool) *CheckpointConfigurationUpdate {
	s.CheckpointingEnabledUpdate = &v
	return s
}

// SetConfigurationTypeUpdate sets the ConfigurationTypeUpdate field's value.
func (s *CheckpointConfigurationUpdate) SetConfigurationTypeUpdate(v string) *CheckpointConfigurationUpdate {
	s.ConfigurationTypeUpdate = &v
	return s
}

// SetMinPauseBetweenCheckpointsUpdate sets the MinPauseBetweenCheckpointsUpdate field's value.
func (s *CheckpointConfigurationUpdate) SetMinPauseBetweenCheckpointsUpdate(v int64) *CheckpointConfigurationUpdate {
	s.MinPauseBetweenCheckpointsUpdate = &v
	return s
}

// Provides a description of Amazon CloudWatch logging options, including the
// log stream Amazon Resource Name (ARN).
type CloudWatchLoggingOption struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch log to receive application messages.
	//
	// LogStreamARN is a required field
	LogStreamARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLoggingOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLoggingOption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLoggingOption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLoggingOption"}
	if s.LogStreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("LogStreamARN"))
	}
	if s.LogStreamARN != nil && len(*s.LogStreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogStreamARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogStreamARN sets the LogStreamARN field's value.
func (s *CloudWatchLoggingOption) SetLogStreamARN(v string) *CloudWatchLoggingOption {
	s.LogStreamARN = &v
	return s
}

// Describes the Amazon CloudWatch logging option.
type CloudWatchLoggingOptionDescription struct {
	_ struct{} `type:"structure"`

	// The ID of the CloudWatch logging option description.
	CloudWatchLoggingOptionId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the CloudWatch log to receive application
	// messages.
	//
	// LogStreamARN is a required field
	LogStreamARN *string `min:"1" type:"string" required:"true"`

	// The IAM ARN of the role to use to send application messages.
	//
	// Provided for backward compatibility. Applications created with the current
	// API version have an application-level service execution role rather than
	// a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLoggingOptionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLoggingOptionDescription) GoString() string {
	return s.String()
}

// SetCloudWatchLoggingOptionId sets the CloudWatchLoggingOptionId field's value.
func (s *CloudWatchLoggingOptionDescription) SetCloudWatchLoggingOptionId(v string) *CloudWatchLoggingOptionDescription {
	s.CloudWatchLoggingOptionId = &v
	return s
}

// SetLogStreamARN sets the LogStreamARN field's value.
func (s *CloudWatchLoggingOptionDescription) SetLogStreamARN(v string) *CloudWatchLoggingOptionDescription {
	s.LogStreamARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CloudWatchLoggingOptionDescription) SetRoleARN(v string) *CloudWatchLoggingOptionDescription {
	s.RoleARN = &v
	return s
}

// Describes the Amazon CloudWatch logging option updates.
type CloudWatchLoggingOptionUpdate struct {
	_ struct{} `type:"structure"`

	// The ID of the CloudWatch logging option to update
	//
	// CloudWatchLoggingOptionId is a required field
	CloudWatchLoggingOptionId *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the CloudWatch log to receive application
	// messages.
	LogStreamARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLoggingOptionUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLoggingOptionUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLoggingOptionUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudWatchLoggingOptionUpdate"}
	if s.CloudWatchLoggingOptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLoggingOptionId"))
	}
	if s.CloudWatchLoggingOptionId != nil && len(*s.CloudWatchLoggingOptionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLoggingOptionId", 1))
	}
	if s.LogStreamARNUpdate != nil && len(*s.LogStreamARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogStreamARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLoggingOptionId sets the CloudWatchLoggingOptionId field's value.
func (s *CloudWatchLoggingOptionUpdate) SetCloudWatchLoggingOptionId(v string) *CloudWatchLoggingOptionUpdate {
	s.CloudWatchLoggingOptionId = &v
	return s
}

// SetLogStreamARNUpdate sets the LogStreamARNUpdate field's value.
func (s *CloudWatchLoggingOptionUpdate) SetLogStreamARNUpdate(v string) *CloudWatchLoggingOptionUpdate {
	s.LogStreamARNUpdate = &v
	return s
}

// Specifies either the application code, or the location of the application
// code, for a Flink-based Kinesis Data Analytics application.
type CodeContent struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon S3 bucket that contains the application code.
	S3ContentLocation *S3ContentLocation `type:"structure"`

	// The text-format code for a Flink-based Kinesis Data Analytics application.
	TextContent *string `type:"string"`

	// The zip-format code for a Flink-based Kinesis Data Analytics application.
	// ZipFileContent is automatically base64 encoded/decoded by the SDK.
	ZipFileContent []byte `type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeContent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeContent) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeContent) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeContent"}
	if s.S3ContentLocation != nil {
		if err := s.S3ContentLocation.Validate(); err != nil {
			invalidParams.AddNested("S3ContentLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3ContentLocation sets the S3ContentLocation field's value.
func (s *CodeContent) SetS3ContentLocation(v *S3ContentLocation) *CodeContent {
	s.S3ContentLocation = v
	return s
}

// SetTextContent sets the TextContent field's value.
func (s *CodeContent) SetTextContent(v string) *CodeContent {
	s.TextContent = &v
	return s
}

// SetZipFileContent sets the ZipFileContent field's value.
func (s *CodeContent) SetZipFileContent(v []byte) *CodeContent {
	s.ZipFileContent = v
	return s
}

// Describes details about the code of a Kinesis Data Analytics application.
type CodeContentDescription struct {
	_ struct{} `type:"structure"`

	// The checksum that can be used to validate zip-format code.
	CodeMD5 *string `min:"128" type:"string"`

	// The size in bytes of the application code. Can be used to validate zip-format
	// code.
	CodeSize *int64 `type:"long"`

	// The S3 bucket Amazon Resource Name (ARN), file key, and object version of
	// the application code stored in Amazon S3.
	S3ApplicationCodeLocationDescription *S3ApplicationCodeLocationDescription `type:"structure"`

	// The text-format code
	TextContent *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeContentDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeContentDescription) GoString() string {
	return s.String()
}

// SetCodeMD5 sets the CodeMD5 field's value.
func (s *CodeContentDescription) SetCodeMD5(v string) *CodeContentDescription {
	s.CodeMD5 = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *CodeContentDescription) SetCodeSize(v int64) *CodeContentDescription {
	s.CodeSize = &v
	return s
}

// SetS3ApplicationCodeLocationDescription sets the S3ApplicationCodeLocationDescription field's value.
func (s *CodeContentDescription) SetS3ApplicationCodeLocationDescription(v *S3ApplicationCodeLocationDescription) *CodeContentDescription {
	s.S3ApplicationCodeLocationDescription = v
	return s
}

// SetTextContent sets the TextContent field's value.
func (s *CodeContentDescription) SetTextContent(v string) *CodeContentDescription {
	s.TextContent = &v
	return s
}

// Describes an update to the code of an application. Not supported for Apache
// Zeppelin.
type CodeContentUpdate struct {
	_ struct{} `type:"structure"`

	// Describes an update to the location of code for an application.
	S3ContentLocationUpdate *S3ContentLocationUpdate `type:"structure"`

	// Describes an update to the text code for an application.
	TextContentUpdate *string `type:"string"`

	// Describes an update to the zipped code for an application.
	// ZipFileContentUpdate is automatically base64 encoded/decoded by the SDK.
	ZipFileContentUpdate []byte `type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeContentUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeContentUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeContentUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeContentUpdate"}
	if s.S3ContentLocationUpdate != nil {
		if err := s.S3ContentLocationUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3ContentLocationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3ContentLocationUpdate sets the S3ContentLocationUpdate field's value.
func (s *CodeContentUpdate) SetS3ContentLocationUpdate(v *S3ContentLocationUpdate) *CodeContentUpdate {
	s.S3ContentLocationUpdate = v
	return s
}

// SetTextContentUpdate sets the TextContentUpdate field's value.
func (s *CodeContentUpdate) SetTextContentUpdate(v string) *CodeContentUpdate {
	s.TextContentUpdate = &v
	return s
}

// SetZipFileContentUpdate sets the ZipFileContentUpdate field's value.
func (s *CodeContentUpdate) SetZipFileContentUpdate(v []byte) *CodeContentUpdate {
	s.ZipFileContentUpdate = v
	return s
}

// The user-provided application code (query) is not valid. This can be a simple
// syntax error.
type CodeValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CodeValidationException) GoString() string {
	return s.String()
}

func newErrorCodeValidationException(v protocol.ResponseMetadata) error {
	return &CodeValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CodeValidationException) Code() string {
	return "CodeValidationException"
}

// Message returns the exception's message.
func (s *CodeValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CodeValidationException) OrigErr() error {
	return nil
}

func (s *CodeValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CodeValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CodeValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Exception thrown as a result of concurrent modifications to an application.
// This error can be the result of attempting to modify an application without
// using the current application ID.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter to configure the application.
	ApplicationConfiguration *ApplicationConfiguration `type:"structure"`

	// A summary description of the application.
	ApplicationDescription *string `type:"string"`

	// Use the STREAMING mode to create a Kinesis Data Analytics Studio notebook.
	// To create a Kinesis Data Analytics Studio notebook, use the INTERACTIVE mode.
	ApplicationMode *string `type:"string" enum:"ApplicationMode"`

	// The name of your application (for example, sample-app).
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Use this parameter to configure an Amazon CloudWatch log stream to monitor
	// application configuration errors.
	CloudWatchLoggingOptions []*CloudWatchLoggingOption `type:"list"`

	// The runtime environment for the application (SQL-1_0, FLINK-1_6, FLINK-1_8,
	// or FLINK-1_11).
	//
	// RuntimeEnvironment is a required field
	RuntimeEnvironment *string `type:"string" required:"true" enum:"RuntimeEnvironment"`

	// The IAM role used by the application to access Kinesis data streams, Kinesis
	// Data Firehose delivery streams, Amazon S3 objects, and other external resources.
	//
	// ServiceExecutionRole is a required field
	ServiceExecutionRole *string `min:"1" type:"string" required:"true"`

	// A list of one or more tags to assign to the application. A tag is a key-value
	// pair that identifies an application. Note that the maximum number of application
	// tags includes system tags. The maximum number of user-defined application
	// tags is 50. For more information, see Using Tagging (https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.RuntimeEnvironment == nil {
		invalidParams.Add(request.NewErrParamRequired("RuntimeEnvironment"))
	}
	if s.ServiceExecutionRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceExecutionRole"))
	}
	if s.ServiceExecutionRole != nil && len(*s.ServiceExecutionRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceExecutionRole", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ApplicationConfiguration != nil {
		if err := s.ApplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ApplicationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.CloudWatchLoggingOptions != nil {
		for i, v := range s.CloudWatchLoggingOptions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CloudWatchLoggingOptions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationConfiguration sets the ApplicationConfiguration field's value.
func (s *CreateApplicationInput) SetApplicationConfiguration(v *ApplicationConfiguration) *CreateApplicationInput {
	s.ApplicationConfiguration = v
	return s
}

// SetApplicationDescription sets the ApplicationDescription field's value.
func (s *CreateApplicationInput) SetApplicationDescription(v string) *CreateApplicationInput {
	s.ApplicationDescription = &v
	return s
}

// SetApplicationMode sets the ApplicationMode field's value.
func (s *CreateApplicationInput) SetApplicationMode(v string) *CreateApplicationInput {
	s.ApplicationMode = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateApplicationInput) SetApplicationName(v string) *CreateApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *CreateApplicationInput) SetCloudWatchLoggingOptions(v []*CloudWatchLoggingOption) *CreateApplicationInput {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetRuntimeEnvironment sets the RuntimeEnvironment field's value.
func (s *CreateApplicationInput) SetRuntimeEnvironment(v string) *CreateApplicationInput {
	s.RuntimeEnvironment = &v
	return s
}

// SetServiceExecutionRole sets the ServiceExecutionRole field's value.
func (s *CreateApplicationInput) SetServiceExecutionRole(v string) *CreateApplicationInput {
	s.ServiceExecutionRole = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v []*Tag) *CreateApplicationInput {
	s.Tags = v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// In response to your CreateApplication request, Kinesis Data Analytics returns
	// a response with details of the application it created.
	//
	// ApplicationDetail is a required field
	ApplicationDetail *ApplicationDetail `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationDetail sets the ApplicationDetail field's value.
func (s *CreateApplicationOutput) SetApplicationDetail(v *ApplicationDetail) *CreateApplicationOutput {
	s.ApplicationDetail = v
	return s
}

type CreateApplicationPresignedUrlInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The duration in seconds for which the returned URL will be valid.
	SessionExpirationDurationInSeconds *int64 `min:"1800" type:"long"`

	// The type of the extension for which to create and return a URL. Currently,
	// the only valid extension URL type is FLINK_DASHBOARD_URL.
	//
	// UrlType is a required field
	UrlType *string `type:"string" required:"true" enum:"UrlType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationPresignedUrlInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationPresignedUrlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationPresignedUrlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationPresignedUrlInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.SessionExpirationDurationInSeconds != nil && *s.SessionExpirationDurationInSeconds < 1800 {
		invalidParams.Add(request.NewErrParamMinValue("SessionExpirationDurationInSeconds", 1800))
	}
	if s.UrlType == nil {
		invalidParams.Add(request.NewErrParamRequired("UrlType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateApplicationPresignedUrlInput) SetApplicationName(v string) *CreateApplicationPresignedUrlInput {
	s.ApplicationName = &v
	return s
}

// SetSessionExpirationDurationInSeconds sets the SessionExpirationDurationInSeconds field's value.
func (s *CreateApplicationPresignedUrlInput) SetSessionExpirationDurationInSeconds(v int64) *CreateApplicationPresignedUrlInput {
	s.SessionExpirationDurationInSeconds = &v
	return s
}

// SetUrlType sets the UrlType field's value.
func (s *CreateApplicationPresignedUrlInput) SetUrlType(v string) *CreateApplicationPresignedUrlInput {
	s.UrlType = &v
	return s
}

type CreateApplicationPresignedUrlOutput struct {
	_ struct{} `type:"structure"`

	// The URL of the extension.
	AuthorizedUrl *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationPresignedUrlOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationPresignedUrlOutput) GoString() string {
	return s.String()
}

// SetAuthorizedUrl sets the AuthorizedUrl field's value.
func (s *CreateApplicationPresignedUrlOutput) SetAuthorizedUrl(v string) *CreateApplicationPresignedUrlOutput {
	s.AuthorizedUrl = &v
	return s
}

type CreateApplicationSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing application
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// An identifier for the application snapshot.
	//
	// SnapshotName is a required field
	SnapshotName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationSnapshotInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}
	if s.SnapshotName != nil && len(*s.SnapshotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *CreateApplicationSnapshotInput) SetApplicationName(v string) *CreateApplicationSnapshotInput {
	s.ApplicationName = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *CreateApplicationSnapshotInput) SetSnapshotName(v string) *CreateApplicationSnapshotInput {
	s.SnapshotName = &v
	return s
}

type CreateApplicationSnapshotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationSnapshotOutput) GoString() string {
	return s.String()
}

// Specifies dependency JARs, as well as JAR files that contain user-defined
// functions (UDF).
type CustomArtifactConfiguration struct {
	_ struct{} `type:"structure"`

	// UDF stands for user-defined functions. This type of artifact must be in an
	// S3 bucket. A DEPENDENCY_JAR can be in either Maven or an S3 bucket.
	//
	// ArtifactType is a required field
	ArtifactType *string `type:"string" required:"true" enum:"ArtifactType"`

	// The parameters required to fully specify a Maven reference.
	MavenReference *MavenReference `type:"structure"`

	// For a Kinesis Data Analytics application provides a description of an Amazon
	// S3 object, including the Amazon Resource Name (ARN) of the S3 bucket, the
	// name of the Amazon S3 object that contains the data, and the version number
	// of the Amazon S3 object that contains the data.
	S3ContentLocation *S3ContentLocation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomArtifactConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomArtifactConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomArtifactConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomArtifactConfiguration"}
	if s.ArtifactType == nil {
		invalidParams.Add(request.NewErrParamRequired("ArtifactType"))
	}
	if s.MavenReference != nil {
		if err := s.MavenReference.Validate(); err != nil {
			invalidParams.AddNested("MavenReference", err.(request.ErrInvalidParams))
		}
	}
	if s.S3ContentLocation != nil {
		if err := s.S3ContentLocation.Validate(); err != nil {
			invalidParams.AddNested("S3ContentLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactType sets the ArtifactType field's value.
func (s *CustomArtifactConfiguration) SetArtifactType(v string) *CustomArtifactConfiguration {
	s.ArtifactType = &v
	return s
}

// SetMavenReference sets the MavenReference field's value.
func (s *CustomArtifactConfiguration) SetMavenReference(v *MavenReference) *CustomArtifactConfiguration {
	s.MavenReference = v
	return s
}

// SetS3ContentLocation sets the S3ContentLocation field's value.
func (s *CustomArtifactConfiguration) SetS3ContentLocation(v *S3ContentLocation) *CustomArtifactConfiguration {
	s.S3ContentLocation = v
	return s
}

// Specifies a dependency JAR or a JAR of user-defined functions.
type CustomArtifactConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// UDF stands for user-defined functions. This type of artifact must be in an
	// S3 bucket. A DEPENDENCY_JAR can be in either Maven or an S3 bucket.
	ArtifactType *string `type:"string" enum:"ArtifactType"`

	// The parameters that are required to specify a Maven dependency.
	MavenReferenceDescription *MavenReference `type:"structure"`

	// For a Kinesis Data Analytics application provides a description of an Amazon
	// S3 object, including the Amazon Resource Name (ARN) of the S3 bucket, the
	// name of the Amazon S3 object that contains the data, and the version number
	// of the Amazon S3 object that contains the data.
	S3ContentLocationDescription *S3ContentLocation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomArtifactConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomArtifactConfigurationDescription) GoString() string {
	return s.String()
}

// SetArtifactType sets the ArtifactType field's value.
func (s *CustomArtifactConfigurationDescription) SetArtifactType(v string) *CustomArtifactConfigurationDescription {
	s.ArtifactType = &v
	return s
}

// SetMavenReferenceDescription sets the MavenReferenceDescription field's value.
func (s *CustomArtifactConfigurationDescription) SetMavenReferenceDescription(v *MavenReference) *CustomArtifactConfigurationDescription {
	s.MavenReferenceDescription = v
	return s
}

// SetS3ContentLocationDescription sets the S3ContentLocationDescription field's value.
func (s *CustomArtifactConfigurationDescription) SetS3ContentLocationDescription(v *S3ContentLocation) *CustomArtifactConfigurationDescription {
	s.S3ContentLocationDescription = v
	return s
}

type DeleteApplicationCloudWatchLoggingOptionInput struct {
	_ struct{} `type:"structure"`

	// The application name.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The CloudWatchLoggingOptionId of the Amazon CloudWatch logging option to
	// delete. You can get the CloudWatchLoggingOptionId by using the DescribeApplication
	// operation.
	//
	// CloudWatchLoggingOptionId is a required field
	CloudWatchLoggingOptionId *string `min:"1" type:"string" required:"true"`

	// A value you use to implement strong concurrency for application updates.
	// You must provide the CurrentApplicationVersionId or the ConditionalToken.
	// You get the application's current ConditionalToken using DescribeApplication.
	// For better concurrency support, use the ConditionalToken parameter instead
	// of CurrentApplicationVersionId.
	ConditionalToken *string `min:"1" type:"string"`

	// The version ID of the application. You must provide the CurrentApplicationVersionId
	// or the ConditionalToken. You can retrieve the application version ID using
	// DescribeApplication. For better concurrency support, use the ConditionalToken
	// parameter instead of CurrentApplicationVersionId.
	CurrentApplicationVersionId *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationCloudWatchLoggingOptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationCloudWatchLoggingOptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationCloudWatchLoggingOptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationCloudWatchLoggingOptionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CloudWatchLoggingOptionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CloudWatchLoggingOptionId"))
	}
	if s.CloudWatchLoggingOptionId != nil && len(*s.CloudWatchLoggingOptionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CloudWatchLoggingOptionId", 1))
	}
	if s.ConditionalToken != nil && len(*s.ConditionalToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConditionalToken", 1))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationCloudWatchLoggingOptionInput) SetApplicationName(v string) *DeleteApplicationCloudWatchLoggingOptionInput {
	s.ApplicationName = &v
	return s
}

// SetCloudWatchLoggingOptionId sets the CloudWatchLoggingOptionId field's value.
func (s *DeleteApplicationCloudWatchLoggingOptionInput) SetCloudWatchLoggingOptionId(v string) *DeleteApplicationCloudWatchLoggingOptionInput {
	s.CloudWatchLoggingOptionId = &v
	return s
}

// SetConditionalToken sets the ConditionalToken field's value.
func (s *DeleteApplicationCloudWatchLoggingOptionInput) SetConditionalToken(v string) *DeleteApplicationCloudWatchLoggingOptionInput {
	s.ConditionalToken = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *DeleteApplicationCloudWatchLoggingOptionInput) SetCurrentApplicationVersionId(v int64) *DeleteApplicationCloudWatchLoggingOptionInput {
	s.CurrentApplicationVersionId = &v
	return s
}

type DeleteApplicationCloudWatchLoggingOptionOutput struct {
	_ struct{} `type:"structure"`

	// The application's Amazon Resource Name (ARN).
	ApplicationARN *string `min:"1" type:"string"`

	// The version ID of the application. Kinesis Data Analytics updates the ApplicationVersionId
	// each time you change the CloudWatch logging options.
	ApplicationVersionId *int64 `min:"1" type:"long"`

	// The descriptions of the remaining CloudWatch logging options for the application.
	CloudWatchLoggingOptionDescriptions []*CloudWatchLoggingOptionDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationCloudWatchLoggingOptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationCloudWatchLoggingOptionOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *DeleteApplicationCloudWatchLoggingOptionOutput) SetApplicationARN(v string) *DeleteApplicationCloudWatchLoggingOptionOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *DeleteApplicationCloudWatchLoggingOptionOutput) SetApplicationVersionId(v int64) *DeleteApplicationCloudWatchLoggingOptionOutput {
	s.ApplicationVersionId = &v
	return s
}

// SetCloudWatchLoggingOptionDescriptions sets the CloudWatchLoggingOptionDescriptions field's value.
func (s *DeleteApplicationCloudWatchLoggingOptionOutput) SetCloudWatchLoggingOptionDescriptions(v []*CloudWatchLoggingOptionDescription) *DeleteApplicationCloudWatchLoggingOptionOutput {
	s.CloudWatchLoggingOptionDescriptions = v
	return s
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to delete.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Use the DescribeApplication operation to get this value.
	//
	// CreateTimestamp is a required field
	CreateTimestamp *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CreateTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationInput) SetApplicationName(v string) *DeleteApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *DeleteApplicationInput) SetCreateTimestamp(v time.Time) *DeleteApplicationInput {
	s.CreateTimestamp = &v
	return s
}

type DeleteApplicationInputProcessingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The application version. You can use the DescribeApplication operation to
	// get the current application version. If the version specified is not the
	// current version, the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The ID of the input configuration from which to delete the input processing
	// configuration. You can get a list of the input IDs for an application by
	// using the DescribeApplication operation.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInputProcessingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInputProcessingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInputProcessingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInputProcessingConfigurationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationInputProcessingConfigurationInput) SetApplicationName(v string) *DeleteApplicationInputProcessingConfigurationInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *DeleteApplicationInputProcessingConfigurationInput) SetCurrentApplicationVersionId(v int64) *DeleteApplicationInputProcessingConfigurationInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetInputId sets the InputId field's value.
func (s *DeleteApplicationInputProcessingConfigurationInput) SetInputId(v string) *DeleteApplicationInputProcessingConfigurationInput {
	s.InputId = &v
	return s
}

type DeleteApplicationInputProcessingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	ApplicationARN *string `min:"1" type:"string"`

	// The current application version ID.
	ApplicationVersionId *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInputProcessingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInputProcessingConfigurationOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *DeleteApplicationInputProcessingConfigurationOutput) SetApplicationARN(v string) *DeleteApplicationInputProcessingConfigurationOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *DeleteApplicationInputProcessingConfigurationOutput) SetApplicationVersionId(v int64) *DeleteApplicationInputProcessingConfigurationOutput {
	s.ApplicationVersionId = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type DeleteApplicationOutputInput struct {
	_ struct{} `type:"structure"`

	// The application name.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The application version. You can use the DescribeApplication operation to
	// get the current application version. If the version specified is not the
	// current version, the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The ID of the configuration to delete. Each output configuration that is
	// added to the application (either when the application is created or later)
	// using the AddApplicationOutput operation has a unique ID. You need to provide
	// the ID to uniquely identify the output configuration that you want to delete
	// from the application configuration. You can use the DescribeApplication operation
	// to get the specific OutputId.
	//
	// OutputId is a required field
	OutputId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationOutputInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.OutputId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputId"))
	}
	if s.OutputId != nil && len(*s.OutputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationOutputInput) SetApplicationName(v string) *DeleteApplicationOutputInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *DeleteApplicationOutputInput) SetCurrentApplicationVersionId(v int64) *DeleteApplicationOutputInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetOutputId sets the OutputId field's value.
func (s *DeleteApplicationOutputInput) SetOutputId(v string) *DeleteApplicationOutputInput {
	s.OutputId = &v
	return s
}

type DeleteApplicationOutputOutput struct {
	_ struct{} `type:"structure"`

	// The application Amazon Resource Name (ARN).
	ApplicationARN *string `min:"1" type:"string"`

	// The current application version ID.
	ApplicationVersionId *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutputOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *DeleteApplicationOutputOutput) SetApplicationARN(v string) *DeleteApplicationOutputOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *DeleteApplicationOutputOutput) SetApplicationVersionId(v int64) *DeleteApplicationOutputOutput {
	s.ApplicationVersionId = &v
	return s
}

type DeleteApplicationReferenceDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The current application version. You can use the DescribeApplication operation
	// to get the current application version. If the version specified is not the
	// current version, the ConcurrentModificationException is returned.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The ID of the reference data source. When you add a reference data source
	// to your application using the AddApplicationReferenceDataSource, Kinesis
	// Data Analytics assigns an ID. You can use the DescribeApplication operation
	// to get the reference ID.
	//
	// ReferenceId is a required field
	ReferenceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationReferenceDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationReferenceDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationReferenceDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationReferenceDataSourceInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.ReferenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceId"))
	}
	if s.ReferenceId != nil && len(*s.ReferenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationReferenceDataSourceInput) SetApplicationName(v string) *DeleteApplicationReferenceDataSourceInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *DeleteApplicationReferenceDataSourceInput) SetCurrentApplicationVersionId(v int64) *DeleteApplicationReferenceDataSourceInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *DeleteApplicationReferenceDataSourceInput) SetReferenceId(v string) *DeleteApplicationReferenceDataSourceInput {
	s.ReferenceId = &v
	return s
}

type DeleteApplicationReferenceDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The application Amazon Resource Name (ARN).
	ApplicationARN *string `min:"1" type:"string"`

	// The updated version ID of the application.
	ApplicationVersionId *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationReferenceDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationReferenceDataSourceOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *DeleteApplicationReferenceDataSourceOutput) SetApplicationARN(v string) *DeleteApplicationReferenceDataSourceOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *DeleteApplicationReferenceDataSourceOutput) SetApplicationVersionId(v int64) *DeleteApplicationReferenceDataSourceOutput {
	s.ApplicationVersionId = &v
	return s
}

type DeleteApplicationSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The creation timestamp of the application snapshot to delete. You can retrieve
	// this value using or .
	//
	// SnapshotCreationTimestamp is a required field
	SnapshotCreationTimestamp *time.Time `type:"timestamp" required:"true"`

	// The identifier for the snapshot delete.
	//
	// SnapshotName is a required field
	SnapshotName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationSnapshotInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.SnapshotCreationTimestamp == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotCreationTimestamp"))
	}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}
	if s.SnapshotName != nil && len(*s.SnapshotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationSnapshotInput) SetApplicationName(v string) *DeleteApplicationSnapshotInput {
	s.ApplicationName = &v
	return s
}

// SetSnapshotCreationTimestamp sets the SnapshotCreationTimestamp field's value.
func (s *DeleteApplicationSnapshotInput) SetSnapshotCreationTimestamp(v time.Time) *DeleteApplicationSnapshotInput {
	s.SnapshotCreationTimestamp = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *DeleteApplicationSnapshotInput) SetSnapshotName(v string) *DeleteApplicationSnapshotInput {
	s.SnapshotName = &v
	return s
}

type DeleteApplicationSnapshotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationSnapshotOutput) GoString() string {
	return s.String()
}

type DeleteApplicationVpcConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// A value you use to implement strong concurrency for application updates.
	// You must provide the CurrentApplicationVersionId or the ConditionalToken.
	// You get the application's current ConditionalToken using DescribeApplication.
	// For better concurrency support, use the ConditionalToken parameter instead
	// of CurrentApplicationVersionId.
	ConditionalToken *string `min:"1" type:"string"`

	// The current application version ID. You must provide the CurrentApplicationVersionId
	// or the ConditionalToken. You can retrieve the application version ID using
	// DescribeApplication. For better concurrency support, use the ConditionalToken
	// parameter instead of CurrentApplicationVersionId.
	CurrentApplicationVersionId *int64 `min:"1" type:"long"`

	// The ID of the VPC configuration to delete.
	//
	// VpcConfigurationId is a required field
	VpcConfigurationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationVpcConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationVpcConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationVpcConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationVpcConfigurationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.ConditionalToken != nil && len(*s.ConditionalToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConditionalToken", 1))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.VpcConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcConfigurationId"))
	}
	if s.VpcConfigurationId != nil && len(*s.VpcConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcConfigurationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DeleteApplicationVpcConfigurationInput) SetApplicationName(v string) *DeleteApplicationVpcConfigurationInput {
	s.ApplicationName = &v
	return s
}

// SetConditionalToken sets the ConditionalToken field's value.
func (s *DeleteApplicationVpcConfigurationInput) SetConditionalToken(v string) *DeleteApplicationVpcConfigurationInput {
	s.ConditionalToken = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *DeleteApplicationVpcConfigurationInput) SetCurrentApplicationVersionId(v int64) *DeleteApplicationVpcConfigurationInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetVpcConfigurationId sets the VpcConfigurationId field's value.
func (s *DeleteApplicationVpcConfigurationInput) SetVpcConfigurationId(v string) *DeleteApplicationVpcConfigurationInput {
	s.VpcConfigurationId = &v
	return s
}

type DeleteApplicationVpcConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Kinesis Data Analytics application.
	ApplicationARN *string `min:"1" type:"string"`

	// The updated version ID of the application.
	ApplicationVersionId *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationVpcConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationVpcConfigurationOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *DeleteApplicationVpcConfigurationOutput) SetApplicationARN(v string) *DeleteApplicationVpcConfigurationOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *DeleteApplicationVpcConfigurationOutput) SetApplicationVersionId(v int64) *DeleteApplicationVpcConfigurationOutput {
	s.ApplicationVersionId = &v
	return s
}

// The information required to deploy a Kinesis Data Analytics Studio notebook
// as an application with durable state.
type DeployAsApplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// The description of an Amazon S3 object that contains the Amazon Data Analytics
	// application, including the Amazon Resource Name (ARN) of the S3 bucket, the
	// name of the Amazon S3 object that contains the data, and the version number
	// of the Amazon S3 object that contains the data.
	//
	// S3ContentLocation is a required field
	S3ContentLocation *S3ContentBaseLocation `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployAsApplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployAsApplicationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeployAsApplicationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeployAsApplicationConfiguration"}
	if s.S3ContentLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("S3ContentLocation"))
	}
	if s.S3ContentLocation != nil {
		if err := s.S3ContentLocation.Validate(); err != nil {
			invalidParams.AddNested("S3ContentLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3ContentLocation sets the S3ContentLocation field's value.
func (s *DeployAsApplicationConfiguration) SetS3ContentLocation(v *S3ContentBaseLocation) *DeployAsApplicationConfiguration {
	s.S3ContentLocation = v
	return s
}

// The configuration information required to deploy an Amazon Data Analytics
// Studio notebook as an application with durable state.
type DeployAsApplicationConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The location that holds the data required to specify an Amazon Data Analytics
	// application.
	//
	// S3ContentLocationDescription is a required field
	S3ContentLocationDescription *S3ContentBaseLocationDescription `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployAsApplicationConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployAsApplicationConfigurationDescription) GoString() string {
	return s.String()
}

// SetS3ContentLocationDescription sets the S3ContentLocationDescription field's value.
func (s *DeployAsApplicationConfigurationDescription) SetS3ContentLocationDescription(v *S3ContentBaseLocationDescription) *DeployAsApplicationConfigurationDescription {
	s.S3ContentLocationDescription = v
	return s
}

// Updates to the configuration information required to deploy an Amazon Data
// Analytics Studio notebook as an application with durable state.
type DeployAsApplicationConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Updates to the location that holds the data required to specify an Amazon
	// Data Analytics application.
	S3ContentLocationUpdate *S3ContentBaseLocationUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployAsApplicationConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeployAsApplicationConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeployAsApplicationConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeployAsApplicationConfigurationUpdate"}
	if s.S3ContentLocationUpdate != nil {
		if err := s.S3ContentLocationUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3ContentLocationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3ContentLocationUpdate sets the S3ContentLocationUpdate field's value.
func (s *DeployAsApplicationConfigurationUpdate) SetS3ContentLocationUpdate(v *S3ContentBaseLocationUpdate) *DeployAsApplicationConfigurationUpdate {
	s.S3ContentLocationUpdate = v
	return s
}

type DescribeApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Displays verbose information about a Kinesis Data Analytics application,
	// including the application's job plan.
	IncludeAdditionalDetails *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DescribeApplicationInput) SetApplicationName(v string) *DescribeApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetIncludeAdditionalDetails sets the IncludeAdditionalDetails field's value.
func (s *DescribeApplicationInput) SetIncludeAdditionalDetails(v bool) *DescribeApplicationInput {
	s.IncludeAdditionalDetails = &v
	return s
}

type DescribeApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Provides a description of the application, such as the application's Amazon
	// Resource Name (ARN), status, and latest version.
	//
	// ApplicationDetail is a required field
	ApplicationDetail *ApplicationDetail `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationDetail sets the ApplicationDetail field's value.
func (s *DescribeApplicationOutput) SetApplicationDetail(v *ApplicationDetail) *DescribeApplicationOutput {
	s.ApplicationDetail = v
	return s
}

type DescribeApplicationSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The identifier of an application snapshot. You can retrieve this value using .
	//
	// SnapshotName is a required field
	SnapshotName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationSnapshotInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}
	if s.SnapshotName != nil && len(*s.SnapshotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DescribeApplicationSnapshotInput) SetApplicationName(v string) *DescribeApplicationSnapshotInput {
	s.ApplicationName = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *DescribeApplicationSnapshotInput) SetSnapshotName(v string) *DescribeApplicationSnapshotInput {
	s.SnapshotName = &v
	return s
}

type DescribeApplicationSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the application snapshot.
	//
	// SnapshotDetails is a required field
	SnapshotDetails *SnapshotDetails `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshotDetails sets the SnapshotDetails field's value.
func (s *DescribeApplicationSnapshotOutput) SetSnapshotDetails(v *SnapshotDetails) *DescribeApplicationSnapshotOutput {
	s.SnapshotDetails = v
	return s
}

type DescribeApplicationVersionInput struct {
	_ struct{} `type:"structure"`

	// The name of the application for which you want to get the version description.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The ID of the application version for which you want to get the description.
	//
	// ApplicationVersionId is a required field
	ApplicationVersionId *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationVersionInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.ApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationVersionId"))
	}
	if s.ApplicationVersionId != nil && *s.ApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ApplicationVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *DescribeApplicationVersionInput) SetApplicationName(v string) *DescribeApplicationVersionInput {
	s.ApplicationName = &v
	return s
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *DescribeApplicationVersionInput) SetApplicationVersionId(v int64) *DescribeApplicationVersionInput {
	s.ApplicationVersionId = &v
	return s
}

type DescribeApplicationVersionOutput struct {
	_ struct{} `type:"structure"`

	// Describes the application, including the application Amazon Resource Name
	// (ARN), status, latest version, and input and output configurations.
	ApplicationVersionDetail *ApplicationDetail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationVersionOutput) GoString() string {
	return s.String()
}

// SetApplicationVersionDetail sets the ApplicationVersionDetail field's value.
func (s *DescribeApplicationVersionOutput) SetApplicationVersionDetail(v *ApplicationDetail) *DescribeApplicationVersionOutput {
	s.ApplicationVersionDetail = v
	return s
}

// Describes the data format when records are written to the destination in
// a SQL-based Kinesis Data Analytics application.
type DestinationSchema struct {
	_ struct{} `type:"structure"`

	// Specifies the format of the records on the output stream.
	//
	// RecordFormatType is a required field
	RecordFormatType *string `type:"string" required:"true" enum:"RecordFormatType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationSchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationSchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationSchema"}
	if s.RecordFormatType == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordFormatType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordFormatType sets the RecordFormatType field's value.
func (s *DestinationSchema) SetRecordFormatType(v string) *DestinationSchema {
	s.RecordFormatType = &v
	return s
}

type DiscoverInputSchemaInput struct {
	_ struct{} `type:"structure"`

	// The InputProcessingConfiguration to use to preprocess the records before
	// discovering the schema of the records.
	InputProcessingConfiguration *InputProcessingConfiguration `type:"structure"`

	// The point at which you want Kinesis Data Analytics to start reading records
	// from the specified streaming source discovery purposes.
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of the streaming source.
	ResourceARN *string `min:"1" type:"string"`

	// Specify this parameter to discover a schema from data in an Amazon S3 object.
	S3Configuration *S3Configuration `type:"structure"`

	// The ARN of the role that is used to access the streaming source.
	//
	// ServiceExecutionRole is a required field
	ServiceExecutionRole *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoverInputSchemaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoverInputSchemaInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiscoverInputSchemaInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DiscoverInputSchemaInput"}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.ServiceExecutionRole == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceExecutionRole"))
	}
	if s.ServiceExecutionRole != nil && len(*s.ServiceExecutionRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceExecutionRole", 1))
	}
	if s.InputProcessingConfiguration != nil {
		if err := s.InputProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputProcessingConfiguration sets the InputProcessingConfiguration field's value.
func (s *DiscoverInputSchemaInput) SetInputProcessingConfiguration(v *InputProcessingConfiguration) *DiscoverInputSchemaInput {
	s.InputProcessingConfiguration = v
	return s
}

// SetInputStartingPositionConfiguration sets the InputStartingPositionConfiguration field's value.
func (s *DiscoverInputSchemaInput) SetInputStartingPositionConfiguration(v *InputStartingPositionConfiguration) *DiscoverInputSchemaInput {
	s.InputStartingPositionConfiguration = v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *DiscoverInputSchemaInput) SetResourceARN(v string) *DiscoverInputSchemaInput {
	s.ResourceARN = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *DiscoverInputSchemaInput) SetS3Configuration(v *S3Configuration) *DiscoverInputSchemaInput {
	s.S3Configuration = v
	return s
}

// SetServiceExecutionRole sets the ServiceExecutionRole field's value.
func (s *DiscoverInputSchemaInput) SetServiceExecutionRole(v string) *DiscoverInputSchemaInput {
	s.ServiceExecutionRole = &v
	return s
}

type DiscoverInputSchemaOutput struct {
	_ struct{} `type:"structure"`

	// The schema inferred from the streaming source. It identifies the format of
	// the data in the streaming source and how each data element maps to corresponding
	// columns in the in-application stream that you can create.
	InputSchema *SourceSchema `type:"structure"`

	// An array of elements, where each element corresponds to a row in a stream
	// record (a stream record can have more than one row).
	ParsedInputRecords [][]*string `type:"list"`

	// The stream data that was modified by the processor specified in the InputProcessingConfiguration
	// parameter.
	ProcessedInputRecords []*string `type:"list"`

	// The raw stream data that was sampled to infer the schema.
	RawInputRecords []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoverInputSchemaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoverInputSchemaOutput) GoString() string {
	return s.String()
}

// SetInputSchema sets the InputSchema field's value.
func (s *DiscoverInputSchemaOutput) SetInputSchema(v *SourceSchema) *DiscoverInputSchemaOutput {
	s.InputSchema = v
	return s
}

// SetParsedInputRecords sets the ParsedInputRecords field's value.
func (s *DiscoverInputSchemaOutput) SetParsedInputRecords(v [][]*string) *DiscoverInputSchemaOutput {
	s.ParsedInputRecords = v
	return s
}

// SetProcessedInputRecords sets the ProcessedInputRecords field's value.
func (s *DiscoverInputSchemaOutput) SetProcessedInputRecords(v []*string) *DiscoverInputSchemaOutput {
	s.ProcessedInputRecords = v
	return s
}

// SetRawInputRecords sets the RawInputRecords field's value.
func (s *DiscoverInputSchemaOutput) SetRawInputRecords(v []*string) *DiscoverInputSchemaOutput {
	s.RawInputRecords = v
	return s
}

// Describes execution properties for a Flink-based Kinesis Data Analytics application.
type EnvironmentProperties struct {
	_ struct{} `type:"structure"`

	// Describes the execution property groups.
	//
	// PropertyGroups is a required field
	PropertyGroups []*PropertyGroup `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnvironmentProperties"}
	if s.PropertyGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyGroups"))
	}
	if s.PropertyGroups != nil {
		for i, v := range s.PropertyGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPropertyGroups sets the PropertyGroups field's value.
func (s *EnvironmentProperties) SetPropertyGroups(v []*PropertyGroup) *EnvironmentProperties {
	s.PropertyGroups = v
	return s
}

// Describes the execution properties for an Apache Flink runtime.
type EnvironmentPropertyDescriptions struct {
	_ struct{} `type:"structure"`

	// Describes the execution property groups.
	PropertyGroupDescriptions []*PropertyGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentPropertyDescriptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentPropertyDescriptions) GoString() string {
	return s.String()
}

// SetPropertyGroupDescriptions sets the PropertyGroupDescriptions field's value.
func (s *EnvironmentPropertyDescriptions) SetPropertyGroupDescriptions(v []*PropertyGroup) *EnvironmentPropertyDescriptions {
	s.PropertyGroupDescriptions = v
	return s
}

// Describes updates to the execution property groups for a Flink-based Kinesis
// Data Analytics application or a Studio notebook.
type EnvironmentPropertyUpdates struct {
	_ struct{} `type:"structure"`

	// Describes updates to the execution property groups.
	//
	// PropertyGroups is a required field
	PropertyGroups []*PropertyGroup `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentPropertyUpdates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentPropertyUpdates) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentPropertyUpdates) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnvironmentPropertyUpdates"}
	if s.PropertyGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyGroups"))
	}
	if s.PropertyGroups != nil {
		for i, v := range s.PropertyGroups {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyGroups", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPropertyGroups sets the PropertyGroups field's value.
func (s *EnvironmentPropertyUpdates) SetPropertyGroups(v []*PropertyGroup) *EnvironmentPropertyUpdates {
	s.PropertyGroups = v
	return s
}

// Describes configuration parameters for a Flink-based Kinesis Data Analytics
// application or a Studio notebook.
type FlinkApplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes an application's checkpointing configuration. Checkpointing is
	// the process of persisting application state for fault tolerance. For more
	// information, see Checkpoints for Fault Tolerance (https://ci.apache.org/projects/flink/flink-docs-release-1.8/concepts/programming-model.html#checkpoints-for-fault-tolerance)
	// in the Apache Flink Documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
	CheckpointConfiguration *CheckpointConfiguration `type:"structure"`

	// Describes configuration parameters for Amazon CloudWatch logging for an application.
	MonitoringConfiguration *MonitoringConfiguration `type:"structure"`

	// Describes parameters for how an application executes multiple tasks simultaneously.
	ParallelismConfiguration *ParallelismConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlinkApplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlinkApplicationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlinkApplicationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlinkApplicationConfiguration"}
	if s.CheckpointConfiguration != nil {
		if err := s.CheckpointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CheckpointConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.MonitoringConfiguration != nil {
		if err := s.MonitoringConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MonitoringConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ParallelismConfiguration != nil {
		if err := s.ParallelismConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ParallelismConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckpointConfiguration sets the CheckpointConfiguration field's value.
func (s *FlinkApplicationConfiguration) SetCheckpointConfiguration(v *CheckpointConfiguration) *FlinkApplicationConfiguration {
	s.CheckpointConfiguration = v
	return s
}

// SetMonitoringConfiguration sets the MonitoringConfiguration field's value.
func (s *FlinkApplicationConfiguration) SetMonitoringConfiguration(v *MonitoringConfiguration) *FlinkApplicationConfiguration {
	s.MonitoringConfiguration = v
	return s
}

// SetParallelismConfiguration sets the ParallelismConfiguration field's value.
func (s *FlinkApplicationConfiguration) SetParallelismConfiguration(v *ParallelismConfiguration) *FlinkApplicationConfiguration {
	s.ParallelismConfiguration = v
	return s
}

// Describes configuration parameters for a Flink-based Kinesis Data Analytics
// application.
type FlinkApplicationConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes an application's checkpointing configuration. Checkpointing is
	// the process of persisting application state for fault tolerance.
	CheckpointConfigurationDescription *CheckpointConfigurationDescription `type:"structure"`

	// The job plan for an application. For more information about the job plan,
	// see Jobs and Scheduling (https://ci.apache.org/projects/flink/flink-docs-release-1.8/internals/job_scheduling.html)
	// in the Apache Flink Documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
	// To retrieve the job plan for the application, use the DescribeApplicationRequest$IncludeAdditionalDetails
	// parameter of the DescribeApplication operation.
	JobPlanDescription *string `type:"string"`

	// Describes configuration parameters for Amazon CloudWatch logging for an application.
	MonitoringConfigurationDescription *MonitoringConfigurationDescription `type:"structure"`

	// Describes parameters for how an application executes multiple tasks simultaneously.
	ParallelismConfigurationDescription *ParallelismConfigurationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlinkApplicationConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlinkApplicationConfigurationDescription) GoString() string {
	return s.String()
}

// SetCheckpointConfigurationDescription sets the CheckpointConfigurationDescription field's value.
func (s *FlinkApplicationConfigurationDescription) SetCheckpointConfigurationDescription(v *CheckpointConfigurationDescription) *FlinkApplicationConfigurationDescription {
	s.CheckpointConfigurationDescription = v
	return s
}

// SetJobPlanDescription sets the JobPlanDescription field's value.
func (s *FlinkApplicationConfigurationDescription) SetJobPlanDescription(v string) *FlinkApplicationConfigurationDescription {
	s.JobPlanDescription = &v
	return s
}

// SetMonitoringConfigurationDescription sets the MonitoringConfigurationDescription field's value.
func (s *FlinkApplicationConfigurationDescription) SetMonitoringConfigurationDescription(v *MonitoringConfigurationDescription) *FlinkApplicationConfigurationDescription {
	s.MonitoringConfigurationDescription = v
	return s
}

// SetParallelismConfigurationDescription sets the ParallelismConfigurationDescription field's value.
func (s *FlinkApplicationConfigurationDescription) SetParallelismConfigurationDescription(v *ParallelismConfigurationDescription) *FlinkApplicationConfigurationDescription {
	s.ParallelismConfigurationDescription = v
	return s
}

// Describes updates to the configuration parameters for a Flink-based Kinesis
// Data Analytics application.
type FlinkApplicationConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to an application's checkpointing configuration. Checkpointing
	// is the process of persisting application state for fault tolerance.
	CheckpointConfigurationUpdate *CheckpointConfigurationUpdate `type:"structure"`

	// Describes updates to the configuration parameters for Amazon CloudWatch logging
	// for an application.
	MonitoringConfigurationUpdate *MonitoringConfigurationUpdate `type:"structure"`

	// Describes updates to the parameters for how an application executes multiple
	// tasks simultaneously.
	ParallelismConfigurationUpdate *ParallelismConfigurationUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlinkApplicationConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlinkApplicationConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlinkApplicationConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlinkApplicationConfigurationUpdate"}
	if s.CheckpointConfigurationUpdate != nil {
		if err := s.CheckpointConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("CheckpointConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.ParallelismConfigurationUpdate != nil {
		if err := s.ParallelismConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ParallelismConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckpointConfigurationUpdate sets the CheckpointConfigurationUpdate field's value.
func (s *FlinkApplicationConfigurationUpdate) SetCheckpointConfigurationUpdate(v *CheckpointConfigurationUpdate) *FlinkApplicationConfigurationUpdate {
	s.CheckpointConfigurationUpdate = v
	return s
}

// SetMonitoringConfigurationUpdate sets the MonitoringConfigurationUpdate field's value.
func (s *FlinkApplicationConfigurationUpdate) SetMonitoringConfigurationUpdate(v *MonitoringConfigurationUpdate) *FlinkApplicationConfigurationUpdate {
	s.MonitoringConfigurationUpdate = v
	return s
}

// SetParallelismConfigurationUpdate sets the ParallelismConfigurationUpdate field's value.
func (s *FlinkApplicationConfigurationUpdate) SetParallelismConfigurationUpdate(v *ParallelismConfigurationUpdate) *FlinkApplicationConfigurationUpdate {
	s.ParallelismConfigurationUpdate = v
	return s
}

// Describes the starting parameters for a Flink-based Kinesis Data Analytics
// application.
type FlinkRunConfiguration struct {
	_ struct{} `type:"structure"`

	// When restoring from a snapshot, specifies whether the runtime is allowed
	// to skip a state that cannot be mapped to the new program. This will happen
	// if the program is updated between snapshots to remove stateful parameters,
	// and state data in the snapshot no longer corresponds to valid application
	// data. For more information, see Allowing Non-Restored State (https://ci.apache.org/projects/flink/flink-docs-release-1.8/ops/state/savepoints.html#allowing-non-restored-state)
	// in the Apache Flink documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
	//
	// This value defaults to false. If you update your application without specifying
	// this parameter, AllowNonRestoredState will be set to false, even if it was
	// previously set to true.
	AllowNonRestoredState *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlinkRunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlinkRunConfiguration) GoString() string {
	return s.String()
}

// SetAllowNonRestoredState sets the AllowNonRestoredState field's value.
func (s *FlinkRunConfiguration) SetAllowNonRestoredState(v bool) *FlinkRunConfiguration {
	s.AllowNonRestoredState = &v
	return s
}

// The configuration of the Glue Data Catalog that you use for Apache Flink
// SQL queries and table API transforms that you write in an application.
type GlueDataCatalogConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the database.
	//
	// DatabaseARN is a required field
	DatabaseARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueDataCatalogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueDataCatalogConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlueDataCatalogConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlueDataCatalogConfiguration"}
	if s.DatabaseARN == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseARN"))
	}
	if s.DatabaseARN != nil && len(*s.DatabaseARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseARN sets the DatabaseARN field's value.
func (s *GlueDataCatalogConfiguration) SetDatabaseARN(v string) *GlueDataCatalogConfiguration {
	s.DatabaseARN = &v
	return s
}

// The configuration of the Glue Data Catalog that you use for Apache Flink
// SQL queries and table API transforms that you write in an application.
type GlueDataCatalogConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the database.
	//
	// DatabaseARN is a required field
	DatabaseARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueDataCatalogConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueDataCatalogConfigurationDescription) GoString() string {
	return s.String()
}

// SetDatabaseARN sets the DatabaseARN field's value.
func (s *GlueDataCatalogConfigurationDescription) SetDatabaseARN(v string) *GlueDataCatalogConfigurationDescription {
	s.DatabaseARN = &v
	return s
}

// Updates to the configuration of the Glue Data Catalog that you use for SQL
// queries that you write in a Kinesis Data Analytics Studio notebook.
type GlueDataCatalogConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// The updated Amazon Resource Name (ARN) of the database.
	//
	// DatabaseARNUpdate is a required field
	DatabaseARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueDataCatalogConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueDataCatalogConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlueDataCatalogConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlueDataCatalogConfigurationUpdate"}
	if s.DatabaseARNUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseARNUpdate"))
	}
	if s.DatabaseARNUpdate != nil && len(*s.DatabaseARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseARNUpdate sets the DatabaseARNUpdate field's value.
func (s *GlueDataCatalogConfigurationUpdate) SetDatabaseARNUpdate(v string) *GlueDataCatalogConfigurationUpdate {
	s.DatabaseARNUpdate = &v
	return s
}

// When you configure the application input for a SQL-based Kinesis Data Analytics
// application, you specify the streaming source, the in-application stream
// name that is created, and the mapping between the two.
type Input struct {
	_ struct{} `type:"structure"`

	// Describes the number of in-application streams to create.
	InputParallelism *InputParallelism `type:"structure"`

	// The InputProcessingConfiguration for the input. An input processor transforms
	// records as they are received from the stream, before the application's SQL
	// code executes. Currently, the only input processing configuration available
	// is InputLambdaProcessor.
	InputProcessingConfiguration *InputProcessingConfiguration `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns in the in-application stream that is
	// being created.
	//
	// Also used to describe the format of the reference data source.
	//
	// InputSchema is a required field
	InputSchema *SourceSchema `type:"structure" required:"true"`

	// If the streaming source is an Amazon Kinesis Data Firehose delivery stream,
	// identifies the delivery stream's ARN.
	KinesisFirehoseInput *KinesisFirehoseInput `type:"structure"`

	// If the streaming source is an Amazon Kinesis data stream, identifies the
	// stream's Amazon Resource Name (ARN).
	KinesisStreamsInput *KinesisStreamsInput `type:"structure"`

	// The name prefix to use when creating an in-application stream. Suppose that
	// you specify a prefix "MyInApplicationStream." Kinesis Data Analytics then
	// creates one or more (as per the InputParallelism count you specified) in-application
	// streams with the names "MyInApplicationStream_001," "MyInApplicationStream_002,"
	// and so on.
	//
	// NamePrefix is a required field
	NamePrefix *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Input"}
	if s.InputSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSchema"))
	}
	if s.NamePrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("NamePrefix"))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.InputParallelism != nil {
		if err := s.InputParallelism.Validate(); err != nil {
			invalidParams.AddNested("InputParallelism", err.(request.ErrInvalidParams))
		}
	}
	if s.InputProcessingConfiguration != nil {
		if err := s.InputProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.InputSchema != nil {
		if err := s.InputSchema.Validate(); err != nil {
			invalidParams.AddNested("InputSchema", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseInput != nil {
		if err := s.KinesisFirehoseInput.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseInput", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsInput != nil {
		if err := s.KinesisStreamsInput.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputParallelism sets the InputParallelism field's value.
func (s *Input) SetInputParallelism(v *InputParallelism) *Input {
	s.InputParallelism = v
	return s
}

// SetInputProcessingConfiguration sets the InputProcessingConfiguration field's value.
func (s *Input) SetInputProcessingConfiguration(v *InputProcessingConfiguration) *Input {
	s.InputProcessingConfiguration = v
	return s
}

// SetInputSchema sets the InputSchema field's value.
func (s *Input) SetInputSchema(v *SourceSchema) *Input {
	s.InputSchema = v
	return s
}

// SetKinesisFirehoseInput sets the KinesisFirehoseInput field's value.
func (s *Input) SetKinesisFirehoseInput(v *KinesisFirehoseInput) *Input {
	s.KinesisFirehoseInput = v
	return s
}

// SetKinesisStreamsInput sets the KinesisStreamsInput field's value.
func (s *Input) SetKinesisStreamsInput(v *KinesisStreamsInput) *Input {
	s.KinesisStreamsInput = v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *Input) SetNamePrefix(v string) *Input {
	s.NamePrefix = &v
	return s
}

// Describes the application input configuration for a SQL-based Kinesis Data
// Analytics application.
type InputDescription struct {
	_ struct{} `type:"structure"`

	// Returns the in-application stream names that are mapped to the stream source.
	InAppStreamNames []*string `type:"list"`

	// The input ID that is associated with the application input. This is the ID
	// that Kinesis Data Analytics assigns to each input configuration that you
	// add to your application.
	InputId *string `min:"1" type:"string"`

	// Describes the configured parallelism (number of in-application streams mapped
	// to the streaming source).
	InputParallelism *InputParallelism `type:"structure"`

	// The description of the preprocessor that executes on records in this input
	// before the application's code is run.
	InputProcessingConfigurationDescription *InputProcessingConfigurationDescription `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns in the in-application stream that is
	// being created.
	InputSchema *SourceSchema `type:"structure"`

	// The point at which the application is configured to read from the input stream.
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure"`

	// If a Kinesis Data Firehose delivery stream is configured as a streaming source,
	// provides the delivery stream's ARN.
	KinesisFirehoseInputDescription *KinesisFirehoseInputDescription `type:"structure"`

	// If a Kinesis data stream is configured as a streaming source, provides the
	// Kinesis data stream's Amazon Resource Name (ARN).
	KinesisStreamsInputDescription *KinesisStreamsInputDescription `type:"structure"`

	// The in-application name prefix.
	NamePrefix *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDescription) GoString() string {
	return s.String()
}

// SetInAppStreamNames sets the InAppStreamNames field's value.
func (s *InputDescription) SetInAppStreamNames(v []*string) *InputDescription {
	s.InAppStreamNames = v
	return s
}

// SetInputId sets the InputId field's value.
func (s *InputDescription) SetInputId(v string) *InputDescription {
	s.InputId = &v
	return s
}

// SetInputParallelism sets the InputParallelism field's value.
func (s *InputDescription) SetInputParallelism(v *InputParallelism) *InputDescription {
	s.InputParallelism = v
	return s
}

// SetInputProcessingConfigurationDescription sets the InputProcessingConfigurationDescription field's value.
func (s *InputDescription) SetInputProcessingConfigurationDescription(v *InputProcessingConfigurationDescription) *InputDescription {
	s.InputProcessingConfigurationDescription = v
	return s
}

// SetInputSchema sets the InputSchema field's value.
func (s *InputDescription) SetInputSchema(v *SourceSchema) *InputDescription {
	s.InputSchema = v
	return s
}

// SetInputStartingPositionConfiguration sets the InputStartingPositionConfiguration field's value.
func (s *InputDescription) SetInputStartingPositionConfiguration(v *InputStartingPositionConfiguration) *InputDescription {
	s.InputStartingPositionConfiguration = v
	return s
}

// SetKinesisFirehoseInputDescription sets the KinesisFirehoseInputDescription field's value.
func (s *InputDescription) SetKinesisFirehoseInputDescription(v *KinesisFirehoseInputDescription) *InputDescription {
	s.KinesisFirehoseInputDescription = v
	return s
}

// SetKinesisStreamsInputDescription sets the KinesisStreamsInputDescription field's value.
func (s *InputDescription) SetKinesisStreamsInputDescription(v *KinesisStreamsInputDescription) *InputDescription {
	s.KinesisStreamsInputDescription = v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *InputDescription) SetNamePrefix(v string) *InputDescription {
	s.NamePrefix = &v
	return s
}

// An object that contains the Amazon Resource Name (ARN) of the Amazon Lambda
// function that is used to preprocess records in the stream in a SQL-based
// Kinesis Data Analytics application.
type InputLambdaProcessor struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Lambda function that operates on records in the stream.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: Amazon Lambda (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLambdaProcessor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLambdaProcessor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLambdaProcessor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLambdaProcessor"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *InputLambdaProcessor) SetResourceARN(v string) *InputLambdaProcessor {
	s.ResourceARN = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, an object that contains
// the Amazon Resource Name (ARN) of the Amazon Lambda function that is used
// to preprocess records in the stream.
type InputLambdaProcessorDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Lambda function that is used to preprocess the records
	// in the stream.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: Amazon Lambda (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that is used to access the Amazon Lambda function.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLambdaProcessorDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLambdaProcessorDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *InputLambdaProcessorDescription) SetResourceARN(v string) *InputLambdaProcessorDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *InputLambdaProcessorDescription) SetRoleARN(v string) *InputLambdaProcessorDescription {
	s.RoleARN = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, represents an update
// to the InputLambdaProcessor that is used to preprocess the records in the
// stream.
type InputLambdaProcessorUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new Amazon Lambda function that is
	// used to preprocess the records in the stream.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: Amazon Lambda (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLambdaProcessorUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputLambdaProcessorUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLambdaProcessorUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputLambdaProcessorUpdate"}
	if s.ResourceARNUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *InputLambdaProcessorUpdate) SetResourceARNUpdate(v string) *InputLambdaProcessorUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes the number
// of in-application streams to create for a given streaming source.
type InputParallelism struct {
	_ struct{} `type:"structure"`

	// The number of in-application streams to create.
	Count *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputParallelism) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputParallelism) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputParallelism) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputParallelism"}
	if s.Count != nil && *s.Count < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Count", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCount sets the Count field's value.
func (s *InputParallelism) SetCount(v int64) *InputParallelism {
	s.Count = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, provides updates to the
// parallelism count.
type InputParallelismUpdate struct {
	_ struct{} `type:"structure"`

	// The number of in-application streams to create for the specified streaming
	// source.
	//
	// CountUpdate is a required field
	CountUpdate *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputParallelismUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputParallelismUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputParallelismUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputParallelismUpdate"}
	if s.CountUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("CountUpdate"))
	}
	if s.CountUpdate != nil && *s.CountUpdate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CountUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCountUpdate sets the CountUpdate field's value.
func (s *InputParallelismUpdate) SetCountUpdate(v int64) *InputParallelismUpdate {
	s.CountUpdate = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes a processor
// that is used to preprocess the records in the stream before being processed
// by your application code. Currently, the only input processor available is
// Amazon Lambda (https://docs.aws.amazon.com/lambda/).
type InputProcessingConfiguration struct {
	_ struct{} `type:"structure"`

	// The InputLambdaProcessor that is used to preprocess the records in the stream
	// before being processed by your application code.
	//
	// InputLambdaProcessor is a required field
	InputLambdaProcessor *InputLambdaProcessor `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputProcessingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputProcessingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputProcessingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputProcessingConfiguration"}
	if s.InputLambdaProcessor == nil {
		invalidParams.Add(request.NewErrParamRequired("InputLambdaProcessor"))
	}
	if s.InputLambdaProcessor != nil {
		if err := s.InputLambdaProcessor.Validate(); err != nil {
			invalidParams.AddNested("InputLambdaProcessor", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputLambdaProcessor sets the InputLambdaProcessor field's value.
func (s *InputProcessingConfiguration) SetInputLambdaProcessor(v *InputLambdaProcessor) *InputProcessingConfiguration {
	s.InputLambdaProcessor = v
	return s
}

// For a SQL-based Kinesis Data Analytics application, provides the configuration
// information about an input processor. Currently, the only input processor
// available is Amazon Lambda (https://docs.aws.amazon.com/lambda/).
type InputProcessingConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Provides configuration information about the associated InputLambdaProcessorDescription
	InputLambdaProcessorDescription *InputLambdaProcessorDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputProcessingConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputProcessingConfigurationDescription) GoString() string {
	return s.String()
}

// SetInputLambdaProcessorDescription sets the InputLambdaProcessorDescription field's value.
func (s *InputProcessingConfigurationDescription) SetInputLambdaProcessorDescription(v *InputLambdaProcessorDescription) *InputProcessingConfigurationDescription {
	s.InputLambdaProcessorDescription = v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes updates to
// an InputProcessingConfiguration.
type InputProcessingConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Provides update information for an InputLambdaProcessor.
	//
	// InputLambdaProcessorUpdate is a required field
	InputLambdaProcessorUpdate *InputLambdaProcessorUpdate `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputProcessingConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputProcessingConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputProcessingConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputProcessingConfigurationUpdate"}
	if s.InputLambdaProcessorUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("InputLambdaProcessorUpdate"))
	}
	if s.InputLambdaProcessorUpdate != nil {
		if err := s.InputLambdaProcessorUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputLambdaProcessorUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputLambdaProcessorUpdate sets the InputLambdaProcessorUpdate field's value.
func (s *InputProcessingConfigurationUpdate) SetInputLambdaProcessorUpdate(v *InputLambdaProcessorUpdate) *InputProcessingConfigurationUpdate {
	s.InputLambdaProcessorUpdate = v
	return s
}

// Describes updates for an SQL-based Kinesis Data Analytics application's input
// schema.
type InputSchemaUpdate struct {
	_ struct{} `type:"structure"`

	// A list of RecordColumn objects. Each object describes the mapping of the
	// streaming source element to the corresponding column in the in-application
	// stream.
	RecordColumnUpdates []*RecordColumn `min:"1" type:"list"`

	// Specifies the encoding of the records in the streaming source; for example,
	// UTF-8.
	RecordEncodingUpdate *string `min:"5" type:"string"`

	// Specifies the format of the records on the streaming source.
	RecordFormatUpdate *RecordFormat `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSchemaUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputSchemaUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSchemaUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputSchemaUpdate"}
	if s.RecordColumnUpdates != nil && len(s.RecordColumnUpdates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordColumnUpdates", 1))
	}
	if s.RecordEncodingUpdate != nil && len(*s.RecordEncodingUpdate) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("RecordEncodingUpdate", 5))
	}
	if s.RecordColumnUpdates != nil {
		for i, v := range s.RecordColumnUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecordColumnUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RecordFormatUpdate != nil {
		if err := s.RecordFormatUpdate.Validate(); err != nil {
			invalidParams.AddNested("RecordFormatUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordColumnUpdates sets the RecordColumnUpdates field's value.
func (s *InputSchemaUpdate) SetRecordColumnUpdates(v []*RecordColumn) *InputSchemaUpdate {
	s.RecordColumnUpdates = v
	return s
}

// SetRecordEncodingUpdate sets the RecordEncodingUpdate field's value.
func (s *InputSchemaUpdate) SetRecordEncodingUpdate(v string) *InputSchemaUpdate {
	s.RecordEncodingUpdate = &v
	return s
}

// SetRecordFormatUpdate sets the RecordFormatUpdate field's value.
func (s *InputSchemaUpdate) SetRecordFormatUpdate(v *RecordFormat) *InputSchemaUpdate {
	s.RecordFormatUpdate = v
	return s
}

// Describes the point at which the application reads from the streaming source.
type InputStartingPositionConfiguration struct {
	_ struct{} `type:"structure"`

	// The starting position on the stream.
	//
	//    * NOW - Start reading just after the most recent record in the stream,
	//    and start at the request timestamp that the customer issued.
	//
	//    * TRIM_HORIZON - Start reading at the last untrimmed record in the stream,
	//    which is the oldest record available in the stream. This option is not
	//    available for an Amazon Kinesis Data Firehose delivery stream.
	//
	//    * LAST_STOPPED_POINT - Resume reading from where the application last
	//    stopped reading.
	InputStartingPosition *string `type:"string" enum:"InputStartingPosition"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputStartingPositionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputStartingPositionConfiguration) GoString() string {
	return s.String()
}

// SetInputStartingPosition sets the InputStartingPosition field's value.
func (s *InputStartingPositionConfiguration) SetInputStartingPosition(v string) *InputStartingPositionConfiguration {
	s.InputStartingPosition = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes updates to
// a specific input configuration (identified by the InputId of an application).
type InputUpdate struct {
	_ struct{} `type:"structure"`

	// The input ID of the application input to be updated.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`

	// Describes the parallelism updates (the number of in-application streams Kinesis
	// Data Analytics creates for the specific streaming source).
	InputParallelismUpdate *InputParallelismUpdate `type:"structure"`

	// Describes updates to an InputProcessingConfiguration.
	InputProcessingConfigurationUpdate *InputProcessingConfigurationUpdate `type:"structure"`

	// Describes the data format on the streaming source, and how record elements
	// on the streaming source map to columns of the in-application stream that
	// is created.
	InputSchemaUpdate *InputSchemaUpdate `type:"structure"`

	// If a Kinesis Data Firehose delivery stream is the streaming source to be
	// updated, provides an updated stream ARN.
	KinesisFirehoseInputUpdate *KinesisFirehoseInputUpdate `type:"structure"`

	// If a Kinesis data stream is the streaming source to be updated, provides
	// an updated stream Amazon Resource Name (ARN).
	KinesisStreamsInputUpdate *KinesisStreamsInputUpdate `type:"structure"`

	// The name prefix for in-application streams that Kinesis Data Analytics creates
	// for the specific streaming source.
	NamePrefixUpdate *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputUpdate"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}
	if s.NamePrefixUpdate != nil && len(*s.NamePrefixUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefixUpdate", 1))
	}
	if s.InputParallelismUpdate != nil {
		if err := s.InputParallelismUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputParallelismUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.InputProcessingConfigurationUpdate != nil {
		if err := s.InputProcessingConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.InputSchemaUpdate != nil {
		if err := s.InputSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputSchemaUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseInputUpdate != nil {
		if err := s.KinesisFirehoseInputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseInputUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsInputUpdate != nil {
		if err := s.KinesisStreamsInputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsInputUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *InputUpdate) SetInputId(v string) *InputUpdate {
	s.InputId = &v
	return s
}

// SetInputParallelismUpdate sets the InputParallelismUpdate field's value.
func (s *InputUpdate) SetInputParallelismUpdate(v *InputParallelismUpdate) *InputUpdate {
	s.InputParallelismUpdate = v
	return s
}

// SetInputProcessingConfigurationUpdate sets the InputProcessingConfigurationUpdate field's value.
func (s *InputUpdate) SetInputProcessingConfigurationUpdate(v *InputProcessingConfigurationUpdate) *InputUpdate {
	s.InputProcessingConfigurationUpdate = v
	return s
}

// SetInputSchemaUpdate sets the InputSchemaUpdate field's value.
func (s *InputUpdate) SetInputSchemaUpdate(v *InputSchemaUpdate) *InputUpdate {
	s.InputSchemaUpdate = v
	return s
}

// SetKinesisFirehoseInputUpdate sets the KinesisFirehoseInputUpdate field's value.
func (s *InputUpdate) SetKinesisFirehoseInputUpdate(v *KinesisFirehoseInputUpdate) *InputUpdate {
	s.KinesisFirehoseInputUpdate = v
	return s
}

// SetKinesisStreamsInputUpdate sets the KinesisStreamsInputUpdate field's value.
func (s *InputUpdate) SetKinesisStreamsInputUpdate(v *KinesisStreamsInputUpdate) *InputUpdate {
	s.KinesisStreamsInputUpdate = v
	return s
}

// SetNamePrefixUpdate sets the NamePrefixUpdate field's value.
func (s *InputUpdate) SetNamePrefixUpdate(v string) *InputUpdate {
	s.NamePrefixUpdate = &v
	return s
}

// The user-provided application configuration is not valid.
type InvalidApplicationConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidApplicationConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidApplicationConfigurationException) GoString() string {
	return s.String()
}

func newErrorInvalidApplicationConfigurationException(v protocol.ResponseMetadata) error {
	return &InvalidApplicationConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidApplicationConfigurationException) Code() string {
	return "InvalidApplicationConfigurationException"
}

// Message returns the exception's message.
func (s *InvalidApplicationConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidApplicationConfigurationException) OrigErr() error {
	return nil
}

func (s *InvalidApplicationConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidApplicationConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidApplicationConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified input parameter value is not valid.
type InvalidArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s *InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArgumentException) OrigErr() error {
	return nil
}

func (s *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request JSON is not valid for the operation.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// For a SQL-based Kinesis Data Analytics application, provides additional mapping
// information when JSON is the record format on the streaming source.
type JSONMappingParameters struct {
	_ struct{} `type:"structure"`

	// The path to the top-level parent that contains the records.
	//
	// RecordRowPath is a required field
	RecordRowPath *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JSONMappingParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JSONMappingParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JSONMappingParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JSONMappingParameters"}
	if s.RecordRowPath == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordRowPath"))
	}
	if s.RecordRowPath != nil && len(*s.RecordRowPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordRowPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordRowPath sets the RecordRowPath field's value.
func (s *JSONMappingParameters) SetRecordRowPath(v string) *JSONMappingParameters {
	s.RecordRowPath = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, identifies a Kinesis
// Data Firehose delivery stream as the streaming source. You provide the delivery
// stream's Amazon Resource Name (ARN).
type KinesisFirehoseInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisFirehoseInput) SetResourceARN(v string) *KinesisFirehoseInput {
	s.ResourceARN = &v
	return s
}

// Describes the Amazon Kinesis Data Firehose delivery stream that is configured
// as the streaming source in the application input configuration.
type KinesisFirehoseInputDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics assumes to access the
	// stream.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseInputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseInputDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisFirehoseInputDescription) SetResourceARN(v string) *KinesisFirehoseInputDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisFirehoseInputDescription) SetRoleARN(v string) *KinesisFirehoseInputDescription {
	s.RoleARN = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, when updating application
// input configuration, provides information about a Kinesis Data Firehose delivery
// stream as the streaming source.
type KinesisFirehoseInputUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the input delivery stream to read.
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseInputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseInputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseInputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseInputUpdate"}
	if s.ResourceARNUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *KinesisFirehoseInputUpdate) SetResourceARNUpdate(v string) *KinesisFirehoseInputUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, when configuring application
// output, identifies a Kinesis Data Firehose delivery stream as the destination.
// You provide the stream Amazon Resource Name (ARN) of the delivery stream.
type KinesisFirehoseOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the destination delivery stream to write to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseOutput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseOutput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisFirehoseOutput) SetResourceARN(v string) *KinesisFirehoseOutput {
	s.ResourceARN = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application's output, describes the
// Kinesis Data Firehose delivery stream that is configured as its destination.
type KinesisFirehoseOutputDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics can assume to access
	// the stream.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseOutputDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisFirehoseOutputDescription) SetResourceARN(v string) *KinesisFirehoseOutputDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisFirehoseOutputDescription) SetRoleARN(v string) *KinesisFirehoseOutputDescription {
	s.RoleARN = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, when updating an output
// configuration using the UpdateApplication operation, provides information
// about a Kinesis Data Firehose delivery stream that is configured as the destination.
type KinesisFirehoseOutputUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the delivery stream to write to.
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisFirehoseOutputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseOutputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisFirehoseOutputUpdate"}
	if s.ResourceARNUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *KinesisFirehoseOutputUpdate) SetResourceARNUpdate(v string) *KinesisFirehoseOutputUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// Identifies a Kinesis data stream as the streaming source. You provide the
// stream's Amazon Resource Name (ARN).
type KinesisStreamsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the input Kinesis data stream to read.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamsInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisStreamsInput) SetResourceARN(v string) *KinesisStreamsInput {
	s.ResourceARN = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes the Kinesis
// data stream that is configured as the streaming source in the application
// input configuration.
type KinesisStreamsInputDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Kinesis data stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics can assume to access
	// the stream.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsInputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsInputDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisStreamsInputDescription) SetResourceARN(v string) *KinesisStreamsInputDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamsInputDescription) SetRoleARN(v string) *KinesisStreamsInputDescription {
	s.RoleARN = &v
	return s
}

// When you update the input configuration for a SQL-based Kinesis Data Analytics
// application, provides information about a Kinesis stream as the streaming
// source.
type KinesisStreamsInputUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the input Kinesis data stream to read.
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsInputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsInputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsInputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamsInputUpdate"}
	if s.ResourceARNUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *KinesisStreamsInputUpdate) SetResourceARNUpdate(v string) *KinesisStreamsInputUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// When you configure a SQL-based Kinesis Data Analytics application's output,
// identifies a Kinesis data stream as the destination. You provide the stream
// Amazon Resource Name (ARN).
type KinesisStreamsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the destination Kinesis data stream to write to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsOutput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamsOutput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisStreamsOutput) SetResourceARN(v string) *KinesisStreamsOutput {
	s.ResourceARN = &v
	return s
}

// For an SQL-based Kinesis Data Analytics application's output, describes the
// Kinesis data stream that is configured as its destination.
type KinesisStreamsOutputDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Kinesis data stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics can assume to access
	// the stream.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsOutputDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *KinesisStreamsOutputDescription) SetResourceARN(v string) *KinesisStreamsOutputDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamsOutputDescription) SetRoleARN(v string) *KinesisStreamsOutputDescription {
	s.RoleARN = &v
	return s
}

// When you update a SQL-based Kinesis Data Analytics application's output configuration
// using the UpdateApplication operation, provides information about a Kinesis
// data stream that is configured as the destination.
type KinesisStreamsOutputUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Kinesis data stream where you want
	// to write the output.
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamsOutputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsOutputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamsOutputUpdate"}
	if s.ResourceARNUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *KinesisStreamsOutputUpdate) SetResourceARNUpdate(v string) *KinesisStreamsOutputUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// When you configure a SQL-based Kinesis Data Analytics application's output,
// identifies an Amazon Lambda function as the destination. You provide the
// function Amazon Resource Name (ARN) of the Lambda function.
type LambdaOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination Lambda function to write
	// to.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: Amazon Lambda (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaOutput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaOutput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *LambdaOutput) SetResourceARN(v string) *LambdaOutput {
	s.ResourceARN = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application's output, describes the
// Amazon Lambda function that is configured as its destination.
type LambdaOutputDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination Lambda function.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics can assume to write to
	// the destination function.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaOutputDescription) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *LambdaOutputDescription) SetResourceARN(v string) *LambdaOutputDescription {
	s.ResourceARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *LambdaOutputDescription) SetRoleARN(v string) *LambdaOutputDescription {
	s.RoleARN = &v
	return s
}

// When you update an SQL-based Kinesis Data Analytics application's output
// configuration using the UpdateApplication operation, provides information
// about an Amazon Lambda function that is configured as the destination.
type LambdaOutputUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination Amazon Lambda function.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: Amazon Lambda (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaOutputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaOutputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaOutputUpdate"}
	if s.ResourceARNUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNUpdate sets the ResourceARNUpdate field's value.
func (s *LambdaOutputUpdate) SetResourceARNUpdate(v string) *LambdaOutputUpdate {
	s.ResourceARNUpdate = &v
	return s
}

// The number of allowed resources has been exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApplicationSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The maximum number of application snapshots to list.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationSnapshotsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ListApplicationSnapshotsInput) SetApplicationName(v string) *ListApplicationSnapshotsInput {
	s.ApplicationName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListApplicationSnapshotsInput) SetLimit(v int64) *ListApplicationSnapshotsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationSnapshotsInput) SetNextToken(v string) *ListApplicationSnapshotsInput {
	s.NextToken = &v
	return s
}

type ListApplicationSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `min:"1" type:"string"`

	// A collection of objects containing information about the application snapshots.
	SnapshotSummaries []*SnapshotDetails `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationSnapshotsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationSnapshotsOutput) SetNextToken(v string) *ListApplicationSnapshotsOutput {
	s.NextToken = &v
	return s
}

// SetSnapshotSummaries sets the SnapshotSummaries field's value.
func (s *ListApplicationSnapshotsOutput) SetSnapshotSummaries(v []*SnapshotDetails) *ListApplicationSnapshotsOutput {
	s.SnapshotSummaries = v
	return s
}

type ListApplicationVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the application for which you want to list all versions.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The maximum number of versions to list in this invocation of the operation.
	Limit *int64 `min:"1" type:"integer"`

	// If a previous invocation of this operation returned a pagination token, pass
	// it into this value to retrieve the next set of results. For more information
	// about pagination, see Using the Amazon Command Line Interface's Pagination
	// Options (https://docs.aws.amazon.com/cli/latest/userguide/pagination.html).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationVersionsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ListApplicationVersionsInput) SetApplicationName(v string) *ListApplicationVersionsInput {
	s.ApplicationName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListApplicationVersionsInput) SetLimit(v int64) *ListApplicationVersionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationVersionsInput) SetNextToken(v string) *ListApplicationVersionsInput {
	s.NextToken = &v
	return s
}

type ListApplicationVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the application versions and the associated configuration summaries.
	// The list includes application versions that were rolled back.
	//
	// To get the complete description of a specific application version, invoke
	// the DescribeApplicationVersion operation.
	ApplicationVersionSummaries []*ApplicationVersionSummary `type:"list"`

	// The pagination token for the next set of results, or null if there are no
	// additional results. To retrieve the next set of items, pass this token into
	// a subsequent invocation of this operation. For more information about pagination,
	// see Using the Amazon Command Line Interface's Pagination Options (https://docs.aws.amazon.com/cli/latest/userguide/pagination.html).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationVersionsOutput) GoString() string {
	return s.String()
}

// SetApplicationVersionSummaries sets the ApplicationVersionSummaries field's value.
func (s *ListApplicationVersionsOutput) SetApplicationVersionSummaries(v []*ApplicationVersionSummary) *ListApplicationVersionsOutput {
	s.ApplicationVersionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationVersionsOutput) SetNextToken(v string) *ListApplicationVersionsOutput {
	s.NextToken = &v
	return s
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of applications to list.
	Limit *int64 `min:"1" type:"integer"`

	// If a previous command returned a pagination token, pass it into this value
	// to retrieve the next set of results. For more information about pagination,
	// see Using the Amazon Command Line Interface's Pagination Options (https://docs.aws.amazon.com/cli/latest/userguide/pagination.html).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListApplicationsInput) SetLimit(v int64) *ListApplicationsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of ApplicationSummary objects.
	//
	// ApplicationSummaries is a required field
	ApplicationSummaries []*ApplicationSummary `type:"list" required:"true"`

	// The pagination token for the next set of results, or null if there are no
	// additional results. Pass this token into a subsequent command to retrieve
	// the next set of items For more information about pagination, see Using the
	// Amazon Command Line Interface's Pagination Options (https://docs.aws.amazon.com/cli/latest/userguide/pagination.html).
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplicationSummaries sets the ApplicationSummaries field's value.
func (s *ListApplicationsOutput) SetApplicationSummaries(v []*ApplicationSummary) *ListApplicationsOutput {
	s.ApplicationSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the application for which to retrieve tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The key-value tags assigned to the application.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// When you configure a SQL-based Kinesis Data Analytics application's input
// at the time of creating or updating an application, provides additional mapping
// information specific to the record format (such as JSON, CSV, or record fields
// delimited by some delimiter) on the streaming source.
type MappingParameters struct {
	_ struct{} `type:"structure"`

	// Provides additional mapping information when the record format uses delimiters
	// (for example, CSV).
	CSVMappingParameters *CSVMappingParameters `type:"structure"`

	// Provides additional mapping information when JSON is the record format on
	// the streaming source.
	JSONMappingParameters *JSONMappingParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MappingParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MappingParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MappingParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MappingParameters"}
	if s.CSVMappingParameters != nil {
		if err := s.CSVMappingParameters.Validate(); err != nil {
			invalidParams.AddNested("CSVMappingParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.JSONMappingParameters != nil {
		if err := s.JSONMappingParameters.Validate(); err != nil {
			invalidParams.AddNested("JSONMappingParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCSVMappingParameters sets the CSVMappingParameters field's value.
func (s *MappingParameters) SetCSVMappingParameters(v *CSVMappingParameters) *MappingParameters {
	s.CSVMappingParameters = v
	return s
}

// SetJSONMappingParameters sets the JSONMappingParameters field's value.
func (s *MappingParameters) SetJSONMappingParameters(v *JSONMappingParameters) *MappingParameters {
	s.JSONMappingParameters = v
	return s
}

// The information required to specify a Maven reference. You can use Maven
// references to specify dependency JAR files.
type MavenReference struct {
	_ struct{} `type:"structure"`

	// The artifact ID of the Maven reference.
	//
	// ArtifactId is a required field
	ArtifactId *string `min:"1" type:"string" required:"true"`

	// The group ID of the Maven reference.
	//
	// GroupId is a required field
	GroupId *string `min:"1" type:"string" required:"true"`

	// The version of the Maven reference.
	//
	// Version is a required field
	Version *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MavenReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MavenReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MavenReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MavenReference"}
	if s.ArtifactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ArtifactId"))
	}
	if s.ArtifactId != nil && len(*s.ArtifactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArtifactId", 1))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactId sets the ArtifactId field's value.
func (s *MavenReference) SetArtifactId(v string) *MavenReference {
	s.ArtifactId = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *MavenReference) SetGroupId(v string) *MavenReference {
	s.GroupId = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *MavenReference) SetVersion(v string) *MavenReference {
	s.Version = &v
	return s
}

// Describes configuration parameters for Amazon CloudWatch logging for an application.
// For more information about CloudWatch logging, see Monitoring (https://docs.aws.amazon.com/kinesisanalytics/latest/java/monitoring-overview.html).
type MonitoringConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes whether to use the default CloudWatch logging configuration for
	// an application. You must set this property to CUSTOM in order to set the
	// LogLevel or MetricsLevel parameters.
	//
	// ConfigurationType is a required field
	ConfigurationType *string `type:"string" required:"true" enum:"ConfigurationType"`

	// Describes the verbosity of the CloudWatch Logs for an application.
	LogLevel *string `type:"string" enum:"LogLevel"`

	// Describes the granularity of the CloudWatch Logs for an application. The
	// Parallelism level is not recommended for applications with a Parallelism
	// over 64 due to excessive costs.
	MetricsLevel *string `type:"string" enum:"MetricsLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoringConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoringConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MonitoringConfiguration"}
	if s.ConfigurationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigurationType sets the ConfigurationType field's value.
func (s *MonitoringConfiguration) SetConfigurationType(v string) *MonitoringConfiguration {
	s.ConfigurationType = &v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *MonitoringConfiguration) SetLogLevel(v string) *MonitoringConfiguration {
	s.LogLevel = &v
	return s
}

// SetMetricsLevel sets the MetricsLevel field's value.
func (s *MonitoringConfiguration) SetMetricsLevel(v string) *MonitoringConfiguration {
	s.MetricsLevel = &v
	return s
}

// Describes configuration parameters for CloudWatch logging for an application.
type MonitoringConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes whether to use the default CloudWatch logging configuration for
	// an application.
	ConfigurationType *string `type:"string" enum:"ConfigurationType"`

	// Describes the verbosity of the CloudWatch Logs for an application.
	LogLevel *string `type:"string" enum:"LogLevel"`

	// Describes the granularity of the CloudWatch Logs for an application.
	MetricsLevel *string `type:"string" enum:"MetricsLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoringConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoringConfigurationDescription) GoString() string {
	return s.String()
}

// SetConfigurationType sets the ConfigurationType field's value.
func (s *MonitoringConfigurationDescription) SetConfigurationType(v string) *MonitoringConfigurationDescription {
	s.ConfigurationType = &v
	return s
}

// SetLogLevel sets the LogLevel field's value.
func (s *MonitoringConfigurationDescription) SetLogLevel(v string) *MonitoringConfigurationDescription {
	s.LogLevel = &v
	return s
}

// SetMetricsLevel sets the MetricsLevel field's value.
func (s *MonitoringConfigurationDescription) SetMetricsLevel(v string) *MonitoringConfigurationDescription {
	s.MetricsLevel = &v
	return s
}

// Describes updates to configuration parameters for Amazon CloudWatch logging
// for an application.
type MonitoringConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to whether to use the default CloudWatch logging configuration
	// for an application. You must set this property to CUSTOM in order to set
	// the LogLevel or MetricsLevel parameters.
	ConfigurationTypeUpdate *string `type:"string" enum:"ConfigurationType"`

	// Describes updates to the verbosity of the CloudWatch Logs for an application.
	LogLevelUpdate *string `type:"string" enum:"LogLevel"`

	// Describes updates to the granularity of the CloudWatch Logs for an application.
	// The Parallelism level is not recommended for applications with a Parallelism
	// over 64 due to excessive costs.
	MetricsLevelUpdate *string `type:"string" enum:"MetricsLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoringConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitoringConfigurationUpdate) GoString() string {
	return s.String()
}

// SetConfigurationTypeUpdate sets the ConfigurationTypeUpdate field's value.
func (s *MonitoringConfigurationUpdate) SetConfigurationTypeUpdate(v string) *MonitoringConfigurationUpdate {
	s.ConfigurationTypeUpdate = &v
	return s
}

// SetLogLevelUpdate sets the LogLevelUpdate field's value.
func (s *MonitoringConfigurationUpdate) SetLogLevelUpdate(v string) *MonitoringConfigurationUpdate {
	s.LogLevelUpdate = &v
	return s
}

// SetMetricsLevelUpdate sets the MetricsLevelUpdate field's value.
func (s *MonitoringConfigurationUpdate) SetMetricsLevelUpdate(v string) *MonitoringConfigurationUpdate {
	s.MetricsLevelUpdate = &v
	return s
}

// Describes a SQL-based Kinesis Data Analytics application's output configuration,
// in which you identify an in-application stream and a destination where you
// want the in-application stream data to be written. The destination can be
// a Kinesis data stream or a Kinesis Data Firehose delivery stream.
type Output struct {
	_ struct{} `type:"structure"`

	// Describes the data format when records are written to the destination.
	//
	// DestinationSchema is a required field
	DestinationSchema *DestinationSchema `type:"structure" required:"true"`

	// Identifies a Kinesis Data Firehose delivery stream as the destination.
	KinesisFirehoseOutput *KinesisFirehoseOutput `type:"structure"`

	// Identifies a Kinesis data stream as the destination.
	KinesisStreamsOutput *KinesisStreamsOutput `type:"structure"`

	// Identifies an Amazon Lambda function as the destination.
	LambdaOutput *LambdaOutput `type:"structure"`

	// The name of the in-application stream.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Output) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Output"}
	if s.DestinationSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationSchema"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.DestinationSchema != nil {
		if err := s.DestinationSchema.Validate(); err != nil {
			invalidParams.AddNested("DestinationSchema", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseOutput != nil {
		if err := s.KinesisFirehoseOutput.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseOutput", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsOutput != nil {
		if err := s.KinesisStreamsOutput.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsOutput", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaOutput != nil {
		if err := s.LambdaOutput.Validate(); err != nil {
			invalidParams.AddNested("LambdaOutput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationSchema sets the DestinationSchema field's value.
func (s *Output) SetDestinationSchema(v *DestinationSchema) *Output {
	s.DestinationSchema = v
	return s
}

// SetKinesisFirehoseOutput sets the KinesisFirehoseOutput field's value.
func (s *Output) SetKinesisFirehoseOutput(v *KinesisFirehoseOutput) *Output {
	s.KinesisFirehoseOutput = v
	return s
}

// SetKinesisStreamsOutput sets the KinesisStreamsOutput field's value.
func (s *Output) SetKinesisStreamsOutput(v *KinesisStreamsOutput) *Output {
	s.KinesisStreamsOutput = v
	return s
}

// SetLambdaOutput sets the LambdaOutput field's value.
func (s *Output) SetLambdaOutput(v *LambdaOutput) *Output {
	s.LambdaOutput = v
	return s
}

// SetName sets the Name field's value.
func (s *Output) SetName(v string) *Output {
	s.Name = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes the application
// output configuration, which includes the in-application stream name and the
// destination where the stream data is written. The destination can be a Kinesis
// data stream or a Kinesis Data Firehose delivery stream.
type OutputDescription struct {
	_ struct{} `type:"structure"`

	// The data format used for writing data to the destination.
	DestinationSchema *DestinationSchema `type:"structure"`

	// Describes the Kinesis Data Firehose delivery stream that is configured as
	// the destination where output is written.
	KinesisFirehoseOutputDescription *KinesisFirehoseOutputDescription `type:"structure"`

	// Describes the Kinesis data stream that is configured as the destination where
	// output is written.
	KinesisStreamsOutputDescription *KinesisStreamsOutputDescription `type:"structure"`

	// Describes the Lambda function that is configured as the destination where
	// output is written.
	LambdaOutputDescription *LambdaOutputDescription `type:"structure"`

	// The name of the in-application stream that is configured as output.
	Name *string `min:"1" type:"string"`

	// A unique identifier for the output configuration.
	OutputId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDescription) GoString() string {
	return s.String()
}

// SetDestinationSchema sets the DestinationSchema field's value.
func (s *OutputDescription) SetDestinationSchema(v *DestinationSchema) *OutputDescription {
	s.DestinationSchema = v
	return s
}

// SetKinesisFirehoseOutputDescription sets the KinesisFirehoseOutputDescription field's value.
func (s *OutputDescription) SetKinesisFirehoseOutputDescription(v *KinesisFirehoseOutputDescription) *OutputDescription {
	s.KinesisFirehoseOutputDescription = v
	return s
}

// SetKinesisStreamsOutputDescription sets the KinesisStreamsOutputDescription field's value.
func (s *OutputDescription) SetKinesisStreamsOutputDescription(v *KinesisStreamsOutputDescription) *OutputDescription {
	s.KinesisStreamsOutputDescription = v
	return s
}

// SetLambdaOutputDescription sets the LambdaOutputDescription field's value.
func (s *OutputDescription) SetLambdaOutputDescription(v *LambdaOutputDescription) *OutputDescription {
	s.LambdaOutputDescription = v
	return s
}

// SetName sets the Name field's value.
func (s *OutputDescription) SetName(v string) *OutputDescription {
	s.Name = &v
	return s
}

// SetOutputId sets the OutputId field's value.
func (s *OutputDescription) SetOutputId(v string) *OutputDescription {
	s.OutputId = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes updates to
// the output configuration identified by the OutputId.
type OutputUpdate struct {
	_ struct{} `type:"structure"`

	// Describes the data format when records are written to the destination.
	DestinationSchemaUpdate *DestinationSchema `type:"structure"`

	// Describes a Kinesis Data Firehose delivery stream as the destination for
	// the output.
	KinesisFirehoseOutputUpdate *KinesisFirehoseOutputUpdate `type:"structure"`

	// Describes a Kinesis data stream as the destination for the output.
	KinesisStreamsOutputUpdate *KinesisStreamsOutputUpdate `type:"structure"`

	// Describes an Amazon Lambda function as the destination for the output.
	LambdaOutputUpdate *LambdaOutputUpdate `type:"structure"`

	// If you want to specify a different in-application stream for this output
	// configuration, use this field to specify the new in-application stream name.
	NameUpdate *string `min:"1" type:"string"`

	// Identifies the specific output configuration that you want to update.
	//
	// OutputId is a required field
	OutputId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputUpdate"}
	if s.NameUpdate != nil && len(*s.NameUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameUpdate", 1))
	}
	if s.OutputId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputId"))
	}
	if s.OutputId != nil && len(*s.OutputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputId", 1))
	}
	if s.DestinationSchemaUpdate != nil {
		if err := s.DestinationSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("DestinationSchemaUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseOutputUpdate != nil {
		if err := s.KinesisFirehoseOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseOutputUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsOutputUpdate != nil {
		if err := s.KinesisStreamsOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsOutputUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaOutputUpdate != nil {
		if err := s.LambdaOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("LambdaOutputUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationSchemaUpdate sets the DestinationSchemaUpdate field's value.
func (s *OutputUpdate) SetDestinationSchemaUpdate(v *DestinationSchema) *OutputUpdate {
	s.DestinationSchemaUpdate = v
	return s
}

// SetKinesisFirehoseOutputUpdate sets the KinesisFirehoseOutputUpdate field's value.
func (s *OutputUpdate) SetKinesisFirehoseOutputUpdate(v *KinesisFirehoseOutputUpdate) *OutputUpdate {
	s.KinesisFirehoseOutputUpdate = v
	return s
}

// SetKinesisStreamsOutputUpdate sets the KinesisStreamsOutputUpdate field's value.
func (s *OutputUpdate) SetKinesisStreamsOutputUpdate(v *KinesisStreamsOutputUpdate) *OutputUpdate {
	s.KinesisStreamsOutputUpdate = v
	return s
}

// SetLambdaOutputUpdate sets the LambdaOutputUpdate field's value.
func (s *OutputUpdate) SetLambdaOutputUpdate(v *LambdaOutputUpdate) *OutputUpdate {
	s.LambdaOutputUpdate = v
	return s
}

// SetNameUpdate sets the NameUpdate field's value.
func (s *OutputUpdate) SetNameUpdate(v string) *OutputUpdate {
	s.NameUpdate = &v
	return s
}

// SetOutputId sets the OutputId field's value.
func (s *OutputUpdate) SetOutputId(v string) *OutputUpdate {
	s.OutputId = &v
	return s
}

// Describes parameters for how a Flink-based Kinesis Data Analytics application
// executes multiple tasks simultaneously. For more information about parallelism,
// see Parallel Execution (https://ci.apache.org/projects/flink/flink-docs-release-1.8/dev/parallel.html)
// in the Apache Flink Documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.8/).
type ParallelismConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes whether the Kinesis Data Analytics service can increase the parallelism
	// of the application in response to increased throughput.
	AutoScalingEnabled *bool `type:"boolean"`

	// Describes whether the application uses the default parallelism for the Kinesis
	// Data Analytics service. You must set this property to CUSTOM in order to
	// change your application's AutoScalingEnabled, Parallelism, or ParallelismPerKPU
	// properties.
	//
	// ConfigurationType is a required field
	ConfigurationType *string `type:"string" required:"true" enum:"ConfigurationType"`

	// Describes the initial number of parallel tasks that a Flink-based Kinesis
	// Data Analytics application can perform. If AutoScalingEnabled is set to True,
	// Kinesis Data Analytics increases the CurrentParallelism value in response
	// to application load. The service can increase the CurrentParallelism value
	// up to the maximum parallelism, which is ParalellismPerKPU times the maximum
	// KPUs for the application. The maximum KPUs for an application is 32 by default,
	// and can be increased by requesting a limit increase. If application load
	// is reduced, the service can reduce the CurrentParallelism value down to the
	// Parallelism setting.
	Parallelism *int64 `min:"1" type:"integer"`

	// Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics
	// application can perform per Kinesis Processing Unit (KPU) used by the application.
	// For more information about KPUs, see Amazon Kinesis Data Analytics Pricing
	// (http://aws.amazon.com/kinesis/data-analytics/pricing/).
	ParallelismPerKPU *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelismConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelismConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParallelismConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParallelismConfiguration"}
	if s.ConfigurationType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigurationType"))
	}
	if s.Parallelism != nil && *s.Parallelism < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Parallelism", 1))
	}
	if s.ParallelismPerKPU != nil && *s.ParallelismPerKPU < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParallelismPerKPU", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingEnabled sets the AutoScalingEnabled field's value.
func (s *ParallelismConfiguration) SetAutoScalingEnabled(v bool) *ParallelismConfiguration {
	s.AutoScalingEnabled = &v
	return s
}

// SetConfigurationType sets the ConfigurationType field's value.
func (s *ParallelismConfiguration) SetConfigurationType(v string) *ParallelismConfiguration {
	s.ConfigurationType = &v
	return s
}

// SetParallelism sets the Parallelism field's value.
func (s *ParallelismConfiguration) SetParallelism(v int64) *ParallelismConfiguration {
	s.Parallelism = &v
	return s
}

// SetParallelismPerKPU sets the ParallelismPerKPU field's value.
func (s *ParallelismConfiguration) SetParallelismPerKPU(v int64) *ParallelismConfiguration {
	s.ParallelismPerKPU = &v
	return s
}

// Describes parameters for how a Flink-based Kinesis Data Analytics application
// executes multiple tasks simultaneously.
type ParallelismConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes whether the Kinesis Data Analytics service can increase the parallelism
	// of the application in response to increased throughput.
	AutoScalingEnabled *bool `type:"boolean"`

	// Describes whether the application uses the default parallelism for the Kinesis
	// Data Analytics service.
	ConfigurationType *string `type:"string" enum:"ConfigurationType"`

	// Describes the current number of parallel tasks that a Flink-based Kinesis
	// Data Analytics application can perform. If AutoScalingEnabled is set to True,
	// Kinesis Data Analytics can increase this value in response to application
	// load. The service can increase this value up to the maximum parallelism,
	// which is ParalellismPerKPU times the maximum KPUs for the application. The
	// maximum KPUs for an application is 32 by default, and can be increased by
	// requesting a limit increase. If application load is reduced, the service
	// can reduce the CurrentParallelism value down to the Parallelism setting.
	CurrentParallelism *int64 `min:"1" type:"integer"`

	// Describes the initial number of parallel tasks that a Flink-based Kinesis
	// Data Analytics application can perform. If AutoScalingEnabled is set to True,
	// then Kinesis Data Analytics can increase the CurrentParallelism value in
	// response to application load. The service can increase CurrentParallelism
	// up to the maximum parallelism, which is ParalellismPerKPU times the maximum
	// KPUs for the application. The maximum KPUs for an application is 32 by default,
	// and can be increased by requesting a limit increase. If application load
	// is reduced, the service can reduce the CurrentParallelism value down to the
	// Parallelism setting.
	Parallelism *int64 `min:"1" type:"integer"`

	// Describes the number of parallel tasks that a Flink-based Kinesis Data Analytics
	// application can perform per Kinesis Processing Unit (KPU) used by the application.
	ParallelismPerKPU *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelismConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelismConfigurationDescription) GoString() string {
	return s.String()
}

// SetAutoScalingEnabled sets the AutoScalingEnabled field's value.
func (s *ParallelismConfigurationDescription) SetAutoScalingEnabled(v bool) *ParallelismConfigurationDescription {
	s.AutoScalingEnabled = &v
	return s
}

// SetConfigurationType sets the ConfigurationType field's value.
func (s *ParallelismConfigurationDescription) SetConfigurationType(v string) *ParallelismConfigurationDescription {
	s.ConfigurationType = &v
	return s
}

// SetCurrentParallelism sets the CurrentParallelism field's value.
func (s *ParallelismConfigurationDescription) SetCurrentParallelism(v int64) *ParallelismConfigurationDescription {
	s.CurrentParallelism = &v
	return s
}

// SetParallelism sets the Parallelism field's value.
func (s *ParallelismConfigurationDescription) SetParallelism(v int64) *ParallelismConfigurationDescription {
	s.Parallelism = &v
	return s
}

// SetParallelismPerKPU sets the ParallelismPerKPU field's value.
func (s *ParallelismConfigurationDescription) SetParallelismPerKPU(v int64) *ParallelismConfigurationDescription {
	s.ParallelismPerKPU = &v
	return s
}

// Describes updates to parameters for how an application executes multiple
// tasks simultaneously.
type ParallelismConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to whether the Kinesis Data Analytics service can increase
	// the parallelism of a Flink-based Kinesis Data Analytics application in response
	// to increased throughput.
	AutoScalingEnabledUpdate *bool `type:"boolean"`

	// Describes updates to whether the application uses the default parallelism
	// for the Kinesis Data Analytics service, or if a custom parallelism is used.
	// You must set this property to CUSTOM in order to change your application's
	// AutoScalingEnabled, Parallelism, or ParallelismPerKPU properties.
	ConfigurationTypeUpdate *string `type:"string" enum:"ConfigurationType"`

	// Describes updates to the number of parallel tasks an application can perform
	// per Kinesis Processing Unit (KPU) used by the application.
	ParallelismPerKPUUpdate *int64 `min:"1" type:"integer"`

	// Describes updates to the initial number of parallel tasks an application
	// can perform. If AutoScalingEnabled is set to True, then Kinesis Data Analytics
	// can increase the CurrentParallelism value in response to application load.
	// The service can increase CurrentParallelism up to the maximum parallelism,
	// which is ParalellismPerKPU times the maximum KPUs for the application. The
	// maximum KPUs for an application is 32 by default, and can be increased by
	// requesting a limit increase. If application load is reduced, the service
	// will reduce CurrentParallelism down to the Parallelism setting.
	ParallelismUpdate *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelismConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParallelismConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParallelismConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParallelismConfigurationUpdate"}
	if s.ParallelismPerKPUUpdate != nil && *s.ParallelismPerKPUUpdate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParallelismPerKPUUpdate", 1))
	}
	if s.ParallelismUpdate != nil && *s.ParallelismUpdate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParallelismUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingEnabledUpdate sets the AutoScalingEnabledUpdate field's value.
func (s *ParallelismConfigurationUpdate) SetAutoScalingEnabledUpdate(v bool) *ParallelismConfigurationUpdate {
	s.AutoScalingEnabledUpdate = &v
	return s
}

// SetConfigurationTypeUpdate sets the ConfigurationTypeUpdate field's value.
func (s *ParallelismConfigurationUpdate) SetConfigurationTypeUpdate(v string) *ParallelismConfigurationUpdate {
	s.ConfigurationTypeUpdate = &v
	return s
}

// SetParallelismPerKPUUpdate sets the ParallelismPerKPUUpdate field's value.
func (s *ParallelismConfigurationUpdate) SetParallelismPerKPUUpdate(v int64) *ParallelismConfigurationUpdate {
	s.ParallelismPerKPUUpdate = &v
	return s
}

// SetParallelismUpdate sets the ParallelismUpdate field's value.
func (s *ParallelismConfigurationUpdate) SetParallelismUpdate(v int64) *ParallelismConfigurationUpdate {
	s.ParallelismUpdate = &v
	return s
}

// Property key-value pairs passed into an application.
type PropertyGroup struct {
	_ struct{} `type:"structure"`

	// Describes the key of an application execution property key-value pair.
	//
	// PropertyGroupId is a required field
	PropertyGroupId *string `min:"1" type:"string" required:"true"`

	// Describes the value of an application execution property key-value pair.
	//
	// PropertyMap is a required field
	PropertyMap map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PropertyGroup) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyGroup) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PropertyGroup"}
	if s.PropertyGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyGroupId"))
	}
	if s.PropertyGroupId != nil && len(*s.PropertyGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyGroupId", 1))
	}
	if s.PropertyMap == nil {
		invalidParams.Add(request.NewErrParamRequired("PropertyMap"))
	}
	if s.PropertyMap != nil && len(s.PropertyMap) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PropertyMap", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPropertyGroupId sets the PropertyGroupId field's value.
func (s *PropertyGroup) SetPropertyGroupId(v string) *PropertyGroup {
	s.PropertyGroupId = &v
	return s
}

// SetPropertyMap sets the PropertyMap field's value.
func (s *PropertyGroup) SetPropertyMap(v map[string]*string) *PropertyGroup {
	s.PropertyMap = v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes the mapping
// of each data element in the streaming source to the corresponding column
// in the in-application stream.
//
// Also used to describe the format of the reference data source.
type RecordColumn struct {
	_ struct{} `type:"structure"`

	// A reference to the data element in the streaming input or the reference data
	// source.
	Mapping *string `type:"string"`

	// The name of the column that is created in the in-application input stream
	// or reference table.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The type of column created in the in-application input stream or reference
	// table.
	//
	// SqlType is a required field
	SqlType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordColumn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordColumn) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordColumn) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordColumn"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SqlType == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlType"))
	}
	if s.SqlType != nil && len(*s.SqlType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SqlType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMapping sets the Mapping field's value.
func (s *RecordColumn) SetMapping(v string) *RecordColumn {
	s.Mapping = &v
	return s
}

// SetName sets the Name field's value.
func (s *RecordColumn) SetName(v string) *RecordColumn {
	s.Name = &v
	return s
}

// SetSqlType sets the SqlType field's value.
func (s *RecordColumn) SetSqlType(v string) *RecordColumn {
	s.SqlType = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes the record
// format and relevant mapping information that should be applied to schematize
// the records on the stream.
type RecordFormat struct {
	_ struct{} `type:"structure"`

	// When you configure application input at the time of creating or updating
	// an application, provides additional mapping information specific to the record
	// format (such as JSON, CSV, or record fields delimited by some delimiter)
	// on the streaming source.
	MappingParameters *MappingParameters `type:"structure"`

	// The type of record format.
	//
	// RecordFormatType is a required field
	RecordFormatType *string `type:"string" required:"true" enum:"RecordFormatType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordFormat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecordFormat) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordFormat) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordFormat"}
	if s.RecordFormatType == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordFormatType"))
	}
	if s.MappingParameters != nil {
		if err := s.MappingParameters.Validate(); err != nil {
			invalidParams.AddNested("MappingParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMappingParameters sets the MappingParameters field's value.
func (s *RecordFormat) SetMappingParameters(v *MappingParameters) *RecordFormat {
	s.MappingParameters = v
	return s
}

// SetRecordFormatType sets the RecordFormatType field's value.
func (s *RecordFormat) SetRecordFormatType(v string) *RecordFormat {
	s.RecordFormatType = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes the reference
// data source by providing the source information (Amazon S3 bucket name and
// object key name), the resulting in-application table name that is created,
// and the necessary schema to map the data elements in the Amazon S3 object
// to the in-application table.
type ReferenceDataSource struct {
	_ struct{} `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	//
	// ReferenceSchema is a required field
	ReferenceSchema *SourceSchema `type:"structure" required:"true"`

	// Identifies the S3 bucket and object that contains the reference data. A Kinesis
	// Data Analytics application loads reference data only once. If the data changes,
	// you call the UpdateApplication operation to trigger reloading of data into
	// your application.
	S3ReferenceDataSource *S3ReferenceDataSource `type:"structure"`

	// The name of the in-application table to create.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReferenceDataSource"}
	if s.ReferenceSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceSchema"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.ReferenceSchema != nil {
		if err := s.ReferenceSchema.Validate(); err != nil {
			invalidParams.AddNested("ReferenceSchema", err.(request.ErrInvalidParams))
		}
	}
	if s.S3ReferenceDataSource != nil {
		if err := s.S3ReferenceDataSource.Validate(); err != nil {
			invalidParams.AddNested("S3ReferenceDataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReferenceSchema sets the ReferenceSchema field's value.
func (s *ReferenceDataSource) SetReferenceSchema(v *SourceSchema) *ReferenceDataSource {
	s.ReferenceSchema = v
	return s
}

// SetS3ReferenceDataSource sets the S3ReferenceDataSource field's value.
func (s *ReferenceDataSource) SetS3ReferenceDataSource(v *S3ReferenceDataSource) *ReferenceDataSource {
	s.S3ReferenceDataSource = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ReferenceDataSource) SetTableName(v string) *ReferenceDataSource {
	s.TableName = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes the reference
// data source configured for an application.
type ReferenceDataSourceDescription struct {
	_ struct{} `type:"structure"`

	// The ID of the reference data source. This is the ID that Kinesis Data Analytics
	// assigns when you add the reference data source to your application using
	// the CreateApplication or UpdateApplication operation.
	//
	// ReferenceId is a required field
	ReferenceId *string `min:"1" type:"string" required:"true"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	ReferenceSchema *SourceSchema `type:"structure"`

	// Provides the Amazon S3 bucket name, the object key name that contains the
	// reference data.
	//
	// S3ReferenceDataSourceDescription is a required field
	S3ReferenceDataSourceDescription *S3ReferenceDataSourceDescription `type:"structure" required:"true"`

	// The in-application table name created by the specific reference data source
	// configuration.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceDataSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceDataSourceDescription) GoString() string {
	return s.String()
}

// SetReferenceId sets the ReferenceId field's value.
func (s *ReferenceDataSourceDescription) SetReferenceId(v string) *ReferenceDataSourceDescription {
	s.ReferenceId = &v
	return s
}

// SetReferenceSchema sets the ReferenceSchema field's value.
func (s *ReferenceDataSourceDescription) SetReferenceSchema(v *SourceSchema) *ReferenceDataSourceDescription {
	s.ReferenceSchema = v
	return s
}

// SetS3ReferenceDataSourceDescription sets the S3ReferenceDataSourceDescription field's value.
func (s *ReferenceDataSourceDescription) SetS3ReferenceDataSourceDescription(v *S3ReferenceDataSourceDescription) *ReferenceDataSourceDescription {
	s.S3ReferenceDataSourceDescription = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ReferenceDataSourceDescription) SetTableName(v string) *ReferenceDataSourceDescription {
	s.TableName = &v
	return s
}

// When you update a reference data source configuration for a SQL-based Kinesis
// Data Analytics application, this object provides all the updated values (such
// as the source bucket name and object key name), the in-application table
// name that is created, and updated mapping information that maps the data
// in the Amazon S3 object to the in-application reference table that is created.
type ReferenceDataSourceUpdate struct {
	_ struct{} `type:"structure"`

	// The ID of the reference data source that is being updated. You can use the
	// DescribeApplication operation to get this value.
	//
	// ReferenceId is a required field
	ReferenceId *string `min:"1" type:"string" required:"true"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	ReferenceSchemaUpdate *SourceSchema `type:"structure"`

	// Describes the S3 bucket name, object key name, and IAM role that Kinesis
	// Data Analytics can assume to read the Amazon S3 object on your behalf and
	// populate the in-application reference table.
	S3ReferenceDataSourceUpdate *S3ReferenceDataSourceUpdate `type:"structure"`

	// The in-application table name that is created by this update.
	TableNameUpdate *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceDataSourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReferenceDataSourceUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceDataSourceUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReferenceDataSourceUpdate"}
	if s.ReferenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReferenceId"))
	}
	if s.ReferenceId != nil && len(*s.ReferenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReferenceId", 1))
	}
	if s.TableNameUpdate != nil && len(*s.TableNameUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableNameUpdate", 1))
	}
	if s.ReferenceSchemaUpdate != nil {
		if err := s.ReferenceSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("ReferenceSchemaUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.S3ReferenceDataSourceUpdate != nil {
		if err := s.S3ReferenceDataSourceUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3ReferenceDataSourceUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReferenceId sets the ReferenceId field's value.
func (s *ReferenceDataSourceUpdate) SetReferenceId(v string) *ReferenceDataSourceUpdate {
	s.ReferenceId = &v
	return s
}

// SetReferenceSchemaUpdate sets the ReferenceSchemaUpdate field's value.
func (s *ReferenceDataSourceUpdate) SetReferenceSchemaUpdate(v *SourceSchema) *ReferenceDataSourceUpdate {
	s.ReferenceSchemaUpdate = v
	return s
}

// SetS3ReferenceDataSourceUpdate sets the S3ReferenceDataSourceUpdate field's value.
func (s *ReferenceDataSourceUpdate) SetS3ReferenceDataSourceUpdate(v *S3ReferenceDataSourceUpdate) *ReferenceDataSourceUpdate {
	s.S3ReferenceDataSourceUpdate = v
	return s
}

// SetTableNameUpdate sets the TableNameUpdate field's value.
func (s *ReferenceDataSourceUpdate) SetTableNameUpdate(v string) *ReferenceDataSourceUpdate {
	s.TableNameUpdate = &v
	return s
}

// The application is not available for this operation.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specified application can't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Discovery failed to get a record from the streaming source because of the
// Kinesis Streams ProvisionedThroughputExceededException. For more information,
// see GetRecords (http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetRecords.html)
// in the Amazon Kinesis Streams API Reference.
type ResourceProvisionedThroughputExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceProvisionedThroughputExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceProvisionedThroughputExceededException) GoString() string {
	return s.String()
}

func newErrorResourceProvisionedThroughputExceededException(v protocol.ResponseMetadata) error {
	return &ResourceProvisionedThroughputExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceProvisionedThroughputExceededException) Code() string {
	return "ResourceProvisionedThroughputExceededException"
}

// Message returns the exception's message.
func (s *ResourceProvisionedThroughputExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceProvisionedThroughputExceededException) OrigErr() error {
	return nil
}

func (s *ResourceProvisionedThroughputExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceProvisionedThroughputExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceProvisionedThroughputExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RollbackApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The current application version ID. You can retrieve the application version
	// ID using DescribeApplication.
	//
	// CurrentApplicationVersionId is a required field
	CurrentApplicationVersionId *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RollbackApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RollbackApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.CurrentApplicationVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentApplicationVersionId"))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *RollbackApplicationInput) SetApplicationName(v string) *RollbackApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *RollbackApplicationInput) SetCurrentApplicationVersionId(v int64) *RollbackApplicationInput {
	s.CurrentApplicationVersionId = &v
	return s
}

type RollbackApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Describes the application, including the application Amazon Resource Name
	// (ARN), status, latest version, and input and output configurations.
	//
	// ApplicationDetail is a required field
	ApplicationDetail *ApplicationDetail `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RollbackApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationDetail sets the ApplicationDetail field's value.
func (s *RollbackApplicationOutput) SetApplicationDetail(v *ApplicationDetail) *RollbackApplicationOutput {
	s.ApplicationDetail = v
	return s
}

// Describes the starting parameters for an Kinesis Data Analytics application.
type RunConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes the restore behavior of a restarting application.
	ApplicationRestoreConfiguration *ApplicationRestoreConfiguration `type:"structure"`

	// Describes the starting parameters for a Flink-based Kinesis Data Analytics
	// application.
	FlinkRunConfiguration *FlinkRunConfiguration `type:"structure"`

	// Describes the starting parameters for a SQL-based Kinesis Data Analytics
	// application application.
	SqlRunConfigurations []*SqlRunConfiguration `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunConfiguration"}
	if s.ApplicationRestoreConfiguration != nil {
		if err := s.ApplicationRestoreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ApplicationRestoreConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SqlRunConfigurations != nil {
		for i, v := range s.SqlRunConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SqlRunConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationRestoreConfiguration sets the ApplicationRestoreConfiguration field's value.
func (s *RunConfiguration) SetApplicationRestoreConfiguration(v *ApplicationRestoreConfiguration) *RunConfiguration {
	s.ApplicationRestoreConfiguration = v
	return s
}

// SetFlinkRunConfiguration sets the FlinkRunConfiguration field's value.
func (s *RunConfiguration) SetFlinkRunConfiguration(v *FlinkRunConfiguration) *RunConfiguration {
	s.FlinkRunConfiguration = v
	return s
}

// SetSqlRunConfigurations sets the SqlRunConfigurations field's value.
func (s *RunConfiguration) SetSqlRunConfigurations(v []*SqlRunConfiguration) *RunConfiguration {
	s.SqlRunConfigurations = v
	return s
}

// Describes the starting properties for a Kinesis Data Analytics application.
type RunConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes the restore behavior of a restarting application.
	ApplicationRestoreConfigurationDescription *ApplicationRestoreConfiguration `type:"structure"`

	// Describes the starting parameters for a Flink-based Kinesis Data Analytics
	// application.
	FlinkRunConfigurationDescription *FlinkRunConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunConfigurationDescription) GoString() string {
	return s.String()
}

// SetApplicationRestoreConfigurationDescription sets the ApplicationRestoreConfigurationDescription field's value.
func (s *RunConfigurationDescription) SetApplicationRestoreConfigurationDescription(v *ApplicationRestoreConfiguration) *RunConfigurationDescription {
	s.ApplicationRestoreConfigurationDescription = v
	return s
}

// SetFlinkRunConfigurationDescription sets the FlinkRunConfigurationDescription field's value.
func (s *RunConfigurationDescription) SetFlinkRunConfigurationDescription(v *FlinkRunConfiguration) *RunConfigurationDescription {
	s.FlinkRunConfigurationDescription = v
	return s
}

// Describes the updates to the starting parameters for a Kinesis Data Analytics
// application.
type RunConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to the restore behavior of a restarting application.
	ApplicationRestoreConfiguration *ApplicationRestoreConfiguration `type:"structure"`

	// Describes the starting parameters for a Flink-based Kinesis Data Analytics
	// application.
	FlinkRunConfiguration *FlinkRunConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RunConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunConfigurationUpdate"}
	if s.ApplicationRestoreConfiguration != nil {
		if err := s.ApplicationRestoreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ApplicationRestoreConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationRestoreConfiguration sets the ApplicationRestoreConfiguration field's value.
func (s *RunConfigurationUpdate) SetApplicationRestoreConfiguration(v *ApplicationRestoreConfiguration) *RunConfigurationUpdate {
	s.ApplicationRestoreConfiguration = v
	return s
}

// SetFlinkRunConfiguration sets the FlinkRunConfiguration field's value.
func (s *RunConfigurationUpdate) SetFlinkRunConfiguration(v *FlinkRunConfiguration) *RunConfigurationUpdate {
	s.FlinkRunConfiguration = v
	return s
}

// Describes the location of an application's code stored in an S3 bucket.
type S3ApplicationCodeLocationDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the S3 bucket containing the application
	// code.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The file key for the object containing the application code.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// The version of the object containing the application code.
	ObjectVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ApplicationCodeLocationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ApplicationCodeLocationDescription) GoString() string {
	return s.String()
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3ApplicationCodeLocationDescription) SetBucketARN(v string) *S3ApplicationCodeLocationDescription {
	s.BucketARN = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *S3ApplicationCodeLocationDescription) SetFileKey(v string) *S3ApplicationCodeLocationDescription {
	s.FileKey = &v
	return s
}

// SetObjectVersion sets the ObjectVersion field's value.
func (s *S3ApplicationCodeLocationDescription) SetObjectVersion(v string) *S3ApplicationCodeLocationDescription {
	s.ObjectVersion = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, provides a description
// of an Amazon S3 data source, including the Amazon Resource Name (ARN) of
// the S3 bucket and the name of the Amazon S3 object that contains the data.
type S3Configuration struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket that contains the data.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The name of the object that contains the data.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Configuration"}
	if s.BucketARN == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.FileKey == nil {
		invalidParams.Add(request.NewErrParamRequired("FileKey"))
	}
	if s.FileKey != nil && len(*s.FileKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3Configuration) SetBucketARN(v string) *S3Configuration {
	s.BucketARN = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *S3Configuration) SetFileKey(v string) *S3Configuration {
	s.FileKey = &v
	return s
}

// The S3 bucket that holds the application information.
type S3ContentBaseLocation struct {
	_ struct{} `type:"structure"`

	// The base path for the S3 bucket.
	BasePath *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ContentBaseLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ContentBaseLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ContentBaseLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ContentBaseLocation"}
	if s.BasePath != nil && len(*s.BasePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BasePath", 1))
	}
	if s.BucketARN == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasePath sets the BasePath field's value.
func (s *S3ContentBaseLocation) SetBasePath(v string) *S3ContentBaseLocation {
	s.BasePath = &v
	return s
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3ContentBaseLocation) SetBucketARN(v string) *S3ContentBaseLocation {
	s.BucketARN = &v
	return s
}

// The description of the S3 base location that holds the application.
type S3ContentBaseLocationDescription struct {
	_ struct{} `type:"structure"`

	// The base path for the S3 bucket.
	BasePath *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ContentBaseLocationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ContentBaseLocationDescription) GoString() string {
	return s.String()
}

// SetBasePath sets the BasePath field's value.
func (s *S3ContentBaseLocationDescription) SetBasePath(v string) *S3ContentBaseLocationDescription {
	s.BasePath = &v
	return s
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3ContentBaseLocationDescription) SetBucketARN(v string) *S3ContentBaseLocationDescription {
	s.BucketARN = &v
	return s
}

// The information required to update the S3 base location that holds the application.
type S3ContentBaseLocationUpdate struct {
	_ struct{} `type:"structure"`

	// The updated S3 bucket path.
	BasePathUpdate *string `min:"1" type:"string"`

	// The updated Amazon Resource Name (ARN) of the S3 bucket.
	BucketARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ContentBaseLocationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ContentBaseLocationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ContentBaseLocationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ContentBaseLocationUpdate"}
	if s.BasePathUpdate != nil && len(*s.BasePathUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BasePathUpdate", 1))
	}
	if s.BucketARNUpdate != nil && len(*s.BucketARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasePathUpdate sets the BasePathUpdate field's value.
func (s *S3ContentBaseLocationUpdate) SetBasePathUpdate(v string) *S3ContentBaseLocationUpdate {
	s.BasePathUpdate = &v
	return s
}

// SetBucketARNUpdate sets the BucketARNUpdate field's value.
func (s *S3ContentBaseLocationUpdate) SetBucketARNUpdate(v string) *S3ContentBaseLocationUpdate {
	s.BucketARNUpdate = &v
	return s
}

// For a Kinesis Data Analytics application provides a description of an Amazon
// S3 object, including the Amazon Resource Name (ARN) of the S3 bucket, the
// name of the Amazon S3 object that contains the data, and the version number
// of the Amazon S3 object that contains the data.
type S3ContentLocation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the S3 bucket containing the application
	// code.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The file key for the object containing the application code.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// The version of the object containing the application code.
	ObjectVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ContentLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ContentLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ContentLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ContentLocation"}
	if s.BucketARN == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.FileKey == nil {
		invalidParams.Add(request.NewErrParamRequired("FileKey"))
	}
	if s.FileKey != nil && len(*s.FileKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3ContentLocation) SetBucketARN(v string) *S3ContentLocation {
	s.BucketARN = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *S3ContentLocation) SetFileKey(v string) *S3ContentLocation {
	s.FileKey = &v
	return s
}

// SetObjectVersion sets the ObjectVersion field's value.
func (s *S3ContentLocation) SetObjectVersion(v string) *S3ContentLocation {
	s.ObjectVersion = &v
	return s
}

// Describes an update for the Amazon S3 code content location for an application.
type S3ContentLocationUpdate struct {
	_ struct{} `type:"structure"`

	// The new Amazon Resource Name (ARN) for the S3 bucket containing the application
	// code.
	BucketARNUpdate *string `min:"1" type:"string"`

	// The new file key for the object containing the application code.
	FileKeyUpdate *string `min:"1" type:"string"`

	// The new version of the object containing the application code.
	ObjectVersionUpdate *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ContentLocationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ContentLocationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ContentLocationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ContentLocationUpdate"}
	if s.BucketARNUpdate != nil && len(*s.BucketARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARNUpdate", 1))
	}
	if s.FileKeyUpdate != nil && len(*s.FileKeyUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileKeyUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARNUpdate sets the BucketARNUpdate field's value.
func (s *S3ContentLocationUpdate) SetBucketARNUpdate(v string) *S3ContentLocationUpdate {
	s.BucketARNUpdate = &v
	return s
}

// SetFileKeyUpdate sets the FileKeyUpdate field's value.
func (s *S3ContentLocationUpdate) SetFileKeyUpdate(v string) *S3ContentLocationUpdate {
	s.FileKeyUpdate = &v
	return s
}

// SetObjectVersionUpdate sets the ObjectVersionUpdate field's value.
func (s *S3ContentLocationUpdate) SetObjectVersionUpdate(v string) *S3ContentLocationUpdate {
	s.ObjectVersionUpdate = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, identifies the Amazon
// S3 bucket and object that contains the reference data.
//
// A Kinesis Data Analytics application loads reference data only once. If the
// data changes, you call the UpdateApplication operation to trigger reloading
// of data into your application.
type S3ReferenceDataSource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 bucket.
	BucketARN *string `min:"1" type:"string"`

	// The object key name containing the reference data.
	FileKey *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ReferenceDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ReferenceDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ReferenceDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ReferenceDataSource"}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.FileKey != nil && len(*s.FileKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3ReferenceDataSource) SetBucketARN(v string) *S3ReferenceDataSource {
	s.BucketARN = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *S3ReferenceDataSource) SetFileKey(v string) *S3ReferenceDataSource {
	s.FileKey = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, provides the bucket name
// and object key name that stores the reference data.
type S3ReferenceDataSourceDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// Amazon S3 object key name.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics can assume to read the
	// Amazon S3 object on your behalf to populate the in-application reference
	// table.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	ReferenceRoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ReferenceDataSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ReferenceDataSourceDescription) GoString() string {
	return s.String()
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3ReferenceDataSourceDescription) SetBucketARN(v string) *S3ReferenceDataSourceDescription {
	s.BucketARN = &v
	return s
}

// SetFileKey sets the FileKey field's value.
func (s *S3ReferenceDataSourceDescription) SetFileKey(v string) *S3ReferenceDataSourceDescription {
	s.FileKey = &v
	return s
}

// SetReferenceRoleARN sets the ReferenceRoleARN field's value.
func (s *S3ReferenceDataSourceDescription) SetReferenceRoleARN(v string) *S3ReferenceDataSourceDescription {
	s.ReferenceRoleARN = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes the Amazon
// S3 bucket name and object key name for an in-application reference table.
type S3ReferenceDataSourceUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 bucket.
	BucketARNUpdate *string `min:"1" type:"string"`

	// The object key name.
	FileKeyUpdate *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ReferenceDataSourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ReferenceDataSourceUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ReferenceDataSourceUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ReferenceDataSourceUpdate"}
	if s.BucketARNUpdate != nil && len(*s.BucketARNUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARNUpdate", 1))
	}
	if s.FileKeyUpdate != nil && len(*s.FileKeyUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileKeyUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARNUpdate sets the BucketARNUpdate field's value.
func (s *S3ReferenceDataSourceUpdate) SetBucketARNUpdate(v string) *S3ReferenceDataSourceUpdate {
	s.BucketARNUpdate = &v
	return s
}

// SetFileKeyUpdate sets the FileKeyUpdate field's value.
func (s *S3ReferenceDataSourceUpdate) SetFileKeyUpdate(v string) *S3ReferenceDataSourceUpdate {
	s.FileKeyUpdate = &v
	return s
}

// The service cannot complete the request.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides details about a snapshot of application state.
type SnapshotDetails struct {
	_ struct{} `type:"structure"`

	// The current application version ID when the snapshot was created.
	//
	// ApplicationVersionId is a required field
	ApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The timestamp of the application snapshot.
	SnapshotCreationTimestamp *time.Time `type:"timestamp"`

	// The identifier for the application snapshot.
	//
	// SnapshotName is a required field
	SnapshotName *string `min:"1" type:"string" required:"true"`

	// The status of the application snapshot.
	//
	// SnapshotStatus is a required field
	SnapshotStatus *string `type:"string" required:"true" enum:"SnapshotStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotDetails) GoString() string {
	return s.String()
}

// SetApplicationVersionId sets the ApplicationVersionId field's value.
func (s *SnapshotDetails) SetApplicationVersionId(v int64) *SnapshotDetails {
	s.ApplicationVersionId = &v
	return s
}

// SetSnapshotCreationTimestamp sets the SnapshotCreationTimestamp field's value.
func (s *SnapshotDetails) SetSnapshotCreationTimestamp(v time.Time) *SnapshotDetails {
	s.SnapshotCreationTimestamp = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *SnapshotDetails) SetSnapshotName(v string) *SnapshotDetails {
	s.SnapshotName = &v
	return s
}

// SetSnapshotStatus sets the SnapshotStatus field's value.
func (s *SnapshotDetails) SetSnapshotStatus(v string) *SnapshotDetails {
	s.SnapshotStatus = &v
	return s
}

// For a SQL-based Kinesis Data Analytics application, describes the format
// of the data in the streaming source, and how each data element maps to corresponding
// columns created in the in-application stream.
type SourceSchema struct {
	_ struct{} `type:"structure"`

	// A list of RecordColumn objects.
	//
	// RecordColumns is a required field
	RecordColumns []*RecordColumn `min:"1" type:"list" required:"true"`

	// Specifies the encoding of the records in the streaming source. For example,
	// UTF-8.
	RecordEncoding *string `min:"5" type:"string"`

	// Specifies the format of the records on the streaming source.
	//
	// RecordFormat is a required field
	RecordFormat *RecordFormat `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceSchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceSchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceSchema"}
	if s.RecordColumns == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordColumns"))
	}
	if s.RecordColumns != nil && len(s.RecordColumns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordColumns", 1))
	}
	if s.RecordEncoding != nil && len(*s.RecordEncoding) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("RecordEncoding", 5))
	}
	if s.RecordFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordFormat"))
	}
	if s.RecordColumns != nil {
		for i, v := range s.RecordColumns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecordColumns", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RecordFormat != nil {
		if err := s.RecordFormat.Validate(); err != nil {
			invalidParams.AddNested("RecordFormat", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordColumns sets the RecordColumns field's value.
func (s *SourceSchema) SetRecordColumns(v []*RecordColumn) *SourceSchema {
	s.RecordColumns = v
	return s
}

// SetRecordEncoding sets the RecordEncoding field's value.
func (s *SourceSchema) SetRecordEncoding(v string) *SourceSchema {
	s.RecordEncoding = &v
	return s
}

// SetRecordFormat sets the RecordFormat field's value.
func (s *SourceSchema) SetRecordFormat(v *RecordFormat) *SourceSchema {
	s.RecordFormat = v
	return s
}

// Describes the inputs, outputs, and reference data sources for a SQL-based
// Kinesis Data Analytics application.
type SqlApplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// The array of Input objects describing the input streams used by the application.
	Inputs []*Input `type:"list"`

	// The array of Output objects describing the destination streams used by the
	// application.
	Outputs []*Output `type:"list"`

	// The array of ReferenceDataSource objects describing the reference data sources
	// used by the application.
	ReferenceDataSources []*ReferenceDataSource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlApplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlApplicationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlApplicationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqlApplicationConfiguration"}
	if s.Inputs != nil {
		for i, v := range s.Inputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Inputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ReferenceDataSources != nil {
		for i, v := range s.ReferenceDataSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReferenceDataSources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputs sets the Inputs field's value.
func (s *SqlApplicationConfiguration) SetInputs(v []*Input) *SqlApplicationConfiguration {
	s.Inputs = v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *SqlApplicationConfiguration) SetOutputs(v []*Output) *SqlApplicationConfiguration {
	s.Outputs = v
	return s
}

// SetReferenceDataSources sets the ReferenceDataSources field's value.
func (s *SqlApplicationConfiguration) SetReferenceDataSources(v []*ReferenceDataSource) *SqlApplicationConfiguration {
	s.ReferenceDataSources = v
	return s
}

// Describes the inputs, outputs, and reference data sources for a SQL-based
// Kinesis Data Analytics application.
type SqlApplicationConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The array of InputDescription objects describing the input streams used by
	// the application.
	InputDescriptions []*InputDescription `type:"list"`

	// The array of OutputDescription objects describing the destination streams
	// used by the application.
	OutputDescriptions []*OutputDescription `type:"list"`

	// The array of ReferenceDataSourceDescription objects describing the reference
	// data sources used by the application.
	ReferenceDataSourceDescriptions []*ReferenceDataSourceDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlApplicationConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlApplicationConfigurationDescription) GoString() string {
	return s.String()
}

// SetInputDescriptions sets the InputDescriptions field's value.
func (s *SqlApplicationConfigurationDescription) SetInputDescriptions(v []*InputDescription) *SqlApplicationConfigurationDescription {
	s.InputDescriptions = v
	return s
}

// SetOutputDescriptions sets the OutputDescriptions field's value.
func (s *SqlApplicationConfigurationDescription) SetOutputDescriptions(v []*OutputDescription) *SqlApplicationConfigurationDescription {
	s.OutputDescriptions = v
	return s
}

// SetReferenceDataSourceDescriptions sets the ReferenceDataSourceDescriptions field's value.
func (s *SqlApplicationConfigurationDescription) SetReferenceDataSourceDescriptions(v []*ReferenceDataSourceDescription) *SqlApplicationConfigurationDescription {
	s.ReferenceDataSourceDescriptions = v
	return s
}

// Describes updates to the input streams, destination streams, and reference
// data sources for a SQL-based Kinesis Data Analytics application.
type SqlApplicationConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// The array of InputUpdate objects describing the new input streams used by
	// the application.
	InputUpdates []*InputUpdate `type:"list"`

	// The array of OutputUpdate objects describing the new destination streams
	// used by the application.
	OutputUpdates []*OutputUpdate `type:"list"`

	// The array of ReferenceDataSourceUpdate objects describing the new reference
	// data sources used by the application.
	ReferenceDataSourceUpdates []*ReferenceDataSourceUpdate `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlApplicationConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlApplicationConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlApplicationConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqlApplicationConfigurationUpdate"}
	if s.InputUpdates != nil {
		for i, v := range s.InputUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OutputUpdates != nil {
		for i, v := range s.OutputUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ReferenceDataSourceUpdates != nil {
		for i, v := range s.ReferenceDataSourceUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReferenceDataSourceUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputUpdates sets the InputUpdates field's value.
func (s *SqlApplicationConfigurationUpdate) SetInputUpdates(v []*InputUpdate) *SqlApplicationConfigurationUpdate {
	s.InputUpdates = v
	return s
}

// SetOutputUpdates sets the OutputUpdates field's value.
func (s *SqlApplicationConfigurationUpdate) SetOutputUpdates(v []*OutputUpdate) *SqlApplicationConfigurationUpdate {
	s.OutputUpdates = v
	return s
}

// SetReferenceDataSourceUpdates sets the ReferenceDataSourceUpdates field's value.
func (s *SqlApplicationConfigurationUpdate) SetReferenceDataSourceUpdates(v []*ReferenceDataSourceUpdate) *SqlApplicationConfigurationUpdate {
	s.ReferenceDataSourceUpdates = v
	return s
}

// Describes the starting parameters for a SQL-based Kinesis Data Analytics
// application.
type SqlRunConfiguration struct {
	_ struct{} `type:"structure"`

	// The input source ID. You can get this ID by calling the DescribeApplication
	// operation.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`

	// The point at which you want the application to start processing records from
	// the streaming source.
	//
	// InputStartingPositionConfiguration is a required field
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlRunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SqlRunConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlRunConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqlRunConfiguration"}
	if s.InputId == nil {
		invalidParams.Add(request.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputId", 1))
	}
	if s.InputStartingPositionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InputStartingPositionConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputId sets the InputId field's value.
func (s *SqlRunConfiguration) SetInputId(v string) *SqlRunConfiguration {
	s.InputId = &v
	return s
}

// SetInputStartingPositionConfiguration sets the InputStartingPositionConfiguration field's value.
func (s *SqlRunConfiguration) SetInputStartingPositionConfiguration(v *InputStartingPositionConfiguration) *SqlRunConfiguration {
	s.InputStartingPositionConfiguration = v
	return s
}

type StartApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Identifies the run configuration (start parameters) of a Kinesis Data Analytics
	// application.
	RunConfiguration *RunConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.RunConfiguration != nil {
		if err := s.RunConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RunConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *StartApplicationInput) SetApplicationName(v string) *StartApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetRunConfiguration sets the RunConfiguration field's value.
func (s *StartApplicationInput) SetRunConfiguration(v *RunConfiguration) *StartApplicationInput {
	s.RunConfiguration = v
	return s
}

type StartApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartApplicationOutput) GoString() string {
	return s.String()
}

type StopApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the running application to stop.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Set to true to force the application to stop. If you set Force to true, Kinesis
	// Data Analytics stops the application without taking a snapshot.
	//
	// Force-stopping your application may lead to data loss or duplication. To
	// prevent data loss or duplicate processing of data during application restarts,
	// we recommend you to take frequent snapshots of your application.
	//
	// You can only force stop a Flink-based Kinesis Data Analytics application.
	// You can't force stop a SQL-based Kinesis Data Analytics application.
	//
	// The application must be in the STARTING, UPDATING, STOPPING, AUTOSCALING,
	// or RUNNING status.
	Force *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *StopApplicationInput) SetApplicationName(v string) *StopApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetForce sets the Force field's value.
func (s *StopApplicationInput) SetForce(v bool) *StopApplicationInput {
	s.Force = &v
	return s
}

type StopApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopApplicationOutput) GoString() string {
	return s.String()
}

// A key-value pair (the value is optional) that you can define and assign to
// Amazon resources. If you specify a tag that already exists, the tag value
// is replaced with the value that you specify in the request. Note that the
// maximum number of application tags includes system tags. The maximum number
// of user-defined application tags is 50. For more information, see Using Tagging
// (https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html).
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the key-value tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the key-value tag. The value is optional.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the application to assign the tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The key-value tags to assign to the application.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Application created with too many tags, or too many tags added to an application.
// Note that the maximum number of application tags includes system tags. The
// maximum number of user-defined application tags is 50.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The data format is not valid. Kinesis Data Analytics cannot detect the schema
// for the given streaming source.
type UnableToDetectSchemaException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Stream data that was modified by the processor specified in the InputProcessingConfiguration
	// parameter.
	ProcessedInputRecords []*string `type:"list"`

	// Raw stream data that was sampled to infer the schema.
	RawInputRecords []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnableToDetectSchemaException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnableToDetectSchemaException) GoString() string {
	return s.String()
}

func newErrorUnableToDetectSchemaException(v protocol.ResponseMetadata) error {
	return &UnableToDetectSchemaException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnableToDetectSchemaException) Code() string {
	return "UnableToDetectSchemaException"
}

// Message returns the exception's message.
func (s *UnableToDetectSchemaException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnableToDetectSchemaException) OrigErr() error {
	return nil
}

func (s *UnableToDetectSchemaException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnableToDetectSchemaException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnableToDetectSchemaException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was rejected because a specified parameter is not supported or
// a specified resource is not valid for this operation.
type UnsupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperationException) Code() string {
	return "UnsupportedOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Kinesis Data Analytics application from which to remove the
	// tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of keys of tags to remove from the specified application.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Describes application configuration updates.
	ApplicationConfigurationUpdate *ApplicationConfigurationUpdate `type:"structure"`

	// The name of the application to update.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Describes application Amazon CloudWatch logging option updates. You can only
	// update existing CloudWatch logging options with this action. To add a new
	// CloudWatch logging option, use AddApplicationCloudWatchLoggingOption.
	CloudWatchLoggingOptionUpdates []*CloudWatchLoggingOptionUpdate `type:"list"`

	// A value you use to implement strong concurrency for application updates.
	// You must provide the CurrentApplicationVersionId or the ConditionalToken.
	// You get the application's current ConditionalToken using DescribeApplication.
	// For better concurrency support, use the ConditionalToken parameter instead
	// of CurrentApplicationVersionId.
	ConditionalToken *string `min:"1" type:"string"`

	// The current application version ID. You must provide the CurrentApplicationVersionId
	// or the ConditionalToken.You can retrieve the application version ID using
	// DescribeApplication. For better concurrency support, use the ConditionalToken
	// parameter instead of CurrentApplicationVersionId.
	CurrentApplicationVersionId *int64 `min:"1" type:"long"`

	// Describes updates to the application's starting parameters.
	RunConfigurationUpdate *RunConfigurationUpdate `type:"structure"`

	// Describes updates to the service execution role.
	ServiceExecutionRoleUpdate *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.ConditionalToken != nil && len(*s.ConditionalToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConditionalToken", 1))
	}
	if s.CurrentApplicationVersionId != nil && *s.CurrentApplicationVersionId < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentApplicationVersionId", 1))
	}
	if s.ServiceExecutionRoleUpdate != nil && len(*s.ServiceExecutionRoleUpdate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceExecutionRoleUpdate", 1))
	}
	if s.ApplicationConfigurationUpdate != nil {
		if err := s.ApplicationConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ApplicationConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.CloudWatchLoggingOptionUpdates != nil {
		for i, v := range s.CloudWatchLoggingOptionUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CloudWatchLoggingOptionUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RunConfigurationUpdate != nil {
		if err := s.RunConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("RunConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationConfigurationUpdate sets the ApplicationConfigurationUpdate field's value.
func (s *UpdateApplicationInput) SetApplicationConfigurationUpdate(v *ApplicationConfigurationUpdate) *UpdateApplicationInput {
	s.ApplicationConfigurationUpdate = v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateApplicationInput) SetApplicationName(v string) *UpdateApplicationInput {
	s.ApplicationName = &v
	return s
}

// SetCloudWatchLoggingOptionUpdates sets the CloudWatchLoggingOptionUpdates field's value.
func (s *UpdateApplicationInput) SetCloudWatchLoggingOptionUpdates(v []*CloudWatchLoggingOptionUpdate) *UpdateApplicationInput {
	s.CloudWatchLoggingOptionUpdates = v
	return s
}

// SetConditionalToken sets the ConditionalToken field's value.
func (s *UpdateApplicationInput) SetConditionalToken(v string) *UpdateApplicationInput {
	s.ConditionalToken = &v
	return s
}

// SetCurrentApplicationVersionId sets the CurrentApplicationVersionId field's value.
func (s *UpdateApplicationInput) SetCurrentApplicationVersionId(v int64) *UpdateApplicationInput {
	s.CurrentApplicationVersionId = &v
	return s
}

// SetRunConfigurationUpdate sets the RunConfigurationUpdate field's value.
func (s *UpdateApplicationInput) SetRunConfigurationUpdate(v *RunConfigurationUpdate) *UpdateApplicationInput {
	s.RunConfigurationUpdate = v
	return s
}

// SetServiceExecutionRoleUpdate sets the ServiceExecutionRoleUpdate field's value.
func (s *UpdateApplicationInput) SetServiceExecutionRoleUpdate(v string) *UpdateApplicationInput {
	s.ServiceExecutionRoleUpdate = &v
	return s
}

type UpdateApplicationMaintenanceConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Describes the application maintenance configuration update.
	//
	// ApplicationMaintenanceConfigurationUpdate is a required field
	ApplicationMaintenanceConfigurationUpdate *ApplicationMaintenanceConfigurationUpdate `type:"structure" required:"true"`

	// The name of the application for which you want to update the maintenance
	// configuration.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationMaintenanceConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationMaintenanceConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationMaintenanceConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationMaintenanceConfigurationInput"}
	if s.ApplicationMaintenanceConfigurationUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationMaintenanceConfigurationUpdate"))
	}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationName", 1))
	}
	if s.ApplicationMaintenanceConfigurationUpdate != nil {
		if err := s.ApplicationMaintenanceConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ApplicationMaintenanceConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationMaintenanceConfigurationUpdate sets the ApplicationMaintenanceConfigurationUpdate field's value.
func (s *UpdateApplicationMaintenanceConfigurationInput) SetApplicationMaintenanceConfigurationUpdate(v *ApplicationMaintenanceConfigurationUpdate) *UpdateApplicationMaintenanceConfigurationInput {
	s.ApplicationMaintenanceConfigurationUpdate = v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateApplicationMaintenanceConfigurationInput) SetApplicationName(v string) *UpdateApplicationMaintenanceConfigurationInput {
	s.ApplicationName = &v
	return s
}

type UpdateApplicationMaintenanceConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the application.
	ApplicationARN *string `min:"1" type:"string"`

	// The application maintenance configuration description after the update.
	ApplicationMaintenanceConfigurationDescription *ApplicationMaintenanceConfigurationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationMaintenanceConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationMaintenanceConfigurationOutput) GoString() string {
	return s.String()
}

// SetApplicationARN sets the ApplicationARN field's value.
func (s *UpdateApplicationMaintenanceConfigurationOutput) SetApplicationARN(v string) *UpdateApplicationMaintenanceConfigurationOutput {
	s.ApplicationARN = &v
	return s
}

// SetApplicationMaintenanceConfigurationDescription sets the ApplicationMaintenanceConfigurationDescription field's value.
func (s *UpdateApplicationMaintenanceConfigurationOutput) SetApplicationMaintenanceConfigurationDescription(v *ApplicationMaintenanceConfigurationDescription) *UpdateApplicationMaintenanceConfigurationOutput {
	s.ApplicationMaintenanceConfigurationDescription = v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Describes application updates.
	//
	// ApplicationDetail is a required field
	ApplicationDetail *ApplicationDetail `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationDetail sets the ApplicationDetail field's value.
func (s *UpdateApplicationOutput) SetApplicationDetail(v *ApplicationDetail) *UpdateApplicationOutput {
	s.ApplicationDetail = v
	return s
}

// Describes the parameters of a VPC used by the application.
type VpcConfiguration struct {
	_ struct{} `type:"structure"`

	// The array of SecurityGroup (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html)
	// IDs used by the VPC configuration.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `min:"1" type:"list" required:"true"`

	// The array of Subnet (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html)
	// IDs used by the VPC configuration.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfiguration"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfiguration) SetSecurityGroupIds(v []*string) *VpcConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfiguration) SetSubnetIds(v []*string) *VpcConfiguration {
	s.SubnetIds = v
	return s
}

// Describes the parameters of a VPC used by the application.
type VpcConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The array of SecurityGroup (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html)
	// IDs used by the VPC configuration.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `min:"1" type:"list" required:"true"`

	// The array of Subnet (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html)
	// IDs used by the VPC configuration.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`

	// The ID of the VPC configuration.
	//
	// VpcConfigurationId is a required field
	VpcConfigurationId *string `min:"1" type:"string" required:"true"`

	// The ID of the associated VPC.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigurationDescription) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigurationDescription) SetSecurityGroupIds(v []*string) *VpcConfigurationDescription {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigurationDescription) SetSubnetIds(v []*string) *VpcConfigurationDescription {
	s.SubnetIds = v
	return s
}

// SetVpcConfigurationId sets the VpcConfigurationId field's value.
func (s *VpcConfigurationDescription) SetVpcConfigurationId(v string) *VpcConfigurationDescription {
	s.VpcConfigurationId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigurationDescription) SetVpcId(v string) *VpcConfigurationDescription {
	s.VpcId = &v
	return s
}

// Describes updates to the VPC configuration used by the application.
type VpcConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to the array of SecurityGroup (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_SecurityGroup.html)
	// IDs used by the VPC configuration.
	SecurityGroupIdUpdates []*string `min:"1" type:"list"`

	// Describes updates to the array of Subnet (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Subnet.html)
	// IDs used by the VPC configuration.
	SubnetIdUpdates []*string `min:"1" type:"list"`

	// Describes an update to the ID of the VPC configuration.
	//
	// VpcConfigurationId is a required field
	VpcConfigurationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfigurationUpdate"}
	if s.SecurityGroupIdUpdates != nil && len(s.SecurityGroupIdUpdates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIdUpdates", 1))
	}
	if s.SubnetIdUpdates != nil && len(s.SubnetIdUpdates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIdUpdates", 1))
	}
	if s.VpcConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcConfigurationId"))
	}
	if s.VpcConfigurationId != nil && len(*s.VpcConfigurationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcConfigurationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIdUpdates sets the SecurityGroupIdUpdates field's value.
func (s *VpcConfigurationUpdate) SetSecurityGroupIdUpdates(v []*string) *VpcConfigurationUpdate {
	s.SecurityGroupIdUpdates = v
	return s
}

// SetSubnetIdUpdates sets the SubnetIdUpdates field's value.
func (s *VpcConfigurationUpdate) SetSubnetIdUpdates(v []*string) *VpcConfigurationUpdate {
	s.SubnetIdUpdates = v
	return s
}

// SetVpcConfigurationId sets the VpcConfigurationId field's value.
func (s *VpcConfigurationUpdate) SetVpcConfigurationId(v string) *VpcConfigurationUpdate {
	s.VpcConfigurationId = &v
	return s
}

// The configuration of a Kinesis Data Analytics Studio notebook.
type ZeppelinApplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Glue Data Catalog that you use in queries in a Kinesis Data Analytics
	// Studio notebook.
	CatalogConfiguration *CatalogConfiguration `type:"structure"`

	// Custom artifacts are dependency JARs and user-defined functions (UDF).
	CustomArtifactsConfiguration []*CustomArtifactConfiguration `type:"list"`

	// The information required to deploy a Kinesis Data Analytics Studio notebook
	// as an application with durable state.
	DeployAsApplicationConfiguration *DeployAsApplicationConfiguration `type:"structure"`

	// The monitoring configuration of a Kinesis Data Analytics Studio notebook.
	MonitoringConfiguration *ZeppelinMonitoringConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinApplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinApplicationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZeppelinApplicationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZeppelinApplicationConfiguration"}
	if s.CatalogConfiguration != nil {
		if err := s.CatalogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CatalogConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomArtifactsConfiguration != nil {
		for i, v := range s.CustomArtifactsConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomArtifactsConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DeployAsApplicationConfiguration != nil {
		if err := s.DeployAsApplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DeployAsApplicationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.MonitoringConfiguration != nil {
		if err := s.MonitoringConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MonitoringConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogConfiguration sets the CatalogConfiguration field's value.
func (s *ZeppelinApplicationConfiguration) SetCatalogConfiguration(v *CatalogConfiguration) *ZeppelinApplicationConfiguration {
	s.CatalogConfiguration = v
	return s
}

// SetCustomArtifactsConfiguration sets the CustomArtifactsConfiguration field's value.
func (s *ZeppelinApplicationConfiguration) SetCustomArtifactsConfiguration(v []*CustomArtifactConfiguration) *ZeppelinApplicationConfiguration {
	s.CustomArtifactsConfiguration = v
	return s
}

// SetDeployAsApplicationConfiguration sets the DeployAsApplicationConfiguration field's value.
func (s *ZeppelinApplicationConfiguration) SetDeployAsApplicationConfiguration(v *DeployAsApplicationConfiguration) *ZeppelinApplicationConfiguration {
	s.DeployAsApplicationConfiguration = v
	return s
}

// SetMonitoringConfiguration sets the MonitoringConfiguration field's value.
func (s *ZeppelinApplicationConfiguration) SetMonitoringConfiguration(v *ZeppelinMonitoringConfiguration) *ZeppelinApplicationConfiguration {
	s.MonitoringConfiguration = v
	return s
}

// The configuration of a Kinesis Data Analytics Studio notebook.
type ZeppelinApplicationConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Glue Data Catalog that is associated with the Kinesis Data Analytics
	// Studio notebook.
	CatalogConfigurationDescription *CatalogConfigurationDescription `type:"structure"`

	// Custom artifacts are dependency JARs and user-defined functions (UDF).
	CustomArtifactsConfigurationDescription []*CustomArtifactConfigurationDescription `type:"list"`

	// The parameters required to deploy a Kinesis Data Analytics Studio notebook
	// as an application with durable state.
	DeployAsApplicationConfigurationDescription *DeployAsApplicationConfigurationDescription `type:"structure"`

	// The monitoring configuration of a Kinesis Data Analytics Studio notebook.
	//
	// MonitoringConfigurationDescription is a required field
	MonitoringConfigurationDescription *ZeppelinMonitoringConfigurationDescription `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinApplicationConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinApplicationConfigurationDescription) GoString() string {
	return s.String()
}

// SetCatalogConfigurationDescription sets the CatalogConfigurationDescription field's value.
func (s *ZeppelinApplicationConfigurationDescription) SetCatalogConfigurationDescription(v *CatalogConfigurationDescription) *ZeppelinApplicationConfigurationDescription {
	s.CatalogConfigurationDescription = v
	return s
}

// SetCustomArtifactsConfigurationDescription sets the CustomArtifactsConfigurationDescription field's value.
func (s *ZeppelinApplicationConfigurationDescription) SetCustomArtifactsConfigurationDescription(v []*CustomArtifactConfigurationDescription) *ZeppelinApplicationConfigurationDescription {
	s.CustomArtifactsConfigurationDescription = v
	return s
}

// SetDeployAsApplicationConfigurationDescription sets the DeployAsApplicationConfigurationDescription field's value.
func (s *ZeppelinApplicationConfigurationDescription) SetDeployAsApplicationConfigurationDescription(v *DeployAsApplicationConfigurationDescription) *ZeppelinApplicationConfigurationDescription {
	s.DeployAsApplicationConfigurationDescription = v
	return s
}

// SetMonitoringConfigurationDescription sets the MonitoringConfigurationDescription field's value.
func (s *ZeppelinApplicationConfigurationDescription) SetMonitoringConfigurationDescription(v *ZeppelinMonitoringConfigurationDescription) *ZeppelinApplicationConfigurationDescription {
	s.MonitoringConfigurationDescription = v
	return s
}

// Updates to the configuration of Kinesis Data Analytics Studio notebook.
type ZeppelinApplicationConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Updates to the configuration of the Amazon Glue Data Catalog that is associated
	// with the Kinesis Data Analytics Studio notebook.
	CatalogConfigurationUpdate *CatalogConfigurationUpdate `type:"structure"`

	// Updates to the customer artifacts. Custom artifacts are dependency JAR files
	// and user-defined functions (UDF).
	CustomArtifactsConfigurationUpdate []*CustomArtifactConfiguration `type:"list"`

	// Updates to the configuration information required to deploy an Amazon Data
	// Analytics Studio notebook as an application with durable state.
	DeployAsApplicationConfigurationUpdate *DeployAsApplicationConfigurationUpdate `type:"structure"`

	// Updates to the monitoring configuration of a Kinesis Data Analytics Studio
	// notebook.
	MonitoringConfigurationUpdate *ZeppelinMonitoringConfigurationUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinApplicationConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinApplicationConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZeppelinApplicationConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZeppelinApplicationConfigurationUpdate"}
	if s.CatalogConfigurationUpdate != nil {
		if err := s.CatalogConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("CatalogConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomArtifactsConfigurationUpdate != nil {
		for i, v := range s.CustomArtifactsConfigurationUpdate {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomArtifactsConfigurationUpdate", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DeployAsApplicationConfigurationUpdate != nil {
		if err := s.DeployAsApplicationConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("DeployAsApplicationConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.MonitoringConfigurationUpdate != nil {
		if err := s.MonitoringConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("MonitoringConfigurationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogConfigurationUpdate sets the CatalogConfigurationUpdate field's value.
func (s *ZeppelinApplicationConfigurationUpdate) SetCatalogConfigurationUpdate(v *CatalogConfigurationUpdate) *ZeppelinApplicationConfigurationUpdate {
	s.CatalogConfigurationUpdate = v
	return s
}

// SetCustomArtifactsConfigurationUpdate sets the CustomArtifactsConfigurationUpdate field's value.
func (s *ZeppelinApplicationConfigurationUpdate) SetCustomArtifactsConfigurationUpdate(v []*CustomArtifactConfiguration) *ZeppelinApplicationConfigurationUpdate {
	s.CustomArtifactsConfigurationUpdate = v
	return s
}

// SetDeployAsApplicationConfigurationUpdate sets the DeployAsApplicationConfigurationUpdate field's value.
func (s *ZeppelinApplicationConfigurationUpdate) SetDeployAsApplicationConfigurationUpdate(v *DeployAsApplicationConfigurationUpdate) *ZeppelinApplicationConfigurationUpdate {
	s.DeployAsApplicationConfigurationUpdate = v
	return s
}

// SetMonitoringConfigurationUpdate sets the MonitoringConfigurationUpdate field's value.
func (s *ZeppelinApplicationConfigurationUpdate) SetMonitoringConfigurationUpdate(v *ZeppelinMonitoringConfigurationUpdate) *ZeppelinApplicationConfigurationUpdate {
	s.MonitoringConfigurationUpdate = v
	return s
}

// Describes configuration parameters for Amazon CloudWatch logging for a Kinesis
// Data Analytics Studio notebook. For more information about CloudWatch logging,
// see Monitoring (https://docs.aws.amazon.com/kinesisanalytics/latest/java/monitoring-overview.html).
type ZeppelinMonitoringConfiguration struct {
	_ struct{} `type:"structure"`

	// The verbosity of the CloudWatch Logs for an application.
	//
	// LogLevel is a required field
	LogLevel *string `type:"string" required:"true" enum:"LogLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinMonitoringConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinMonitoringConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZeppelinMonitoringConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZeppelinMonitoringConfiguration"}
	if s.LogLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("LogLevel"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogLevel sets the LogLevel field's value.
func (s *ZeppelinMonitoringConfiguration) SetLogLevel(v string) *ZeppelinMonitoringConfiguration {
	s.LogLevel = &v
	return s
}

// The monitoring configuration for Apache Zeppelin within a Kinesis Data Analytics
// Studio notebook.
type ZeppelinMonitoringConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes the verbosity of the CloudWatch Logs for an application.
	LogLevel *string `type:"string" enum:"LogLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinMonitoringConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinMonitoringConfigurationDescription) GoString() string {
	return s.String()
}

// SetLogLevel sets the LogLevel field's value.
func (s *ZeppelinMonitoringConfigurationDescription) SetLogLevel(v string) *ZeppelinMonitoringConfigurationDescription {
	s.LogLevel = &v
	return s
}

// Updates to the monitoring configuration for Apache Zeppelin within a Kinesis
// Data Analytics Studio notebook.
type ZeppelinMonitoringConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Updates to the logging level for Apache Zeppelin within a Kinesis Data Analytics
	// Studio notebook.
	//
	// LogLevelUpdate is a required field
	LogLevelUpdate *string `type:"string" required:"true" enum:"LogLevel"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinMonitoringConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ZeppelinMonitoringConfigurationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZeppelinMonitoringConfigurationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZeppelinMonitoringConfigurationUpdate"}
	if s.LogLevelUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("LogLevelUpdate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogLevelUpdate sets the LogLevelUpdate field's value.
func (s *ZeppelinMonitoringConfigurationUpdate) SetLogLevelUpdate(v string) *ZeppelinMonitoringConfigurationUpdate {
	s.LogLevelUpdate = &v
	return s
}

const (
	// ApplicationModeStreaming is a ApplicationMode enum value
	ApplicationModeStreaming = "STREAMING"

	// ApplicationModeInteractive is a ApplicationMode enum value
	ApplicationModeInteractive = "INTERACTIVE"
)

// ApplicationMode_Values returns all elements of the ApplicationMode enum
func ApplicationMode_Values() []string {
	return []string{
		ApplicationModeStreaming,
		ApplicationModeInteractive,
	}
}

const (
	// ApplicationRestoreTypeSkipRestoreFromSnapshot is a ApplicationRestoreType enum value
	ApplicationRestoreTypeSkipRestoreFromSnapshot = "SKIP_RESTORE_FROM_SNAPSHOT"

	// ApplicationRestoreTypeRestoreFromLatestSnapshot is a ApplicationRestoreType enum value
	ApplicationRestoreTypeRestoreFromLatestSnapshot = "RESTORE_FROM_LATEST_SNAPSHOT"

	// ApplicationRestoreTypeRestoreFromCustomSnapshot is a ApplicationRestoreType enum value
	ApplicationRestoreTypeRestoreFromCustomSnapshot = "RESTORE_FROM_CUSTOM_SNAPSHOT"
)

// ApplicationRestoreType_Values returns all elements of the ApplicationRestoreType enum
func ApplicationRestoreType_Values() []string {
	return []string{
		ApplicationRestoreTypeSkipRestoreFromSnapshot,
		ApplicationRestoreTypeRestoreFromLatestSnapshot,
		ApplicationRestoreTypeRestoreFromCustomSnapshot,
	}
}

const (
	// ApplicationStatusDeleting is a ApplicationStatus enum value
	ApplicationStatusDeleting = "DELETING"

	// ApplicationStatusStarting is a ApplicationStatus enum value
	ApplicationStatusStarting = "STARTING"

	// ApplicationStatusStopping is a ApplicationStatus enum value
	ApplicationStatusStopping = "STOPPING"

	// ApplicationStatusReady is a ApplicationStatus enum value
	ApplicationStatusReady = "READY"

	// ApplicationStatusRunning is a ApplicationStatus enum value
	ApplicationStatusRunning = "RUNNING"

	// ApplicationStatusUpdating is a ApplicationStatus enum value
	ApplicationStatusUpdating = "UPDATING"

	// ApplicationStatusAutoscaling is a ApplicationStatus enum value
	ApplicationStatusAutoscaling = "AUTOSCALING"

	// ApplicationStatusForceStopping is a ApplicationStatus enum value
	ApplicationStatusForceStopping = "FORCE_STOPPING"

	// ApplicationStatusRollingBack is a ApplicationStatus enum value
	ApplicationStatusRollingBack = "ROLLING_BACK"

	// ApplicationStatusMaintenance is a ApplicationStatus enum value
	ApplicationStatusMaintenance = "MAINTENANCE"

	// ApplicationStatusRolledBack is a ApplicationStatus enum value
	ApplicationStatusRolledBack = "ROLLED_BACK"
)

// ApplicationStatus_Values returns all elements of the ApplicationStatus enum
func ApplicationStatus_Values() []string {
	return []string{
		ApplicationStatusDeleting,
		ApplicationStatusStarting,
		ApplicationStatusStopping,
		ApplicationStatusReady,
		ApplicationStatusRunning,
		ApplicationStatusUpdating,
		ApplicationStatusAutoscaling,
		ApplicationStatusForceStopping,
		ApplicationStatusRollingBack,
		ApplicationStatusMaintenance,
		ApplicationStatusRolledBack,
	}
}

const (
	// ArtifactTypeUdf is a ArtifactType enum value
	ArtifactTypeUdf = "UDF"

	// ArtifactTypeDependencyJar is a ArtifactType enum value
	ArtifactTypeDependencyJar = "DEPENDENCY_JAR"
)

// ArtifactType_Values returns all elements of the ArtifactType enum
func ArtifactType_Values() []string {
	return []string{
		ArtifactTypeUdf,
		ArtifactTypeDependencyJar,
	}
}

const (
	// CodeContentTypePlaintext is a CodeContentType enum value
	CodeContentTypePlaintext = "PLAINTEXT"

	// CodeContentTypeZipfile is a CodeContentType enum value
	CodeContentTypeZipfile = "ZIPFILE"
)

// CodeContentType_Values returns all elements of the CodeContentType enum
func CodeContentType_Values() []string {
	return []string{
		CodeContentTypePlaintext,
		CodeContentTypeZipfile,
	}
}

const (
	// ConfigurationTypeDefault is a ConfigurationType enum value
	ConfigurationTypeDefault = "DEFAULT"

	// ConfigurationTypeCustom is a ConfigurationType enum value
	ConfigurationTypeCustom = "CUSTOM"
)

// ConfigurationType_Values returns all elements of the ConfigurationType enum
func ConfigurationType_Values() []string {
	return []string{
		ConfigurationTypeDefault,
		ConfigurationTypeCustom,
	}
}

const (
	// InputStartingPositionNow is a InputStartingPosition enum value
	InputStartingPositionNow = "NOW"

	// InputStartingPositionTrimHorizon is a InputStartingPosition enum value
	InputStartingPositionTrimHorizon = "TRIM_HORIZON"

	// InputStartingPositionLastStoppedPoint is a InputStartingPosition enum value
	InputStartingPositionLastStoppedPoint = "LAST_STOPPED_POINT"
)

// InputStartingPosition_Values returns all elements of the InputStartingPosition enum
func InputStartingPosition_Values() []string {
	return []string{
		InputStartingPositionNow,
		InputStartingPositionTrimHorizon,
		InputStartingPositionLastStoppedPoint,
	}
}

const (
	// LogLevelInfo is a LogLevel enum value
	LogLevelInfo = "INFO"

	// LogLevelWarn is a LogLevel enum value
	LogLevelWarn = "WARN"

	// LogLevelError is a LogLevel enum value
	LogLevelError = "ERROR"

	// LogLevelDebug is a LogLevel enum value
	LogLevelDebug = "DEBUG"
)

// LogLevel_Values returns all elements of the LogLevel enum
func LogLevel_Values() []string {
	return []string{
		LogLevelInfo,
		LogLevelWarn,
		LogLevelError,
		LogLevelDebug,
	}
}

const (
	// MetricsLevelApplication is a MetricsLevel enum value
	MetricsLevelApplication = "APPLICATION"

	// MetricsLevelTask is a MetricsLevel enum value
	MetricsLevelTask = "TASK"

	// MetricsLevelOperator is a MetricsLevel enum value
	MetricsLevelOperator = "OPERATOR"

	// MetricsLevelParallelism is a MetricsLevel enum value
	MetricsLevelParallelism = "PARALLELISM"
)

// MetricsLevel_Values returns all elements of the MetricsLevel enum
func MetricsLevel_Values() []string {
	return []string{
		MetricsLevelApplication,
		MetricsLevelTask,
		MetricsLevelOperator,
		MetricsLevelParallelism,
	}
}

const (
	// RecordFormatTypeJson is a RecordFormatType enum value
	RecordFormatTypeJson = "JSON"

	// RecordFormatTypeCsv is a RecordFormatType enum value
	RecordFormatTypeCsv = "CSV"
)

// RecordFormatType_Values returns all elements of the RecordFormatType enum
func RecordFormatType_Values() []string {
	return []string{
		RecordFormatTypeJson,
		RecordFormatTypeCsv,
	}
}

const (
	// RuntimeEnvironmentSql10 is a RuntimeEnvironment enum value
	RuntimeEnvironmentSql10 = "SQL-1_0"

	// RuntimeEnvironmentFlink16 is a RuntimeEnvironment enum value
	RuntimeEnvironmentFlink16 = "FLINK-1_6"

	// RuntimeEnvironmentFlink18 is a RuntimeEnvironment enum value
	RuntimeEnvironmentFlink18 = "FLINK-1_8"

	// RuntimeEnvironmentZeppelinFlink10 is a RuntimeEnvironment enum value
	RuntimeEnvironmentZeppelinFlink10 = "ZEPPELIN-FLINK-1_0"

	// RuntimeEnvironmentFlink111 is a RuntimeEnvironment enum value
	RuntimeEnvironmentFlink111 = "FLINK-1_11"

	// RuntimeEnvironmentFlink113 is a RuntimeEnvironment enum value
	RuntimeEnvironmentFlink113 = "FLINK-1_13"

	// RuntimeEnvironmentZeppelinFlink20 is a RuntimeEnvironment enum value
	RuntimeEnvironmentZeppelinFlink20 = "ZEPPELIN-FLINK-2_0"
)

// RuntimeEnvironment_Values returns all elements of the RuntimeEnvironment enum
func RuntimeEnvironment_Values() []string {
	return []string{
		RuntimeEnvironmentSql10,
		RuntimeEnvironmentFlink16,
		RuntimeEnvironmentFlink18,
		RuntimeEnvironmentZeppelinFlink10,
		RuntimeEnvironmentFlink111,
		RuntimeEnvironmentFlink113,
		RuntimeEnvironmentZeppelinFlink20,
	}
}

const (
	// SnapshotStatusCreating is a SnapshotStatus enum value
	SnapshotStatusCreating = "CREATING"

	// SnapshotStatusReady is a SnapshotStatus enum value
	SnapshotStatusReady = "READY"

	// SnapshotStatusDeleting is a SnapshotStatus enum value
	SnapshotStatusDeleting = "DELETING"

	// SnapshotStatusFailed is a SnapshotStatus enum value
	SnapshotStatusFailed = "FAILED"
)

// SnapshotStatus_Values returns all elements of the SnapshotStatus enum
func SnapshotStatus_Values() []string {
	return []string{
		SnapshotStatusCreating,
		SnapshotStatusReady,
		SnapshotStatusDeleting,
		SnapshotStatusFailed,
	}
}

const (
	// UrlTypeFlinkDashboardUrl is a UrlType enum value
	UrlTypeFlinkDashboardUrl = "FLINK_DASHBOARD_URL"

	// UrlTypeZeppelinUiUrl is a UrlType enum value
	UrlTypeZeppelinUiUrl = "ZEPPELIN_UI_URL"
)

// UrlType_Values returns all elements of the UrlType enum
func UrlType_Values() []string {
	return []string{
		UrlTypeFlinkDashboardUrl,
		UrlTypeZeppelinUiUrl,
	}
}
