/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// KubernetesClusterPropertiesForPost struct for KubernetesClusterPropertiesForPost
type KubernetesClusterPropertiesForPost struct {
	// A Kubernetes cluster name. Valid Kubernetes cluster name must be 63 characters or less and must be empty or begin and end with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.
	Name *string `json:"name"`
	// The Kubernetes version that the cluster is running. This limits which Kubernetes versions can run in a cluster's node pools. Also, not all Kubernetes versions are suitable upgrade targets for all earlier versions.
	K8sVersion        *string                      `json:"k8sVersion,omitempty"`
	MaintenanceWindow *KubernetesMaintenanceWindow `json:"maintenanceWindow,omitempty"`
	// The indicator whether the cluster is public or private. Note that the status FALSE is still in the beta phase.
	Public *bool `json:"public,omitempty"`
	// This attribute is mandatory if the cluster is private and optional if the cluster is public. The location must be enabled for your contract, or you must have a data center at that location. This property is not adjustable.
	Location *string `json:"location,omitempty"`
	// The nat gateway IP of the cluster if the cluster is private. This property is immutable. Must be a reserved IP in the same location as the cluster's location. This attribute is mandatory if the cluster is private.
	NatGatewayIp *string `json:"natGatewayIp,omitempty"`
	// The node subnet of the cluster, if the cluster is private. This property is optional and immutable. Must be a valid CIDR notation for an IPv4 network prefix of 16 bits length.
	NodeSubnet *string `json:"nodeSubnet,omitempty"`
	// Access to the K8s API server is restricted to these CIDRs. Intra-cluster traffic is not affected by this restriction. If no AllowList is specified, access is not limited. If an IP is specified without a subnet mask, the default value is 32 for IPv4 and 128 for IPv6.
	ApiSubnetAllowList *[]string `json:"apiSubnetAllowList,omitempty"`
	// List of S3 buckets configured for K8s usage. At the moment, it contains only one S3 bucket that is used to store K8s API audit logs.
	S3Buckets *[]S3Bucket `json:"s3Buckets,omitempty"`
}

// NewKubernetesClusterPropertiesForPost instantiates a new KubernetesClusterPropertiesForPost object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKubernetesClusterPropertiesForPost(name string) *KubernetesClusterPropertiesForPost {
	this := KubernetesClusterPropertiesForPost{}

	this.Name = &name
	var public bool = true
	this.Public = &public

	return &this
}

// NewKubernetesClusterPropertiesForPostWithDefaults instantiates a new KubernetesClusterPropertiesForPost object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKubernetesClusterPropertiesForPostWithDefaults() *KubernetesClusterPropertiesForPost {
	this := KubernetesClusterPropertiesForPost{}
	var public bool = true
	this.Public = &public
	return &this
}

// GetName returns the Name field value
// If the value is explicit nil, nil is returned
func (o *KubernetesClusterPropertiesForPost) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name

}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesClusterPropertiesForPost) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Name, true
}

// SetName sets field value
func (o *KubernetesClusterPropertiesForPost) SetName(v string) {

	o.Name = &v

}

// HasName returns a boolean if a field has been set.
func (o *KubernetesClusterPropertiesForPost) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// GetK8sVersion returns the K8sVersion field value
// If the value is explicit nil, nil is returned
func (o *KubernetesClusterPropertiesForPost) GetK8sVersion() *string {
	if o == nil {
		return nil
	}

	return o.K8sVersion

}

// GetK8sVersionOk returns a tuple with the K8sVersion field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesClusterPropertiesForPost) GetK8sVersionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.K8sVersion, true
}

// SetK8sVersion sets field value
func (o *KubernetesClusterPropertiesForPost) SetK8sVersion(v string) {

	o.K8sVersion = &v

}

// HasK8sVersion returns a boolean if a field has been set.
func (o *KubernetesClusterPropertiesForPost) HasK8sVersion() bool {
	if o != nil && o.K8sVersion != nil {
		return true
	}

	return false
}

// GetMaintenanceWindow returns the MaintenanceWindow field value
// If the value is explicit nil, nil is returned
func (o *KubernetesClusterPropertiesForPost) GetMaintenanceWindow() *KubernetesMaintenanceWindow {
	if o == nil {
		return nil
	}

	return o.MaintenanceWindow

}

// GetMaintenanceWindowOk returns a tuple with the MaintenanceWindow field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesClusterPropertiesForPost) GetMaintenanceWindowOk() (*KubernetesMaintenanceWindow, bool) {
	if o == nil {
		return nil, false
	}

	return o.MaintenanceWindow, true
}

// SetMaintenanceWindow sets field value
func (o *KubernetesClusterPropertiesForPost) SetMaintenanceWindow(v KubernetesMaintenanceWindow) {

	o.MaintenanceWindow = &v

}

// HasMaintenanceWindow returns a boolean if a field has been set.
func (o *KubernetesClusterPropertiesForPost) HasMaintenanceWindow() bool {
	if o != nil && o.MaintenanceWindow != nil {
		return true
	}

	return false
}

// GetPublic returns the Public field value
// If the value is explicit nil, nil is returned
func (o *KubernetesClusterPropertiesForPost) GetPublic() *bool {
	if o == nil {
		return nil
	}

	return o.Public

}

// GetPublicOk returns a tuple with the Public field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesClusterPropertiesForPost) GetPublicOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}

	return o.Public, true
}

// SetPublic sets field value
func (o *KubernetesClusterPropertiesForPost) SetPublic(v bool) {

	o.Public = &v

}

// HasPublic returns a boolean if a field has been set.
func (o *KubernetesClusterPropertiesForPost) HasPublic() bool {
	if o != nil && o.Public != nil {
		return true
	}

	return false
}

// GetLocation returns the Location field value
// If the value is explicit nil, nil is returned
func (o *KubernetesClusterPropertiesForPost) GetLocation() *string {
	if o == nil {
		return nil
	}

	return o.Location

}

// GetLocationOk returns a tuple with the Location field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesClusterPropertiesForPost) GetLocationOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Location, true
}

// SetLocation sets field value
func (o *KubernetesClusterPropertiesForPost) SetLocation(v string) {

	o.Location = &v

}

// HasLocation returns a boolean if a field has been set.
func (o *KubernetesClusterPropertiesForPost) HasLocation() bool {
	if o != nil && o.Location != nil {
		return true
	}

	return false
}

// GetNatGatewayIp returns the NatGatewayIp field value
// If the value is explicit nil, nil is returned
func (o *KubernetesClusterPropertiesForPost) GetNatGatewayIp() *string {
	if o == nil {
		return nil
	}

	return o.NatGatewayIp

}

// GetNatGatewayIpOk returns a tuple with the NatGatewayIp field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesClusterPropertiesForPost) GetNatGatewayIpOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.NatGatewayIp, true
}

// SetNatGatewayIp sets field value
func (o *KubernetesClusterPropertiesForPost) SetNatGatewayIp(v string) {

	o.NatGatewayIp = &v

}

// HasNatGatewayIp returns a boolean if a field has been set.
func (o *KubernetesClusterPropertiesForPost) HasNatGatewayIp() bool {
	if o != nil && o.NatGatewayIp != nil {
		return true
	}

	return false
}

// GetNodeSubnet returns the NodeSubnet field value
// If the value is explicit nil, nil is returned
func (o *KubernetesClusterPropertiesForPost) GetNodeSubnet() *string {
	if o == nil {
		return nil
	}

	return o.NodeSubnet

}

// GetNodeSubnetOk returns a tuple with the NodeSubnet field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesClusterPropertiesForPost) GetNodeSubnetOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.NodeSubnet, true
}

// SetNodeSubnet sets field value
func (o *KubernetesClusterPropertiesForPost) SetNodeSubnet(v string) {

	o.NodeSubnet = &v

}

// HasNodeSubnet returns a boolean if a field has been set.
func (o *KubernetesClusterPropertiesForPost) HasNodeSubnet() bool {
	if o != nil && o.NodeSubnet != nil {
		return true
	}

	return false
}

// GetApiSubnetAllowList returns the ApiSubnetAllowList field value
// If the value is explicit nil, nil is returned
func (o *KubernetesClusterPropertiesForPost) GetApiSubnetAllowList() *[]string {
	if o == nil {
		return nil
	}

	return o.ApiSubnetAllowList

}

// GetApiSubnetAllowListOk returns a tuple with the ApiSubnetAllowList field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesClusterPropertiesForPost) GetApiSubnetAllowListOk() (*[]string, bool) {
	if o == nil {
		return nil, false
	}

	return o.ApiSubnetAllowList, true
}

// SetApiSubnetAllowList sets field value
func (o *KubernetesClusterPropertiesForPost) SetApiSubnetAllowList(v []string) {

	o.ApiSubnetAllowList = &v

}

// HasApiSubnetAllowList returns a boolean if a field has been set.
func (o *KubernetesClusterPropertiesForPost) HasApiSubnetAllowList() bool {
	if o != nil && o.ApiSubnetAllowList != nil {
		return true
	}

	return false
}

// GetS3Buckets returns the S3Buckets field value
// If the value is explicit nil, nil is returned
func (o *KubernetesClusterPropertiesForPost) GetS3Buckets() *[]S3Bucket {
	if o == nil {
		return nil
	}

	return o.S3Buckets

}

// GetS3BucketsOk returns a tuple with the S3Buckets field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *KubernetesClusterPropertiesForPost) GetS3BucketsOk() (*[]S3Bucket, bool) {
	if o == nil {
		return nil, false
	}

	return o.S3Buckets, true
}

// SetS3Buckets sets field value
func (o *KubernetesClusterPropertiesForPost) SetS3Buckets(v []S3Bucket) {

	o.S3Buckets = &v

}

// HasS3Buckets returns a boolean if a field has been set.
func (o *KubernetesClusterPropertiesForPost) HasS3Buckets() bool {
	if o != nil && o.S3Buckets != nil {
		return true
	}

	return false
}

func (o KubernetesClusterPropertiesForPost) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Name != nil {
		toSerialize["name"] = o.Name
	}

	if o.K8sVersion != nil {
		toSerialize["k8sVersion"] = o.K8sVersion
	}

	if o.MaintenanceWindow != nil {
		toSerialize["maintenanceWindow"] = o.MaintenanceWindow
	}

	if o.Public != nil {
		toSerialize["public"] = o.Public
	}

	if o.Location != nil {
		toSerialize["location"] = o.Location
	}

	if o.NatGatewayIp != nil {
		toSerialize["natGatewayIp"] = o.NatGatewayIp
	}

	if o.NodeSubnet != nil {
		toSerialize["nodeSubnet"] = o.NodeSubnet
	}

	if o.ApiSubnetAllowList != nil {
		toSerialize["apiSubnetAllowList"] = o.ApiSubnetAllowList
	}

	if o.S3Buckets != nil {
		toSerialize["s3Buckets"] = o.S3Buckets
	}

	return json.Marshal(toSerialize)
}

type NullableKubernetesClusterPropertiesForPost struct {
	value *KubernetesClusterPropertiesForPost
	isSet bool
}

func (v NullableKubernetesClusterPropertiesForPost) Get() *KubernetesClusterPropertiesForPost {
	return v.value
}

func (v *NullableKubernetesClusterPropertiesForPost) Set(val *KubernetesClusterPropertiesForPost) {
	v.value = val
	v.isSet = true
}

func (v NullableKubernetesClusterPropertiesForPost) IsSet() bool {
	return v.isSet
}

func (v *NullableKubernetesClusterPropertiesForPost) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKubernetesClusterPropertiesForPost(val *KubernetesClusterPropertiesForPost) *NullableKubernetesClusterPropertiesForPost {
	return &NullableKubernetesClusterPropertiesForPost{value: val, isSet: true}
}

func (v NullableKubernetesClusterPropertiesForPost) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKubernetesClusterPropertiesForPost) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
