#!/bin/bash

# updates commonInitialisms from most recent go lint source.

SRC=$(realpath $(cd -P "$( dirname "${BASH_SOURCE[0]}" )" && pwd ))

PKG="golang.org/x/lint"
PKGPATH="$(go env GOPATH)/src/$PKG"
OUT=$SRC/initialisms.go

set -e

# get latest revision
if [ "$1" == "--update" ]; then
  pushd $PKGPATH &> /dev/null
  git reset --hard
  git pull
  popd &> /dev/null
fi

# get git rev info
pushd $PKGPATH &> /dev/null
PKGVER=$(git rev-parse --short master)
popd &> /dev/null

DATA="package $(basename $SRC)

// Code generated by gen.sh. DO NOT EDIT.

// commonInitialisms is the set of commonInitialisms.
//
// taken from: $PKG @ $PKGVER
$(sed '/{/{:1; /}/!{N; b1}; /var commonInitialisms/p}; d' $PKGPATH/lint.go)"

echo "$DATA" > $OUT

gofmt -w -s $OUT
