// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/asset/v1p2beta1/asset_service.proto

package asset

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Asset content type.
type ContentType int32

const (
	// Unspecified content type.
	ContentType_CONTENT_TYPE_UNSPECIFIED ContentType = 0
	// Resource metadata.
	ContentType_RESOURCE ContentType = 1
	// The actual IAM policy set on a resource.
	ContentType_IAM_POLICY ContentType = 2
	// The IAM policy name for the IAM policy set on a resource.
	ContentType_IAM_POLICY_NAME ContentType = 3
	ContentType_ORG_POLICY      ContentType = 4
	// The Cloud Access context mananger Policy set on an asset.
	ContentType_ACCESS_POLICY ContentType = 5
)

var ContentType_name = map[int32]string{
	0: "CONTENT_TYPE_UNSPECIFIED",
	1: "RESOURCE",
	2: "IAM_POLICY",
	3: "IAM_POLICY_NAME",
	4: "ORG_POLICY",
	5: "ACCESS_POLICY",
}

var ContentType_value = map[string]int32{
	"CONTENT_TYPE_UNSPECIFIED": 0,
	"RESOURCE":                 1,
	"IAM_POLICY":               2,
	"IAM_POLICY_NAME":          3,
	"ORG_POLICY":               4,
	"ACCESS_POLICY":            5,
}

func (x ContentType) String() string {
	return proto.EnumName(ContentType_name, int32(x))
}

func (ContentType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{0}
}

// Export asset request.
type ExportAssetsRequest struct {
	// Required. The relative name of the root asset. This can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Timestamp to take an asset snapshot. This can only be set to a timestamp
	// between 2018-10-02 UTC (inclusive) and the current time. If not specified,
	// the current time will be used. Due to delays in resource data collection
	// and indexing, there is a volatile window during which running the same
	// query may get different results.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// A list of asset types of which to take a snapshot for. For example:
	// "compute.googleapis.com/Disk". If specified, only matching assets will be
	// returned. See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/resource-manager/docs/cloud-asset-inventory/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name will be
	// returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1p2beta1.ContentType" json:"content_type,omitempty"`
	// Required. Output configuration indicating where the results will be output
	// to. All results will be in newline delimited JSON format.
	OutputConfig         *OutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportAssetsRequest) Reset()         { *m = ExportAssetsRequest{} }
func (m *ExportAssetsRequest) String() string { return proto.CompactTextString(m) }
func (*ExportAssetsRequest) ProtoMessage()    {}
func (*ExportAssetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{0}
}

func (m *ExportAssetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportAssetsRequest.Unmarshal(m, b)
}
func (m *ExportAssetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportAssetsRequest.Marshal(b, m, deterministic)
}
func (m *ExportAssetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportAssetsRequest.Merge(m, src)
}
func (m *ExportAssetsRequest) XXX_Size() int {
	return xxx_messageInfo_ExportAssetsRequest.Size(m)
}
func (m *ExportAssetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportAssetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportAssetsRequest proto.InternalMessageInfo

func (m *ExportAssetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ExportAssetsRequest) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ExportAssetsRequest) GetAssetTypes() []string {
	if m != nil {
		return m.AssetTypes
	}
	return nil
}

func (m *ExportAssetsRequest) GetContentType() ContentType {
	if m != nil {
		return m.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (m *ExportAssetsRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// The export asset response. This message is returned by the
// [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation] method in the returned
// [google.longrunning.Operation.response][google.longrunning.Operation.response] field.
type ExportAssetsResponse struct {
	// Time the snapshot was taken.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Output configuration indicating where the results were output to.
	// All results are in JSON format.
	OutputConfig         *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportAssetsResponse) Reset()         { *m = ExportAssetsResponse{} }
func (m *ExportAssetsResponse) String() string { return proto.CompactTextString(m) }
func (*ExportAssetsResponse) ProtoMessage()    {}
func (*ExportAssetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{1}
}

func (m *ExportAssetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportAssetsResponse.Unmarshal(m, b)
}
func (m *ExportAssetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportAssetsResponse.Marshal(b, m, deterministic)
}
func (m *ExportAssetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportAssetsResponse.Merge(m, src)
}
func (m *ExportAssetsResponse) XXX_Size() int {
	return xxx_messageInfo_ExportAssetsResponse.Size(m)
}
func (m *ExportAssetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportAssetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportAssetsResponse proto.InternalMessageInfo

func (m *ExportAssetsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ExportAssetsResponse) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Batch get assets history request.
type BatchGetAssetsHistoryRequest struct {
	// Required. The relative name of the root asset. It can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id")", or a project number (such as "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A list of the full names of the assets. For example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// and [Resource Name
	// Format](https://cloud.google.com/resource-manager/docs/cloud-asset-inventory/resource-name-format)
	// for more info.
	//
	// The request becomes a no-op if the asset name list is empty, and the max
	// size of the asset name list is 100 in one request.
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// Required. The content type.
	ContentType ContentType `protobuf:"varint,3,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1p2beta1.ContentType" json:"content_type,omitempty"`
	// Optional. The time window for the asset history. Both start_time and
	// end_time are optional and if set, it must be after 2018-10-02 UTC. If
	// end_time is not set, it is default to current timestamp. If start_time is
	// not set, the snapshot of the assets at end_time will be returned. The
	// returned results contain all temporal assets whose time window overlap with
	// read_time_window.
	ReadTimeWindow       *TimeWindow `protobuf:"bytes,4,opt,name=read_time_window,json=readTimeWindow,proto3" json:"read_time_window,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *BatchGetAssetsHistoryRequest) Reset()         { *m = BatchGetAssetsHistoryRequest{} }
func (m *BatchGetAssetsHistoryRequest) String() string { return proto.CompactTextString(m) }
func (*BatchGetAssetsHistoryRequest) ProtoMessage()    {}
func (*BatchGetAssetsHistoryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{2}
}

func (m *BatchGetAssetsHistoryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchGetAssetsHistoryRequest.Unmarshal(m, b)
}
func (m *BatchGetAssetsHistoryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchGetAssetsHistoryRequest.Marshal(b, m, deterministic)
}
func (m *BatchGetAssetsHistoryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchGetAssetsHistoryRequest.Merge(m, src)
}
func (m *BatchGetAssetsHistoryRequest) XXX_Size() int {
	return xxx_messageInfo_BatchGetAssetsHistoryRequest.Size(m)
}
func (m *BatchGetAssetsHistoryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchGetAssetsHistoryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchGetAssetsHistoryRequest proto.InternalMessageInfo

func (m *BatchGetAssetsHistoryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchGetAssetsHistoryRequest) GetAssetNames() []string {
	if m != nil {
		return m.AssetNames
	}
	return nil
}

func (m *BatchGetAssetsHistoryRequest) GetContentType() ContentType {
	if m != nil {
		return m.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (m *BatchGetAssetsHistoryRequest) GetReadTimeWindow() *TimeWindow {
	if m != nil {
		return m.ReadTimeWindow
	}
	return nil
}

// Batch get assets history response.
type BatchGetAssetsHistoryResponse struct {
	// A list of assets with valid time windows.
	Assets               []*TemporalAsset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *BatchGetAssetsHistoryResponse) Reset()         { *m = BatchGetAssetsHistoryResponse{} }
func (m *BatchGetAssetsHistoryResponse) String() string { return proto.CompactTextString(m) }
func (*BatchGetAssetsHistoryResponse) ProtoMessage()    {}
func (*BatchGetAssetsHistoryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{3}
}

func (m *BatchGetAssetsHistoryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchGetAssetsHistoryResponse.Unmarshal(m, b)
}
func (m *BatchGetAssetsHistoryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchGetAssetsHistoryResponse.Marshal(b, m, deterministic)
}
func (m *BatchGetAssetsHistoryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchGetAssetsHistoryResponse.Merge(m, src)
}
func (m *BatchGetAssetsHistoryResponse) XXX_Size() int {
	return xxx_messageInfo_BatchGetAssetsHistoryResponse.Size(m)
}
func (m *BatchGetAssetsHistoryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchGetAssetsHistoryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchGetAssetsHistoryResponse proto.InternalMessageInfo

func (m *BatchGetAssetsHistoryResponse) GetAssets() []*TemporalAsset {
	if m != nil {
		return m.Assets
	}
	return nil
}

// Create asset feed request.
type CreateFeedRequest struct {
	// Required. The name of the project/folder/organization where this feed
	// should be created in. It can only be an organization number (such as
	// "organizations/123"), a folder number (such as "folders/123"), a project ID
	// (such as "projects/my-project-id")", or a project number (such as
	// "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. This is the client-assigned asset feed identifier and it needs to
	// be unique under a specific parent project/folder/organization.
	FeedId string `protobuf:"bytes,2,opt,name=feed_id,json=feedId,proto3" json:"feed_id,omitempty"`
	// The feed details. The field `name` must be empty and it will be generated
	// in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Feed                 *Feed    `protobuf:"bytes,3,opt,name=feed,proto3" json:"feed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFeedRequest) Reset()         { *m = CreateFeedRequest{} }
func (m *CreateFeedRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFeedRequest) ProtoMessage()    {}
func (*CreateFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{4}
}

func (m *CreateFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFeedRequest.Unmarshal(m, b)
}
func (m *CreateFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFeedRequest.Marshal(b, m, deterministic)
}
func (m *CreateFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFeedRequest.Merge(m, src)
}
func (m *CreateFeedRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFeedRequest.Size(m)
}
func (m *CreateFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFeedRequest proto.InternalMessageInfo

func (m *CreateFeedRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateFeedRequest) GetFeedId() string {
	if m != nil {
		return m.FeedId
	}
	return ""
}

func (m *CreateFeedRequest) GetFeed() *Feed {
	if m != nil {
		return m.Feed
	}
	return nil
}

// Get asset feed request.
type GetFeedRequest struct {
	// The name of the Feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFeedRequest) Reset()         { *m = GetFeedRequest{} }
func (m *GetFeedRequest) String() string { return proto.CompactTextString(m) }
func (*GetFeedRequest) ProtoMessage()    {}
func (*GetFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{5}
}

func (m *GetFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFeedRequest.Unmarshal(m, b)
}
func (m *GetFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFeedRequest.Marshal(b, m, deterministic)
}
func (m *GetFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFeedRequest.Merge(m, src)
}
func (m *GetFeedRequest) XXX_Size() int {
	return xxx_messageInfo_GetFeedRequest.Size(m)
}
func (m *GetFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFeedRequest proto.InternalMessageInfo

func (m *GetFeedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// List asset feeds request.
type ListFeedsRequest struct {
	// Required. The parent project/folder/organization whose feeds are to be
	// listed. It can only be using project/folder/organization number (such as
	// "folders/12345")", or a project ID (such as "projects/my-project-id").
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFeedsRequest) Reset()         { *m = ListFeedsRequest{} }
func (m *ListFeedsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFeedsRequest) ProtoMessage()    {}
func (*ListFeedsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{6}
}

func (m *ListFeedsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFeedsRequest.Unmarshal(m, b)
}
func (m *ListFeedsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFeedsRequest.Marshal(b, m, deterministic)
}
func (m *ListFeedsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFeedsRequest.Merge(m, src)
}
func (m *ListFeedsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFeedsRequest.Size(m)
}
func (m *ListFeedsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFeedsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFeedsRequest proto.InternalMessageInfo

func (m *ListFeedsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type ListFeedsResponse struct {
	// A list of feeds.
	Feeds                []*Feed  `protobuf:"bytes,1,rep,name=feeds,proto3" json:"feeds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFeedsResponse) Reset()         { *m = ListFeedsResponse{} }
func (m *ListFeedsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFeedsResponse) ProtoMessage()    {}
func (*ListFeedsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{7}
}

func (m *ListFeedsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFeedsResponse.Unmarshal(m, b)
}
func (m *ListFeedsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFeedsResponse.Marshal(b, m, deterministic)
}
func (m *ListFeedsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFeedsResponse.Merge(m, src)
}
func (m *ListFeedsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFeedsResponse.Size(m)
}
func (m *ListFeedsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFeedsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFeedsResponse proto.InternalMessageInfo

func (m *ListFeedsResponse) GetFeeds() []*Feed {
	if m != nil {
		return m.Feeds
	}
	return nil
}

// Update asset feed request.
type UpdateFeedRequest struct {
	// The new values of feed details. It must match an existing feed and the
	// field `name` must be in the format of:
	// projects/project_number/feeds/feed_id or
	// folders/folder_number/feeds/feed_id or
	// organizations/organization_number/feeds/feed_id.
	Feed *Feed `protobuf:"bytes,1,opt,name=feed,proto3" json:"feed,omitempty"`
	// Only updates the `feed` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateFeedRequest) Reset()         { *m = UpdateFeedRequest{} }
func (m *UpdateFeedRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFeedRequest) ProtoMessage()    {}
func (*UpdateFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{8}
}

func (m *UpdateFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFeedRequest.Unmarshal(m, b)
}
func (m *UpdateFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFeedRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFeedRequest.Merge(m, src)
}
func (m *UpdateFeedRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFeedRequest.Size(m)
}
func (m *UpdateFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFeedRequest proto.InternalMessageInfo

func (m *UpdateFeedRequest) GetFeed() *Feed {
	if m != nil {
		return m.Feed
	}
	return nil
}

func (m *UpdateFeedRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteFeedRequest struct {
	// The name of the feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFeedRequest) Reset()         { *m = DeleteFeedRequest{} }
func (m *DeleteFeedRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteFeedRequest) ProtoMessage()    {}
func (*DeleteFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{9}
}

func (m *DeleteFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFeedRequest.Unmarshal(m, b)
}
func (m *DeleteFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFeedRequest.Marshal(b, m, deterministic)
}
func (m *DeleteFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFeedRequest.Merge(m, src)
}
func (m *DeleteFeedRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteFeedRequest.Size(m)
}
func (m *DeleteFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFeedRequest proto.InternalMessageInfo

func (m *DeleteFeedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Output configuration for export assets destination.
type OutputConfig struct {
	// Asset export destination.
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	//	*OutputConfig_BigqueryDestination
	Destination          isOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{10}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_BigqueryDestination struct {
	BigqueryDestination *BigQueryDestination `protobuf:"bytes,2,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (*OutputConfig_BigqueryDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (m *OutputConfig) GetBigqueryDestination() *BigQueryDestination {
	if x, ok := m.GetDestination().(*OutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OutputConfig_GcsDestination)(nil),
		(*OutputConfig_BigqueryDestination)(nil),
	}
}

// A Cloud Storage location.
type GcsDestination struct {
	// Required.
	//
	// Types that are valid to be assigned to ObjectUri:
	//	*GcsDestination_Uri
	//	*GcsDestination_UriPrefix
	ObjectUri            isGcsDestination_ObjectUri `protobuf_oneof:"object_uri"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{11}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

type isGcsDestination_ObjectUri interface {
	isGcsDestination_ObjectUri()
}

type GcsDestination_Uri struct {
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type GcsDestination_UriPrefix struct {
	UriPrefix string `protobuf:"bytes,2,opt,name=uri_prefix,json=uriPrefix,proto3,oneof"`
}

func (*GcsDestination_Uri) isGcsDestination_ObjectUri() {}

func (*GcsDestination_UriPrefix) isGcsDestination_ObjectUri() {}

func (m *GcsDestination) GetObjectUri() isGcsDestination_ObjectUri {
	if m != nil {
		return m.ObjectUri
	}
	return nil
}

func (m *GcsDestination) GetUri() string {
	if x, ok := m.GetObjectUri().(*GcsDestination_Uri); ok {
		return x.Uri
	}
	return ""
}

func (m *GcsDestination) GetUriPrefix() string {
	if x, ok := m.GetObjectUri().(*GcsDestination_UriPrefix); ok {
		return x.UriPrefix
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GcsDestination) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GcsDestination_Uri)(nil),
		(*GcsDestination_UriPrefix)(nil),
	}
}

// A Bigquery destination.
type BigQueryDestination struct {
	// Required. The BigQuery dataset in format
	// "projects/projectId/datasets/datasetId", to which the snapshot result
	// should be exported. If this dataset does not exist, the export call returns
	// an error.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The BigQuery table to which the snapshot result should be
	// written. If this table does not exist, a new table with the given name
	// will be created.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
	// If the destination table already exists and this flag is `TRUE`, the
	// table will be overwritten by the contents of assets snapshot. If the flag
	// is not set and the destination table already exists, the export call
	// returns an error.
	Force                bool     `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BigQueryDestination) Reset()         { *m = BigQueryDestination{} }
func (m *BigQueryDestination) String() string { return proto.CompactTextString(m) }
func (*BigQueryDestination) ProtoMessage()    {}
func (*BigQueryDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{12}
}

func (m *BigQueryDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BigQueryDestination.Unmarshal(m, b)
}
func (m *BigQueryDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BigQueryDestination.Marshal(b, m, deterministic)
}
func (m *BigQueryDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BigQueryDestination.Merge(m, src)
}
func (m *BigQueryDestination) XXX_Size() int {
	return xxx_messageInfo_BigQueryDestination.Size(m)
}
func (m *BigQueryDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_BigQueryDestination.DiscardUnknown(m)
}

var xxx_messageInfo_BigQueryDestination proto.InternalMessageInfo

func (m *BigQueryDestination) GetDataset() string {
	if m != nil {
		return m.Dataset
	}
	return ""
}

func (m *BigQueryDestination) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *BigQueryDestination) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// A Cloud Pubsub destination.
type PubsubDestination struct {
	// The name of the Cloud Pub/Sub topic to publish to.
	// For example: `projects/PROJECT_ID/topics/TOPIC_ID`.
	Topic                string   `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PubsubDestination) Reset()         { *m = PubsubDestination{} }
func (m *PubsubDestination) String() string { return proto.CompactTextString(m) }
func (*PubsubDestination) ProtoMessage()    {}
func (*PubsubDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{13}
}

func (m *PubsubDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PubsubDestination.Unmarshal(m, b)
}
func (m *PubsubDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PubsubDestination.Marshal(b, m, deterministic)
}
func (m *PubsubDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PubsubDestination.Merge(m, src)
}
func (m *PubsubDestination) XXX_Size() int {
	return xxx_messageInfo_PubsubDestination.Size(m)
}
func (m *PubsubDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_PubsubDestination.DiscardUnknown(m)
}

var xxx_messageInfo_PubsubDestination proto.InternalMessageInfo

func (m *PubsubDestination) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// Output configuration for asset feed destination.
type FeedOutputConfig struct {
	// Asset feed destination.
	//
	// Types that are valid to be assigned to Destination:
	//	*FeedOutputConfig_PubsubDestination
	Destination          isFeedOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *FeedOutputConfig) Reset()         { *m = FeedOutputConfig{} }
func (m *FeedOutputConfig) String() string { return proto.CompactTextString(m) }
func (*FeedOutputConfig) ProtoMessage()    {}
func (*FeedOutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{14}
}

func (m *FeedOutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FeedOutputConfig.Unmarshal(m, b)
}
func (m *FeedOutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FeedOutputConfig.Marshal(b, m, deterministic)
}
func (m *FeedOutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeedOutputConfig.Merge(m, src)
}
func (m *FeedOutputConfig) XXX_Size() int {
	return xxx_messageInfo_FeedOutputConfig.Size(m)
}
func (m *FeedOutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FeedOutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FeedOutputConfig proto.InternalMessageInfo

type isFeedOutputConfig_Destination interface {
	isFeedOutputConfig_Destination()
}

type FeedOutputConfig_PubsubDestination struct {
	PubsubDestination *PubsubDestination `protobuf:"bytes,1,opt,name=pubsub_destination,json=pubsubDestination,proto3,oneof"`
}

func (*FeedOutputConfig_PubsubDestination) isFeedOutputConfig_Destination() {}

func (m *FeedOutputConfig) GetDestination() isFeedOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *FeedOutputConfig) GetPubsubDestination() *PubsubDestination {
	if x, ok := m.GetDestination().(*FeedOutputConfig_PubsubDestination); ok {
		return x.PubsubDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*FeedOutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*FeedOutputConfig_PubsubDestination)(nil),
	}
}

// An asset feed used to export asset updates to a destinations.
// An asset feed filter controls what updates are exported.
// The asset feed must be created within a project, organization, or
// folder. Supported destinations are:
// Cloud Pub/Sub topics.
type Feed struct {
	// Required. The format will be
	// projects/{project_number}/feeds/{client-assigned_feed_identifier} or
	// folders/{folder_number}/feeds/{client-assigned_feed_identifier} or
	// organizations/{organization_number}/feeds/{client-assigned_feed_identifier}
	//
	// The client-assigned feed identifier must be unique within the parent
	// project/folder/organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of the full names of the assets to receive updates. You must specify
	// either or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names and asset_types are exported to the feed. For
	// example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more info.
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// A list of types of the assets to receive updates. You must specify either
	// or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names and asset_types are exported to the feed.
	// For example:
	// "compute.googleapis.com/Disk" See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/resource-manager/docs/cloud-asset-inventory/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name and
	// type will be returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1p2beta1.ContentType" json:"content_type,omitempty"`
	// Required. Feed output configuration defining where the asset updates are
	// published to.
	FeedOutputConfig     *FeedOutputConfig `protobuf:"bytes,5,opt,name=feed_output_config,json=feedOutputConfig,proto3" json:"feed_output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Feed) Reset()         { *m = Feed{} }
func (m *Feed) String() string { return proto.CompactTextString(m) }
func (*Feed) ProtoMessage()    {}
func (*Feed) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{15}
}

func (m *Feed) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Feed.Unmarshal(m, b)
}
func (m *Feed) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Feed.Marshal(b, m, deterministic)
}
func (m *Feed) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Feed.Merge(m, src)
}
func (m *Feed) XXX_Size() int {
	return xxx_messageInfo_Feed.Size(m)
}
func (m *Feed) XXX_DiscardUnknown() {
	xxx_messageInfo_Feed.DiscardUnknown(m)
}

var xxx_messageInfo_Feed proto.InternalMessageInfo

func (m *Feed) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Feed) GetAssetNames() []string {
	if m != nil {
		return m.AssetNames
	}
	return nil
}

func (m *Feed) GetAssetTypes() []string {
	if m != nil {
		return m.AssetTypes
	}
	return nil
}

func (m *Feed) GetContentType() ContentType {
	if m != nil {
		return m.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (m *Feed) GetFeedOutputConfig() *FeedOutputConfig {
	if m != nil {
		return m.FeedOutputConfig
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.asset.v1p2beta1.ContentType", ContentType_name, ContentType_value)
	proto.RegisterType((*ExportAssetsRequest)(nil), "google.cloud.asset.v1p2beta1.ExportAssetsRequest")
	proto.RegisterType((*ExportAssetsResponse)(nil), "google.cloud.asset.v1p2beta1.ExportAssetsResponse")
	proto.RegisterType((*BatchGetAssetsHistoryRequest)(nil), "google.cloud.asset.v1p2beta1.BatchGetAssetsHistoryRequest")
	proto.RegisterType((*BatchGetAssetsHistoryResponse)(nil), "google.cloud.asset.v1p2beta1.BatchGetAssetsHistoryResponse")
	proto.RegisterType((*CreateFeedRequest)(nil), "google.cloud.asset.v1p2beta1.CreateFeedRequest")
	proto.RegisterType((*GetFeedRequest)(nil), "google.cloud.asset.v1p2beta1.GetFeedRequest")
	proto.RegisterType((*ListFeedsRequest)(nil), "google.cloud.asset.v1p2beta1.ListFeedsRequest")
	proto.RegisterType((*ListFeedsResponse)(nil), "google.cloud.asset.v1p2beta1.ListFeedsResponse")
	proto.RegisterType((*UpdateFeedRequest)(nil), "google.cloud.asset.v1p2beta1.UpdateFeedRequest")
	proto.RegisterType((*DeleteFeedRequest)(nil), "google.cloud.asset.v1p2beta1.DeleteFeedRequest")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.asset.v1p2beta1.OutputConfig")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.asset.v1p2beta1.GcsDestination")
	proto.RegisterType((*BigQueryDestination)(nil), "google.cloud.asset.v1p2beta1.BigQueryDestination")
	proto.RegisterType((*PubsubDestination)(nil), "google.cloud.asset.v1p2beta1.PubsubDestination")
	proto.RegisterType((*FeedOutputConfig)(nil), "google.cloud.asset.v1p2beta1.FeedOutputConfig")
	proto.RegisterType((*Feed)(nil), "google.cloud.asset.v1p2beta1.Feed")
}

func init() {
	proto.RegisterFile("google/cloud/asset/v1p2beta1/asset_service.proto", fileDescriptor_266ed218574f68b8)
}

var fileDescriptor_266ed218574f68b8 = []byte{
	// 1314 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x57, 0xcd, 0x6e, 0xdb, 0x46,
	0x10, 0x36, 0xe5, 0x9f, 0xd8, 0x23, 0xc5, 0x91, 0xd6, 0x69, 0xa2, 0xaa, 0x0e, 0x2c, 0xb0, 0x29,
	0x22, 0xab, 0x0d, 0x59, 0xab, 0xe8, 0x0f, 0x1c, 0xf4, 0x20, 0x29, 0x8a, 0x6d, 0x20, 0xb6, 0x54,
	0xda, 0x69, 0x90, 0xd6, 0x00, 0x4b, 0x51, 0x2b, 0x86, 0x8d, 0xc4, 0x65, 0xc8, 0x65, 0x1c, 0xa3,
	0xc9, 0xa1, 0xe9, 0x25, 0x40, 0x2f, 0x2d, 0xf2, 0x02, 0x3d, 0xf5, 0xd0, 0x27, 0xe8, 0x1b, 0x14,
	0xc8, 0xb1, 0xbd, 0xf7, 0xd4, 0x57, 0xe8, 0xa1, 0xb7, 0x62, 0x77, 0x49, 0x8b, 0xfa, 0xb1, 0xe8,
	0x34, 0x40, 0x6f, 0x9a, 0xdd, 0x99, 0xf9, 0xbe, 0xfd, 0x46, 0x3b, 0xb3, 0x84, 0xf7, 0x2d, 0x42,
	0xac, 0x1e, 0x56, 0xcd, 0x1e, 0x09, 0x3a, 0xaa, 0xe1, 0xfb, 0x98, 0xaa, 0x8f, 0x36, 0xdc, 0x4a,
	0x1b, 0x53, 0x63, 0x43, 0xd8, 0xba, 0x8f, 0xbd, 0x47, 0xb6, 0x89, 0x15, 0xd7, 0x23, 0x94, 0xa0,
	0x55, 0x11, 0xa1, 0xf0, 0x08, 0x85, 0x7b, 0x28, 0x27, 0x11, 0x85, 0x70, 0x57, 0x35, 0x5c, 0x5b,
	0x35, 0x1c, 0x87, 0x50, 0x83, 0xda, 0xc4, 0xf1, 0x45, 0x6c, 0x61, 0x3d, 0x19, 0x2d, 0x72, 0x7d,
	0x3b, 0x74, 0xed, 0x11, 0xc7, 0xf2, 0x02, 0xc7, 0xb1, 0x1d, 0x4b, 0x25, 0x2e, 0xf6, 0x86, 0xf2,
	0xbd, 0x15, 0x3a, 0x71, 0xab, 0x1d, 0x74, 0x55, 0xdc, 0x77, 0xe9, 0x71, 0xb8, 0x59, 0x1c, 0xdd,
	0xec, 0xda, 0xb8, 0xd7, 0xd1, 0xfb, 0x86, 0xff, 0x20, 0xf4, 0x58, 0x1b, 0xf5, 0xa0, 0x76, 0x1f,
	0xfb, 0xd4, 0xe8, 0xbb, 0xa1, 0xc3, 0xe5, 0xd8, 0x69, 0xcc, 0x9e, 0x8d, 0x1d, 0x2a, 0x36, 0xe4,
	0x9f, 0x53, 0xb0, 0xd2, 0x78, 0xec, 0x12, 0x8f, 0x56, 0x39, 0x69, 0x0d, 0x3f, 0x0c, 0xb0, 0x4f,
	0xd1, 0x25, 0x58, 0x70, 0x0d, 0x0f, 0x3b, 0x34, 0x2f, 0x15, 0xa5, 0xd2, 0x92, 0x16, 0x5a, 0xe8,
	0x63, 0x58, 0xf2, 0xb0, 0xd1, 0xd1, 0x19, 0x40, 0x3e, 0x55, 0x94, 0x4a, 0xe9, 0x4a, 0x41, 0x09,
	0x85, 0x8c, 0xd0, 0x95, 0x83, 0x08, 0x5d, 0x5b, 0x64, 0xce, 0xcc, 0x44, 0x6b, 0x90, 0x16, 0x45,
	0xa0, 0xc7, 0x2e, 0xf6, 0xf3, 0xb3, 0xc5, 0xd9, 0xd2, 0x92, 0x06, 0x7c, 0xe9, 0x80, 0xad, 0xa0,
	0xdb, 0x90, 0x31, 0x89, 0x43, 0xb1, 0x23, 0x5c, 0xf2, 0x73, 0x45, 0xa9, 0xb4, 0x5c, 0x59, 0x57,
	0xa6, 0x55, 0x49, 0xa9, 0x8b, 0x08, 0x96, 0x41, 0x4b, 0x9b, 0x03, 0x03, 0x35, 0xe1, 0x3c, 0x09,
	0xa8, 0x1b, 0x50, 0xdd, 0x24, 0x4e, 0xd7, 0xb6, 0xf2, 0xf3, 0x9c, 0x6b, 0x79, 0x7a, 0xba, 0x26,
	0x0f, 0xa9, 0xf3, 0x08, 0x2d, 0x43, 0x62, 0x96, 0xfc, 0x93, 0x04, 0x17, 0x87, 0x85, 0xf2, 0x5d,
	0xe2, 0xf8, 0x78, 0x58, 0x11, 0xe9, 0x15, 0x14, 0x19, 0xa3, 0x98, 0x7a, 0x4d, 0x8a, 0xff, 0x48,
	0xb0, 0x5a, 0x33, 0xa8, 0x79, 0x7f, 0x0b, 0x87, 0x24, 0xb7, 0x6d, 0x9f, 0x12, 0xef, 0x38, 0xa9,
	0xa8, 0x27, 0xb5, 0x71, 0x8c, 0x3e, 0xf6, 0xf3, 0xa9, 0x58, 0x6d, 0xf6, 0xd8, 0xca, 0x58, 0x6d,
	0x66, 0x5f, 0xab, 0x36, 0x1a, 0x64, 0x4f, 0x14, 0xd3, 0x8f, 0x6c, 0xa7, 0x43, 0x8e, 0x78, 0xb5,
	0xd3, 0x95, 0xd2, 0xf4, 0x8c, 0x4c, 0xb6, 0xbb, 0xdc, 0x5f, 0x5b, 0x8e, 0x64, 0x14, 0xb6, 0xdc,
	0x81, 0x2b, 0xa7, 0x1c, 0x3d, 0x2c, 0x53, 0x1d, 0x16, 0xc4, 0xb5, 0xcc, 0x4b, 0xc5, 0xd9, 0x52,
	0xba, 0xf2, 0x6e, 0x02, 0x14, 0xee, 0xbb, 0xc4, 0x33, 0x7a, 0x3c, 0x99, 0x16, 0x86, 0xca, 0x4f,
	0x20, 0x57, 0xf7, 0xb0, 0x41, 0xf1, 0x2d, 0x8c, 0x3b, 0x49, 0xaa, 0x5e, 0x86, 0x73, 0x5d, 0x8c,
	0x3b, 0xba, 0xdd, 0xe1, 0x95, 0x5d, 0xd2, 0x16, 0x98, 0xb9, 0xd3, 0x41, 0x1f, 0xc1, 0x1c, 0xfb,
	0xc5, 0x55, 0x4c, 0x57, 0xe4, 0xe9, 0x44, 0x38, 0x12, 0xf7, 0x97, 0xaf, 0xc2, 0xf2, 0x16, 0xa6,
	0x71, 0x68, 0x04, 0x73, 0xac, 0x64, 0x21, 0x30, 0xff, 0x2d, 0x97, 0x21, 0x7b, 0xdb, 0xf6, 0xb9,
	0x5b, 0xd2, 0x6d, 0x96, 0x77, 0x21, 0x17, 0xf3, 0x0d, 0x95, 0xfa, 0x04, 0xe6, 0x19, 0x5c, 0x24,
	0xd4, 0x59, 0xf8, 0x89, 0x00, 0xf9, 0xb9, 0x04, 0xb9, 0x3b, 0x6e, 0x67, 0x44, 0x9f, 0xe8, 0xb8,
	0xd2, 0xab, 0x1d, 0x17, 0xdd, 0x80, 0x74, 0xc0, 0x93, 0xf1, 0x4e, 0x77, 0x6a, 0xb3, 0xb9, 0xc5,
	0x9a, 0xe1, 0xae, 0xe1, 0x3f, 0xd0, 0x40, 0xb8, 0xb3, 0xdf, 0xf2, 0x35, 0xc8, 0xdd, 0xc4, 0x3d,
	0x3c, 0xcc, 0x64, 0x92, 0x5c, 0x7f, 0x4a, 0x90, 0x89, 0xdf, 0x29, 0x74, 0x17, 0x2e, 0x58, 0xa6,
	0xaf, 0x77, 0xb0, 0x4f, 0x6d, 0x87, 0x37, 0xe9, 0x90, 0xf9, 0x7b, 0xd3, 0x99, 0x6f, 0x99, 0xfe,
	0xcd, 0x41, 0xcc, 0xf6, 0x8c, 0xb6, 0x6c, 0x0d, 0xad, 0xa0, 0x2e, 0x5c, 0x6c, 0xdb, 0xd6, 0xc3,
	0x00, 0x7b, 0xc7, 0x43, 0xd9, 0xc5, 0xc1, 0x36, 0xa6, 0x67, 0xaf, 0xd9, 0xd6, 0x67, 0x2c, 0x72,
	0x18, 0x62, 0x25, 0x4a, 0x18, 0x5b, 0xae, 0x9d, 0x87, 0x74, 0x2c, 0xbd, 0xbc, 0x0f, 0xcb, 0xc3,
	0xd4, 0x10, 0x82, 0xd9, 0xc0, 0xb3, 0x85, 0x0a, 0xdb, 0x33, 0x1a, 0x33, 0xd0, 0x1a, 0x40, 0xe0,
	0xd9, 0xba, 0xeb, 0xe1, 0xae, 0xfd, 0x58, 0xfc, 0x5f, 0xb7, 0x67, 0xb4, 0xa5, 0xc0, 0xb3, 0x5b,
	0x7c, 0xa9, 0x96, 0x01, 0x20, 0xed, 0xaf, 0xb1, 0x49, 0xf5, 0xc0, 0xb3, 0xe5, 0x2f, 0x61, 0x65,
	0x02, 0x23, 0x94, 0x87, 0x73, 0x1d, 0x83, 0x1a, 0x3e, 0x8e, 0xfe, 0x68, 0x91, 0x89, 0x2e, 0xc2,
	0x3c, 0x35, 0xda, 0x3d, 0x1c, 0x5e, 0x05, 0x61, 0xb0, 0xd5, 0x2e, 0xf1, 0x4c, 0xd1, 0x50, 0x16,
	0x35, 0x61, 0xc8, 0xeb, 0x90, 0x6b, 0x05, 0x6d, 0x3f, 0x68, 0xc7, 0x53, 0xb3, 0x04, 0xc4, 0xb5,
	0xcd, 0x30, 0xb1, 0x30, 0xe4, 0xef, 0x24, 0xc8, 0xb2, 0x0a, 0x0f, 0x55, 0xf0, 0x2b, 0x40, 0x2e,
	0x8f, 0x9f, 0x50, 0x44, 0x75, 0xba, 0xcc, 0x63, 0xb8, 0xdb, 0x33, 0x5a, 0xce, 0x1d, 0x5d, 0x1c,
	0x95, 0xf8, 0x79, 0x0a, 0xe6, 0x18, 0x8b, 0x49, 0x7f, 0xb0, 0xe4, 0xe6, 0xfa, 0x3f, 0x4f, 0xc6,
	0x43, 0x40, 0xbc, 0x2d, 0x4d, 0x1a, 0x8f, 0x4a, 0xf2, 0xe5, 0x1c, 0x9a, 0x3f, 0xd9, 0xee, 0xc8,
	0x4a, 0xf9, 0x5b, 0x09, 0xd2, 0x31, 0x68, 0xb4, 0x0a, 0xf9, 0x7a, 0x73, 0xef, 0xa0, 0xb1, 0x77,
	0xa0, 0x1f, 0xdc, 0x6b, 0x35, 0xf4, 0x3b, 0x7b, 0xfb, 0xad, 0x46, 0x7d, 0xe7, 0xd6, 0x4e, 0xe3,
	0x66, 0x76, 0x06, 0x65, 0x60, 0x51, 0x6b, 0xec, 0x37, 0xef, 0x68, 0xf5, 0x46, 0x56, 0x42, 0xcb,
	0x00, 0x3b, 0xd5, 0x5d, 0xbd, 0xd5, 0xbc, 0xbd, 0x53, 0xbf, 0x97, 0x4d, 0xa1, 0x15, 0xb8, 0x30,
	0xb0, 0xf5, 0xbd, 0xea, 0x6e, 0x23, 0x3b, 0xcb, 0x9c, 0x9a, 0xda, 0x56, 0xe4, 0x34, 0x87, 0x72,
	0x70, 0xbe, 0x5a, 0xaf, 0x37, 0xf6, 0xf7, 0xa3, 0xa5, 0xf9, 0xca, 0xdf, 0x8b, 0x90, 0xe1, 0x7d,
	0x7b, 0x5f, 0xbc, 0xf7, 0xd0, 0x8f, 0x12, 0x64, 0xe2, 0xb3, 0x1b, 0x25, 0x5c, 0xb6, 0x09, 0x0f,
	0xa2, 0xc2, 0x95, 0x28, 0x24, 0xf6, 0x8e, 0x53, 0x9a, 0xd1, 0x3b, 0x4e, 0x56, 0x9f, 0xfd, 0xf1,
	0xd7, 0x8b, 0xd4, 0xba, 0x7c, 0x35, 0xf6, 0x0c, 0xfc, 0x46, 0x74, 0xd9, 0x4f, 0xcb, 0x6a, 0xf9,
	0xe9, 0x26, 0x8e, 0xe5, 0xdc, 0x94, 0xca, 0xe8, 0x37, 0x09, 0xde, 0x98, 0x38, 0xb1, 0xd0, 0x66,
	0x42, 0x27, 0x98, 0x32, 0xe1, 0x0b, 0x37, 0xfe, 0x53, 0xac, 0x68, 0xfc, 0xf2, 0x87, 0xfc, 0x0c,
	0x2a, 0xba, 0x7e, 0xda, 0x19, 0xda, 0x13, 0xf9, 0x7e, 0x2f, 0x01, 0x0c, 0xa6, 0x22, 0x4a, 0xb8,
	0x61, 0x63, 0xf3, 0xb3, 0x70, 0x86, 0x89, 0x20, 0x97, 0x38, 0x35, 0x59, 0xbe, 0x72, 0x0a, 0x35,
	0x95, 0x0f, 0x20, 0xa6, 0xeb, 0x33, 0x09, 0xce, 0x85, 0x53, 0x12, 0x25, 0x75, 0xec, 0xa1, 0x61,
	0x7a, 0x26, 0x1e, 0xef, 0x70, 0x1e, 0x6b, 0x68, 0x88, 0x07, 0xbb, 0xd8, 0x8c, 0x85, 0x20, 0xa1,
	0x96, 0x9f, 0xa2, 0x17, 0x12, 0x2c, 0x9d, 0x0c, 0x56, 0x94, 0x70, 0xab, 0x46, 0xa7, 0x75, 0x41,
	0x3d, 0xb3, 0x7f, 0x58, 0xb8, 0x89, 0xac, 0xc6, 0xd4, 0x41, 0x3f, 0x48, 0x00, 0x83, 0xf1, 0x9c,
	0x54, 0xa8, 0xb1, 0x41, 0x7e, 0x26, 0x81, 0xae, 0x73, 0x2a, 0xd7, 0x2a, 0x72, 0x9c, 0x0a, 0x83,
	0x57, 0xc6, 0x54, 0x62, 0xd5, 0x7a, 0x02, 0x30, 0x18, 0xd3, 0x49, 0x8c, 0xc6, 0x06, 0x7a, 0xe1,
	0xd2, 0xd8, 0x6b, 0xa0, 0xc1, 0xbe, 0x9b, 0x22, 0x41, 0xca, 0xd3, 0xcb, 0x54, 0xd8, 0x7d, 0x59,
	0x7d, 0x93, 0x43, 0x09, 0x24, 0x91, 0xcb, 0x70, 0x6d, 0x5f, 0x31, 0x49, 0xff, 0xf7, 0xaa, 0x72,
	0x9f, 0x52, 0xd7, 0xdf, 0x54, 0xd5, 0xa3, 0xa3, 0xa3, 0x91, 0x4d, 0xd5, 0x08, 0xe8, 0x7d, 0xf1,
	0xf5, 0x77, 0xdd, 0xed, 0x19, 0xb4, 0x4b, 0xbc, 0x7e, 0xed, 0x57, 0x09, 0x8a, 0x26, 0xe9, 0x4f,
	0x3d, 0x44, 0x2d, 0x17, 0xef, 0x4c, 0x2d, 0x46, 0xbb, 0x25, 0x7d, 0x51, 0x0d, 0x43, 0x2c, 0xd2,
	0x33, 0x1c, 0x4b, 0x21, 0x9e, 0xa5, 0x5a, 0xd8, 0xe1, 0x87, 0x52, 0x07, 0xc0, 0x93, 0xbf, 0x36,
	0x6f, 0x70, 0xfb, 0x97, 0xd4, 0xea, 0x96, 0xc8, 0x51, 0xe7, 0xb0, 0x1c, 0x45, 0xf9, 0x7c, 0xc3,
	0xad, 0xd4, 0x98, 0xd3, 0xcb, 0x68, 0xfb, 0x90, 0x6f, 0x1f, 0xf2, 0xed, 0xc3, 0x93, 0xed, 0xf6,
	0x02, 0xc7, 0xfa, 0xe0, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x76, 0x29, 0x46, 0x9f, 0x46, 0x0f,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location. The output format is newline-delimited JSON.
	// This API implements the [google.longrunning.Operation][google.longrunning.Operation] API allowing you
	// to keep track of the export.
	ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Batch gets the update history of assets that overlap a time window.
	// For RESOURCE content, this API outputs history with asset in both
	// non-delete or deleted status.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type assetServiceClient struct {
	cc *grpc.ClientConn
}

func NewAssetServiceClient(cc *grpc.ClientConn) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/ExportAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error) {
	out := new(BatchGetAssetsHistoryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/BatchGetAssetsHistory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/CreateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/GetFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error) {
	out := new(ListFeedsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/ListFeeds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/UpdateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/DeleteFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location. The output format is newline-delimited JSON.
	// This API implements the [google.longrunning.Operation][google.longrunning.Operation] API allowing you
	// to keep track of the export.
	ExportAssets(context.Context, *ExportAssetsRequest) (*longrunning.Operation, error)
	// Batch gets the update history of assets that overlap a time window.
	// For RESOURCE content, this API outputs history with asset in both
	// non-delete or deleted status.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	BatchGetAssetsHistory(context.Context, *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(context.Context, *GetFeedRequest) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(context.Context, *DeleteFeedRequest) (*empty.Empty, error)
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_ExportAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ExportAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/ExportAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ExportAssets(ctx, req.(*ExportAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_BatchGetAssetsHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetAssetsHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/BatchGetAssetsHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, req.(*BatchGetAssetsHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_CreateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).CreateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/CreateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).CreateFeed(ctx, req.(*CreateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_GetFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/GetFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetFeed(ctx, req.(*GetFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/ListFeeds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListFeeds(ctx, req.(*ListFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_UpdateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).UpdateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/UpdateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).UpdateFeed(ctx, req.(*UpdateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_DeleteFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).DeleteFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/DeleteFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).DeleteFeed(ctx, req.(*DeleteFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1p2beta1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportAssets",
			Handler:    _AssetService_ExportAssets_Handler,
		},
		{
			MethodName: "BatchGetAssetsHistory",
			Handler:    _AssetService_BatchGetAssetsHistory_Handler,
		},
		{
			MethodName: "CreateFeed",
			Handler:    _AssetService_CreateFeed_Handler,
		},
		{
			MethodName: "GetFeed",
			Handler:    _AssetService_GetFeed_Handler,
		},
		{
			MethodName: "ListFeeds",
			Handler:    _AssetService_ListFeeds_Handler,
		},
		{
			MethodName: "UpdateFeed",
			Handler:    _AssetService_UpdateFeed_Handler,
		},
		{
			MethodName: "DeleteFeed",
			Handler:    _AssetService_DeleteFeed_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1p2beta1/asset_service.proto",
}
