// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/agent.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Match mode determines how intents are detected from user queries.
type Agent_MatchMode int32

const (
	// Not specified.
	Agent_MATCH_MODE_UNSPECIFIED Agent_MatchMode = 0
	// Best for agents with a small number of examples in intents and/or wide
	// use of templates syntax and composite entities.
	Agent_MATCH_MODE_HYBRID Agent_MatchMode = 1
	// Can be used for agents with a large number of examples in intents,
	// especially the ones using @sys.any or very large developer entities.
	Agent_MATCH_MODE_ML_ONLY Agent_MatchMode = 2
)

var Agent_MatchMode_name = map[int32]string{
	0: "MATCH_MODE_UNSPECIFIED",
	1: "MATCH_MODE_HYBRID",
	2: "MATCH_MODE_ML_ONLY",
}

var Agent_MatchMode_value = map[string]int32{
	"MATCH_MODE_UNSPECIFIED": 0,
	"MATCH_MODE_HYBRID":      1,
	"MATCH_MODE_ML_ONLY":     2,
}

func (x Agent_MatchMode) String() string {
	return proto.EnumName(Agent_MatchMode_name, int32(x))
}

func (Agent_MatchMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{0, 0}
}

// API version for the agent.
type Agent_ApiVersion int32

const (
	// Not specified.
	Agent_API_VERSION_UNSPECIFIED Agent_ApiVersion = 0
	// Legacy V1 API.
	Agent_API_VERSION_V1 Agent_ApiVersion = 1
	// V2 API.
	Agent_API_VERSION_V2 Agent_ApiVersion = 2
	// V2beta1 API.
	Agent_API_VERSION_V2_BETA_1 Agent_ApiVersion = 3
)

var Agent_ApiVersion_name = map[int32]string{
	0: "API_VERSION_UNSPECIFIED",
	1: "API_VERSION_V1",
	2: "API_VERSION_V2",
	3: "API_VERSION_V2_BETA_1",
}

var Agent_ApiVersion_value = map[string]int32{
	"API_VERSION_UNSPECIFIED": 0,
	"API_VERSION_V1":          1,
	"API_VERSION_V2":          2,
	"API_VERSION_V2_BETA_1":   3,
}

func (x Agent_ApiVersion) String() string {
	return proto.EnumName(Agent_ApiVersion_name, int32(x))
}

func (Agent_ApiVersion) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{0, 1}
}

// Represents the agent tier.
type Agent_Tier int32

const (
	// Not specified. This value should never be used.
	Agent_TIER_UNSPECIFIED Agent_Tier = 0
	// Standard tier.
	Agent_TIER_STANDARD Agent_Tier = 1
	// Enterprise tier (Essentials).
	Agent_TIER_ENTERPRISE Agent_Tier = 2
	// Enterprise tier (Plus).
	Agent_TIER_ENTERPRISE_PLUS Agent_Tier = 3
)

var Agent_Tier_name = map[int32]string{
	0: "TIER_UNSPECIFIED",
	1: "TIER_STANDARD",
	2: "TIER_ENTERPRISE",
	3: "TIER_ENTERPRISE_PLUS",
}

var Agent_Tier_value = map[string]int32{
	"TIER_UNSPECIFIED":     0,
	"TIER_STANDARD":        1,
	"TIER_ENTERPRISE":      2,
	"TIER_ENTERPRISE_PLUS": 3,
}

func (x Agent_Tier) String() string {
	return proto.EnumName(Agent_Tier_name, int32(x))
}

func (Agent_Tier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{0, 2}
}

// Represents a conversational agent.
type Agent struct {
	// Required. The project of this agent.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of this agent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The default language of the agent as a language tag. See
	// [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. This field cannot be
	// set by the `Update` method.
	DefaultLanguageCode string `protobuf:"bytes,3,opt,name=default_language_code,json=defaultLanguageCode,proto3" json:"default_language_code,omitempty"`
	// Optional. The list of all languages supported by this agent (except for the
	// `default_language_code`).
	SupportedLanguageCodes []string `protobuf:"bytes,4,rep,name=supported_language_codes,json=supportedLanguageCodes,proto3" json:"supported_language_codes,omitempty"`
	// Required. The time zone of this agent from the
	// [time zone database](https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris.
	TimeZone string `protobuf:"bytes,5,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Optional. The description of this agent.
	// The maximum length is 500 characters. If exceeded, the request is rejected.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The URI of the agent's avatar.
	// Avatars are used throughout the Dialogflow console and in the self-hosted
	// [Web
	// Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
	// integration.
	AvatarUri string `protobuf:"bytes,7,opt,name=avatar_uri,json=avatarUri,proto3" json:"avatar_uri,omitempty"`
	// Optional. Determines whether this agent should log conversation queries.
	EnableLogging bool `protobuf:"varint,8,opt,name=enable_logging,json=enableLogging,proto3" json:"enable_logging,omitempty"`
	// Optional. Determines how intents are detected from user queries.
	MatchMode Agent_MatchMode `protobuf:"varint,9,opt,name=match_mode,json=matchMode,proto3,enum=google.cloud.dialogflow.v2beta1.Agent_MatchMode" json:"match_mode,omitempty"`
	// Optional. To filter out false positive results and still get variety in
	// matched natural language inputs for your agent, you can tune the machine
	// learning classification threshold. If the returned score value is less than
	// the threshold value, then a fallback intent will be triggered or, if there
	// are no fallback intents defined, no intent will be triggered. The score
	// values range from 0.0 (completely uncertain) to 1.0 (completely certain).
	// If set to 0.0, the default of 0.3 is used.
	ClassificationThreshold float32 `protobuf:"fixed32,10,opt,name=classification_threshold,json=classificationThreshold,proto3" json:"classification_threshold,omitempty"`
	// Optional. API version displayed in Dialogflow console. If not specified,
	// V2 API is assumed. Clients are free to query different service endpoints
	// for different API versions. However, bots connectors and webhook calls will
	// follow the specified API version.
	ApiVersion Agent_ApiVersion `protobuf:"varint,14,opt,name=api_version,json=apiVersion,proto3,enum=google.cloud.dialogflow.v2beta1.Agent_ApiVersion" json:"api_version,omitempty"`
	// Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
	Tier                 Agent_Tier `protobuf:"varint,15,opt,name=tier,proto3,enum=google.cloud.dialogflow.v2beta1.Agent_Tier" json:"tier,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Agent) Reset()         { *m = Agent{} }
func (m *Agent) String() string { return proto.CompactTextString(m) }
func (*Agent) ProtoMessage()    {}
func (*Agent) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{0}
}

func (m *Agent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Agent.Unmarshal(m, b)
}
func (m *Agent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Agent.Marshal(b, m, deterministic)
}
func (m *Agent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Agent.Merge(m, src)
}
func (m *Agent) XXX_Size() int {
	return xxx_messageInfo_Agent.Size(m)
}
func (m *Agent) XXX_DiscardUnknown() {
	xxx_messageInfo_Agent.DiscardUnknown(m)
}

var xxx_messageInfo_Agent proto.InternalMessageInfo

func (m *Agent) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Agent) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Agent) GetDefaultLanguageCode() string {
	if m != nil {
		return m.DefaultLanguageCode
	}
	return ""
}

func (m *Agent) GetSupportedLanguageCodes() []string {
	if m != nil {
		return m.SupportedLanguageCodes
	}
	return nil
}

func (m *Agent) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

func (m *Agent) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Agent) GetAvatarUri() string {
	if m != nil {
		return m.AvatarUri
	}
	return ""
}

func (m *Agent) GetEnableLogging() bool {
	if m != nil {
		return m.EnableLogging
	}
	return false
}

func (m *Agent) GetMatchMode() Agent_MatchMode {
	if m != nil {
		return m.MatchMode
	}
	return Agent_MATCH_MODE_UNSPECIFIED
}

func (m *Agent) GetClassificationThreshold() float32 {
	if m != nil {
		return m.ClassificationThreshold
	}
	return 0
}

func (m *Agent) GetApiVersion() Agent_ApiVersion {
	if m != nil {
		return m.ApiVersion
	}
	return Agent_API_VERSION_UNSPECIFIED
}

func (m *Agent) GetTier() Agent_Tier {
	if m != nil {
		return m.Tier
	}
	return Agent_TIER_UNSPECIFIED
}

// The request message for [Agents.GetAgent][google.cloud.dialogflow.v2beta1.Agents.GetAgent].
type GetAgentRequest struct {
	// Required. The project that the agent to fetch is associated with.
	// Format: `projects/<Project ID>`.
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAgentRequest) Reset()         { *m = GetAgentRequest{} }
func (m *GetAgentRequest) String() string { return proto.CompactTextString(m) }
func (*GetAgentRequest) ProtoMessage()    {}
func (*GetAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{1}
}

func (m *GetAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAgentRequest.Unmarshal(m, b)
}
func (m *GetAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAgentRequest.Marshal(b, m, deterministic)
}
func (m *GetAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAgentRequest.Merge(m, src)
}
func (m *GetAgentRequest) XXX_Size() int {
	return xxx_messageInfo_GetAgentRequest.Size(m)
}
func (m *GetAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAgentRequest proto.InternalMessageInfo

func (m *GetAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// The request message for [Agents.SetAgent][google.cloud.dialogflow.v2beta1.Agents.SetAgent].
type SetAgentRequest struct {
	// Required. The agent to update.
	Agent *Agent `protobuf:"bytes,1,opt,name=agent,proto3" json:"agent,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SetAgentRequest) Reset()         { *m = SetAgentRequest{} }
func (m *SetAgentRequest) String() string { return proto.CompactTextString(m) }
func (*SetAgentRequest) ProtoMessage()    {}
func (*SetAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{2}
}

func (m *SetAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetAgentRequest.Unmarshal(m, b)
}
func (m *SetAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetAgentRequest.Marshal(b, m, deterministic)
}
func (m *SetAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetAgentRequest.Merge(m, src)
}
func (m *SetAgentRequest) XXX_Size() int {
	return xxx_messageInfo_SetAgentRequest.Size(m)
}
func (m *SetAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetAgentRequest proto.InternalMessageInfo

func (m *SetAgentRequest) GetAgent() *Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (m *SetAgentRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request message for [Agents.DeleteAgent][google.cloud.dialogflow.v2beta1.Agents.DeleteAgent].
type DeleteAgentRequest struct {
	// Required. The project that the agent to delete is associated with.
	// Format: `projects/<Project ID>`.
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAgentRequest) Reset()         { *m = DeleteAgentRequest{} }
func (m *DeleteAgentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAgentRequest) ProtoMessage()    {}
func (*DeleteAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{3}
}

func (m *DeleteAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAgentRequest.Unmarshal(m, b)
}
func (m *DeleteAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAgentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAgentRequest.Merge(m, src)
}
func (m *DeleteAgentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAgentRequest.Size(m)
}
func (m *DeleteAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAgentRequest proto.InternalMessageInfo

func (m *DeleteAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// The request message for [Agents.SearchAgents][google.cloud.dialogflow.v2beta1.Agents.SearchAgents].
type SearchAgentsRequest struct {
	// Required. The project to list agents from.
	// Format: `projects/<Project ID or '-'>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAgentsRequest) Reset()         { *m = SearchAgentsRequest{} }
func (m *SearchAgentsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchAgentsRequest) ProtoMessage()    {}
func (*SearchAgentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{4}
}

func (m *SearchAgentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAgentsRequest.Unmarshal(m, b)
}
func (m *SearchAgentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAgentsRequest.Marshal(b, m, deterministic)
}
func (m *SearchAgentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAgentsRequest.Merge(m, src)
}
func (m *SearchAgentsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchAgentsRequest.Size(m)
}
func (m *SearchAgentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAgentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAgentsRequest proto.InternalMessageInfo

func (m *SearchAgentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchAgentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchAgentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [Agents.SearchAgents][google.cloud.dialogflow.v2beta1.Agents.SearchAgents].
type SearchAgentsResponse struct {
	// The list of agents. There will be a maximum number of items returned based
	// on the page_size field in the request.
	Agents []*Agent `protobuf:"bytes,1,rep,name=agents,proto3" json:"agents,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchAgentsResponse) Reset()         { *m = SearchAgentsResponse{} }
func (m *SearchAgentsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchAgentsResponse) ProtoMessage()    {}
func (*SearchAgentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{5}
}

func (m *SearchAgentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchAgentsResponse.Unmarshal(m, b)
}
func (m *SearchAgentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchAgentsResponse.Marshal(b, m, deterministic)
}
func (m *SearchAgentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchAgentsResponse.Merge(m, src)
}
func (m *SearchAgentsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchAgentsResponse.Size(m)
}
func (m *SearchAgentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchAgentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchAgentsResponse proto.InternalMessageInfo

func (m *SearchAgentsResponse) GetAgents() []*Agent {
	if m != nil {
		return m.Agents
	}
	return nil
}

func (m *SearchAgentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [Agents.TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent].
type TrainAgentRequest struct {
	// Required. The project that the agent to train is associated with.
	// Format: `projects/<Project ID>`.
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TrainAgentRequest) Reset()         { *m = TrainAgentRequest{} }
func (m *TrainAgentRequest) String() string { return proto.CompactTextString(m) }
func (*TrainAgentRequest) ProtoMessage()    {}
func (*TrainAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{6}
}

func (m *TrainAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TrainAgentRequest.Unmarshal(m, b)
}
func (m *TrainAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TrainAgentRequest.Marshal(b, m, deterministic)
}
func (m *TrainAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrainAgentRequest.Merge(m, src)
}
func (m *TrainAgentRequest) XXX_Size() int {
	return xxx_messageInfo_TrainAgentRequest.Size(m)
}
func (m *TrainAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TrainAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TrainAgentRequest proto.InternalMessageInfo

func (m *TrainAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// The request message for [Agents.ExportAgent][google.cloud.dialogflow.v2beta1.Agents.ExportAgent].
type ExportAgentRequest struct {
	// Required. The project that the agent to export is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The
	// [Google Cloud Storage](https://cloud.google.com/storage/docs/)
	// URI to export the agent to.
	// The format of this URI must be `gs://<bucket-name>/<object-name>`.
	// If left unspecified, the serialized agent is returned inline.
	AgentUri             string   `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3" json:"agent_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportAgentRequest) Reset()         { *m = ExportAgentRequest{} }
func (m *ExportAgentRequest) String() string { return proto.CompactTextString(m) }
func (*ExportAgentRequest) ProtoMessage()    {}
func (*ExportAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{7}
}

func (m *ExportAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportAgentRequest.Unmarshal(m, b)
}
func (m *ExportAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportAgentRequest.Marshal(b, m, deterministic)
}
func (m *ExportAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportAgentRequest.Merge(m, src)
}
func (m *ExportAgentRequest) XXX_Size() int {
	return xxx_messageInfo_ExportAgentRequest.Size(m)
}
func (m *ExportAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportAgentRequest proto.InternalMessageInfo

func (m *ExportAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ExportAgentRequest) GetAgentUri() string {
	if m != nil {
		return m.AgentUri
	}
	return ""
}

// The response message for [Agents.ExportAgent][google.cloud.dialogflow.v2beta1.Agents.ExportAgent].
type ExportAgentResponse struct {
	// Required. The exported agent.
	//
	// Types that are valid to be assigned to Agent:
	//	*ExportAgentResponse_AgentUri
	//	*ExportAgentResponse_AgentContent
	Agent                isExportAgentResponse_Agent `protobuf_oneof:"agent"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ExportAgentResponse) Reset()         { *m = ExportAgentResponse{} }
func (m *ExportAgentResponse) String() string { return proto.CompactTextString(m) }
func (*ExportAgentResponse) ProtoMessage()    {}
func (*ExportAgentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{8}
}

func (m *ExportAgentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportAgentResponse.Unmarshal(m, b)
}
func (m *ExportAgentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportAgentResponse.Marshal(b, m, deterministic)
}
func (m *ExportAgentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportAgentResponse.Merge(m, src)
}
func (m *ExportAgentResponse) XXX_Size() int {
	return xxx_messageInfo_ExportAgentResponse.Size(m)
}
func (m *ExportAgentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportAgentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportAgentResponse proto.InternalMessageInfo

type isExportAgentResponse_Agent interface {
	isExportAgentResponse_Agent()
}

type ExportAgentResponse_AgentUri struct {
	AgentUri string `protobuf:"bytes,1,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type ExportAgentResponse_AgentContent struct {
	AgentContent []byte `protobuf:"bytes,2,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

func (*ExportAgentResponse_AgentUri) isExportAgentResponse_Agent() {}

func (*ExportAgentResponse_AgentContent) isExportAgentResponse_Agent() {}

func (m *ExportAgentResponse) GetAgent() isExportAgentResponse_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (m *ExportAgentResponse) GetAgentUri() string {
	if x, ok := m.GetAgent().(*ExportAgentResponse_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (m *ExportAgentResponse) GetAgentContent() []byte {
	if x, ok := m.GetAgent().(*ExportAgentResponse_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExportAgentResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExportAgentResponse_AgentUri)(nil),
		(*ExportAgentResponse_AgentContent)(nil),
	}
}

// The request message for [Agents.ImportAgent][google.cloud.dialogflow.v2beta1.Agents.ImportAgent].
type ImportAgentRequest struct {
	// Required. The project that the agent to import is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The agent to import.
	//
	// Types that are valid to be assigned to Agent:
	//	*ImportAgentRequest_AgentUri
	//	*ImportAgentRequest_AgentContent
	Agent                isImportAgentRequest_Agent `protobuf_oneof:"agent"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ImportAgentRequest) Reset()         { *m = ImportAgentRequest{} }
func (m *ImportAgentRequest) String() string { return proto.CompactTextString(m) }
func (*ImportAgentRequest) ProtoMessage()    {}
func (*ImportAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{9}
}

func (m *ImportAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportAgentRequest.Unmarshal(m, b)
}
func (m *ImportAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportAgentRequest.Marshal(b, m, deterministic)
}
func (m *ImportAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportAgentRequest.Merge(m, src)
}
func (m *ImportAgentRequest) XXX_Size() int {
	return xxx_messageInfo_ImportAgentRequest.Size(m)
}
func (m *ImportAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportAgentRequest proto.InternalMessageInfo

func (m *ImportAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isImportAgentRequest_Agent interface {
	isImportAgentRequest_Agent()
}

type ImportAgentRequest_AgentUri struct {
	AgentUri string `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type ImportAgentRequest_AgentContent struct {
	AgentContent []byte `protobuf:"bytes,3,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

func (*ImportAgentRequest_AgentUri) isImportAgentRequest_Agent() {}

func (*ImportAgentRequest_AgentContent) isImportAgentRequest_Agent() {}

func (m *ImportAgentRequest) GetAgent() isImportAgentRequest_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (m *ImportAgentRequest) GetAgentUri() string {
	if x, ok := m.GetAgent().(*ImportAgentRequest_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (m *ImportAgentRequest) GetAgentContent() []byte {
	if x, ok := m.GetAgent().(*ImportAgentRequest_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ImportAgentRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ImportAgentRequest_AgentUri)(nil),
		(*ImportAgentRequest_AgentContent)(nil),
	}
}

// The request message for [Agents.RestoreAgent][google.cloud.dialogflow.v2beta1.Agents.RestoreAgent].
type RestoreAgentRequest struct {
	// Required. The project that the agent to restore is associated with.
	// Format: `projects/<Project ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The agent to restore.
	//
	// Types that are valid to be assigned to Agent:
	//	*RestoreAgentRequest_AgentUri
	//	*RestoreAgentRequest_AgentContent
	Agent                isRestoreAgentRequest_Agent `protobuf_oneof:"agent"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *RestoreAgentRequest) Reset()         { *m = RestoreAgentRequest{} }
func (m *RestoreAgentRequest) String() string { return proto.CompactTextString(m) }
func (*RestoreAgentRequest) ProtoMessage()    {}
func (*RestoreAgentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_be44838675479699, []int{10}
}

func (m *RestoreAgentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RestoreAgentRequest.Unmarshal(m, b)
}
func (m *RestoreAgentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RestoreAgentRequest.Marshal(b, m, deterministic)
}
func (m *RestoreAgentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RestoreAgentRequest.Merge(m, src)
}
func (m *RestoreAgentRequest) XXX_Size() int {
	return xxx_messageInfo_RestoreAgentRequest.Size(m)
}
func (m *RestoreAgentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RestoreAgentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RestoreAgentRequest proto.InternalMessageInfo

func (m *RestoreAgentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isRestoreAgentRequest_Agent interface {
	isRestoreAgentRequest_Agent()
}

type RestoreAgentRequest_AgentUri struct {
	AgentUri string `protobuf:"bytes,2,opt,name=agent_uri,json=agentUri,proto3,oneof"`
}

type RestoreAgentRequest_AgentContent struct {
	AgentContent []byte `protobuf:"bytes,3,opt,name=agent_content,json=agentContent,proto3,oneof"`
}

func (*RestoreAgentRequest_AgentUri) isRestoreAgentRequest_Agent() {}

func (*RestoreAgentRequest_AgentContent) isRestoreAgentRequest_Agent() {}

func (m *RestoreAgentRequest) GetAgent() isRestoreAgentRequest_Agent {
	if m != nil {
		return m.Agent
	}
	return nil
}

func (m *RestoreAgentRequest) GetAgentUri() string {
	if x, ok := m.GetAgent().(*RestoreAgentRequest_AgentUri); ok {
		return x.AgentUri
	}
	return ""
}

func (m *RestoreAgentRequest) GetAgentContent() []byte {
	if x, ok := m.GetAgent().(*RestoreAgentRequest_AgentContent); ok {
		return x.AgentContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*RestoreAgentRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*RestoreAgentRequest_AgentUri)(nil),
		(*RestoreAgentRequest_AgentContent)(nil),
	}
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Agent_MatchMode", Agent_MatchMode_name, Agent_MatchMode_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Agent_ApiVersion", Agent_ApiVersion_name, Agent_ApiVersion_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Agent_Tier", Agent_Tier_name, Agent_Tier_value)
	proto.RegisterType((*Agent)(nil), "google.cloud.dialogflow.v2beta1.Agent")
	proto.RegisterType((*GetAgentRequest)(nil), "google.cloud.dialogflow.v2beta1.GetAgentRequest")
	proto.RegisterType((*SetAgentRequest)(nil), "google.cloud.dialogflow.v2beta1.SetAgentRequest")
	proto.RegisterType((*DeleteAgentRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteAgentRequest")
	proto.RegisterType((*SearchAgentsRequest)(nil), "google.cloud.dialogflow.v2beta1.SearchAgentsRequest")
	proto.RegisterType((*SearchAgentsResponse)(nil), "google.cloud.dialogflow.v2beta1.SearchAgentsResponse")
	proto.RegisterType((*TrainAgentRequest)(nil), "google.cloud.dialogflow.v2beta1.TrainAgentRequest")
	proto.RegisterType((*ExportAgentRequest)(nil), "google.cloud.dialogflow.v2beta1.ExportAgentRequest")
	proto.RegisterType((*ExportAgentResponse)(nil), "google.cloud.dialogflow.v2beta1.ExportAgentResponse")
	proto.RegisterType((*ImportAgentRequest)(nil), "google.cloud.dialogflow.v2beta1.ImportAgentRequest")
	proto.RegisterType((*RestoreAgentRequest)(nil), "google.cloud.dialogflow.v2beta1.RestoreAgentRequest")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/agent.proto", fileDescriptor_be44838675479699)
}

var fileDescriptor_be44838675479699 = []byte{
	// 1291 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x57, 0x4b, 0x6f, 0xdb, 0x46,
	0x17, 0x0d, 0xe5, 0xd8, 0x91, 0xae, 0xfc, 0x50, 0xc6, 0x89, 0xc3, 0x28, 0x31, 0xa2, 0x8f, 0xf9,
	0x12, 0x38, 0x76, 0x42, 0xd6, 0x4a, 0x82, 0xb6, 0x4e, 0x1f, 0x90, 0x2d, 0x25, 0x16, 0xe0, 0x87,
	0x40, 0xc9, 0x06, 0x92, 0x45, 0x89, 0x31, 0x39, 0xa6, 0xa7, 0x21, 0x39, 0x2c, 0x39, 0xca, 0xb3,
	0xed, 0xa2, 0x8b, 0xae, 0xba, 0x28, 0xd0, 0x02, 0x05, 0x0a, 0x74, 0xd3, 0x55, 0xd1, 0x45, 0x7f,
	0x48, 0x97, 0xed, 0xa2, 0x7f, 0xa0, 0x3f, 0xa2, 0x8b, 0x2e, 0x0a, 0x0e, 0x29, 0x8b, 0x92, 0xea,
	0x88, 0x29, 0x0a, 0x74, 0x47, 0x9e, 0x7b, 0xee, 0xbd, 0x67, 0x2e, 0x67, 0x0e, 0x86, 0xb0, 0x62,
	0x33, 0x66, 0x3b, 0x44, 0x33, 0x1d, 0xd6, 0xb5, 0x34, 0x8b, 0x62, 0x87, 0xd9, 0x87, 0x0e, 0x7b,
	0xaa, 0x3d, 0xa9, 0x1e, 0x10, 0x8e, 0x57, 0x35, 0x6c, 0x13, 0x8f, 0xab, 0x7e, 0xc0, 0x38, 0x43,
	0x57, 0x62, 0xb2, 0x2a, 0xc8, 0x6a, 0x9f, 0xac, 0x26, 0xe4, 0xf2, 0xe5, 0xa4, 0x1a, 0xf6, 0xa9,
	0x86, 0x3d, 0x8f, 0x71, 0xcc, 0x29, 0xf3, 0xc2, 0x38, 0xbd, 0x7c, 0x35, 0x89, 0x3a, 0xcc, 0xb3,
	0x83, 0xae, 0xe7, 0x51, 0xcf, 0xd6, 0x98, 0x4f, 0x82, 0x01, 0xd2, 0xa5, 0x84, 0x24, 0xde, 0x0e,
	0xba, 0x87, 0x1a, 0x71, 0x7d, 0xfe, 0x3c, 0x09, 0x56, 0x86, 0x83, 0x87, 0x94, 0x38, 0x96, 0xe1,
	0xe2, 0xf0, 0x71, 0xc2, 0xb8, 0x3c, 0xcc, 0x08, 0x79, 0xd0, 0x35, 0x93, 0x05, 0x94, 0x2f, 0xa4,
	0xf4, 0x99, 0x0e, 0x3d, 0x5e, 0x99, 0xf2, 0xe7, 0x14, 0x4c, 0xd6, 0xa2, 0x95, 0xa2, 0x05, 0x98,
	0xf2, 0x71, 0x40, 0x3c, 0x2e, 0x4b, 0x15, 0x69, 0xa9, 0xa0, 0x27, 0x6f, 0xe8, 0x7f, 0x30, 0x6d,
	0xd1, 0xd0, 0x77, 0xf0, 0x73, 0xc3, 0xc3, 0x2e, 0x91, 0x73, 0x22, 0x5a, 0x4c, 0xb0, 0x1d, 0xec,
	0x12, 0x54, 0x85, 0xf3, 0x16, 0x39, 0xc4, 0x5d, 0x87, 0x1b, 0x0e, 0xf6, 0xec, 0x2e, 0xb6, 0x89,
	0x61, 0x32, 0x8b, 0xc8, 0x13, 0x82, 0x3b, 0x9f, 0x04, 0xb7, 0x92, 0xd8, 0x06, 0xb3, 0x08, 0x7a,
	0x0b, 0xe4, 0xb0, 0xeb, 0xfb, 0x2c, 0xe0, 0xc4, 0x1a, 0xcc, 0x0a, 0xe5, 0xd3, 0x95, 0x89, 0xa5,
	0x82, 0xbe, 0x70, 0x1c, 0x4f, 0x27, 0x86, 0xe8, 0x12, 0x14, 0x38, 0x75, 0x89, 0xf1, 0x82, 0x79,
	0x44, 0x9e, 0x14, 0x1d, 0xf2, 0x11, 0xf0, 0x88, 0x79, 0x04, 0x55, 0xa0, 0x68, 0x91, 0xd0, 0x0c,
	0xa8, 0x1f, 0xcd, 0x56, 0x9e, 0x4a, 0xc4, 0xf6, 0x21, 0xb4, 0x08, 0x80, 0x9f, 0x60, 0x8e, 0x03,
	0xa3, 0x1b, 0x50, 0xf9, 0x8c, 0x20, 0x14, 0x62, 0x64, 0x2f, 0xa0, 0xe8, 0x1a, 0xcc, 0x12, 0x0f,
	0x1f, 0x38, 0xc4, 0x70, 0x98, 0x6d, 0x53, 0xcf, 0x96, 0xf3, 0x15, 0x69, 0x29, 0xaf, 0xcf, 0xc4,
	0xe8, 0x56, 0x0c, 0xa2, 0x5d, 0x00, 0x17, 0x73, 0xf3, 0xc8, 0x70, 0xa3, 0x75, 0x16, 0x2a, 0xd2,
	0xd2, 0x6c, 0xf5, 0x0d, 0x75, 0xcc, 0x36, 0x51, 0xc5, 0xa4, 0xd5, 0xed, 0x28, 0x71, 0x9b, 0x59,
	0x44, 0x2f, 0xb8, 0xbd, 0x47, 0xf4, 0x36, 0xc8, 0xa6, 0x83, 0xc3, 0x90, 0x1e, 0x52, 0x53, 0xec,
	0x0b, 0x83, 0x1f, 0x05, 0x24, 0x3c, 0x62, 0x8e, 0x25, 0x43, 0x45, 0x5a, 0xca, 0xe9, 0x17, 0x06,
	0xe3, 0x9d, 0x5e, 0x18, 0xe9, 0x50, 0xc4, 0x3e, 0x35, 0x9e, 0x90, 0x20, 0x8c, 0xd6, 0x3c, 0x2b,
	0xc4, 0xac, 0x66, 0x14, 0x53, 0xf3, 0xe9, 0x7e, 0x9c, 0xa8, 0x03, 0x3e, 0x7e, 0x46, 0xef, 0xc3,
	0x69, 0x4e, 0x49, 0x20, 0xcf, 0x89, 0x62, 0x2b, 0x19, 0x8b, 0x75, 0x28, 0x09, 0x74, 0x91, 0xa8,
	0xec, 0x43, 0xe1, 0x78, 0x9d, 0xa8, 0x0c, 0x0b, 0xdb, 0xb5, 0xce, 0xc6, 0xa6, 0xb1, 0xbd, 0x5b,
	0x6f, 0x18, 0x7b, 0x3b, 0xed, 0x56, 0x63, 0xa3, 0x79, 0xbf, 0xd9, 0xa8, 0x97, 0x4e, 0xa1, 0xf3,
	0x70, 0x36, 0x15, 0xdb, 0x7c, 0xb8, 0xae, 0x37, 0xeb, 0x25, 0x09, 0x2d, 0x00, 0x4a, 0xc1, 0xdb,
	0x5b, 0xc6, 0xee, 0xce, 0xd6, 0xc3, 0x52, 0x4e, 0x71, 0x00, 0xfa, 0x92, 0xd1, 0x25, 0xb8, 0x50,
	0x6b, 0x35, 0x8d, 0xfd, 0x86, 0xde, 0x6e, 0xee, 0xee, 0x0c, 0x55, 0x46, 0x30, 0x9b, 0x0e, 0xee,
	0xaf, 0x96, 0xa4, 0x11, 0xac, 0x5a, 0xca, 0xa1, 0x8b, 0x70, 0x7e, 0x10, 0x33, 0xd6, 0x1b, 0x9d,
	0x9a, 0xb1, 0x5a, 0x9a, 0x50, 0x3e, 0x80, 0xd3, 0xd1, 0x9a, 0xd0, 0x39, 0x28, 0x75, 0x9a, 0x0d,
	0x7d, 0xa8, 0xc1, 0x59, 0x98, 0x11, 0x68, 0xbb, 0x53, 0xdb, 0xa9, 0xd7, 0xf4, 0x48, 0xf6, 0x3c,
	0xcc, 0x09, 0xa8, 0xb1, 0xd3, 0x69, 0xe8, 0x2d, 0xbd, 0xd9, 0x6e, 0x94, 0x72, 0x48, 0x86, 0x73,
	0x43, 0xa0, 0xd1, 0xda, 0xda, 0x6b, 0x97, 0x26, 0x94, 0x1b, 0x30, 0xf7, 0x80, 0x70, 0x31, 0x3c,
	0x9d, 0x7c, 0xd4, 0x25, 0xe1, 0x89, 0xe7, 0x50, 0xf9, 0x42, 0x82, 0xb9, 0xf6, 0x10, 0xf7, 0x1d,
	0x98, 0x14, 0x36, 0x25, 0xa8, 0xc5, 0xea, 0xf5, 0x6c, 0x9f, 0x49, 0x8f, 0x93, 0xd0, 0x3d, 0x28,
	0x76, 0x7d, 0x0b, 0x73, 0x22, 0x7c, 0x44, 0x1c, 0xec, 0x62, 0xb5, 0xdc, 0xab, 0xd1, 0x33, 0x12,
	0xf5, 0x7e, 0x64, 0x35, 0xdb, 0x38, 0x7c, 0xac, 0x43, 0x4c, 0x8f, 0x9e, 0x95, 0x9b, 0x80, 0xea,
	0xc4, 0x21, 0x9c, 0x64, 0x12, 0x4f, 0x61, 0xbe, 0x4d, 0x70, 0x60, 0x1e, 0x09, 0x76, 0x38, 0x86,
	0x1e, 0x1d, 0x71, 0x3f, 0xb2, 0x83, 0x90, 0xbe, 0x88, 0x0d, 0x67, 0x52, 0xcf, 0x47, 0x40, 0x9b,
	0xbe, 0x20, 0xd1, 0x01, 0x16, 0x41, 0xce, 0x1e, 0x13, 0x2f, 0xb1, 0x18, 0x41, 0xef, 0x44, 0x80,
	0xf2, 0x29, 0x9c, 0x1b, 0x6c, 0x15, 0xfa, 0xcc, 0x0b, 0x09, 0x7a, 0x0f, 0xa6, 0xc4, 0xb2, 0x43,
	0x59, 0xaa, 0x4c, 0xbc, 0xc6, 0xb0, 0x92, 0x2c, 0x74, 0x1d, 0xe6, 0x3c, 0xf2, 0x8c, 0x1b, 0xa9,
	0xde, 0xb1, 0x15, 0xce, 0x44, 0x70, 0xeb, 0xb8, 0xff, 0x0a, 0x9c, 0xed, 0x04, 0x98, 0x7a, 0x99,
	0xe6, 0xd2, 0x04, 0xd4, 0x78, 0x16, 0x99, 0x5c, 0x16, 0x76, 0x34, 0x16, 0x21, 0x46, 0x38, 0x57,
	0xdc, 0x3c, 0x2f, 0x80, 0xbd, 0x80, 0x2a, 0x16, 0xcc, 0x0f, 0x94, 0x4a, 0x96, 0xbd, 0x98, 0xce,
	0x11, 0xe5, 0x36, 0x4f, 0xf5, 0xb3, 0xd0, 0x35, 0x98, 0x89, 0xc3, 0x26, 0xf3, 0x78, 0xd4, 0x31,
	0x2a, 0x3b, 0xbd, 0x79, 0x4a, 0x9f, 0x16, 0xf0, 0x46, 0x8c, 0xae, 0x9f, 0x49, 0x36, 0x9a, 0xf2,
	0x12, 0x50, 0xd3, 0xcd, 0x2c, 0x78, 0x71, 0x44, 0xf0, 0xab, 0x9b, 0x4f, 0xbc, 0xba, 0xf9, 0xc7,
	0x30, 0xaf, 0x93, 0x90, 0xb3, 0x80, 0xfc, 0x07, 0xdd, 0xab, 0xbf, 0x01, 0x4c, 0xc5, 0x7b, 0x0a,
	0x7d, 0x29, 0x41, 0xbe, 0x77, 0x6e, 0xd1, 0x78, 0xdb, 0x1f, 0x3a, 0xe2, 0xe5, 0x8c, 0x5b, 0x4f,
	0x59, 0xfe, 0xec, 0xd7, 0xdf, 0xbf, 0xca, 0xfd, 0x1f, 0x29, 0xc7, 0x97, 0x92, 0x97, 0xf1, 0xd2,
	0xde, 0xf5, 0x03, 0xf6, 0x21, 0x31, 0x79, 0xa8, 0x2d, 0x7f, 0x12, 0x5f, 0x54, 0xd0, 0x77, 0x12,
	0xe4, 0xdb, 0xd9, 0x25, 0xb5, 0xff, 0xa1, 0xa4, 0x37, 0x85, 0xa4, 0x55, 0x65, 0xa9, 0x2f, 0x29,
	0xb9, 0x28, 0x9d, 0x20, 0x6c, 0x2d, 0x31, 0x9b, 0xcf, 0x25, 0x28, 0xa6, 0x0c, 0x03, 0xdd, 0x1e,
	0xdb, 0x70, 0xd4, 0x5e, 0xca, 0x0b, 0x23, 0xe6, 0xd4, 0x88, 0x2e, 0x49, 0xbd, 0x41, 0x2d, 0x67,
	0x19, 0xd4, 0x4f, 0x12, 0x4c, 0xa7, 0x0d, 0x02, 0xdd, 0xc9, 0x30, 0xac, 0x11, 0xeb, 0x2a, 0xdf,
	0x7d, 0xcd, 0xac, 0xf8, 0x38, 0x2a, 0xab, 0x42, 0xe9, 0x0a, 0xba, 0x31, 0x5e, 0xe9, 0x5a, 0x28,
	0x0a, 0xa0, 0xaf, 0x25, 0x80, 0xbe, 0xa3, 0xa0, 0xea, 0xd8, 0xc6, 0x23, 0xf6, 0x53, 0x5e, 0xec,
	0xe5, 0xa4, 0x6e, 0xa0, 0xea, 0x6e, 0xef, 0x06, 0xaa, 0xdc, 0x16, 0xa2, 0x6e, 0xa5, 0x3f, 0xea,
	0x89, 0xa2, 0x78, 0x54, 0x7c, 0x4d, 0x5a, 0x46, 0xdf, 0x48, 0x50, 0x4c, 0x19, 0x4e, 0x86, 0x0f,
	0x3a, 0xea, 0x74, 0xe3, 0x84, 0xdd, 0x11, 0xc2, 0x54, 0x25, 0xcb, 0xb4, 0x88, 0xa8, 0xde, 0x53,
	0x96, 0x32, 0xa9, 0x0c, 0xca, 0x46, 0x2d, 0xed, 0xdf, 0x54, 0x46, 0xdd, 0x9e, 0xb2, 0x6f, 0x25,
	0x98, 0x4e, 0x3b, 0x58, 0x86, 0xbd, 0xf7, 0x37, 0x86, 0x37, 0x4e, 0xdb, 0x5d, 0xa1, 0x4d, 0x53,
	0x96, 0x33, 0x68, 0x0b, 0xe2, 0xf2, 0x6b, 0xd2, 0x72, 0xf9, 0xd9, 0xcf, 0xb5, 0x8b, 0x29, 0x01,
	0x71, 0x0b, 0xec, 0xd3, 0x50, 0x35, 0x99, 0xfb, 0x4b, 0xed, 0xe1, 0x11, 0xe7, 0x7e, 0xb8, 0xa6,
	0x69, 0x4f, 0x9f, 0x0e, 0x07, 0x35, 0xdc, 0xe5, 0x47, 0xf1, 0x9f, 0xd4, 0x2d, 0xdf, 0xc1, 0xfc,
	0x90, 0x05, 0xee, 0xcd, 0x71, 0xf4, 0x7e, 0xab, 0xf5, 0x1f, 0x24, 0xb8, 0x6a, 0x32, 0x77, 0xdc,
	0x2c, 0xd6, 0x41, 0x4c, 0xa1, 0x15, 0x9d, 0xfd, 0x96, 0xf4, 0xa8, 0x99, 0xd0, 0x6d, 0x16, 0xfd,
	0x3e, 0xa8, 0x2c, 0xb0, 0x35, 0x9b, 0x78, 0xc2, 0x19, 0xb4, 0x7e, 0xc3, 0x13, 0x7f, 0xf0, 0xee,
	0xf5, 0xa1, 0x3f, 0x24, 0xe9, 0xfb, 0x5c, 0xae, 0x7e, 0xff, 0xc7, 0xdc, 0x95, 0x07, 0x71, 0xcd,
	0x0d, 0x21, 0xa1, 0xde, 0x97, 0xb0, 0x1f, 0x27, 0x1d, 0x4c, 0x89, 0xfa, 0xb7, 0xff, 0x0a, 0x00,
	0x00, 0xff, 0xff, 0x0b, 0xdb, 0x0b, 0x80, 0x3f, 0x0e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AgentsClient is the client API for Agents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentsClient interface {
	// Retrieves the specified agent.
	GetAgent(ctx context.Context, in *GetAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Creates/updates the specified agent.
	SetAgent(ctx context.Context, in *SetAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Deletes the specified agent.
	DeleteAgent(ctx context.Context, in *DeleteAgentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns the list of agents.
	//
	// Since there is at most one conversational agent per project, this method is
	// useful primarily for listing all agents across projects the caller has
	// access to. One can achieve that with a wildcard project collection id "-".
	// Refer to [List
	// Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
	SearchAgents(ctx context.Context, in *SearchAgentsRequest, opts ...grpc.CallOption) (*SearchAgentsResponse, error)
	// Trains the specified agent.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	TrainAgent(ctx context.Context, in *TrainAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Exports the specified agent to a ZIP file.
	//
	//
	// Operation <response: [ExportAgentResponse][google.cloud.dialogflow.v2beta1.ExportAgentResponse]>
	ExportAgent(ctx context.Context, in *ExportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports the specified agent from a ZIP file.
	//
	// Uploads new intents and entity types without deleting the existing ones.
	// Intents and entity types with the same name are replaced with the new
	// versions from ImportAgentRequest.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	ImportAgent(ctx context.Context, in *ImportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Restores the specified agent from a ZIP file.
	//
	// Replaces the current agent version with a new one. All the intents and
	// entity types in the older version are deleted.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	RestoreAgent(ctx context.Context, in *RestoreAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type agentsClient struct {
	cc *grpc.ClientConn
}

func NewAgentsClient(cc *grpc.ClientConn) AgentsClient {
	return &agentsClient{cc}
}

func (c *agentsClient) GetAgent(ctx context.Context, in *GetAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/GetAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) SetAgent(ctx context.Context, in *SetAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/SetAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) DeleteAgent(ctx context.Context, in *DeleteAgentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/DeleteAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) SearchAgents(ctx context.Context, in *SearchAgentsRequest, opts ...grpc.CallOption) (*SearchAgentsResponse, error) {
	out := new(SearchAgentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/SearchAgents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) TrainAgent(ctx context.Context, in *TrainAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/TrainAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) ExportAgent(ctx context.Context, in *ExportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/ExportAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) ImportAgent(ctx context.Context, in *ImportAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/ImportAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) RestoreAgent(ctx context.Context, in *RestoreAgentRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Agents/RestoreAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentsServer is the server API for Agents service.
type AgentsServer interface {
	// Retrieves the specified agent.
	GetAgent(context.Context, *GetAgentRequest) (*Agent, error)
	// Creates/updates the specified agent.
	SetAgent(context.Context, *SetAgentRequest) (*Agent, error)
	// Deletes the specified agent.
	DeleteAgent(context.Context, *DeleteAgentRequest) (*empty.Empty, error)
	// Returns the list of agents.
	//
	// Since there is at most one conversational agent per project, this method is
	// useful primarily for listing all agents across projects the caller has
	// access to. One can achieve that with a wildcard project collection id "-".
	// Refer to [List
	// Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
	SearchAgents(context.Context, *SearchAgentsRequest) (*SearchAgentsResponse, error)
	// Trains the specified agent.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	TrainAgent(context.Context, *TrainAgentRequest) (*longrunning.Operation, error)
	// Exports the specified agent to a ZIP file.
	//
	//
	// Operation <response: [ExportAgentResponse][google.cloud.dialogflow.v2beta1.ExportAgentResponse]>
	ExportAgent(context.Context, *ExportAgentRequest) (*longrunning.Operation, error)
	// Imports the specified agent from a ZIP file.
	//
	// Uploads new intents and entity types without deleting the existing ones.
	// Intents and entity types with the same name are replaced with the new
	// versions from ImportAgentRequest.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	ImportAgent(context.Context, *ImportAgentRequest) (*longrunning.Operation, error)
	// Restores the specified agent from a ZIP file.
	//
	// Replaces the current agent version with a new one. All the intents and
	// entity types in the older version are deleted.
	//
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	RestoreAgent(context.Context, *RestoreAgentRequest) (*longrunning.Operation, error)
}

func RegisterAgentsServer(s *grpc.Server, srv AgentsServer) {
	s.RegisterService(&_Agents_serviceDesc, srv)
}

func _Agents_GetAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).GetAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/GetAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).GetAgent(ctx, req.(*GetAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_SetAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).SetAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/SetAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).SetAgent(ctx, req.(*SetAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_DeleteAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).DeleteAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/DeleteAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).DeleteAgent(ctx, req.(*DeleteAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_SearchAgents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAgentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).SearchAgents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/SearchAgents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).SearchAgents(ctx, req.(*SearchAgentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_TrainAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrainAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).TrainAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/TrainAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).TrainAgent(ctx, req.(*TrainAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_ExportAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ExportAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/ExportAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ExportAgent(ctx, req.(*ExportAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_ImportAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ImportAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/ImportAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ImportAgent(ctx, req.(*ImportAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_RestoreAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).RestoreAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Agents/RestoreAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).RestoreAgent(ctx, req.(*RestoreAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Agents_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Agents",
	HandlerType: (*AgentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAgent",
			Handler:    _Agents_GetAgent_Handler,
		},
		{
			MethodName: "SetAgent",
			Handler:    _Agents_SetAgent_Handler,
		},
		{
			MethodName: "DeleteAgent",
			Handler:    _Agents_DeleteAgent_Handler,
		},
		{
			MethodName: "SearchAgents",
			Handler:    _Agents_SearchAgents_Handler,
		},
		{
			MethodName: "TrainAgent",
			Handler:    _Agents_TrainAgent_Handler,
		},
		{
			MethodName: "ExportAgent",
			Handler:    _Agents_ExportAgent_Handler,
		},
		{
			MethodName: "ImportAgent",
			Handler:    _Agents_ImportAgent_Handler,
		},
		{
			MethodName: "RestoreAgent",
			Handler:    _Agents_RestoreAgent_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/agent.proto",
}
