/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "animations.h"

/* zooming winboxes */
void zoom_simple(client_t *client, int event) {
	int wid, hei;

	/* grab server, we're doing xor'd lines */
	XGrabServer(display);

	/* get full width and height of the client */
	wid = FULLWIDTH(client);
	hei = FULLHEIGHT(client);

	/* be slightly smart based on what type of event we're doing */
	switch (event) {
	case EV_ZOOM:
	case EV_UNZOOM:
		draw_zoomrects(client->screen, client, client->save_x,
			client->save_y, client->save_width, client->save_height,
			client->x, client->y, client->width, client->height, 1);
		break;
	case EV_DEATH:
	case EV_ICONIFY:
		draw_zoomrects(client->screen, client, client->x, client->y,
			client->width, client->height, client->x + (wid / 2),
			client->y + (hei / 2), 1, 1, 1);
		break;
	default:
		draw_zoomrects(client->screen, client, client->x + (wid / 2),
			client->y + (hei / 2), 1, 1, client->x, client->y,
			client->width, client->height, 1);
	}

	/* let go of the server */
	XUngrabServer(display);
}

/* declare our animation */
ANIMATION_DECLARE("zoom_simple", zoom_simple)
