<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Load required includes */
require_once ("../include/php_setup.inc");
require_once ("functions.inc");
require_once ("setup_checks.inc");

/* Don't call setup if gosa.conf exists */
if (file_exists(CONFIG_DIR."/gosa.conf")){
        header("location:index.php");
        exit();
}

/* Set error handler to own one, initialize time calculation
   and start session. */
session_start ();

/* Download config? */
if (isset($_SESSION['classes']) && isset($_SESSION['ldapconf']) && isset($_GET['getconfig'])){
	$classes= $_SESSION['classes'];
	$ldapconf= $_SESSION['ldapconf'];
	foreach($ldapconf as $key => $value){
		$$key= $value;
	}

	/* Set detected samba version */
	if (isset($classes['samba2'])){
		$samba= "3";
	} else {
		$samba= "2";
	}

	/* Set pwdhash */
        $query= "mkntpwd 2>&1";
        $output= shell_exec ($query);
        if (preg_match("/^Usage: mkntpwd /", $output)){
		$pwdhash= "mkntpwd";
	} else {
		$pwdhash= "perl -MCrypt::SmbHash -e \"ntlmgen \\\"\\\$ARGV[0]\\\", \\\$lm, \\\$nt; print \\\"\\\${lm}:\\\${nt}\n\\\";\"";
        }


	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");
	header("Cache-Control: no-cache");
	header("Pragma: no-cache");
	header("Cache-Control: post-check=0, pre-check=0");

	header("Content-type: text/plain");

	echo <<<EOT
<?xml version="1.0"?>
<conf>
        <menu>
                <section name="My account">
                        <plugin acl="default" class="user" headline="Generic"
                                icon="personal.png"
                                path="plugins/personal/generic" />
                        <plugin acl="default" class="posixAccount" headline="UNIX account"
                                icon="posix.png"
                                path="plugins/personal/posix" />
                        <plugin acl="default" class="mailAccount" headline="Mail account"
                                icon="email.png"
                                path="plugins/personal/mail" />
                        <plugin acl="default" class="sambaAccount" headline="Samba account"
                                icon="samba.png"
                                path="plugins/personal/samba" />
				
EOT;
	echo <<<EOT
                        <plugin acl="default" class="proxyAccount" headline="Proxy account"
                                icon="proxy.png"
                                path="plugins/personal/proxy" />

EOT;
	if (!isset($classes['pureftp'])){
		echo <<<EOT
                        <plugin acl="default" class="pureftpdAccount" headline="FTP account"
                                icon="ftp.png"
                                path="plugins/personal/pureftpd" />

EOT;
	}
	echo <<<EOT
                        <plugin acl="default" class="gofaxAccount" headline="FAX account"
                                icon="fax.png"
                                path="plugins/gofax/faxaccount" />
                        <plugin acl="default" class="password" headline="Change password"
                                icon="password.png"
                                path="plugins/personal/password" />
                </section>

                <section name="Administration">
                        <plugin acl="user" headline="Users" icon="user.png"
                                path="plugins/admin/users" />
                        <plugin acl="group" headline="Groups" icon="group.png"
                                path="plugins/admin/groups" />
                        <plugin acl="department" headline="Departments" icon="department.png"
                                path="plugins/admin/departments" class="department" />
                        <plugin acl="application" headline="Applications"
                                icon="application.png" class="application"
                                path="plugins/admin/applications" />
                        <plugin acl="blocklists" headline="FAX Blocklists" icon="blocklists.png"
                                path="plugins/gofax/blocklists" class="blocklist" />
                        <plugin acl="terminal" headline="Terminals" icon="terminal.png"
                                path="plugins/admin/terminals" />
                        <!-- These are currently disabled
                        <plugin acl="workstation" headline="Workstations" icon="workstation.png"
                                path="plugins/admin/workstations" />
                        <plugin acl="server" headline="Servers" icon="server.png"
                                path="plugins/admin/servers" /> -->
                        <plugin acl="services" headline="Services" icon="service.png"
                                path="plugins/admin/services" />
                </section>

                <section name="Addons">
                        <plugin acl="default" headline="Phone list" icon="phonelist.png"
                                path="plugins/addons/phonelist" />
                        <plugin acl="default" headline="FAX reports" icon="reports.png"
                                path="plugins/gofax/reports" />
                        <plugin acl="ldif" headline="LDIF export" icon="ldif.png"
                                path="plugins/addons/ldifexport" />
                </section>
        </menu>

        <usertabs>
                <tab class="user" name="Generic" />
                <tab class="posixAccount" name="Unix" />
                <tab class="mailAccount" name="Mail" />
                <tab class="sambaAccount" name="Samba" />

EOT;
	echo <<<EOT
                <tab class="proxyAccount" name="Proxy" />

EOT;
	if (!isset($classes['pureftp'])){
		echo <<<EOT
                <tab class="pureftpdAccount" name="FTP" />
		
EOT;
	}
	echo <<<EOT
                <tab class="gofaxAccount" name="Fax" />
        </usertabs>

        <grouptabs>
                <tab class="group" name="Generic" />
                <tab class="appgroup" name="Applications" />
                <tab class="mailgroup" name="Mail" />
                <tab class="acl" name="ACL" />
        </grouptabs>

        <appstabs>
                <tab class="application" name="Generic" />
                <tab class="applicationParameters" name="Options" />
        </appstabs>
EOT;
	if (!isset($classes['dns'])){
		echo <<<EOT
        <dnstabs>
                <tab class="dnsZone" name="Zone" />
                <tab class="dnsEntries" name="Entries" />
        </dnstabs>

EOT;
	}
	echo <<<EOT
        <dhcpsharednetwork>
                <tab class="dhcpSharedNetwork" name="Generic" />
                <tab class="dhcpNetwork" name="Network" />
                <tab class="dhcpAdvanced" name="Advanced" />
        </dhcpsharednetwork>

        <dhcpgroup>
                <tab class="dhcpGroup" name="Generic" />
                <tab class="dhcpNetwork" name="Network" />
                <tab class="dhcpAdvanced" name="Advanced" />
        </dhcpgroup>

        <dhcphost>
                <tab class="dhcpHost" name="Generic" />
                <tab class="dhcpNetwork" name="Network" />
                <tab class="dhcpAdvanced" name="Advanced" />
        </dhcphost>

        <dhcpsubnet>
                <tab class="dhcpSubnet" name="Generic" />
                <tab class="dhcpNetwork" name="Network" />
                <tab class="dhcpAdvanced" name="Advanced" />
        </dhcpsubnet>

        <dhcppool>
                <tab class="dhcpPool" name="Generic" />
                <tab class="dhcpNetwork" name="Network" />
                <tab class="dhcpAdvanced" name="Advanced" />
        </dhcppool>

        <dhcpservice>
                <tab class="dhcpService" name="Generic" />
                <tab class="dhcpNetwork" name="Network" />
                <tab class="dhcpAdvanced" name="Advanced" />
        </dhcpservice>

        <termtabs>
                <tab class="termgeneric" name="Generic" />
                <tab class="termstartup" name="Startup" />
                <tab class="termservice" name="Services" />
                <tab class="terminfo" name="Information"
                        wakecmd="/usr/bin/sudo /usr/sbin/etherwake" />
        </termtabs>

        <servicemenu name="Services">
                <plugin acl="service" headline="DNS" icon="dns.png"
                        class="dns" path="plugins/services/dns" />
                <plugin acl="service"  headline="DHCP" icon="dhcp.png"
                        class="dhcp" path="plugins/services/dhcp" />
        </servicemenu>

        <main default="GONICUS"
                compile="/var/spool/gosa"
                lang=""
                theme="default"
                debuglevel="0"
                forcessl="false"
                warnssl="false"
                iconsize="48x48"
		dmode="$peopledn"
                pwminlen="6"
                forceglobals="false"
                smbhash='$pwdhash'
                hash="crypt">

                <location name="GONICUS"
                        uidbase="$uidbase"
                        governmentmode="false"
                        sambaversion="$samba"
                        server="$uri"
                        admin="$admin"
                        password="$password"
                        base="$base"
                        people="$peopleou"
                        groups="$groupou"
                        config="ou=gosa,ou=configs,ou=systems,$base" />

                <language name="German" tag="de_DE" />
                <language name="English" tag="en_EN" />

                <faxformat type="pdf" />
                <faxformat type="ps" />
                <faxformat type="png" />
                <faxformat type="mtiff" />
                <faxformat type="tiff" />
        </main>
</conf>
EOT;

	exit;
}

/* Set template compile directory */
$smarty->compile_dir= '/var/spool/gosa';

/* Check for compile directory */
if (!(is_dir($smarty->compile_dir) && is_writable($smarty->compile_dir))){
	print_red(sprintf(_("Directory '%s' specified as compile directory is not accessable!"), $smarty->compile_dir));
	exit();
}

/* Language setup */
$lang= get_browser_language();
putenv("LANG=$lang");
setlocale(LC_ALL, $lang);
$GLOBALS['t_language']= $lang;
$GLOBALS['t_gettext_message_dir'] = $BASE_DIR.'/locale/';

/* Set the text domain as 'messages' */
$domain = 'messages';
bindtextdomain($domain, "$BASE_DIR/locale");
textdomain($domain);

if ($_SERVER["REQUEST_METHOD"] != "POST"){
	@DEBUG (DEBUG_TRACE, __LINE__, __FUNCTION__, __FILE__, $lang, "Setting language to");
}

/* Fill template with required values */
$smarty->assign ('date', gmdate("D, d M Y H:i:s"));

if (isset($_POST['continue'])){
	$_SESSION['step']= 2;
}
if (isset($_POST['continue2'])){
	$_SESSION['step']= 3;
}
if (isset($_POST['continue3'])){
	$_SESSION['step']= 4;
}
if (isset($_POST['check'])){
	$_SESSION['step']= 5;
}
if (isset($_POST['retry'])){
	$_SESSION['step']= 6;
}

if (!isset($_SESSION['step'])){
	$smarty->assign ("content", get_template_path('setup_introduction.tpl'));
	$smarty->assign ("tests", perform_php_checks($faults));
	if ($faults){
		$smarty->assign("mode", "disabled");
	}
} else {

	switch ($_SESSION['step']){
		case 2:
			$smarty->assign ("content", get_template_path('setup_step2.tpl'));
			$smarty->assign ("tests", perform_additional_checks($faults));
			if ($faults){
				$smarty->assign("mode", "disabled");
			}
			break;

		case 3:
			$smarty->assign ("content", get_template_path('setup_step3.tpl'));
			$smarty->assign ("uri", "ldap://localhost:389");
			break;

		case 4:
			if (!isset($_POST['uri']) || $_POST['uri'] == ''){
				print_red (_("You've to specify an ldap server before continuing!"));
				$smarty->assign ("content", get_template_path('setup_step3.tpl'));
				break;
			}

			/* Build LDAP connection */
			error_reporting(0);
			$ds= ldap_connect ($_POST['uri']);
			if (!$ds) {
				print_red (_("Can't connect to the specified LDAP server! Please make sure that is reachable for GOsa."));
				$smarty->assign ("content", get_template_path('setup_step3.tpl'));
				$smarty->assign ("uri", $_POST['uri']);
				break;
			}
			ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, 3);
			$r= ldap_bind ($ds);
			if (!$r) {
				print_red (_("Can't bind to the specified LDAP server! Please make sure that is reachable for GOsa."));
				$smarty->assign ("content", get_template_path('setup_step3.tpl'));
				$smarty->assign ("uri", $_POST['uri']);
				break;
			}

			/* Get base to look for schema */
			$sr= ldap_read ($ds, "", "objectClass=*", array("namingContexts"));
			$attr= ldap_get_entries($ds,$sr);
			if (isset($attr[0]['dn'])){
				$base= $attr[0]['dn'];
			} else {
				$base= "dc=example,dc=net";
			}
			error_reporting(E_ALL);

			$ldapconf= array(	"uri" => $_POST['uri'],
						"base" => $base,
						"admin" => "cn=ldapadmin,$base",
						"password" => "",
						"peopleou" => "people",
						"groupou" => "groups",
						"peopledn" => "cn",
						"uidbase" => "1000");
			$_SESSION['ldapconf']= $ldapconf;

			$smarty->assign ("content", get_template_path('setup_step4.tpl'));
			foreach($ldapconf as $key => $val){
				$smarty->assign($key, $val);
			}
			$smarty->assign ("peopledns", array("cn", "uid"));
			break;

		case 5:
			$ldapconf= $_SESSION['ldapconf'];
			$showstopper= false;
			foreach ($ldapconf as $key => $val){
				if ($key == "uri" || $key == "base"){
					continue;
				}
				if (!isset($_POST[$key]) || $_POST[$key] == ""){
					print_red(sprintf(_("You're missing the required attribute '%s' from this formular. Please complete!"), $key));
					$showstopper= true;
					$_SESSION['ldapconf']= $ldapconf;
					$smarty->assign ("content", get_template_path('setup_step4.tpl'));
					foreach($ldapconf as $key => $val){
						$smarty->assign($key, $val);
					}
					$smarty->assign ("peopledns", array("cn", "uid"));
					break;
				}
				$ldapconf[$key]= $_POST[$key];
			}
			$_SESSION['ldapconf']= $ldapconf;
			if (!$showstopper){
				$ldap= new LDAP($ldapconf['admin'], $ldapconf['password'], $ldapconf['uri']);
				if ($ldap->error != "Success"){
					print_red(sprintf(_("Can't log into LDAP server. Reason was: %s."), $ldap->get_error()));
					$smarty->assign ("content", get_template_path('setup_step4.tpl'));
					foreach($ldapconf as $key => $val){
						$smarty->assign($key, $val);
					}
					$smarty->assign ("peopledns", array("cn", "uid"));
					break;
				}

				/* Schema check */
				$m= schema_check($ldapconf['uri'], $ldapconf['admin'], $ldapconf['password']);
				$_SESSION['classes']= $m;
				$errors= 0;
				$message= "";
				foreach ($m as $key => $msg){
					if ($key != 'dns' && $key != 'dhcp' && $key != 'pureftp' && ! ($key == 'samba2' || $key == 'samba3') ){
						$errors++;
						$message.= "$msg!<br>";
					}
				}
				if ($errors){
					print_red (preg_replace('/<br>$/', '', $message));
					$smarty->assign ("content", get_template_path('setup_step4.tpl'));
					foreach($ldapconf as $key => $val){
						$smarty->assign($key, $val);
					}
					$smarty->assign ("peopledns", array("cn", "uid"));
				} else {
					$info= posix_getgrgid(posix_getgid());
					$smarty->assign ("webgroup", $info['name']);
					$smarty->assign ("path", CONFIG_DIR);
					$smarty->assign ("content", get_template_path('setup_finish.tpl'));
				}
			}
			break;
			
		case 6:

			/* Check for config - and permissions */
			if (!file_exists(CONFIG_DIR."/gosa.conf")){
				print_red (_("No configuration found! Please save the generated one and place it in the suggested directory."));
				$info= posix_getgrgid(posix_getgid());
				$smarty->assign ("webgroup", $info['name']);
				$smarty->assign ("path", CONFIG_DIR);
				$smarty->assign ("content", get_template_path('setup_finish.tpl'));
				break;
			}
			$res= stat(CONFIG_DIR."/gosa.conf");
			if ($res['mode'] != 33184 || $res['uid'] != 0 || $res['gid'] != posix_getgid()){
				print_red (_("Config file found, but permissions are not secure. Please fix!"));
				$info= posix_getgrgid(posix_getgid());
				$smarty->assign ("webgroup", $info['name']);
				$smarty->assign ("path", CONFIG_DIR);
				$smarty->assign ("content", get_template_path('setup_finish.tpl'));
				break;
			}

			header ("Location: index.php");
			exit;
	}
}

/* show login screen */
$smarty->display (get_template_path('headers.tpl'));
$smarty->display (get_template_path('setup.tpl'));

?>

</body>

</html>
