<?php
class termservice extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage terminal service aspects";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Generic terminal attributes */
  var $gotoLpdEnable= FALSE;
  var $gotoXMonitor= "";
  var $gotoXMethod= "";
  var $gotoXdmcpServer= "";
  var $gotoFontPath= "";
  var $gotoXDriver= "";
  var $gotoXResolution= "";
  var $gotoXColordepth= "";
  var $gotoXHsync= "";
  var $gotoXVsync= "";
  var $gotoLpdEnable= "";
  var $gotoLpdServer= "";
  var $gotoScannerEnable= "";
  var $gotoScannerModel= "";
  var $gotoScannerClients= "";
  var $gotoScannerBackend= "";

  /* Needed values and lists */
  var $base= "";
  var $cn= "";
  var $XMethods= array();
  var $XDrivers= array("unknown", "ati", "atimisc", "chips", "cirrus", "cyrix", "fbdev",
                       "i128", "i740", "i810", "imstt", "mga", "neomagic", "newport", "nv",
                       "r128", "radeon", "rendition", "s3", "s3virge", "savage", "siliconmotion",
                       "sis", "tdfx", "tga", "trident", "tseng", "vesa", "vga");
  var $XResolutions= array("default", "640x480", "800x600", "1024x768", "1152x864", "1280x1024",
                           "1400x1050", "1600x1200");
  var $XColordepths= array("default", "8", "15", "16", "24");
  var $gotoScannerModels= array();


  /* attribute list for save action */
  var $attributes= array("cn", "gotoLpdEnable", "gotoXMonitor", "gotoXMethod", "gotoXdmcpServer",
			"gotoFontPath", "gotoXDriver", "gotoXResolution", "gotoXColordepth",
			"gotoXHsync", "gotoXVsync", "gotoLpdEnable", "gotoLpdServer",
			"gotoScannerEnable", "gotoScannerModel", "gotoScannerClients",
			"gotoScannerBackend");
  var $objectclasses= array("gotoTerminal", "GOhard");


  function termservice ($config, $dn= NULL)
  {
	plugin::plugin ($config, $dn);

	/* Load scanner models */
	$fcontents = file ($this->config->basedir."/include/scanner.inc");
	while (list ($line_num, $line) = each ($fcontents)) {
		preg_match('/^(\w+) "([^"]+)" "([^"]+)" "([^"]+)"/', "$line", $matches);
		$this->gotoScannerModels[$matches[2]." - ".$matches[3]]= $matches[1]."|".$matches[4];
	}
	ksort ($this->gotoScannerModels);
	
	/* Initialize methods */
  	$this->XMethods["default"]= _("default");
  	$this->XMethods["indirect"]= _("show chooser");
	$this->XMethods["query"]= _("direct");
	#$this->XMethods["squery"]= _("direct via ssh");
	#$this->XMethods["nquery"]= _("direct via nx");
	$this->XMethods["load"]= _("load balanced");
	#$this->XMethods["sload"]= _("load balanced via ssh");
	#$this->XMethods["nload"]= _("load balanced via nx");
	$this->XMethods["rdp"]= _("Windows RDP");
	$this->XMethods["citrix"]= _("ICA client");
  }

  function execute()
  {
	/* Do we need to flip is_account state? */
	if (isset($_POST['modify_state'])){
		$this->is_account= !$this->is_account;
	}

	/* Do we represent a valid terminal? */
	if (!$this->is_account && $this->parent == NULL){
		echo "<img src=\"images/stop.png\" align=center>&nbsp;<b>".
		_("This 'dn' has no terminal features.")."</b>";
		return;
	}

	/* Show main page */
        $smarty= get_smarty();

	/* Arrays */
	foreach(array("XMethods", "XDrivers", "XResolutions", "XColordepths",
			"gotoScannerModels") as $val){
		$smarty->assign("$val", $this->$val);
	}
	$smarty->assign("xdmcpservers", $this->config->data['SERVERS']['TERMINAL']);
	$smarty->assign("fontservers", $this->config->data['SERVERS']['FONT']);
	$smarty->assign("nfsservers", $this->config->data['SERVERS']['NFS']);
	$smarty->assign("nfsservers", $this->config->data['SERVERS']['NFS']);

	/* Variables - select */
	foreach(array("gotoXMethod", "gotoXdmcpServer", "gotoFontPath", 
		"gotoXDriver", "gotoXResolution", "gotoXColordepth", 
		"gotoLpdServer", "gotoScannerModel") as $val){

		$smarty->assign($val."_select", $this->$val);
		$smarty->assign($val."ACL", chkacl($this->acl, $val));
	}

	/* Variables */
	foreach(array("gotoXHsync", "gotoXVsync") as $val){
		$smarty->assign($val, $this->$val);
		$smarty->assign($val."ACL", chkacl($this->acl, $val));
	}

	/* Checkboxes */
	foreach(array("gotoLpdEnable", "gotoScannerEnable") as $val){
		if ($this->$val == TRUE) {
			$smarty->assign("$val", "checked");
		} else {
			$smarty->assign("$val", "");
		}
		$smarty->assign($val."ACL", chkacl($this->acl, "gotoLpdEnable"));
	}

        /* Show main page */
        $smarty->display (get_template_path('service.tpl', TRUE));
  }

  function remove_from_parent()
  {
	$ldap= $this->config->get_ldap_link();
	$ldap->rmdir($this->dn);
	show_ldap_error($ldap->get_error());
  }


  /* Save data to object */
  function save_object()
  {
	plugin::save_object();

	/* Save checkbox state */
	if (isset ($_POST['gotoXMethod'])){
		foreach (array("gotoLpdEnable", "gotoScannerEnable") as $val){
			
			if (!isset ($_POST["$val"]) && chkacl ($this->acl, "$val") == ""){
				$this->$val= FALSE;
			} else {
				$this->$val= TRUE;
			}
		}
	}
  }


  /* Check supplied data */
  function check()
  {
	$message= array();

	/* Default entries can use blank hsync/vsync entries */
	if ($this->dn != "" && $this->cn != "default"){

		/* Check vsync for correct usage */
		$val= preg_replace ("/\s/", "", $this->gotoXVsync);
		if (!preg_match ("/^\d+(\.\d+)?(\-\d+(\.\d+)?)?$/", $val)
			&& chkacl ($this->acl, "gotoXVsync") == ""){

			$message[]= _("Please specify a valid VSync range.");
		} elseif (chkacl ($this->acl, "gotoXVsync") == ""){
			list($v1,$v2)= split ("-", $val);
			if ($v2 != ""){
				if ($v1 > $v2){
					$message[]= _("Please specify a valid VSync range.");
				}
			}
		}

		/* Check hsync for correct usage */
		$val= preg_replace ("/\s/", "", $this->gotoXHsync);
		if (!preg_match ("/^\d+(\.\d+)?(\-\d+(\.\d+)?)?$/", $val)
			&& chkacl ($this->acl, "gotoXHsync") == ""){

			$message[]= _("Please specify a valid HSync range.");
		} elseif (chkacl ($this->acl, "gotoXHsync") == ""){
			list($v1,$v2)= split ("-", $val);
			if ($v2 != ""){
				if ($v1 > $v2){
					$message[]= _("Please specify a valid HSync range.");
				}
			}
		}
	}
	return ($message);
  }


  /* Save to LDAP */
  function save()
  {
	plugin::save();

	/* Strip out 'default' values */
	foreach (array("gotoXdmcpServer", "gotoFontPath", "gotoXResolution",
			"gotoXColordepth", "gotoLpdServer", "gotoXMethod") as $val){

		if ($this->attrs[$val] == "default"){
			$this->attrs[$val]= array();
		}
	}

	/* Write back to ldap */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd($this->dn);
	$ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());
  }

}

?>
