<?php
class proxyAccount extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage users proxy account";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Proxy attributes */
  var $gosaProxyAcctFlags= "[N    ]";
  var $gosaProxyID= "";
  var $gosaProxyWorkingStart= 420;
  var $gosaProxyWorkingStop= 1020;

  /* attribute list for save action */
  var $attributes= array("gosaProxyID", "gosaProxyAcctFlags", "gosaProxyWorkingStart",
			"gosaProxyWorkingStop");
  var $objectclasses= array("gosaProxyAccount");

  function proxyAccount ($config, $dn= NULL)
  {
	plugin::plugin ($config, $dn);
  }

  function execute()
  {
	/* Do we need to flip is_account state? */
	if (isset($_POST['modify_state'])){
		$this->is_account= !$this->is_account;
	}

	/* Do we represent a valid account? */
	if (!$this->is_account && $this->parent == NULL){
		echo "<img src=\"images/stop.png\" align=center>&nbsp;<b>".
			_("This account has no proxy extensions.")."</b>";
		echo back_to_main();
		return;
	}

	/* Show tab dialog headers */
	if ($this->parent != NULL){
		if ($this->is_account){
			$this->show_header(_("Remove proxy account"),
				_("This account has proxy features enabled. ".
				  "You can disable them by clicking below."));
		} else {
			$this->show_header(_("Create proxy account"),
				  _("This account has proxy features disabled. ".
				  "You can enable them by clicking below."));
			return;
		}
	}

	/* Prepare templating */
	$smarty= get_smarty();
	$smarty->assign("gosaProxyAcctFlagsACL", chkacl($this->acl, "gosaProxyAcctFlags"));
	$smarty->assign("gosaProxyWorkingStartACL", chkacl($this->acl, "gosaProxyWorkingStart"));
	$smarty->assign("gosaProxyWorkingStopACL", chkacl($this->acl, "gosaProxyWorkingStop"));

	/* Assign radio boxes */
	foreach (array("F", "T", "B", "N") as $val){
		if (is_integer(strpos($this->gosaProxyAcctFlags, "$val"))) {
			$smarty->assign("filter$val", "checked");
		} else {
			$smarty->assign("filter$val", "");
		}
	}

	/* Assign working time */
	$smarty->assign("starthour", (int)($this->gosaProxyWorkingStart / 60));
	$smarty->assign("startminute", (int)($this->gosaProxyWorkingStart % 60));
	$smarty->assign("stophour", (int)($this->gosaProxyWorkingStop / 60));
	$smarty->assign("stopminute", (int)($this->gosaProxyWorkingStop % 60));
	$hours= array();
	for($i=0; $i<24; $i++){
		$hours[]= sprintf("%02d",$i);
	}
	$smarty->assign("hours", $hours);
	$smarty->assign("minutes", array("00","15","30","45"));

	/* Show main page */
	$smarty->display (get_template_path('generic.tpl', TRUE, dirname(__FILE__)));
  }

  function remove_from_parent()
  {
	plugin::remove_from_parent();
	
	$ldap= $this->config->get_ldap_link();
        @DEBUG (DEBUG_LDAP, __LINE__, __FUNCTION__, __FILE__,
                $this->attributes, "Save");
	$ldap->cd($this->dn);
	$ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
	if (isset($_POST['proxyTab'])){
		/* Save flag value */
		if (chkacl ($this->acl, "gosaProxyAcctFlags") == ""){
			if (isset($_POST["filter"])){
				$this->gosaProxyAcctFlags= "[".$_POST["filter"]."          ]";
			}
		}

		/* Save time values */
		if (chkacl ($this->acl, "gosaProxyWorkingTime") == "" && isset($_POST['startMinute'])){
			$this->gosaProxyWorkingStart= $_POST["startHour"] * 60 + $_POST["startMinute"];
			$this->gosaProxyWorkingStop = $_POST["stopHour"]  * 60 + $_POST["stopMinute"];
		}
	}
  }


  /* Save to LDAP */
  function save()
  {
	plugin::save();

	/* Write back to ldap */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd($this->dn);
	$ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postcreate();
  }

}

?>
