<?php
class sambaAccount extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage users samba account";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Switch for Samba version */
  var $samba3= FALSE;
  var $uidNumber= 65535;
  var $gidNumber= 65535;

  /* Samba 2 attributes */
  var $pwdLastSet= "0";
  var $logonTime= "2147483647";
  var $logoffTime= "2147483647";
  var $kickoffTime= "2147483647";
  var $pwdCanChange= "0";
  var $pwdMustChange= "0";
  var $password_expires= 0;
  var $acctFlags= "[UXP       ]";
  var $smbHome= "";
  var $homeDrive= "";
  var $scriptPath= "";
  var $profilePath= "";
  var $rid= "";
  var $primaryGroupID= "";

  /* Samba 3 attributes */
  var $SID= "";
  var $ridBase= 0;
  var $sambaSID= "";
  var $sambaPwdLastSet= "0";
  var $sambaLogonTime= "2147483647";
  var $sambaLogoffTime= "2147483647";
  var $sambaKickoffTime= "2147483647";
  var $sambaPwdCanChange= "0";
  var $sambaPwdMustChange= "0";
  var $sambaAcctFlags= "[UXP       ]";
  var $sambaHomePath= "";
  var $sambaHomeDrive= "";
  var $sambaLogonScript= "";
  var $sambaProfilePath= "";
  var $sambaPrimaryGroupSID= "";
  var $sambaDomainName= "";

  /* attribute list for save action */
  var $attributes= array();
  var $objectclasses= array();

  function sambaAccount ($config, $dn= NULL)
  {
	/* Load attributes depending on the samba version */
	$this->samba3= ($config->current['SAMBAVERSION'] == 3);

	if ($this->samba3){
		$this->attributes= array ("sambaSID", "sambaPwdLastSet", "sambaLogonTime",
				"sambaLogoffTime", "sambaKickoffTime", "sambaPwdCanChange",
				"sambaPwdMustChange", "sambaAcctFlags", "uid",
				"sambaHomePath", "sambaHomeDrive", "sambaLogonScript",
				"sambaProfilePath", "sambaPrimaryGroupSID", "sambaDomainName");
		$this->objectclasses= array ("sambaSamAccount");
	} else {
		$this->attributes= array ("pwdLastSet", "logonTime", "logoffTime", "kickoffTime",
				"pwdCanChange", "pwdMustChange", "acctFlags", "profilePath", "uid",
				"smbHome", "homeDrive", "scriptPath", "rid", "primaryGroupID");
		$this->objectclasses= array ("sambaAccount");
	}

	plugin::plugin ($config, $dn);

	/* Get samba Domain in case of samba 3 */
	if ($this->samba3 && $this->sambaSID != ""){
		$this->SID= preg_replace ("/-[^-]+$/", "", $this->sambaSID);
		$ldap= $this->config->get_ldap_link();
		$ldap->cd($this->config->current['BASE']);
		$ldap->search ("(&(objectClass=sambaDomain)(sambaSID=$this->SID))");
		if ($ldap->count() != 0){
			$attrs= $ldap->fetch();
			$this->ridBase= $attrs['sambaAlgorithmicRidBase'][0];
			$this->sambaDomainName= $attrs['sambaDomainName'][0];
		} else {
			$this->sambaDomainName= "DEFAULT";
			$this->ridBase= $this->config->current['RIDBASE'];
			$this->SID= $this->config->current['SID'];
		}
	}

	/* Password expiery */
	if(isset($this->attrs['sambaPwdMustChange']) &&
		$this->attrs['sambaPwdMustChange'][0] != 0){
		$this->password_expires= 1;
	}
  }

  function execute()
  {
        /* Do we need to flip is_account state? */
        if (isset($_POST['modify_state'])){
                $this->is_account= !$this->is_account;
        }

	/* Do we represent a valid account? */
	if (!$this->is_account && $this->parent == NULL){
		echo "<img src=\"images/stop.png\" align=center>&nbsp;<b>".
			_("This account has no samba extensions.")."</b>";
		echo back_to_main();
		return;
	}

	/* Show tab dialog headers */
	if ($this->parent != NULL){
		if ($this->is_account){
			$this->show_header(_("Remove samba account"),
				_("This account has samba features enabled. You can disable them by clicking below."));
		} else {
			$obj= $this->parent->by_object['posixAccount'];
			
			/* Samba3 dependency on posix accounts are enabled
			   in the moment, because I need to rely on unique
			   uidNumbers. There'll be a better solution later
			   on. */
#			if ($this->config->current['SAMBAVERSION'] == 3 ||
			if ($obj->is_account){

				$this->show_header(_("Create samba account"),
					_("This account has samba features disabled. You can enable them by clicking below."));
			} else {
				$this->show_header(_("Create samba account"),
					_("This account has samba features disabled. Posix features are needed for samba accounts, enable them first."), TRUE);
			}
			return;
		}
	}

	/* Prepare templating */
	$smarty= get_smarty();
	if ($this->sambaPwdMustChange=="0"){
		$date= getdate();
	} else {
		$date= getdate($this->sambaPwdMustChange);
	}

	/* Fill calendar */
	$days= array();
	for($d= 1; $d<32; $d++){
		$days[]= $d;
	}
	$years= array();
	for($y= $date['year']-4; $y<$date['year']+4; $y++){
		$years[]= $y;
	}
	$months= array(_("January"), _("February"), _("March"), _("April"),
			_("May"), _("June"), _("July"), _("August"), _("September"),
			_("October"), _("November"), _("December"));
	$smarty->assign("day", $date["mday"]);
	$smarty->assign("days", $days);
        $smarty->assign("months", $months);
        $smarty->assign("month", $date["mon"]-1);
        $smarty->assign("years", $years);
	$smarty->assign("year", $date["year"]);

	/* Fill boxes */
	 if ($this->samba3){
		$domains= array();
		foreach($this->config->data['SERVERS']['SAMBA'] as $name => $content){
			$domains[]= $name;
		}
		$smarty->assign("domains", $domains);
	}
	$letters= array();
	for ($i= 68; $i<91; $i++){
		$letters[]= chr($i).":";
	}
	$smarty->assign("drives", $letters);

	/* Variables */
	foreach($this->attributes as $val){
		$smarty->assign("$val", $this->$val);
		$smarty->assign("$val"."ACL", chkacl($this->acl,$val));
	}

	/* Checkboxes */
	foreach(array("P" => "allow_pwchange",
			"N" => "no_password_required",
			"D" => "temporary_disable") as $key => $val){
		if (is_integer(strpos($this->sambaAcctFlags, "$key"))) {
			$smarty->assign("flags$key", "checked");
		} else {
			$smarty->assign("flags$key", "");
		}
		$smarty->assign("$val"."ACL", chkacl($this->acl, "$val"));
	}
	if ($this->password_expires=="1"){
		$smarty->assign("flagsC", "checked");
	}
	$smarty->assign("password_expiresACL", chkacl($this->acl, "password_expires"));
	$smarty->assign("sambaDomainNameACL", chkacl($this->acl, "sambaDomainName"));

	/* Show main page */
	if ($this->samba3){
		$smarty->display (get_template_path('samba3.tpl', TRUE, dirname(__FILE__)));
	} else {
		$smarty->display (get_template_path('samba2.tpl', TRUE, dirname(__FILE__)));
	}
  }

  function remove_from_parent()
  {
	/* include global link_info */
	$ldap= $this->config->get_ldap_link();

	plugin::remove_from_parent();
	
	/* Keep uid attribute for gosaAccount */
	unset($this->attrs['uid']);
	unset($this->attrs['uidNumber']);
	unset($this->attrs['gidNumber']);
        @DEBUG (DEBUG_LDAP, __LINE__, __FUNCTION__, __FILE__,
                $this->attributes, "Save");
	$ldap->cd($this->dn);
	$ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
	if (isset($_POST['sambaTab'])){
		plugin::save_object();

		/* Take care about access options */
		$tmp= "UX";
		if (isset($_POST["allow_pwchange"])){
			if ($_POST["allow_pwchange"] == 1){
				$tmp.= "P";
				$this->pwdCanChange= 1;
			}
		} else {
			$this->pwdCanChange= 0;
		}
		if (isset($_POST["no_password_required"])){
			if ($_POST["no_password_required"] == 1){
				$tmp.= "N";
			}
		}
		if (isset($_POST["password_expires"])){
			if ($_POST["password_expires"] == 1){
				$this->password_expires= 1;
			}
		} else {
			$this->password_expires= 0;
		}
		if (isset($_POST["temporary_disable"])){
			if ($_POST["temporary_disable"] == 1){
				$tmp.= "D";
			}
		}

		$fill= "";
		for ($i= strlen($tmp); $i<12; $i++){
			$fill.= " ";
		}

		$tmp= "[$tmp$fill]";

		/* Only save if acl's are set */
		if (chkacl ($this->acl, "acctFlags") == ""){
			if ($this->samba3){
				$this->sambaAcctFlags= $tmp;
			} else {
				$this->acctFlags= $tmp;
			}
		}

		/* Save sambaDomain attribute */
		if (chkacl ($this->acl, "sambaDomainName") == "" && $this->samba3 &&
			isset ($_POST['sambaDomainName'])){

			$this->sambaDomainName= $_POST['sambaDomainName'];
		}
	}
  }


  /* Save to LDAP */
  function save()
  {
	/* Load uid and gid of this 'dn' */
	$ldap= $this->config->get_ldap_link();
	$ldap->cat($this->dn);
	$tmp= $ldap->fetch();
	$this->uidNumber= $tmp['uidNumber'][0];
	$this->gidNumber= $tmp['gidNumber'][0];

	plugin::save();

	/* Generate rid / primaryGroupId */
	if ($this->samba3){
		$this->SID= $this->config->data['SERVERS']['SAMBA'][$this->sambaDomainName]['SID'];
		$this->ridBase= $this->config->data['SERVERS']['SAMBA'][$this->sambaDomainName]['RIDBASE'];
	
		/* Need to generate a new uniqe uid/gid combination? */
		if ($this->sambaSID == ""){
			$uidNumber= $this->uidNumber;
			while(TRUE){
				$sid= $this->SID."-".($uidNumber*2 + $this->ridBase);
				$ldap->cd($this->config->current['BASE']);
				$ldap->search("(sambaSID=$sid)");
				if ($ldap->count() == 0){
					break;
				}
				$uidNumber++;
			}
			$this->attrs['sambaSID']= $sid;
			
			/* Check for users primary group */
			$ldap->cd($this->config->current['BASE']);
			$ldap->search("(&(objectClass=posixGroup)(gidNumber=".$this->gidNumber."))");
			if ($ldap->count() != 1){
				print_orange(_("Warning: Can't identify users primary group - no conversion to a samba group possible!"));
			} else {
				$attrs= $ldap->fetch();
				$g= new group($this->config, $ldap->getDN());
				if ($g->sambaSID == ""){
					$g->sambaDomainName= $this->sambaDomainName;
					$g->smbgroup= TRUE;
					$g->save ();
				}
				$this->attrs['sambaPrimaryGroupSID']= $g->sambaSID;
			}
		}

		if ($this->sambaHomeDrive == ""){
			$this->attrs["sambaHomeDrive"]= array();
		}

		/* Password expiery */
		if ($this->password_expires == "1"){
			$this->attrs['sambaPwdMustChange']= $this->sambaPwdMustChange;
		} else {
			$this->attrs['sambaPwdMustChange']= 2147483647;
		}
	} else {
		$this->attrs['rid']= $this->uidNumber*2 + 1000;
		$this->attrs['primaryGroupID']= $this->gidNumber*2 +1001;

		if ($this->homeDrive == ""){
			$this->attrs["homeDrive"]= array();
		}

		/* Password expiery */
		if ($this->password_expires == "1"){
			$this->attrs['pwdMustChange']= $this->pwdMustChange;
		} else {
			$this->attrs['pwdMustChange']= 2147483647;
		}
	}

	/* Write back to ldap */
	$ldap->cd($this->dn);
	$ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postcreate();
  }

  function adapt_from_template($dn)
  {
        plugin::adapt_from_template($dn);
	$this->sambaSID= "";
	$this->sambaPrimaryGroupSID= "";
  }

}

?>
