<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2004  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class dhcpNetwork extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage DHCP networks";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Used attributes */
  var $options= array();
  var $statements= array();

  /* attribute list for save action */
  var $attributes= array();
  var $objectclasses= array();

  function dhcpNetwork($config, $dn= NULL)
  {
	/* This is always an account */
	$this->is_account= TRUE;
  }

  function execute()
  {
	/* Check for iteraction */
	if (isset($_POST['add_dns']) && $_POST['addserver'] != ""){
		if (!preg_match('/^[0-9a-z.-]+$/', $_POST['addserver'])){
			print_red(_("The name of the DNS server your're going to add is not valid!"));
		} else {
			$servers= array();
			if (isset($this->options['domain-name-servers'])){
				foreach(split(",", $this->options['domain-name-servers']) as $val){
					$servers[$val]= $val;
				}
			}
			$servers[$_POST['addserver']]= $_POST['addserver'];
			$tmp= "";
			foreach($servers as $val){
				$tmp.= $val.",";
			}
			$this->options['domain-name-servers']= preg_replace('/,$/', '', $tmp);
		}
	}
	if (isset($_POST['delete_dns']) && isset($_POST['dnsserver'])){
		$tmp= preg_replace("/(\s*,\s*)?".$_POST['dnsserver']."/i", '',
					$this->options['domain-name-servers']);
		$tmp= preg_replace("/(\s*)?,(\s*)?$/", '', $tmp);
		if ($tmp != ""){
			$this->options['domain-name-servers']= $tmp;
		} else {
			unset($this->options['domain-name-servers']);
		}
	}

	/* Show main page */
	$smarty= get_smarty();

	/*
	 * Assemble options
	 */
	
	/* Router */
	if (isset($this->options['routers'])){
		$smarty->assign("routers", $this->options['routers']);
	}

	/* DNS */
	if (isset($this->options['domain-name'])){
		$smarty->assign("domain", trim($this->options['domain-name'], '"'));
	}
	if (isset($this->options['domain-name-servers'])){
		$servers= array();
		foreach(split(",", $this->options['domain-name-servers']) as $val){
			$servers[$val]= $val;
		}
		$smarty->assign("dnsservers", $servers);
	}

	/* Netmask / Broadcast */
	if (isset($this->options['subnet-mask'])){
		$this->options['subnet-mask']= normalize_netmask($this->options['subnet-mask']);
		list($nm0, $nm1, $nm2, $nm3)= split('\.', $this->options['subnet-mask']); 
		for ($i= 0; $i<4; $i++){
			$name= "nm$i";
			$smarty->assign("nm$i", $$name);
		}
	}
	if (isset($this->options['broadcast-address'])){
		list($bc0, $bc1, $bc2, $bc3)= split('\.', $this->options['broadcast-address']); 
		for ($i= 0; $i<4; $i++){
			$name= "bc$i";
			$smarty->assign("bc$i", $$name);
		}
	}

	/* Boot stuff */
	if (isset($this->statements['filename'])){
		$smarty->assign("filename", trim($this->statements['filename'], '"'));
	}
	if (isset($this->statements['next-server'])){
		$smarty->assign("nextserver", trim($this->statements['next-server'], '"'));
	}
	
	/* Set flags */
	if (isset($this->statements['get-lease-hostnames'])){
		if (preg_match('/^(true|on|yes)$/', $this->statements['get-lease-hostnames'])){
			$smarty->assign("autohost", "checked");
		}
	}
	if (isset($this->statements['use-host-decl-names'])){
		if (preg_match('/^(true|on|yes)$/', $this->statements['use-host-decl-names'])){
			$smarty->assign("autohostdecl", "checked");
		}
	}
	
	$smarty->display (get_template_path('network.tpl', TRUE));
  }

  function remove_from_parent()
  {
	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
	/* Only save, if we are "active" */
	if (isset($_POST['routers'])){
		
		/*
		 * Assemble options
		 */

		/* Options */
		foreach (array("routers" => "routers", "domain-name" => "domain") as $key => $val){

			if ($_POST["$val"] == ''){
				unset($this->options["$key"]);
			} else {
				$this->options["$key"]= $_POST["$val"];
			}
		}

		/* Statements */
		foreach (array("filename" => "filename", "next-server" => "nextserver") as $key => $val){
			if ($_POST["$val"] == ''){
				unset($this->statements["$key"]);
			} else {
				$this->statements["$key"]= '"'.$_POST["$val"].'"';
			}
		}
		
		/* Netmask / Broadcast */
		foreach (array("subnet-mask" => "nm", "broadcast-address" => "bc")
			as $key => $val){

			$tmp= "";
			for ($i= 0; $i<4; $i++){
				$tmp.= $_POST["$val$i"].".";
			}
			if ($tmp == "...."){
				unset($this->options["$key"]);
			} else {
				$this->options["$key"]= preg_replace('/\.$/', '', $tmp);
			}
		}

		/* Flags */
		if (isset ($_POST['autohost'])){
			$this->statements['get-lease-hostnames']= "true";
		} else {
			unset($this->statements['get-lease-hostnames']);
		}
		if (isset ($_POST['autohostdecl'])){
			$this->statements['use-host-decl-names']= "on";
		} else {
			unset($this->statements['use-host-decl-names']);
		}
	}
  }


  /* Check values */
  function check()
  {
	$message= array();

	/* Check netmask and broadcast */
	foreach(array("subnet-mask" => _("Netmask"), "broadcast-address" => _("Broadcast")) as $key => $typ){
		if (!isset($this->options["$key"])){
			continue;
		}
		$tmp= preg_replace('/^[^\s]+\s/', '', $this->options["$key"]);

		list($n0,$n1,$n2,$n3)= split('\.', $tmp);
		for ($i= 0; $i<4; $i++){
			$name= "n$i";
			if (preg_match('/^[0-9]+$/', $$name)){
				$val= (int)($$name);
				if ($val < 0 || $val > 255){
					$message[]= sprintf(_("Error in definition of '%s'!"), $typ);
					break;
				}
			} else {
				$message[]= sprintf(_("Illegal characters in definition of '%s'!"), $typ);
				break;
			}
		}
	}

	#FIXME: There are some more things we could test -> valid netmask, range
	return $message;
  }


  /* Save to LDAP */
  function save()
  {
  }
  
}

?>
