<?php

class phonelist extends plugin
{
  /* Phonelist attributes */
  var $telephone_list = array();
  var $start= 0;
  var $search_for= "*";
  var $search_base= "";
  var $search_type= "";

  /* attribute list for save action */
  var $attributes= array();
  var $objectclasses= array();

  function phonelist ($config, $dn= NULL)
  {
	/* Include config object */
	$this->config= $config;

        /* Get global filter config */
        if (!is_global("phonefilter")){
		$ui= get_userinfo();
                $base= get_base_from_people($ui->dn);
                $phonefilter= array("search_base" => $base,
                                  "search_for" => "*",
				  "object_type" => "*");
                register_global("phonefilter", $phonefilter);
        }
  }

  function execute()
  {
	/* Save formular information */
        $phonefilter= get_global("phonefilter");
        foreach( array("search_for", "search_base", "object_type") as $type){
                if (isset($_POST[$type])){
                        $phonefilter[$type]= $_POST[$type];
                }
                $this->$type= $phonefilter[$type];
        }

	/* Search string */
	$s= utf8_encode($phonefilter['search_for']);
	if ($s == "") {
		$s= "*";
	}
	if (isset($_GET['search'])){
		$s= $_GET['search'][0]."*";
		if ($s == "**"){
			$s= "*";
		}
		$this->search_for= $s;
		$phonefilter['search_for']= $s;
	}
        register_global("phonefilter", $phonefilter);

	/* Get ldap link / build filter */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd ($this->search_base);
	if ($phonefilter['object_type'] == '*'){
		$ldap->search ("(&(objectClass=gosaAccount)(!(objectClass=gosaUserTemplate))".
			"(|(uid=$s)(homePhone=$s)(telephoneNumber=$s)".
			"(facsimileTelephoneNumber=$s)(mobile=$s)(givenName=$s)(sn=$s)))");
	} else {
		$ldap->search ("(&(objectClass=gosaAccount)(!(objectClass=gosaUserTemplate))".
			"(".$phonefilter['object_type']."=$s))");
	}

	/* Build current list, error reporting is off, because many of the
	   objects may not be defined after LDAP queries. Asking for presence
	   first is too much overhead. */
	error_reporting(0);
	$this->telephone_list= array ();

	/* Walk through LDAP results */
	while ($attrs= $ldap->fetch()){

		/* Only show lines that have set any mail or phone informations */
		if (isset($attrs['telephoneNumber'][0]) ||
			isset($attrs['facsimileTelephoneNumber'][0]) ||
			isset($attrs['mobile'][0]) ||
			isset($attrs['homePhone'][0]) ||
			isset($attrs['mail'][0])){

			$this->telephone_list[$attrs['cn'][0]]=
				"<td title=\"".utf8_decode($attrs['sn'][0]).", ".utf8_decode($attrs['givenName'][0])."\">".utf8_decode($attrs['sn'][0]).", ".utf8_decode($attrs['givenName'][0])."</td>".
				"<td title=\"".$attrs['telephoneNumber'][0]."\">".$attrs['telephoneNumber'][0]."</td>".
				"<td title=\"".$attrs['facsimileTelephoneNumber'][0]."\">".$attrs['facsimileTelephoneNumber'][0]."</td>".
				"<td title=\"".$attrs['mobile'][0]."\">".$attrs['mobile'][0]."</td>".
				"<td title=\"".$attrs['homePhone'][0]."\">".$attrs['homePhone'][0]."</td><td>".
				"<a href=\"getvcard.php?uid=".$attrs['uid'][0]."\">".
				"<img align=\"top\" border=0 src=\"images/save.png\"".
				"alt=\"vcf\" title=\"".sprintf(_("Save contact for %s as vcard"), utf8_decode($attrs['givenName'][0]." ".$attrs['sn'][0]))."\"></a>";

			if (isset($attrs['mail'])){
				$dest= sprintf(_("Send mail to %s"), $attrs['mail'][0]);
				$this->telephone_list[$attrs['cn'][0]].=
					"<a href=\"mailto:".$attrs['mail'][0]."\">".
					"<img align=\"top\" border=0 src=\"images/mailto.png\"".
					"alt=\"vcf\" title=\"$dest\"></a>";
			}
			$this->telephone_list[$attrs['cn'][0]].= "</td>";
		}
	}
	error_reporting(E_ALL);

	/* Sort up list */
	ksort ($this->telephone_list);
	reset ($this->telephone_list);

	/* Fill template variables */
	$smarty= get_smarty();
	$smarty->assign("search_for", $this->search_for);
	$smarty->assign("object_type", $this->object_type);
	$smarty->assign("deplist", $this->config->idepartments);
	$smarty->assign("depselect", $this->search_base);
	$smarty->assign("infoimage", get_template_path('images/info.png'));
	$smarty->assign("launchimage", get_template_path('images/launch.png'));

	/* Generate alphabet */
	$characters= "*ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	$alphabet= "";
	$c= 0;
	for ($i= 0; $i<strlen($characters); $i++){
		if ($c == 0){
			$alphabet.= "<tr>";
		}
		$alphabet.= "<td><a class=\"alphaselect\" href=\"main.php?plug=".$_GET['plug']."&amp;search=".$characters[$i]."\">&nbsp;".$characters[$i]."&nbsp;</a></td>";
		if ($c++ == 10){
			$alphabet.= "</tr>";
			$c= 0;
		}
	}
	while ($c++ < 11){
		$alphabet.= "<td>&nbsp;</td>";
	}

	/* Build list output */
	$output= "";
	$mod= 0;
	if (isset($_GET['start'])){
		$this->start= $_GET['start'];
	}
	foreach ($this->telephone_list as $val){
		if ($mod < $this->start) {
			$mod++;
			continue;
		}
		if ($mod > ($this->start + 19)){
			$mod++;
			break;
		}
		if ( ($mod++) & 1){
			$col= "style=\"background-color: #ECECEC;\"";
		} else {
			$col= "style=\"background-color: #F5F5F5;\"";
		}
		$output.= "<tr $col>$val</tr>";
	}
	$smarty->assign("search_result", $output);
	$smarty->assign("apply", apply_filter());
	$smarty->assign("alphabet", $alphabet);
	$smarty->assign("range_selector", range_selector($this->telephone_list, $this->start));
	$tmp= array("*" => _("All"), "sn" => _("Name"), "givenName" => _("Given name"),
			"telephoneNumber" => _("Work phone"), "mobile" => _("Cell phone"),
			"homePhone" => _("Home phone"), "uid" => _("User ID"));
	natsort($tmp);
	$smarty->assign("objlist", $tmp);

	/* Show main page */
	$smarty->display(get_template_path('contents.tpl', TRUE));
  }

}

?>
