<?php
class termgeneric extends plugin
{
  /* CLI vars */
  var $cli_summary= "Manage terminal base objects";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* Generic terminal attributes */
  var $gotoMode= "disabled";
  var $gotoTerminalPath= "";
  var $gotoSwapServer= "";
  var $gotoSyslogServer= "";
  var $gotoNtpServer= "";
  var $gotoXKbModel= "";
  var $gotoXKbLayout= "";
  var $gotoXKbVariant= "";
  var $gotoXMouseType= "";
  var $gotoXMouseport= "";
  var $gotoSndModule= "";
  var $gotoFloppyEnable= "";
  var $gotoCdromEnable= "";
  var $macAddress= "";
  var $ghCpuType= "-";
  var $ghMemSize= "-";
  var $macAddress= "-";
  var $ghUsbSupport= "-";
  var $ghNetNic= array();
  var $ghIdeDev= array();
  var $ghScsiDev= array();
  var $ghGfxAdapter= "-";
  var $ghSoundAdapter= "-";
  var $gotoLastUser= "-";


  /* Needed values and lists */
  var $base= "";
  var $cn= "";
  var $XKbModels= array ("default", "btc9000", "chicony", "compaq", "dell", "dell101", "everex",
                         "flexpro", "geniuscomfy", "hp", "itouch", "jp106", "logicordless",
                         "logiinetnav", "logiinternet", "macintosh", "microsoft",
                         "microsoftpro", "omnikey101", "pc101", "pc102", "pc104",
                         "pc105", "rapidaccess", "rapidaccess2", "winbook");
  var $XKbLayouts= array ("default", "de", "intl", "us");
  var $XKbVariants= array ("default", "nodeadkeys", "basic");
  var $MouseTypes= array("AUTO", "ImPS/2", "PS/2", "Microsoft", "Logitech");
  var $MousePorts= array("AUTO", "/dev/ttyS0", "/dev/ttyS1", "/dev/psaux", "/dev/input/mice");

  /* Plugin side filled */
  var $modes= array();

  /* attribute list for save action */
  var $attributes= array("gotoMode", "gotoTerminalPath", "macAddress",
			"gotoSwapServer", "gotoSyslogServer", "gotoNtpServer",
			"gotoXKbModel", "gotoXKbLayout", "gotoFloppyEnable", "gotoCdromEnable", 
			"gotoXKbVariant", "gotoXMouseType", "gotoXMouseport", "cn", "gotoSndModule",
			"ghCpuType", "ghMemSize", "macAddress", "ghUsbSupport",
                        "ghGfxAdapter", "ghSoundAdapter", "gotoLastUser");
  var $objectclasses= array("gotoTerminal", "GOhard");

  function termgeneric ($config, $dn= NULL)
  {
	plugin::plugin ($config, $dn);

	/* Load available modes */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd ($this->config->current['BASE']);
	$ldap->search ("(objectClass=gotoInstallProfile)");
	while ($attrs= $ldap->fetch()){
		$this->modes[]= utf8_decode($attrs["cn"][0]);
	}

       /* Read arrays */
        foreach (array("ghNetNic", "ghIdeDev", "ghScsiDev") as $val){
                if (!isset($this->attrs[$val])){
                        continue;
                }
                for ($i= 0; $i<$this->attrs[$val]['count']; $i++){
                        array_push($this->$val, $this->attrs[$val][$i]);
                }
        }

	$this->modes["disabled"]= _("disabled");
	$this->modes["text"]= _("text");
	$this->modes["graphic"]= _("graphic");
  }

  function execute()
  {
	/* Do we need to flip is_account state? */
	if (isset($_POST['modify_state'])){
		$this->is_account= !$this->is_account;
	}

	/* Do we represent a valid terminal? */
	if (!$this->is_account && $this->parent == NULL){
		echo "<img src=\"images/stop.png\" align=center>&nbsp;<b>".
		_("This 'dn' has no terminal features.")."</b>";
		return;
	}

	/* Fill templating stuff */
	$smarty= get_smarty();
	if ($this->cn == 'default'){
		$smarty->assign("cn", _("default"));
	} else {
		$smarty->assign("cn", $this->cn);
	}
	$smarty->assign("bases", $this->config->idepartments);
	if ($this->base == ""){
		$this->base= preg_replace ("/^[^,]+,[^,]+,[^,]+,/", "", $this->dn);
	}
	if ($this->dn == "new" || preg_match ("/,ou=incoming,/", $this->dn)){
		$smarty->assign("selectmode", "");
	} else {
		$smarty->assign("selectmode", "disabled");
	}

	/* Arrays */
	foreach (array("modes", "XKbModels", "XKbLayouts", "XKbVariants",
			"MouseTypes", "MousePorts") as $val){
		$smarty->assign($val, $this->$val);
	}
	$smarty->assign("nfsservers", $this->config->data['SERVERS']['NFS']);
	$smarty->assign("syslogservers", $this->config->data['SERVERS']['SYSLOG']);
	$smarty->assign("ntpservers", $this->config->data['SERVERS']['NTP']);

	/* Variables */
	foreach(array("base", "gotoMode", "gotoTerminalPath", "gotoSwapServer",
		"gotoSyslogServer", "gotoNtpServer", "gotoXKbModel", "gotoXKbLayout",
		"gotoXKbVariant", "gotoXMouseType", "gotoXMouseport") as $val){

		$smarty->assign($val."_select", $this->$val);
		$smarty->assign($val."ACL", chkacl($this->acl, $val));
	}

	/* Show main page */
	$smarty->display (get_template_path('generic.tpl', TRUE));
  }

  function remove_from_parent()
  {
	$ldap= $this->config->get_ldap_link();
	$ldap->rmdir($this->dn);
	show_ldap_error($ldap->get_error());
  }


  /* Save data to object */
  function save_object()
  {
	plugin::save_object();

	/* Save base, since this is no LDAP attribute */
	if (isset($_POST['base']) && chkacl($this->acl, "create") == ""){
		$this->base= $_POST['base'];
	}

	/* Save terminal path to parent since it is used by termstartup, too */
	$this->parent->by_object['termstartup']->gotoTerminalPath=
		$this->gotoTerminalPath;
  }


  /* Check supplied data */
  function check()
  {
	$message= array();

	/* Permissions for that base? */
	if ($this->base != ""){
		$new_dn= utf8_encode("cn=".$this->cn."ou=terminals,ou=systems,").$this->base;
	} else {
		$new_dn= $this->dn;
	}

	$ui= get_userinfo();
	$acl= get_permissions ($new_dn, $ui->subtreeACL);
	$acl= get_module_permission($acl, "group", $new_dn);
	if (chkacl($acl, "create") != ""){
		$message[]= _("You have no permissions to create a terminal on this 'Base'.");
	}

	if ($this->dn == 'new'){
		$ldap= $this->config->get_ldap_link();
		$ldap->cd ($this->base);
		$ldap->search ("(&(objectClass=gotoTerminal)(cn=".$this->cn."))");
		if ($ldap->count() != 0){
			while ($ldap->fetch()){
				if (preg_match ("/,ou=incoming,/", $ldap->getDN())){
					continue;
				} else {
					$message[]= sprintf (_("There is already an entry '%s' in the base choosen by you"), $this->cn);
					break;
				}
			}
		}
	}

	return ($message);
  }


  /* Save to LDAP */
  function save()
  {
	plugin::save();

	/* Need to create new entry? */
	if ( $this->dn == ""){
		$new= TRUE;
		$this->dn= "cn=".$this->cn.",ou=terminals,ou=systems,".$this->base;
	} else {
		$new= FALSE;
	}

	/* Check for presence */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd($ldap->getParentDir($this->dn));
	$ldap->search("(&(objectClass=gotoTerminal)(cn=".$this->cn."))");
	if ($ldap->count() == 0){
		$new= TRUE;
	} else {
		$new= FALSE;
		$tmp= $ldap->fetch ();
		$objectclasses= $tmp["objectClass"];
	}

	/* Strip out 'default' values */
	foreach (array("gotoTerminalPath", "gotoSwapServer", "gotoSyslogServer",
			"gotoNtpServer", "gotoXKbModel",
			"gotoXKbLayout", "gotoXKbVariant") as $val){

		if ($this->attrs[$val] == "default"){
			$this->attrs[$val]= array();
		}
	}

        /* Add missing arrays */
        foreach (array("ghScsiDev", "ghIdeDev", "ghNetNic") as $val){
                if (isset ($this->$val) && count ($this->$val) != 0){
                        $this->attrs["$val"]= $this->$val;
                }
        }

	/* Remove all empty values */
	if ($new){
		$attrs= array();
		foreach ($this->attrs as $key => $val){
			if (is_array($val) && count($val) == 0){
				continue;
			}
			$attrs[$key]= $val;
		}
		$this->attrs= $attrs;
	}

	/* Write back to ldap */
	$ldap= $this->config->get_ldap_link();
	if ($new){
		$ldap->cd($this->config->current['BASE']);
		$ldap->create_missing_trees(preg_replace('/^[^,]+,/', '', $this->dn));
		$ldap->cd($this->dn);
		$ldap->add($this->attrs);
	} else {
		$ldap->cd($this->dn);
		$ldap->modify($this->attrs);
	}
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postcreate();
  }

}

?>
