<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

if (!$remove_lock){

	/* Page header*/
	print_header(get_template_path('images/ftp.png'), _("FTP settings"));

	/* Reset requested? */
	if (isset($_POST['edit_cancel']) ||
		(isset($_GET['reset']) && $_GET['reset'] == 1)){

		del_lock ($ui->dn);
		sess_del ('edit');
		sess_del ('pureftpdAccount');
	}

	/* Create proxyAccount object on demand */
	if (!isset($_SESSION['pureftpdAccount']) || (isset($_GET['reset']) && $_GET['reset'] == 1)){
		$_SESSION['pureftpdAccount']= new pureftpdAccount ($config, $ui->dn);
	}
	$pureftpdAccount= $_SESSION['pureftpdAccount'];

	/* save changes back to object */
	if (isset ($_SESSION['edit'])){
		$pureftpdAccount->save_object ();
	}

	/* Enter edit mode? */
	if (isset($_POST['edit'])){

		/* Check locking */
		if (($username= get_lock($ui->dn)) != ""){
			$_SESSION['back_plugin']= $plug;
			gen_locked_message ($username, $ui->dn);
			exit ();
		}

		/* Lock the current entry */
		add_lock ($ui->dn, $ui->dn);
		$_SESSION['dn']= $ui->dn;
		$_SESSION['edit']= TRUE;
	}

	/* Adjust acl's to mode */
	if (isset($_SESSION['edit'])){
		$acl= get_permissions ($ui->dn, $ui->subtreeACL);
		$pureftpdAccount->acl= get_module_permission($acl, "pureftpd", $ui->dn);
	} else {
		$pureftpdAccount->acl= "#none#";
	}

	/* save changes to LDAP and disable edit mode */
	if (isset($_POST['edit_finish'])){

		/* Perform checks */
		$message= $pureftpdAccount->check ();

		/* No errors, save object */
		if (count ($message) == 0){
			$pureftpdAccount->save ();
			gosa_log ("User/pureftpd object'".$ui->dn."' has been saved");
			$pureftpdAccount->acl= "#none#";
			del_lock ($ui->dn);
			sess_del ('edit');

			/* Reload */
			$pureftpdAccount= new pureftpdAccount ($config, $ui->dn);
		} else {
			/* Errors found, show message */
			show_errors ($message);
		}
	}

	/* Execute formular */
	$pureftpdAccount->execute ();

	/* Store changes  in session */
	if (isset ($_SESSION['edit'])){
		$_SESSION['pureftpdAccount']= $pureftpdAccount;
	}

	if ($pureftpdAccount->is_account){
		echo "<p class=\"plugbottom\">";

		/* Are we in edit mode? */
		if (isset($_SESSION['edit'])){
			echo "<input type=submit name=\"edit_finish\" value=\""._("Finish")."\">\n";
			echo "&nbsp;";
			echo "<input type=submit name=\"edit_cancel\" value=\""._("Cancel")."\">\n";
		} else {
			echo "<input type=submit name=\"edit\" value=\""._("Edit")."\">\n";

		}
		echo "</p>\n";
	}
}
?>
