<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
require "tabs_dns.inc";

class dnsManagement extends plugin
{
  /* Internal use */
  var $zonelist= array();
  var $list= array();
  var $dnstabs= NULL;

  /* Dialog attributes */
  var $ui= NULL;

  function dnsManagement ($config, $ui)
  {
	/* Save configuration for internal use */
	$this->config= $config;
	$this->ui= $ui;

        /* Get global filter config */
        if (!is_global("dnsfilter")){
                $ui= get_userinfo();
                $base= get_base_from_people($ui->dn);
                $dnsfilter= array("forwardzones" => "checked",
                                "reversezones" => "checked",
                                "entry" => "",
                                "depselect" => $base,
                                "regex" => "");
                register_global("dnsfilter", $dnsfilter);
        }
  }

  function execute()
  {
        /* Save data */
        $dnsfilter= get_global("dnsfilter");
        foreach( array("depselect", "entry", "regex") as $type){
                if (isset($_POST[$type])){
                        $dnsfilter[$type]= $_POST[$type];
                }
        }
        if (isset($_POST['depselect'])){
                foreach( array("forwardzones", "reversezones") as $type){

                        if (isset($_POST[$type])) {
                                $dnsfilter[$type]= "checked";
                        } else {
                                $dnsfilter[$type]= "";
                        }
                }
        }
        register_global("dnsfilter", $dnsfilter);

        /* Check sorting variable */
        $this->check_sortranges();
	if (!isset($this->dnstabs)){
	        $this->reload();
	}
	$smarty= get_smarty();

	/* Cancel dialogs */
	if (isset($_POST['edit_cancel']) || isset($_POST['password_cancel']) ||
		isset($_POST['delete_cancel'])){
		
		del_lock ($this->dnstabs->dn);
		del_lock ($this->dn);
		unset ($this->dnstabs);
		$this->dnstabs= NULL;
	}

	/* User wants to edit data? */
	if (isset($_POST['select_zone']) && isset($_POST['zonelist'])
		 && $_POST['zonelist'] != ""){

		/* Get 'dn' from posted 'applist', must be unique */
		$this->dn= $_POST['zonelist'];

		/* Check locking, save current plugin in 'back_plugin', so
		   the dialog knows where to return. */
		if (($user= get_lock($this->dn)) != ""){
			gen_locked_message ($user, $this->dn);
			return;
		}

		/* Lock the current entry, so everyone will get the
		  above dialog */
		add_lock ($this->dn, $this->ui->dn);

		/* Set up the users ACL's for this 'dn' */
		$acl= get_permissions ($this->dn, $this->ui->subtreeACL);

		/* Register apptabs to trigger edit dialog */
		$this->dnstabs= new dnstabs($this->config,
			$this->config->data['TABS']['DNSTABS'], $this->dn);
		$this->dnstabs->set_acl($acl);
	}

        if (isset($_POST['new_zone'])){
                /* By default we set 'dn' to 'new', all relevant plugins will
                   react on this. */
                $this->dn= "new";

                /* Create new dnstabs object */
                $this->dnstabs= new dnstabs($this->config,
                         $this->config->data['TABS']['DNSTABS'], $this->dn);
                $this->dnstabs->set_acl(array(':all'));
        }

	/* Finish zone edit is triggered by the tabulator dialog, so
	   the user wants to save edited data. Check and save at this
	   point. */
	if (isset($_POST['edit_finish'])){

		/* Check tabs, will feed message array */
		$this->dnstabs->last= $this->dnstabs->current;
		$this->dnstabs->save_object();
		$message= $this->dnstabs->check();

		/* Save, or display error message? */
		if (count($message) == 0){

			/* Save data data to ldap */
			$this->dnstabs->save();
			gosa_log ("Zone object'".$this->dn."' has been saved");
			$this->postcreate();

			/* Application has been saved successfully, remove lock from
			   LDAP. */
			if ($this->dn != "new"){
				del_lock ($this->dn);
			}

			/* There's no page reload so we have to read new apps at
			   this point. */
			$this->reload ();
			unset ($this->dnstabs);
			$this->dnstabs= NULL;

		} else {
			/* Ok. There seem to be errors regarding to the tab data,
			show message and continue as usual. */
			show_errors($message);
		}
	}

	/* User wants to edit data? */
	if (isset($_POST['delete_zone']) && isset($_POST['zonelist'])
		 && $_POST['zonelist'] != ""){

		/* Get 'dn' from posted 'applist', must be unique */
		$this->dn= $_POST['zonelist'];

		/* Load permissions for selected 'dn' and check if
		  we're allowed to remove this 'dn' */
                $acl= get_permissions ($this->dn, $this->ui->subtreeACL);
                $this->acl= get_module_permission($acl, "dns", $this->dn);
                if (chkacl($this->acl, "delete") == ""){

			/* Check locking, save current plugin in 'back_plugin', so
			   the dialog knows where to return. */
			if (($user= get_lock($this->dn)) != ""){
				gen_locked_message ($user, $this->dn);
				return;
			} else {
				# Lock this dn for editing
	                        add_lock ($this->dn, $this->ui->dn);

				$smarty->assign("message", sprintf(_("You're about to delete all information about the zone at '%s'."), utf8_decode($this->dn)));
				$smarty->display(get_template_path('remove.tpl', TRUE));
	                        return;
			}
		} else {
			/* Obviously the user isn't allowed to delete. Show message and
			   clean session. */
                        print_red (_("You are not allowed to delete this zone!"));
		}
	}


        /* Confirmation for deletion has been passed. User should be deleted. */
        if (isset($_POST['delete_zone_confirm'])){

                /* Some nice guy may send this as POST, so we've to check
                   for the permissions again. */
                if (chkacl($this->acl, "delete") == ""){

                        /* Delete request is permitted, perform LDAP action */
                        $this->dnstabs= new dnstabs($this->config,
				$this->config->data['TABS']['DNSTABS'],
				$this->dn);
                        $this->dnstabs->set_acl(array($this->acl));
                        $this->dnstabs->delete ();
			gosa_log ("DNS object'".$this->dn."' has been removed");
                        unset ($this->dnstabs);
                        $this->dnstabs= NULL;

                        /* Zone list has changed, reload it. */
                        $this->reload ();
                } else {

                        /* Normally this shouldn't be reached, send some extra
                           logs to notify the administrator */
                        print_red (_("You are not allowed to delete this zone!"));
                        gosa_log ("Warning: '".$this->ui->uid."' tried to trick zone deletion.");
                }

                /* Remove lock file after successfull deletion */
                del_lock ($this->dn);
        }


	/* Show tab dialog if object is present */
	if ($this->dnstabs != NULL){
		$this->dnstabs->execute();

		/* Don't show buttons if tab dialog requests this */
		if (!$this->dnstabs->by_object[$this->dnstabs->current]->dialog){
			echo "<p style=\"text-align:right\">\n";
			echo "<input type=submit name=\"edit_finish\" value=\""._("Finish")."\">\n";
			echo "&nbsp;\n";
			echo "<input type=submit name=\"edit_cancel\" value=\""._("Cancel")."\">\n";
			echo "</p>";
		}
		return;
	}

	/* Show main page */
	$smarty->assign("zonelist", $this->zonelist);
	$smarty->assign("sortranges", get_sort_ranges($this->sortranges));
	$smarty->assign("infoimage", get_template_path('images/info.png'));
	$smarty->assign("launchimage", get_template_path('images/launch.png'));
        foreach( array("depselect", "entry", "regex", "forwardzones", "reversezones") as $type){
                $smarty->assign("$type", $dnsfilter[$type]);
        }
        $smarty->assign("deplist", $this->config->idepartments);

	/* Extend if we are not using javascript */
	$smarty->assign("apply", apply_filter());
		
	$smarty->display(get_template_path('headpage.tpl', TRUE));
  }


  function reload()
  {
	/* Get config */
        $dnsfilter= get_global('dnsfilter');

        /* Set base for all searches */
        $base= $dnsfilter['depselect'];

        /* Regex filter? */
        if ($dnsfilter['regex'] != ""){
                $regex= $dnsfilter['regex'];
        } else {
                $regex= "";
        }

        /* User filter? */
        if ($dnsfilter['entry'] != ""){
                $filter= "(|(relativeDomainName=".$dnsfilter['entry'].")(aRecord=".$dnsfilter['entry'].")(pTRRecord=".$dnsfilter['entry']."))";
        } else {
                $filter= "";
        }

	/* Get list of terminals to be shown */
        $ldap= $this->config->get_ldap_link();
        $showZones= array();
        if ($dnsfilter['forwardzones'] == "checked"){
                $ldap->cd($base);
                $ldap->search("(&(objectClass=dnsZone)(!(zoneName=*in-addr.arpa*))$filter)");
                while ($attrs= $ldap->fetch()){
                        $showZones[$attrs['zoneName'][0]]= $attrs['zoneName'][0];
                }
        }
        if ($dnsfilter['reversezones'] == "checked"){
                $ldap->cd($base);
                $ldap->search("(&(objectClass=dnsZone)(zoneName=*in-addr.arpa*)$filter)");
                while ($attrs= $ldap->fetch()){
                        $showZones[$attrs['zoneName'][0]]= $attrs['zoneName'][0];
                }
        }

	/* Generate zonelist */
	$this->list= get_list($this->ui->subtreeACL, "(&(objectClass=dnsZone)(relativeDomainName=@))");
	$this->zonelist= array();
	foreach ($this->list as $value){

                /* Unwanted? */
                if (!isset($showZones[$value['zoneName'][0]])) continue;
                if ($regex != "" && !preg_match("/$regex/", $value['zoneName'][0])) continue;

		if (preg_match ($this->sortranges[$this->sorting], $value["zoneName"][0])){
			$dn= preg_replace('/^[^,]+,/', '', $value["dn"]);
			if (isset($value["tXTRecord"][0])){
				$this->zonelist[$dn]= utf8_decode($value["zoneName"][0]).
								" [".utf8_decode($value["tXTRecord"][0])."]";
			} else {
				$this->zonelist[$dn]= $value["zoneName"][0];
			}
		}
	}

	/* Sort list and save */
	natcasesort ($this->zonelist);
	reset ($this->zonelist);
  }

  function remove_from_parent()
  {
	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Check values */
  function check()
  {
  }


  /* Save to LDAP */
  function save()
  {
	/* Optionally execute a command after we're done */
	$this->postcreate();
  }

  function adapt_from_template($dn)
  {
  }

  function password_change_needed()
  {
  }

  function show_header($button_text, $text, $disabled= FALSE)
  {
  }

  function remove_lock()
  {
        del_lock ($this->dnstabs->dn);
  }

}

?>
