<?php

function check(&$faults, $message, $description, $test, $required= TRUE)
{
	$msg= "<table class='check'><tr><td class='check' style='font-size:14px;'>$message</td><td rowspan=2 style='vertical-align:middle; text-align:center;width:45px;'>";
	if ($test){
		$msg.= _("OK")."<br>";
	} else {
		if (!$required){
			$msg.="<font color=red>"._("Ignored")."</font><br>";
		} else {
			$msg.="<font color=red>"._("Failed")."</font><br>";
			$faults++;
		}
	}
	$msg.= "</td></tr><tr><td class='check' style='padding-left:20px;background-color:#F0F0F0;'>$description</td></tr></table><br>";

	return $msg;
}

function perform_php_checks(&$faults)
{
	global $check_globals;
	
	$faults= 0;
	$msg= "";

	$msg.= "<h1>"._("PHP setup inspection")."</h1>";
	$msg.= check (	$faults, _("Checking for PHP version (>=4.1.0)"),
			_("PHP must be of version 4.1.0 or above for some functions and known bugs in PHP language."),
			minimum_version('4.1.0'));

	$msg.= check (	$faults, _("Checking if register_globals is set to 'off'"),
			_("register_globals is a PHP mechanism to register all global varibales to be accessible from scripts without changing the scope. This may be a security risk. GOsa will run in both modes."),
			$check_globals == 0, FALSE);

	$msg.= check (	$faults, _("Checking for ldap module"),
			_("This is the main module used by GOsa and therefore really required."),
			function_exists('ldap_bind'));

	$msg.= check (	$faults, _("Checking for gettext support"),
			_("Gettext support is required for internationalized GOsa."), function_exists('bindtextdomain'));

	$msg.= check (	$faults, _("Checking for mhash module"),
			_("To use SSHA encryption, you'll need this module. If you are just using crypt or md5 encryption, ignore this message. GOsa will run without it."),
			function_exists('mhash'), FALSE);

	$msg.= check (	$faults, _("Checking for gd module"),
			_("GOsa needs this module for recalculating image sizes provided for users as jpegPhoto."),
			function_exists('imagecreate'));
	$msg.= check (	$faults, _("Checking for imap module"),
			_("The IMAP module is needed to communicate with the IMAP server. It gets status informations, creates and deletes mail users."),
			function_exists('imap_open'));
	$msg.= check (	$faults, _("Checking for getacl in imap"),
			_("The getacl support is needed for shared folder permissions. The standard IMAP module is not capable of reading acl's. You need a recend PHP version for this feature."),
			function_exists('imap_getacl'), FALSE);
	$msg.= check (	$faults, _("Checking for mysql module"),
			_("MySQL support is needed for reading GOfax reports from databases."),
			function_exists('mysql_query'), FALSE);
	$msg.= check (	$faults, _("Checking for cups module"),
			_("In order to read available printers from IPP protocol instead of printcap files, you've to install the CUPS module."),
			function_exists('cups_get_dest_list'), FALSE);
	$msg.= check (	$faults, _("Checking for kadm5 module"),
			_("Managing users in kerberos requires the kadm5 module which is downloadable via PEAR network."),
			function_exists('kadm5_init_with_password'), FALSE);
	return ($msg);
}

  
function perform_additional_checks(&$faults)
{
	# Programm check
	$msg= "<h1>"._("Checking for some additional programms")."</h1>";
  
	# Image Magick
	$query= "LC_ALL=C LANG=C convert -help";
	$output= shell_exec ($query);
	$lines= split ("\n", $output);
	$version= preg_replace ("/^Version:[^I]+ImageMagick ([^\s]+).*/", "\\1", $lines[0]);
	list($major, $minor)= split("\.", $version);
	$msg.= check (	$faults, _("Checking for ImageMagick (>=5.4.0)"),
			_("ImageMagick is used to convert user supplied images to fit the suggested size and the unified JPEG format."),
			($major > 5 || ($major == 5 && $minor >= 4)));
    
	# Check for fping
	$query= "LC_ALL=C LANG=C fping -v 2>&1";
	$output= shell_exec ($query);
	$have_fping= preg_match("/^fping:/", $output);
	$msg.= check (	$faults, _("Checking for fping utility"),
			_("The fping utility is only used if you've got a thin client based terminal environment running."),
			$have_fping, FALSE);

	# Check for smb hash generation tool
	$query= "mkntpwd 2>&1";
	$output= shell_exec ($query);
	$have_mkntpwd= preg_match("/^Usage: mkntpwd /", $output);
	$alt = 0;
  
	if (!$have_mkntpwd){
		$query= "LC_ALL=C LANG=C perl -MCrypt::SmbHash -e 'ntlmgen \"PASSWD\", \$lm, \$nt; print \"\${lm}:\${nt}\\n\";' &>/dev/null";
		system ($query, $ret);
		$alt= ($ret == 0);
	}

	$msg.= check (	$faults, _("Checking for a way to generate LM/NT password hashes"),
			_("In order to use SAMBA 2/3, you've to install some additional packages to generate password hashes."),
			($have_mkntpwd || $alt));

	return $msg;
}

