<?php
/*
  This code is part of GOsa (https://gosa.gonicus.de)
  Copyright (C) 2003  Cajus Pollmeier

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class department extends plugin
{
  /* department attributes */
  var $ou= "";
  var $description= "";
  var $base= "";
  var $st= "";
  var $l= "";
  var $postalAddress= "";
  var $businessCategory= "";
  var $telephoneNumber= "";
  var $facsimileTelephoneNumber= "";

  /* Headpage attributes */
  var $last_dep_sorting= "invalid";
  var $departments= array();

  /* attribute list for save action */
  var $attributes= array("ou", "description", "businessCategory", "st", "l", "postalAddress",
			"telephoneNumber", "facsimileTelephoneNumber");
  var $objectclasses= array("top", "gosaDepartment", "organizationalUnit");

  function department ($config, $dn)
  {
  	plugin::plugin($config, $dn);
	$this->is_account= TRUE;
	$this->ui= get_userinfo();
	$this->dn= $dn;
	$this->config= $config;

	/* Set base */
        if ($this->dn == "new"){
		$ui= get_userinfo();
		$this->base= dn2base($ui->dn);
	} else {
                $this->base= preg_replace ("/^[^,]+,/", "", $this->dn);
        }
  }

  function execute()
  {
	/* Reload departments */
	$this->config->departments= get_departments();
	$this->config->make_idepartments();
	$smarty= get_smarty();


	/* Show main page */
	$smarty->assign("bases", $this->config->idepartments);
        if ($this->dn == "new"){
                $smarty->assign("mode", "");
                $smarty->assign("selectmode", "");
        } else {
                $smarty->assign("mode", "readonly");
                $smarty->assign("selectmode", "disabled");
        }

	foreach ($this->attributes as $val){
		$smarty->assign("$val", $this->$val);
		$smarty->assign("$val"."ACL", chkacl($this->acl, "$val"));
	}
	$smarty->assign("bases", $this->config->idepartments);
	$smarty->assign("base_select", $this->base);
	return($smarty->fetch (get_template_path('generic.tpl', TRUE)));
  }

  function clear_fields()
  {
	$this->dn= "";
	$this->base= "";
	$this->acl= "#none#";

	foreach ($this->attributes as $val){
		$this->$val= "";
	}
  }


  function remove_from_parent()
  {
	$ldap= $this->config->get_ldap_link();
	$ldap->cd ($this->dn);
	$ldap->recursive_remove();

	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
	plugin::save_object();

	/* Save base, since this is no LDAP attribute */
	if (isset($_POST['base']) && chkacl($this->acl, "create") == ""){
		$this->base= $_POST['base'];
	}
  }


  /* Check values */
  function check()
  {
	$message= array();

	/* Permissions for that base? */
	$new_dn= "ou=$this->ou,".$this->base;
	$acl= get_permissions ($new_dn, $this->ui->subtreeACL);
	$acl= get_module_permission($acl, "department", $new_dn);
	if (chkacl($acl, "create") != ""){
		$message[]= _("You have no permissions to create a department on this 'Base'.");
	}

	/* Check for presence of this department */
	$ldap= $this->config->get_ldap_link();
	$attrs= $ldap->cat ($new_dn);
	if (($this->dn == "new") && !($attrs === FALSE)){
		$message[]= _("Department with that 'Name' already exists.");
	}

	/* All required fields are set? */
	if ($_POST["ou"] == ""){
		$message[]= _("Required field 'Name' is not set.");
	}
	if ($_POST["description"] == ""){
		$message[]= _("Required field 'Description' is not set.");
	}

	/* Validate and modify - or: spaghetti rules! */
	if ($_POST['ou'] == "incoming"){
		$message[]= _("The field 'Name' contains the reserved word 'incoming'.".
				" Please choose another name.");
	}
	if (preg_match ('/[,#+:=>\\\\]/', $_POST['ou'])){
		$message[]= _("The field 'Name' contains invalid characters.");
	}
	if (!is_phone_nr($_POST['telephoneNumber'])){
		$message[]= _("The field 'Phone' contains an invalid phone number.");
	}
	if (!is_phone_nr($_POST['facsimileTelephoneNumber'])){
		$message[]= _("The field 'Fax' contains an invalid phone number.");
	}

	return $message;
  }


  /* Save to LDAP */
  function save()
  {
	plugin::save();

	/* Write back to ldap */
	$ldap= $this->config->get_ldap_link();
	$ldap->cat($this->dn);
	$a= $ldap->fetch();
	$ldap->cd($this->dn);
	if (count($a)){
		$ldap->modify($this->attrs);
	} else {
		$ldap->add($this->attrs);
	}
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postcreate();
  }

}

?>
