# gozerbot/channels.py
#
#

""" channel specific data """

__copyright__ = 'this file is in the public domain'

from gozerbot.pdod import Pdod
 
class Channels(Pdod):

    """ Channels class .. channels object is a pickled dict of dicts """

    def __init__(self, fname):
        Pdod.__init__(self, fname)
        for i, j in self.data.iteritems():
            if not j.has_key('perms'):
                j['perms'] = []

    def getchannels(self):
        """ return channels """
        result = []
        for channel in self.data.keys():
            channel = channel.strip()
            if channel and channel[0] in ['&', '#', '+', '!']:
                if channel not in result:
                    result.append(channel)
        return result

    def getchannelswithkeys(self):
        """ return channels with keys """
        result = []
        for channel in self.data.keys():
            channel = channel.strip()
            if channel and channel[0] in ['&', '#', '+', '!']:
                try:
                    key = self.data[channel]['key']
                    if not channel + ' ' + key in result:
                        result.append(channel + ' ' + key)
                except KeyError:
                    if channel not in result:
                        result.append(channel)
        return result

    def getkey(self, channel):
        try:
            key = self.data[channel]['key']
        except:
            key = None
        return key

    def getnick(self, channel):
        try:
            key = self.data[channel]['nick']
        except:
            key = None
        return key
