# gozerbot/config.py
#
#

""" this is where the config dict lives .. use pickle to persist config data
    .. use this pickle on start until the config file has changed  """

__copyright__ = 'this file is in the public domain'

from gozerbot.datadir import datadir
import os, pickle, popen2

# version string
ver = 'GOZERBOT 0.6.4.2'

def gethgrev():
    """ get mercurial revision """
    rev = None
    try:
        proces = popen2.Popen4('hg parents')
        data = proces.fromchild.readlines()
        if not proces.wait():
            rev = int(data[0].split(':')[1].strip())
    except Exception, ex:
        pass
    return rev

def getsvnrev():
    """ get subversion revision """
    rev = None
    try:
        proces = popen2.Popen4('svn info')
        data = proces.fromchild.readlines()
        if not proces.wait():
            for i in data:
                if i.startswith('Revision'):
                    rev = i.split()[1]
    except Exception, ex:
        pass
    return rev

def diffdict(dictfrom, dictto):
    """ check for differences between two dicts """
    temp = {}
    for i in dictto.iteritems():
        if dictfrom.has_key(i[0]):
            if dictfrom[i[0]] != i[1]:
                temp.setdefault(i[0], i[1])
        else:
            temp.setdefault(i[0], i[1])
    return temp

class Config(dict):

    """ config object is a dict """

    def __init__(self, datadir, *args, **kw):
        dict.__init__(self, *args, **kw)
        self.dir = str(datadir)
        self['dbtype'] = 'mysql'

    def __getitem__(self, item):
        """ get config item .. return None if not available"""
        if not self.has_key(item):
            return None
        else:
            return dict.__getitem__(self, item)

    def set(self, item, value):
        """ set a config item """
        dict.__setitem__(self, item, value)
        self.save()

    def load(self):
        """ load the config file """
        frompickle = {}
        picklemodtime = None
        # first do reload of the data/config file
        self.reload()
        # see if there is a configpickle
        try:
            picklemodtime = os.stat(self.dir + os.sep + 'configpickle')[8]
            configpickle = open(self.dir + os.sep + 'configpickle', 'r')
            frompickle = pickle.load(configpickle)
            configpickle.close()
        except OSError:
            return
        except:
            pass
        # see if data/config is more recent than the configpickle
        configmodtime = os.stat(self.dir + os.sep + 'config')[8]
        if picklemodtime and picklemodtime > configmodtime:
            # if so update the config dict with the pickled data
            a = diffdict(self, frompickle)
            self.update(a)
        # set version
        if self['dbenable']:
            self['version'] = ver + ' ' + self['dbtype'].upper()
        else:
            self['version'] = ver
        rev = gethgrev()
        if rev:
            self['version'] += " HG revision %s" % rev
            return
        rev = getsvnrev()
        if rev:
            self['version'] += " SVN revision %s" % rev
    
    def save(self):
        """ save config data to pickled file """
        picklefile = open(self.dir + os.sep + 'configpickle', 'w')
        pickle.dump(self, picklefile)
        picklefile.close()

    def reload(self):
        """ use execfile to reload data/config """
        try:
            execfile(self.dir + os.sep + 'config', config)
        except IOError:
            self.defaultconfig()
        # remove builtin data
        del self['__builtins__']
        # set version
        if self['dbenable']:
            self['version'] = ver + ' ' + self['dbtype'].upper()
        else:
            self['version'] = ver
        rev = gethgrev()
        if rev:
            self['version'] += " HG revision %s" % rev
            return
        rev = getsvnrev()
        if rev:
            self['version'] += " SVN revision %s" % rev

    def defaultconfig(self):
        self['loglevel'] = 100
        self['jabberenable'] = 0
        self['stripident'] = 1
        self['owneruserhost'] = 'bart@127.0.0.1'
        self['nick'] = 'gozerbot'
        self['server'] = 'localhost'
        self['port'] = 6667
        self['ipv6'] = 0
        self['username'] = 'gozerbot'
        self['realname'] = 'GOZERBOT'
        self['defaultcc'] = "!"
        self['nolimiter'] = 0
        self['quitmsg'] = 'http://gozerbot.org'
        self['dbenable'] = 0
        self['udp'] = 0
        self['partyudp'] = 0


configtxt = """# config
#
#

__copyright__ = 'this file is in the public domain'

# logging level .. the higher this value is the LESS the bot logs
loglevel = 10

## if you want to use jabber as the main bot

jabberenable = 0
jabberowner = 'bartholo@localhost'
jabberhost = 'localhost'
jabberuser = 'gozerbot@localhost'
jabberpass = 'pass'

## if you want to use irc as the main bot:

# stripident .. enable stripping of ident from userhost
stripident = 1

# userhost of owner .. make sure this matches your client's userhost
# if it doesn't match you will get an userhost denied message when you
# try to send commands to the bot
owneruserhost = 'bart@127.0.0.1'

# the nick the bot tries to use
nick = 'gozerbot'

# alternick
#alternick = 'gozerbot2'

# server to connect to
server = 'localhost'

# irc port to connect to 
port = 6667

# ircd password for main bot
#password = 'bla'

# ipv6
ipv6 = 0

# bindhost .. uncomment and edit to use
#bindhost = 'localhost'

# bots username
username = 'gozerbot'

# realname
realname = 'GOZERBOT'

# default control character
defaultcc = "!"

# no limiter
nolimiter = 0

# quit message
quitmsg = 'http://gozerbot.org'

## if you want to use a database:

dbenable = 0 # set to 1 to enable
dbtype = 'mysql' # one of mysql, postgres or sqlite
dbname = "gb_db"
dbhost = "localhost"
dbuser = "bart"
dbpasswd = "mekker2"
dboldstyle = False # set to True if mysql database is <= 4.1

## if you want to use udp:

# udp
udp = 0 # set to 1 to enable
partyudp = 0
udphost = 'localhost'
udpport = 5500
udpmasks = ['192.168*', ]
udpallow = ['127.0.0.1', ]
udpallowednicks = ['#dunkbots', 'dunker']
udppassword = 'mekker'

## other stuff:

# plugin server 
pluginserver = 'http://gozerbot.org'

# upgradeurl .. only needed if mercurial repo changed
#upgradeurl = 'http://gozerbot.org/hg/gozerbot'

# mail related
mailserver = None
mailfrom = None

# collective boot server
collboot = "gozerbot.org:8088"
"""

def writeconfig():
    if not os.path.isfile(datadir + os.sep + 'config'):
        cfgfile = open(datadir + os.sep + 'config', 'w')
        cfgfile.write(configtxt)
        cfgfile.close()

# create the config dict and load it from file
config = Config(datadir)
