# gozerbot/fleet.py
#
#

""" fleet is a list of bots """

__copyright__ = 'this file is in the public domain'

from gozerbot.datadir import datadir
from gozerbot.generic import rlog, handle_exception, waitforqueue
from gozerbot.eventhandler import commandhandler
from gozerbot.ircevent import Ircevent
from gozerbot.persist import Persist
from gozerbot.config import config
from gozerbot.bot import Bot
from gozerbot.plugins import plugins
from gozerbot.thr import start_new_thread
import Queue, os, types, threading

class Fleet(object):

    """ contains multiple bots (list of bots) """

    def __init__(self, fname):
        self.startok = threading.Event()
        self.bots = []
        self.botdata = Persist(fname)
        if not self.botdata.data:
            self.botdata.data = {}
        got = False
        for i,j in self.botdata.data.iteritems():
            if type(j) == types.TupleType:
                self.botdata.data[i] = ['irc', config['owneruserhost']] + \
list(j)
                got = True
        if got:
            self.botdata.save()

    def size(self):
        """ return number of bots """
        return len(self.bots)

    def start(self, mainbot=None):
        """ startup the bots """
        if mainbot:
            self.bots.append(mainbot)
            start_new_thread(mainbot.joinchannels, ())
        for i in self.botdata.data:
            start_new_thread(self.startbot, (i, ))
        self.startok.set()

    def save(self):
        """ save fleet data and call save on all the bots """
        try:
            self.botdata.save()
        except Exception, ex:
            handle_exception()

    def list(self):
        """ return list of bot names """
        result = []
        for i in self.bots:
            result.append(i.name)
        return result

    def stopall(self):
        """ return bot by name """
        for i in self.bots:
            try:
                i.stop()
            except:
                pass

    def byname(self, name):
        """ return bot by name """
        name = name.lower()
        for i in self.bots:
            if name == i.name:
                return i

    def replace(self, name, bot):
        name = name.lower()
        for i in range(len(self.bots)):
            if name == self.bots[i].name:
                self.bots[i] = bot

    # new style fleet
    def addbot(self, bot):
        self.bots.append(bot)
        if bot.type == 'irc':
            datalist = ['irc', bot.owner, bot.nick, bot.server, bot.port, \
bot.password, bot.ipv6]
        elif bot.type == 'jabber':
            datalist = ['jabber', bot.owner, bot.host, bot.user, \
bot.password, bot.port]
        self.botdata.data[bot.name.lower()] = datalist
        self.botdata.save()

    # new style fleet
    def startbot(self, name):
        name = name.lower()
        try:
            bd = self.botdata.data[name]
            got = False
            if bd[0] == 'irc':
                bot = Bot(bd[1], name)
                bot.connect(*bd[2:])
                got = True
            elif bd[0] == 'jabber':
                from gozerbot.jabberbot import Jabberbot
                bot = Jabberbot(name)
                bot.doconnect(*bd[2:])
                got = True
            if got:
                self.bots.append(bot)
                bot.joinchannels()
                rlog(10, 'fleet', 'started %s bot' % bot.name)
            else:
                rlog(10, 'fleet', 'failed to start %s bot' % bot.name)
        except Exception, ex:
            handle_exception()

    def connect(self, name):
        """ connect bot to irc server"""
        name = name.lower()
        for i in self.bots:
            if i.name == name:
                try:
                    data = self.botdata.data[name]
                except:
                    return
                if i.type == 'irc':
                    start_new_thread(i.connect, data[2:])
                elif i.type == 'jabber':
                    start_new_thread(i.doconnect, data[2:])
                else:
                    return 0
                return 1

    def delete(self, name):
        """ delete bot with name from fleet """
        name = name.lower()
        for i in self.bots:
            if i.name == name:
                i.exit()
                try:
                    del self.botdata.data[name]
                    self.botdata.save()
                except:
                    pass
                self.remove(i)
                rlog(10, 'fleet', '%s deleted' % i.name)
                return 1

    def remove(self, bot):
        """ delete bot by object """
        self.bots.remove(bot)

    def exit(self, name):
        """ call exit on all bots """
        name = name.lower()
        for i in self.bots:
            if i.name == name:
                try:
                    i.exit()
                except:
                    pass
                return 1

    def exitall(self):
        """ call exit on all bots """
        commandhandler.stop()
        for i in self.bots:
            try:
                i.exit()
            except Exception, ex:
                handle_exception()

    def cmnd(self, event, name, cmnd):
        """ do command on a bot by name """
        name = name.lower()
        bot = self.byname(name)
        if not bot:
            return 0
        if bot.type == 'irc':
            j = Ircevent()
        elif bot.type == 'jabber':
            from gozerbot.jabbermsg import Jabbermsg
            j = Jabbermsg()
        j.copyin(event)
        j.txt = cmnd
        q = Queue.Queue()
        j.queues = [q]
        j.speed = 3
        start_new_thread(plugins.trydispatch, (bot, j))
        result = waitforqueue(q)
        if not result:
            return
        res = ["[%s]" % bot.name, ]
        res += result
        event.reply(res)

    def cmndall(self, event, cmnd):
        """ do a command on all bots """
        threads = []
        for i in self.bots:
            thread = start_new_thread(self.cmnd, (event, i.name, cmnd))
            threads.append(thread)
        for i in threads:
            i.join(10)

fleet = Fleet(datadir + os.sep + 'fleet')
