# plugs/limiter.py
#
#

""" commands to get/set limiter values """

__copyright__ = 'this file is in the public domain'

from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.limiter import lim, setnrtimesmin, setnrtimeshour
from gozerbot.plughelp import plughelp
from gozerbot.generic import getwho
from gozerbot.users import users

plughelp.add('limiter', 'get/set limiter values')

def handle_limitersetmin(bot, ievent):
    try:
        (nick, nrtimes) = ievent.args
        nrtimes = int(nrtimes)
    except ValueError:
        ievent.missing('<nick> <nrtimes per minute>')
        return
    userhost = getwho(bot, nick)
    if not userhost:
        ievent.reply("can't find userhost of %s" % nick)
        return
    name = users.allowed(userhost, ['OPER', 'LIMITER'])
    if name:
        ievent.reply("can't set limiter on OPER .. LIMITER")
        return
    if not userhost:
        ievent.reply("can't find userhost of %s" % nick)
        return
    setnrtimesmin(userhost, nrtimes)
    ievent.reply("limiter per minute of %s set to %s" % (nick, nrtimes))
    
cmnds.add('limiter-setmin', handle_limitersetmin, 'OPER')
examples.add('limiter-setmin', 'limiter-setmin <nick> <nrtimes> .. set \
limiter value per minute for <nick>', 'limiter-setmin dunker 10')

def handle_limitersethour(bot, ievent):
    try:
        (nick, nrtimes) = ievent.args
        nrtimes = int(nrtimes)
    except ValueError:
        ievent.missing('<nick> <nrtimes per minute>')
        return
    userhost = getwho(bot, nick)
    if not userhost:
        ievent.reply("can't find userhost of %s" % nick)
        return
    name = users.allowed(userhost, ['OPER', 'LIMITER'])
    if name:
        ievent.reply("can't set limiter on OPER .. LIMITER")
        return
    if not userhost:
        ievent.reply("can't find userhost of %s" % nick)
        return
    setnrtimeshour(userhost, nrtimes)
    ievent.reply("limiter per hour of %s set to %s" % (nick,nrtimes))
    
cmnds.add('limiter-sethour', handle_limitersethour, 'OPER')
examples.add('limiter-sethour', 'limiter-sethour <nick> <nrtimes> .. set \
limiter value per hour for <nick>', 'limiter-sethour dunker 25')

def handle_limitergetmin(bot, ievent):
    try:
        nick = ievent.args[0]
    except IndexError:
        ievent.missing('<nick>')
        return
    userhost = getwho(bot, nick)
    if not userhost:
        ievent.reply("can't find userhost of %s" % nick)
        return
    try:
        nr = lim.data[userhost]['nrtimesmin']
    except KeyError:
        ievent.reply('no limit set')
        return
    ievent.reply('%s can given %s commands per minute' % (nick, nr))
    
cmnds.add('limiter-getmin', handle_limitergetmin, ['OPER', 'LIMITER'])
examples.add('limiter-getmin', 'limiter-getmin <nick> .. get \
limiter value per minute for <nick>', 'limiter-getmin dunker')

def handle_limitergethour(bot, ievent):
    try:
        nick = ievent.args[0]
    except IndexError:
        ievent.missing('<nick>')
        return
    userhost = getwho(bot, nick)
    if not userhost:
        ievent.reply("can't find userhost of %s" % nick)
        return
    try:
        nr = lim.data[userhost]['nrtimeshour']
    except KeyError:
        ievent.reply('no limit set')
        return
    ievent.reply('%s can given %s commands per hour' % (nick, nr))
    
cmnds.add('limiter-gethour', handle_limitergethour, ['OPER', 'LIMITER'])
examples.add('limiter-gethour', 'limiter-gethour <nick> .. get \
limiter value per minute for <nick>', 'limiter-gethour dunker')
