# plugs/log.py
#
#

""" logging """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog, handle_exception, elapsedstring, dmy, \
hourmin, toascii, lockdec
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.callbacks import callbacks, jcallbacks
from gozerbot.aliases import aliases
from gozerbot.plughelp import plughelp
from gozerbot.monitor import saymonitor, jabbermonitor
from gozerbot.aliases import aliases
import glob, re, thread, pickle, os, mmap, time

plughelp.add('log', 'logs related commands')

# check if logs dir exists if not create it
if not os.path.isdir('logs'):
    os.mkdir('logs')

loglock = thread.allocate_lock()
locked = lockdec(loglock)

class Logs(object):

    """ hold handles to log files (per channel) """

    def __init__(self, logdir):
        self.logdir = logdir
        self.maps = {}
        self.files = {}
        self.filenames = {}
        self.lock = thread.allocate_lock()
        self.loglist = []
        try:
            loglistfile = open(self.logdir + os.sep + 'loglist', 'r')
            self.loglist = pickle.load(loglistfile)
        except:
            self.loglist = []
        rlog(0, 'logs', 'loglist is %s' % str(self.loglist))
        # open log files in append mode
        for i in glob.glob(self.logdir + os.sep + '*.log'):
            reresult = re.search('logs%s(.+)\.' % os.sep, i)
            filename = reresult.group(1)
            if not filename:
                rlog(10, 'logs', "can't determine channel name")
                continue
            logfile = open(i, 'a')
            if logfile:
                self.files[filename] = logfile
                self.filenames[filename.lower()] = i
                rlog(1, 'logs', 'adding file %s' % i)
            else:
                rlog(10, 'logs', 'failed to open %s' % i)

    def save(self):
        """ save loglist """
        try:
            self.lock.acquire()
            picklefile = open(self.logdir + os.sep + 'loglist', 'w')
            pickle.dump(self.loglist, picklefile)
            rlog(0, 'logs', 'loglist saved')
        finally:
            self.lock.release()

    def close(self):
        """ close log files """
        try:
            self.lock.acquire()
            for i in self.files.keys():
                rlog(10, 'logs', 'closing ' + str(i))
                self.files[i].close()
        finally:
            self.lock.release()
        self.save()

    def size(self, channel):
        """ get size of log file """
        if channel[0] in ['#', '!', '&', '+']:
            chan = channel[1:].lower()
        else:
            chan = channel.lower()
        try:
            size = os.stat(self.filenames[chan])[6]
            return size
        except:
            return

    def add(self, channel):
        """ add logfile for channel """
        if channel[0] in ['#', '!', '&', '+']:
            chan = channel[1:].lower()
        else:
            chan = channel.lower()
        filename = self.logdir + os.sep + chan + '.log'
        rlog(10, 'logs', 'adding logfile %s' % chan)
        if self.files.has_key(chan):
            rlog(10, 'logs', 'already opened file %s' % chan)
            return 1
        try:
            logfile = open(filename,'a')
            self.files[chan] = logfile
            self.filenames[chan] = filename
            if channel not in self.loglist:
                self.loglist.append(channel)
            return 1
        except Exception, ex:
            handle_exception()
            return 0

    def logbot(self, name, ttime, channel, txt):
        if channel not in self.loglist:
            rlog(1, 'logs', "%s not in loglist" % channel)
            return
        if channel[0] in ['#', '!', '&', '+']:
            chan = channel[1:].lower()
        else:
            chan = channel.lower()
        filename = self.logdir + os.sep + chan + '.log'
        if not self.files.has_key(chan):
            if not self.add(channel):
                rlog(1, 'logs', "can't create logfile %s" % filename)
                return
        logfile = self.files[chan]
        logitem = (name, ttime, 'bot', 'bot@bot', txt)
        rlog(-1, 'logs', 'logging [%s] <%s> %s ==> %s' % (name, 'bot', txt, \
filename))
        # write the data to file (comma seperated)
        try:
            self.lock.acquire()
            logfile.write('%s,%s,%s,%s,%s\n' % logitem)
            logfile.flush()
        finally:
            self.lock.release()

    def log(self, name, ttime, ievent):
        """ log ircevent """
        if ievent.nick == ievent.bot.nick:
            ievent.nick = 'bot'
            ievent.userhost = 'bot@bot'
        channel = ievent.channel
        if channel not in self.loglist:
            rlog(1, 'logs', "%s not in loglist" % channel)
            return
        if channel[0] in ['#', '!', '&', '+']:
            chan = channel[1:].lower()
        else:
            chan = channel.lower()
        filename = self.logdir + os.sep + chan + '.log'
        if not self.files.has_key(chan):
            if not self.add(ievent.channel):
                rlog(1, 'logs', "can't create logfile %s" % filename)
                return
        # put ievent.cmnd as first txt
        if ievent.cmnd == 'PRIVMSG' or ievent.cmnd == 'Message':
            if ievent.usercmnd:
                tmp = "CMND: " + ievent.txt
            else:
                if ievent.txt.startswith('\001ACTION'):
                    txt = ievent.txt[7:-1]
                    tmp = "PRIVMSG: /me " + txt
                else:
                    tmp = "PRIVMSG: " + ievent.txt
        elif ievent.cmnd == 'MODE':
            tmp = "MODE: " + ievent.postfix
        elif ievent.cmnd == 'PART':
            tmp = "PART: " + ievent.channel
        elif ievent.cmnd == 'JOIN':
            tmp = "JOIN: " + ievent.channel
        else:
            return
        logfile = self.files[chan]
        logitem = (name, ttime, ievent.nick, ievent.userhost, tmp)
        rlog(-1, 'logs', 'logging [%s] <%s> %s ==> %s' % (name, ievent.nick, \
ievent.txt, filename))
        # write the data to file (comma seperated)
        try:
            self.lock.acquire()
            logfile.write('%s,%s,%s,%s,%s\n' % logitem)
            logfile.flush()
        finally:
            self.lock.release()

    def getmmap(self, channel):
        if channel[0] in ['#', '!', '&', '+']:
            chan = channel[1:].lower()
        else:
            chan = channel.lower()
        try:
            filename = self.filenames[chan]
        except KeyError:
            rlog(10, 'log', 'logging is not enabled in %s' % channel)
            return
        #if self.maps.has_key(filename):
        #    return self.maps[filename]
        logfile = open(filename,'r')
        size = self.size(channel)
        if size == 0:
            return None
        logmap = mmap.mmap(logfile.fileno(), size, mmap.MAP_SHARED, \
access=mmap.ACCESS_READ)
        #self.maps[filename] = logmap
        return logmap

    def loop(self, logmap, nrtimes, func, withbot=False, withcmnd=False):
        logmap.seek(0)
        teller = 0
        times = 0
        while 1:
            teller += 1
            if teller % 100000 == 0:
                time.sleep(0.0001)
            #time.sleep(0.000001)
            line = toascii(logmap.readline())
            if not line:
                break
            # data is comma seperated
            try:
                (botname, ttime, nick, userhost, txt) = \
line.strip().split(',', 4)
            except:
                continue
            if not withbot and userhost == 'bot@bot':
                continue
            # skip over commands
            if not withcmnd and txt.startswith('CMND:'):
                continue
            res = func(botname, ttime, nick, userhost, txt)
            if res:
               times += 1
               if nrtimes and times > nrtimes:
                   break
        logmap.close()

    def search(self, channel, what, nrtimes):
        """ search through logfile """
        res = []
        if not channel:
            return
        andre = re.compile(' and ', re.I)
        ands = re.split(andre, what)
        nrtimes = int(nrtimes)
        logmap = self.getmmap(channel)
        if not logmap:
             return
        res = []
        def dofunc(botname, ttime, nick, userhost, txt):
            for j in ands:
                if txt.find(j.strip()) == -1:
                    return
            res.append((botname, ttime, nick, userhost, txt))
            return 1
        self.loop(logmap, nrtimes, dofunc)        
        if res:
            return res[:nrtimes]

    def seen(self, channel, who):
        """ get last line of who """
        logmap = self.getmmap(channel)
        if not logmap:
            return
        result = []
        who = who.lower()
        if '*' in who:
            who = who.replace('*', '.*')
            rewho = re.compile(who)
            def dofunc(botname, ttime, nick, userhost, txt):
                if re.match(rewho, nick.lower()):
                    result.append((botname, ttime, nick, userhost, txt))
        else:
            def dofunc(botname, ttime, nick, userhost, txt):
                if nick.lower() == who:
                    result.append((botname, ttime, nick, userhost, txt))
        self.loop(logmap, None, dofunc)
        if result:
            return result[-1]

    def back(self, channel, what, nrtimes):
        """ search through the logs backwards """
        if not channel:
            return
        res = []
        andre = re.compile(' and ', re.I)
        ands = re.split(andre, what)
        nrtimes = int(nrtimes)
        logmap = self.getmmap(channel)
        if not logmap:
            return
        def dofunc(botname, ttime, nick, userhost, txt):
            for j in ands:
                if txt.find(j.strip()) == -1:
                    return
            res.append((botname, ttime, nick, userhost, txt))
            return 1
        self.loop(logmap, None, dofunc)
        result = []
        if res:
            if len(res) > nrtimes:
                result = res[len(res)-nrtimes:]
            else:
                result = res
        result.reverse()
        return result

    def fromtime(self, channel, ftime):
        """ returns log items from a certain time """
        if not channel:
            return
        res = []
        logmap = self.getmmap(channel)
        if not logmap:
            return
        def dofunc(botname, ttime, nick, userhost, txt):
            logtime = float(ttime)
            if logtime > ftime:
                res.append((botname, ttime, nick, userhost, txt))
        self.loop(logmap, None, dofunc)
        return res

    def fromtimewithbot(self, channel, ftime):
        """ returns log items from a certain time """
        if not channel:
            return
        res = []
        logmap = self.getmmap(channel)
        if not logmap:
            return
        def dofunc(botname, ttime, nick, userhost, txt):
            logtime = float(ttime)
            if logtime > ftime:
                res.append((botname, ttime, nick, userhost, txt))
        self.loop(logmap, None, dofunc, withbot=True)
        return res

    def linesback(self, channel, nrtimes):
        """ return nr log lines back """
        if not channel:
            return
        result = []
        nrtimes = int(nrtimes)
        logmap = self.getmmap(channel)
        if not logmap:
            return
        def dofunc(botname, ttime, nick, userhost, txt):
            result.append((botname, ttime, nick, userhost, txt))
            return 1
        self.loop(logmap, None, dofunc)
        if len(result) > nrtimes:
            return result[len(result)-nrtimes:]
        else:
            return result

    def linesbacknick(self, channel, who, nrtimes):
        """ return log lines for nick """
        if not channel:
            return
        result = []
        nrtimes = int(nrtimes)
        logmap = self.getmmap(channel)
        if not logmap:
            return
        def dofunc(botname, ttime, nick, userhost, txt):
            if nick.lower() == who.lower():
                result.insert(0, (botname, ttime, nick, userhost, txt))
                return 1
        self.loop(logmap, None, dofunc)
        return result[:nrtimes]

    def linesbacknicksearch(self, channel, who, searchitem, nrtimes):
        """ search logs for lines said by who """
        if not channel:
            return
        who = who.lower()
        result = []
        andre = re.compile(' and ', re.I)
        ands = re.split(andre, searchitem)
        nrtimes = int(nrtimes)
        logmap = self.getmmap(channel)
        if not logmap:
            return
        def dofunc(botname, ttime, nick, userhost, txt):
            if nick.lower() == who.lower():
                got = 0
                for j in ands:
                    if txt.find(j.strip()) == -1:
                        got = 0
                        break
                    got = 1
                if got:
                    result.append((botname, ttime, nick, userhost, txt))
                    return 1
        self.loop(logmap, None, dofunc)
        if len(result) > nrtimes:
            return result[len(result)-nrtimes:]
        else:
            return result

    def lastspoke(self, channel, userhost):
        """ return time of last line spoken by user with userhost """
        if not channel:
            return
        result = []
        logmap = self.getmmap(channel)
        if not logmap:
            return
        def dofunc(botname, ttime, nick, uh, txt):
            if userhost == uh:
                result.append(int(float(ttime)))
        self.loop(logmap, None, dofunc)
        if result:
            return result[-1]

    def lastspokelist(self, channel, userhost, nrtimes):
        """ return time of last line spoken by user with userhost """
        if not channel:
            return
        result = []
        logmap = self.getmmap(channel)
        if not logmap:
            return
        def dofunc(botname, ttime, nick, uh, txt):
            if userhost == uh:
                result.append(int(float(ttime)))
        self.loop(logmap, None, dofunc)
        if result:
            return result[len(result)-nrtimes:]

    def lastnicks(self, channel, nrtimes):
        """ return the nicks of last said lines """
        if not channel:
            return
        logmap = self.getmmap(channel)
        if not logmap:
            return
        result = []
        def dofunc(botname, ttime, nick, userhost, txt):
            if nick.lower() == who.lower():
                result.append(nick)
        self.loop(logmap, None, dofunc)
        if len(result) > nrtimes:
            result = result[len(result)-nrtimes:]
        result.reverse()
        return result


savelist = []

logs = Logs('logs')
savelist.append(logs)

def prelogsay(botname, printto, txt, who, how, fromm):
    if printto in logs.loglist:
        return 1

def cblogsay(botname, printto, txt, who, how, fromm):
    logs.logbot(botname, time.time(), printto, txt)

saymonitor.add('log', cblogsay, prelogsay)

def jprelogsay(botname, msg):
    try:
        to = str(msg.getTo())
    except:
        return
    if to in logs.loglist:
        return 1

def jcblogsay(botname, msg):
    try:
        to = str(msg.getTo())
        txt = msg.getBody()
    except:
        return
    logs.logbot(botname, time.time(), to, txt)

jabbermonitor.add('log', jcblogsay, jprelogsay)

def prelog(bot, ievent):
    """ log pre condition """
    if ievent.channel and ievent.channel in logs.loglist:
        return 1

def logcb(bot, ievent):
    """ callback that logs ievent """
    logs.log(bot.name, time.time(), ievent)

callbacks.add('ALL', logcb, prelog)
jcallbacks.add('Message', logcb, prelog)

def handle_logon(bot, ievent):
    """ log-on .. enable logging in channel the command was given in """
    if not ievent.channel in logs.loglist:
        logs.loglist.append(ievent.channel)
        ievent.reply('logging enabled in %s' % ievent.channel)
    else:
        ievent.reply('%s already in loglist' % ievent.channel)

cmnds.add('log-on', handle_logon, 'OPER')
examples.add('log-on', 'enable logging of the channel in which the command \
was given', 'log-on')

def handle_logoff(bot, ievent):
    """ log-off .. disable logging in channel the command was given in"""
    try:
        logs.loglist.remove(ievent.channel)
        ievent.reply('logging disabled in %s' % ievent.channel)
    except ValueError:
        ievent.reply('%s not in loglist' % ievent.channel)

cmnds.add('log-off', handle_logoff, 'OPER')
examples.add('log-off', 'disable logging of the channel in which the command \
was given', 'log-off')

def handle_loglist(bot, ievent):
    """ log-list .. show list of channels that are being logged """
    ievent.reply(str(logs.loglist))

cmnds.add('log-list', handle_loglist, 'OPER')
examples.add('log-list', 'show list of current logged channels', 'log-list')

def handle_loglen(bot, ievent):
    """ log-len show length of logfile for channel in which command was \
        given """
    if ievent.channel not in logs.loglist:
        ievent.reply('logging not enabled in %s' % ievent.channel)
        return
    if ievent.channel[0] in ['#', '!', '&', '+']:
        chan = ievent.channel[1:].lower()
    else:
        chan = ievent.channel.lower()
    ievent.reply(str(logs.size(chan)))

cmnds.add('log-len', handle_loglen, 'OPER')
examples.add('log-len', 'show size of log file of the channel the command \
was given in', 'log-len')
aliases.data['log-size'] = 'log-len'

def sayresult(bot, ievent, result):
    """ reply with result """
    got = 0
    if result:
        res = []
        for i in result:
            try:
                if i[3] == 'bot@bot':
                    continue
                if 'PRIVMSG' in i[4] or 'CMND' in i[4]:
                    what = i[4].split(':', 1)[1].strip()
                else:
                    what = i[4].strip()
            except:
                what = i[4].strip()
            res.append("[%s %s] <%s> %s" % (dmy(float(i[1])), \
hourmin(float(i[1])), i[2], what))
            got += 1
        ievent.reply(res, dot=True)
    if not got:
        ievent.reply("nothing found")

def handle_logback(bot, ievent):
    """ log-back [<nrtimes>] <txt> ['back' <bytesback>] .. search back \
        through channel log """
    if not ievent.channel:
        ievent.reply("use chan <channelname> to set channel to search in")
        return
    if ievent.channel not in logs.loglist:
        ievent.reply('logging not enabled in %s' % ievent.channel)
        return
    try:
        nrtimes = int(ievent.args[0])
        txt = ' '.join(ievent.args[1:])
    except ValueError:
        txt = ievent.rest
        nrtimes = 100000
    except IndexError:
        ievent.missing('<searchitem> or <nrtimes> <searchitem>')
        return
    result = logs.back(ievent.channel, txt, nrtimes)
    sayresult(bot, ievent, result)

cmnds.add('log-back', handle_logback, ['USER', 'WEB', 'ANON'], speed=3)
examples.add('back', "log-back [<nrtimes>] <txt> ['back' <bytesback>] .. \
search backwards in log file of channel", '1) log-back http 2) log-back 1 \
http')
aliases.data['b'] = 'log-back'
aliases.data['back'] = 'log-back'

def handle_logsearch(bot, ievent):
    """ log-search [<nrtimes>] <txt> ['back' <bytesback>] .. search the log \
        from the beginning """
    if not ievent.channel:
        ievent.reply("use chan <channelname> to set channel to search in")
        return
    if ievent.channel not in logs.loglist:
        ievent.reply('logging not enabled in %s' % ievent.channel)
        return
    try:
        nrtimes = int(ievent.args[0])
        txt = ' '.join(ievent.args[1:])
    except ValueError:
        txt = ievent.rest
        nrtimes = 100000
    except IndexError:
        ievent.missing(' <searchitem> or <nrtimes> <searchitem>')
        return
    result = logs.search(ievent.channel, txt, nrtimes)
    sayresult(bot, ievent, result)

cmnds.add('log-search', handle_logsearch, ['USER', 'WEB', 'ANON'], speed=3)
examples.add('log-search', 'log-search [<nrtimes>] <txt> .. search the log \
from the beginning', '1) log-search http 2) log-search 10 http')
aliases.data['search'] = 'log-search'


def handle_loglast(bot, ievent):
    """ log-last [<nr>] [<nick>] [<txt>] .. search log for last lines of
        <nick> containing <txt> """
    if ievent.channel not in logs.loglist:
        ievent.reply('logging not enabled in %s' % ievent.channel)
        return
    result = []
    try:
        nrlines = int(ievent.args[0])
        del ievent.args[0]
    except (IndexError, ValueError):
        nrlines = 3
    try:
        nick, txt = ievent.args
    except ValueError:
        txt = None
        try:
            nick = ievent.args[0]
        except IndexError:
            nick = None
    if nick and txt:
        result = logs.linesbacknicksearch(ievent.channel, nick, txt, \
nrlines)
    elif nick: 
        result = logs.linesbacknick(ievent.channel, nick, nrlines)
    else:
        result = logs.linesback(ievent.channel, nrlines)
    if result:
        sayresult(bot, ievent, result)
    else:
        ievent.reply('no result found')

cmnds.add('log-last', handle_loglast, ['USER', 'WEB', 'ANON'], speed=3)
examples.add('log-last', 'log-last [<nr>] [<nick>] [<txt>] .. show lastlines \
of channel or user', '1) log-last dunker 2) log-last 5 dunker 3) log-last \
dunker http 4) log-last 5 dunker http')
aliases.data['last'] = 'log-last'

def handle_seen(bot, ievent):
    """ seen <nick> .. give last spoken txt of <nick> """
    if not ievent.channel:
        ievent.reply('you need to set a channel, use chan channelname')
        return
    if ievent.channel not in logs.loglist:
        ievent.reply('logging not enabled in %s' % ievent.channel)
        return
    try:
        nick = ievent.args[0]
    except:
        ievent.missing('<nick>')
        return
    result = logs.seen(ievent.channel, nick)
    if result:
        tdiff = time.time() - float(result[1])
        if result[4].startswith('PRIVMSG'):
            what = result[4][9:]
        elif result[4].startswith('CMND'):
            what = result[4][6:]
        else:
            what = result[4]
        ievent.reply("%s said: %s .. %s ago on %s" % \
(result[2], what, elapsedstring(tdiff), result[0]))
    else:
        ievent.reply("no %s in %s log" % (nick, ievent.channel))

cmnds.add('seen', handle_seen, ['USER', 'WEB', 'ANON'], speed=3)
examples.add('seen', 'seen <nick> .. show last logged line of <nick>', \
'seen dunker')
