# plugs/tail.py
#
#

""" used in a pipeline .. show last <nr> elements """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import waitforqueue
from gozerbot.commands import cmnds

def handle_tail(bot, ievent):
    if not ievent.inqueue:
        ievent.reply("use tail in a pipeline")
        return
    try:
        nr = int(ievent.args[0])
    except (ValueError, IndexError):
        ievent.reply('tail <nr>')
        return
    result = waitforqueue(ievent.inqueue, 30)
    if not result:
        ievent.reply('no data to tail')
        return
    ievent.reply(result[-nr:])
    
cmnds.add('tail', handle_tail, ['USER', 'ANON'])
