/*
 *  Copyright (C) 2004 Morten Fjord-Larsen
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_CRYPT_STREAM_H__
#define __GPASS_CRYPT_STREAM_H__

#include <stdio.h>
#include <glib-object.h>
#include <mcrypt.h>

G_BEGIN_DECLS

/***********************************************************
 *
 * GPassCryptStream
 *
 ***********************************************************/
#define GPASS_TYPE_CRYPT_STREAM (gpass_crypt_stream_get_type())
#define GPASS_CRYPT_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_CRYPT_STREAM, \
                                GPassCryptStream))
#define GPASS_CRYPT_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_CRYPT_STREAM, \
                             GPassCryptStreamClass))
#define GPASS_IS_CRYPT_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_CRYPT_STREAM))
#define GPASS_IS_CRYPT_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_CRYPT_STREAM))
#define GPASS_CRYPT_STREAM_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_CRYPT_STREAM, \
                               GPassCryptStreamClass))

typedef struct {
    GObject parent;
    
    FILE *file;
    MCRYPT mcrypt;
    gint block_size;
} GPassCryptStream;

typedef struct {
    GObjectClass parent;
} GPassCryptStreamClass;

GType gpass_crypt_stream_get_type(void);

/***********************************************************
 *
 * GPassDecryptStream
 *
 ***********************************************************/
#define GPASS_TYPE_DECRYPT_STREAM (gpass_decrypt_stream_get_type())
#define GPASS_DECRYPT_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_DECRYPT_STREAM, \
                                GPassDecryptStream))
#define GPASS_DECRYPT_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_DECRYPT_STREAM, \
                             GPassDecryptStreamClass))
#define GPASS_IS_DECRYPT_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_DECRYPT_STREAM))
#define GPASS_IS_DECRYPT_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_DECRYPT_STREAM))
#define GPASS_DECRYPT_STREAM_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_DECRYPT_STREAM, \
                               GPassDecryptStreamClass))

typedef struct {
    GPassCryptStream parent;
    
    guchar *buffer[2];
    gint buffer_index;
    guchar *ptr;
    guchar *ptr_end;
    gboolean final;
} GPassDecryptStream;

typedef struct {
    GPassCryptStreamClass parent;
} GPassDecryptStreamClass;

GType gpass_decrypt_stream_get_type(void);

GError *gpass_decrypt_stream_open(GPassDecryptStream **self, FILE *file,
                                  const char *password);
GError *gpass_decrypt_stream_read(GPassDecryptStream *self,
                                  gchar *buf, gsize count, gsize *result);
GError *gpass_decrypt_stream_read_line(GPassDecryptStream *self,
                                       GString **line);
gboolean gpass_decrypt_stream_eof(GPassDecryptStream *self);
void gpass_decrypt_stream_close(GPassDecryptStream *self);

/***********************************************************
 *
 * GPassEncryptStream
 *
 ***********************************************************/
#define GPASS_TYPE_ENCRYPT_STREAM (gpass_encrypt_stream_get_type())
#define GPASS_ENCRYPT_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_ENCRYPT_STREAM, \
                                GPassEncryptStream))
#define GPASS_ENCRYPT_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_ENCRYPT_STREAM, \
                             GPassEncryptStreamClass))
#define GPASS_IS_ENCRYPT_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_ENCRYPT_STREAM))
#define GPASS_IS_ENCRYPT_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_ENCRYPT_STREAM))
#define GPASS_ENCRYPT_STREAM_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_ENCRYPT_STREAM, \
                               GPassEncryptStreamClass))

typedef struct {
    GPassCryptStream parent;
    
    guchar *buffer;
    guchar *ptr;
    guchar *ptr_end;
} GPassEncryptStream;

typedef struct {
    GPassCryptStreamClass parent;
} GPassEncryptStreamClass;

GType gpass_encrypt_stream_get_type(void);

GError *gpass_encrypt_stream_open(GPassEncryptStream **self, FILE *file,
                                  const char *password);
GError *gpass_encrypt_stream_write(GPassEncryptStream *self,
                                   const gchar *buf, gsize size);
void gpass_encrypt_stream_close(GPassEncryptStream *self);

G_END_DECLS

#endif /* #ifndef __GPASS_CRYPT_STREAM_H__ */
