# mcrypt.m4 - Macros to locate Mcrypt
#
# Copyright 2005 Kouji TAKAO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# As a special exception to the GNU General Public License, if you
# distribute this file as part of a program that contains a
# configuration script generated by Autoconf, you may include it under
# the same distribution terms that you use for the rest of that program.

# AM_PATH_MHASH
# =============
# Adds support for Mcrypt - http://mcrypt.hellug.gr/
# export MCRYPT_CFLAGS, MCRYPT_LIBS, HAVE_MCRYPT
# ----------------------------------------------------------
AC_DEFUN(AM_PATH_MCRYPT,
[
  AC_ARG_WITH(mcrypt-config,
  AC_HELP_STRING([--with-mcrypt-config=PATH], [path to libmcrypt-config]),
  [
    AC_MSG_RESULT([using $withval for libmcrypt-config])
    MCRYPT_CONFIG="$withval"
  ], 
  [
    AC_PATH_PROG(MCRYPT_CONFIG, libmcrypt-config, no)
  ])
  HAVE_MCRYPT="no"
  if test "$MCRYPT_CONFIG" != "no"; then
    MCRYPT_CFLAGS=`$MCRYPT_CONFIG --cflags`
    MCRYPT_LIBS=`$MCRYPT_CONFIG --libs`
    AC_SUBST(MCRYPT_CFLAGS)
    AC_SUBST(MCRYPT_LIBS)
    HAVE_MCRYPT="yes"
  fi
  AC_SUBST(HAVE_MCRYPT)
])
