/***************************************************************************
 *            gpe-expenses.h
 *
 *  Sun Nov 13 14:56:58 2005
 *  Copyright  2005  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
 
#ifndef _GPE_EXPENSE_H
#define _GPE_EXPENSE_H

/** @addtogroup QOF
    @{ */
/** @addtogroup gpe Using QOF as a framework around GPE

gpe-expenses provides an executable interface to the QOF
external framework. It supports writing the QSF XML offline
storage and SQL-type queries.

The types of SQL queries that are allowed at this point are a little limited.
In general, only the following types of queries are supported: \n
SELECT * FROM SomeObj WHERE (param_a < 10.0) AND (param_b = "asdf") SORT BY param_c DESC;\n
INSERT INTO SomeObj (param_a, param_b, param_c) VALUES ("value_a", true, "0/1");

Joins are not supported directly.\n
SELECT * FROM ObjA,ObjB WHERE (ObjA.param_id = ObjB.param_other_id);\n
The problem with the above is that the search requires a nested search loop, aka a 'join', 
which is not currently supported in the underlying QofQuery code.

However, by repeating queries and adding the entities to a new session using 
::qof_entity_copy_list, a series of queries can be added to a single book. 
e.g. You can insert multiple entities and save out as a QSF XML file or use multiple 
SELECT queries to build a precise list - this can be used to replicate most of the 
functionality of a SQL join.

SELECT * from ObjA where param_id = value; SELECT * from ObjB where param_other_id = value;

Equivalent to:\n
SELECT * from ObjA,ObjB where param_id = param_other_id and param_id = value;

When combined with a foreach callback on the value of param_id for each entity in the 
QofBook, you can produce the effect of a join from running the two SELECT queries for each 
value of param_id held in 'value'.

See ::QofEntityForeachCB and ::qof_object_foreach.

SELECT a,b,c FROM ... 

Used to convert QOF objects between applications by using the returned parameter values
to create a second object. One application using QOF could register objects from two 
applications and convert data from one to the other by using\n
SELECT a,b,c FROM ObjA; SELECT d,f,k FROM ObjB; qof_object_new_instance(); 
ObjC_set_a(value_c); ObjC_set_b(value_k) etc. 

What's needed is for the SELECT to return a complete object that only contains the
parameters selected.

Unsupported: UPDATE, DELETE.

It will not be possible to support CREATE, AMEND or DROP for understandable reasons.

    @{ */

/** @file gpe-expenses.h
  @brief Executable interface to the QOF external framework
  @author Copyright (c) 2005 Neil Williams <linux@codehelp.co.uk>
*/

#include "qof-expenses.h"

#define GPE_MOD_CLI   "gpe-cli"

typedef struct {
	QofMainContext   qof;
	QofBook          *book;            /**< The current book. */
	QofEntity        *entity;          /** \b transient marker of current entity. */
	GtkListStore     *list_store;      /**< The stored list of expenses */
	GtkListStore     *type_store;      /**< The list of expense types. */
	GtkWidget        *window;          /**< \b transient marker of the current window. */
	GtkWidget        *text_view;       /**< Notes */
	GtkEntry         *vendor_entry;    /**< Vendor text. */
	GtkEntry         *city_entry;      /**< Name of the city. */
	GtkEntry         *attendees_entry; /**< String containing series of names of attendees */
	GtkComboBox      *edit_type_list;  /**< Edit ExpenseType */
	GtkComboBox      *set_type_list;   /**< Set ExpenseType */
	GtkComboBox	     *payment_list;    /**< Selected ExpensePayment */
	GtkComboBox      *categories;      /**< GPE PIM categories */
	GtkComboBox	     *currency_list;   /**< unsupported */
	GList *category_list;   /**< The list of category names for the current database. */
	gint max_categories;     /**< The number of possible categories. */
	gint ent_category;       /**< The index of the category of this entity in the category list. */
}GpeExpenseData;

/** \brief Shutdown the QOF framework
*/
void gpe_expense_close(GpeExpenseData *context);

/** \brief Register all QOF objects.

If new objects are added, call the register func()
here. Ensure you have the pack routines for your object.

Follow the template of other objects to create your own callbacks.

gpe_expense_init must be called by any program wanting to
use the QOF framework with gpe-expense objects.

\return A usable gpe_expense_data* context.
*/
GpeExpenseData*  gpe_expense_init (void);

/** Pass a QOF error to a GPE error box. */
void
gpe_expense_error (QofSession * session);


/** @} */
/** @} */

#endif /* _PILOT_QOF_H */
