/*
 * GPG Keys 
 * cdlgkeyinfo.h
 * (c) 2001 Peter Mathiasson <peter@mathiasson.nu>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation
 */

#ifndef __CDLGKEYINFO_H__
#define __CDLGKEYINFO_H__

#include "cdlgkeyinfoui.h"

class QProcess;
class QStatusBar;
class QString;
class CListViewItem;
class QPopupMenu;

class CDlgKeyInfo : public CDlgKeyInfoUI
{
    Q_OBJECT

public:
    CDlgKeyInfo( QWidget *parent, const QString tmpKeyId, const QString userId );
    void getKeyInfo();

public slots:
    void processDone();
    void readFromStdout();
    void contextMenuRequested( QListViewItem *tmpItem, const QPoint &pos, int );
    void lookupKey();
    void reReadInfo();

signals:
    void newPublic();

private:
    void readKeyInfo();
    QProcess *gpgProc;
    QString userId;
    QString keyId;
    CListViewItem *itemUid;
    QPopupMenu *popupMenu;

};

#endif // __CDLGKEYINFO_H__
