/***************************************************************************
                          gpc_utils.h  -  description
                             -------------------
    begin                : Thu May 25 2000
    copyright            : (C) 2000 by Thierry Florac
    email                : tflorac@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GPC_UTILS_H
#define GPC_UTILS_H

#include <gnome.h>

#define GPC_DATABASE_VERSION            2


typedef enum
{
  GPC_ERROR_UNKNOWN = 0,
  GPC_ERROR_QUERY_NOT_OPENED,
  GPC_ERROR_PARAM_NOT_EXISTS
} GpcError;
	
GpcError    gpc_error;



typedef enum
{
  GPC_MODAL_RESULT_UNKNOWN = 0,
  GPC_MODAL_RESULT_OK,
  GPC_MODAL_RESULT_CANCEL,
  GPC_MODAL_RESULT_IGNORE
} GpcModalResult;

GpcModalResult  modal_result;



typedef enum
{
  GPC_ZOOM_CURRENT = 0,
  GPC_ZOOM_NORMAL,
  GPC_ZOOM_FIT,
  GPC_ZOOM_FIT_IF_LARGE
} GpcZoomMode;




void gpc_app_launch (const char *command, char *const args[]);

void gpc_app_check_reply_callback (gint reply, gpointer data);

gchar* gpc_path_relname (gchar *value);
gchar* gpc_file_physname (gchar *value);

gchar* get_sql_string (gchar *value);
gchar* get_sql_float (gfloat value);

void gpc_list_free (GList *list);

gboolean file_is_hidden (gchar *name);

#endif
