/*
 * GPR
 * Copyright (C) 2000 CompuMetric Labs, Inc.
 *
 * For more information contact:
 *        Thomas Hubbell
 *        CompuMetric Labs, Inc.
 *        5920 Grelot Road, Suite C-2
 *        Mobile, AL 36609
 * 
 * Voice: (334) 342-2220
 *   Fax: (334) 343-2261
 * Email: thubbell@compumetric.com
 *   Web: http://www.compumetric.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public 
 * License along with this program; if not, write to the 
 * 
 * Free Software Foundation, Inc., 
 * 59 Temple Place - Suite 330
 * Boston, MA  02111-1307, USA.
 *    
 *        File: Interface.c
 * 
 * Description: Routines to create the user interface
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

/* keywords used to assign data to widgets with gtk_object_set_data */
#define PN "printer name"
#define SD "spool directory"
#define PF "PPD file"
#define OT "option text"
#define OK "option keyword"
#define CT "choice text"
#define CK "choice keyword"
#define IN "index"
#define SS "saved settings"

#define MASTER_PPDDIR "/usr/share/postscript/ppd"

extern char *cmdname;

/* local functions */
static GtkWidget *get_printer_menu(ppd_struct * ppd);
static void fileentry_combo_popdown (GtkWidget *fileentry, 
				     ppd_struct *ppd);

/* Added by MLP: The fileentry_combo_popdown() function needs this
   widget. I couldn't find a way to use the 
   local_ppd->ppd_fileentry element in the callback successfully.
*/

GtkWidget *GLOBAL_ppdfile_fileentry;

/*----------------------------------------------------------------
  These are the pixmaps we're going to embed in the app.
----------------------------------------------------------------*/

#include "../pixmaps/nup1up.xpm"
#include "../pixmaps/nup2up.xpm"
#include "../pixmaps/nup4up.xpm"
#include "../pixmaps/collate.xpm"
#include "../pixmaps/forward.xpm"
#include "../pixmaps/noncoll.xpm"
#include "../pixmaps/reverse.xpm"
#include "../pixmaps/tuxprint.xpm"

/*
 * This function creates the main program window with three tabs
 */
GtkWidget *create_gpr_main_window(ppd_struct * ppd,
				  GtkWidget * inst_opts_window)
{
  /* Main window widgets */
  GtkWidget *gpr_main_window;
  GtkWidget *vbox1;
  GtkWidget *notebook1;

  /* Notebook tab 1 widgets */
  GtkWidget *vbox2;
  GtkWidget *hbox1;
  GtkWidget *printfile_label;
  GtkWidget *printfile_fileentry;
  GtkWidget *printfile_combo_entry;
  GtkWidget *hseparator1;
  GtkWidget *hbox2;
  GtkWidget *printer_select_label;
  GtkWidget *printer_select_optionmenu;
  GtkWidget *printer_select_optionmenu_menu;
  GtkWidget *hseparator2;
  GtkWidget *hbox3;
  GtkWidget *ppdfile_label;
  GtkWidget *ppdfile_fileentry;
  GtkWidget *ppdfile_combo_entry;
  GtkWidget *ppd_gnome_combo;
  GtkWidget *hbox4;
  GtkWidget *hbox5;
  GtkWidget *vbox3;
  GtkWidget *pconfig_frame;
  GtkWidget *hbox14;
  GtkWidget *pconfig_pixmap;
  GtkWidget *hbuttonbox5;
  GtkWidget *pconfig_button;
  GtkWidget *savesett_frame;
  GtkWidget *vbox4;
  GtkWidget *savesett_label1;

  GtkWidget *savesett_button;
  GtkWidget *main_notebook_label;

  /* Notebook tab 2 widgets */
  GtkWidget *vbox5;
  GtkWidget *hbox8;
  GtkWidget *hbox11;
  GtkWidget *numcopies_label;
  GtkObject *numcopies_spinbutton_adj;
  GtkWidget *numcopies_spinbutton;
  GtkWidget *vbox9;
  GtkWidget *vbox6;
  GtkWidget *hbox20;
  GtkWidget *pagesize_label;
  GtkWidget *hbox7;
  GtkWidget *range_frame;
  GtkWidget *vbox10;
  GtkWidget *hbox18;
  GSList *page_range_group = NULL;
  GtkWidget *range_all_radiobutton;
  GtkWidget *range_odd_radiobutton;
  GtkWidget *range_even_radiobutton;
  GtkWidget *hbox19;
  GtkWidget *range_from_radiobutton;
  GtkWidget *range_from_entry;
  GtkWidget *range_to_label;
  GtkWidget *range_to_entry;
  GtkWidget *nup_frame;
  GtkWidget *hbox12;
  GtkWidget *nup1up_pixmap;
  GtkWidget *nup2up_pixmap;
  GtkWidget *nup4up_pixmap;
  GtkWidget *vbox8;
  GtkWidget *vbox17;
  GSList *n_up_group = NULL;
  GtkWidget *nup_1up_radiobutton;
  GtkWidget *nup_2up_radiobutton;
  GtkWidget *nup_4up_radiobutton;
  GtkWidget *hbox17;
  GtkWidget *hbox21;
  GtkWidget *collate_frame;
  GtkWidget *hbox22;
  GtkWidget *collate_off_pixmap;
  GtkWidget *collate_on_pixmap;
  GtkWidget *vbox14;
  GSList *collate_group = NULL;
  GtkWidget *collate_yes_radiobutton;
  GtkWidget *collate_no_radiobutton;
  GtkWidget *revordr_frame;
  GtkWidget *hbox23;
  GtkWidget *order_rev_pixmap;
  GtkWidget *order_for_pixmap;
  GtkWidget *vbox15;
  GSList *rev_order_group = NULL;
  GtkWidget *revordr_yes_radiobutton;
  GtkWidget *revordr_no_radiobutton;
  GtkWidget *common_notebook_label;
  GtkWidget *hbox24;
  GtkWidget *hbox25;
  GtkWidget *temp_menu;
  GtkWidget *temp_menu2;

  /* Notebook tab 3 widgets */
  GtkWidget *advanced_notebook_label;

  /* main window widgets */
  GtkWidget *hbuttonbox1;
  GtkWidget *main_print_button;
  GtkWidget *main_cancel_button;

  ppd_struct *local_ppd;	/* local copy of ppd_struct */
  /* end declarations */

  local_ppd = ppd;

  /* create main window */
  gpr_main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data(GTK_OBJECT(gpr_main_window), "gpr_main_window",
		      gpr_main_window);

  /* delete the line below once we adjust size of viewport 
     contents */
  gtk_widget_set_usize(gpr_main_window, 500, 0);
  gtk_window_set_title(GTK_WINDOW(gpr_main_window), _("gpr"));
  /* MLP: changed the following to allow window resizing. */
  gtk_window_set_policy(GTK_WINDOW(gpr_main_window), TRUE, TRUE, FALSE);

  /* add a vbox to the window containing a notebook and a button 
     box */
  vbox1 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox1);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox1", vbox1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox1);
  gtk_container_add(GTK_CONTAINER(gpr_main_window), vbox1);

  /* create notebook */
  notebook1 = gtk_notebook_new();
  gtk_widget_ref(notebook1);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "notebook1", notebook1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(notebook1);
  gtk_box_pack_start(GTK_BOX(vbox1), notebook1, TRUE, TRUE, 0);

  /* a container */
  vbox2 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox2);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox2", vbox2,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox2);
  gtk_container_add(GTK_CONTAINER(notebook1), vbox2);

  /* a container */
  hbox1 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox1);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox1", hbox1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox1);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(hbox1), 3);

  /* label for printfile entrybox */
  printfile_label = gtk_label_new(_("File To\nPrint"));
  gtk_widget_ref(printfile_label);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "printfile_label",
			   printfile_label,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(printfile_label);
  gtk_box_pack_start(GTK_BOX(hbox1), printfile_label, FALSE, FALSE, 21);

  /* printfile entrybox */
  printfile_fileentry = gnome_file_entry_new(NULL, NULL);
  gtk_widget_ref(printfile_fileentry);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "printfile_fileentry",
			   printfile_fileentry,
			   (GtkDestroyNotify) gtk_widget_unref);

  /* specify some default settings for the entrybox */
  gnome_file_entry_set_title(GNOME_FILE_ENTRY(printfile_fileentry),
			     "Select a file to print");
  gnome_file_entry_set_default_path(GNOME_FILE_ENTRY(printfile_fileentry),
				    g_get_home_dir());


  gtk_widget_show(printfile_fileentry);
  gtk_box_pack_start(GTK_BOX(hbox1), printfile_fileentry, TRUE, FALSE, 0);
  gtk_widget_set_usize(printfile_fileentry, 260, 42);
  gtk_container_set_border_width(GTK_CONTAINER(printfile_fileentry), 10);

  /* printfile combo entry - entrybox + file browser */
  printfile_combo_entry =
    gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(printfile_fileentry));
  gtk_widget_ref(printfile_combo_entry);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), 
			   "printfile_combo_entry", printfile_combo_entry,
			   (GtkDestroyNotify) gtk_widget_unref);

  /* set the file name to the one specified on the command line, 
     if it exists */
  if (local_ppd->file_to_print != NULL) {
    gtk_entry_set_text(GTK_ENTRY
		       (gnome_file_entry_gtk_entry
			(GNOME_FILE_ENTRY(printfile_fileentry))),
		       local_ppd->file_to_print);
    gtk_widget_set_sensitive(printfile_fileentry, FALSE);
  }

  gtk_widget_show(printfile_combo_entry);

  /* signal handler called each time the filename changes */
  gtk_signal_connect(GTK_OBJECT
		     (gnome_file_entry_gtk_entry
		      (GNOME_FILE_ENTRY(printfile_fileentry))), "changed",
		     GTK_SIGNAL_FUNC(grab_file_to_print),(gpointer) local_ppd);


  /* separator */
  hseparator1 = gtk_hseparator_new();
  gtk_widget_ref(hseparator1);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hseparator1",
			   hseparator1, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hseparator1);
  gtk_box_pack_start(GTK_BOX(vbox2), hseparator1, TRUE, TRUE, 0);

  /* a container */
  hbox2 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox2);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox2", hbox2,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox2);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox2, TRUE, TRUE, 10);
  gtk_container_set_border_width(GTK_CONTAINER(hbox2), 5);

  /* label for printer selection optionmenu */
  printer_select_label = gtk_label_new(_("Select Printer"));
  gtk_widget_ref(printer_select_label);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "printer_select_label",
			   printer_select_label,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(printer_select_label);
  gtk_box_pack_start(GTK_BOX(hbox2), printer_select_label, FALSE, FALSE, 3);

  /* printer selection option menu */
  printer_select_optionmenu = gtk_option_menu_new();
  gtk_widget_ref(printer_select_optionmenu);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),
			   "printer_select_optionmenu",
			   printer_select_optionmenu,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(printer_select_optionmenu);
  gtk_box_pack_start(GTK_BOX(hbox2), printer_select_optionmenu, TRUE, FALSE,0);
  gtk_widget_set_usize(printer_select_optionmenu, 242, 27);

  printer_select_optionmenu_menu = get_printer_menu(local_ppd);

  gtk_option_menu_set_menu(GTK_OPTION_MENU(printer_select_optionmenu),
			   printer_select_optionmenu_menu);

  /* a separator */
  hseparator2 = gtk_hseparator_new();
  gtk_widget_ref(hseparator2);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hseparator2",
			   hseparator2, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hseparator2);
  gtk_box_pack_start(GTK_BOX(vbox2), hseparator2, TRUE, TRUE, 0);

  /* a container */
  hbox3 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox3);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox3", hbox3,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox3);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox3, TRUE, TRUE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(hbox3), 3);
  /* label for ppd file entry box */
  ppdfile_label = gtk_label_new(_("PPD File"));
  gtk_widget_ref(ppdfile_label);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "ppdfile_label",
			   ppdfile_label, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(ppdfile_label);
  gtk_box_pack_start(GTK_BOX(hbox3), ppdfile_label, FALSE, FALSE, 15);

  /* ppd file entry box */
  ppdfile_fileentry = gnome_file_entry_new(NULL, NULL);
  local_ppd->ppd_fileentry = ppdfile_fileentry;
  gtk_widget_ref(ppdfile_fileentry);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "ppdfile_fileentry",
			   ppdfile_fileentry,
			   (GtkDestroyNotify) gtk_widget_unref);

  /* specify some default settings for the file entry widget */
  gnome_file_entry_set_title(GNOME_FILE_ENTRY(ppdfile_fileentry),
			     "Select a PPD File");

  gtk_widget_show(ppdfile_fileentry);
  gtk_box_pack_start(GTK_BOX(hbox3), ppdfile_fileentry, TRUE, FALSE, 0);
  gtk_widget_set_usize(ppdfile_fileentry, 260, 42);
  gtk_container_set_border_width(GTK_CONTAINER(ppdfile_fileentry), 10);

  /* ppd file combo entry - entrybox+ file browser */
  ppdfile_combo_entry =
    gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(ppdfile_fileentry));
  gtk_widget_ref(ppdfile_combo_entry);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "ppdfile_combo_entry",
			   ppdfile_combo_entry,
			   (GtkDestroyNotify) gtk_widget_unref);

  /* signal handler called every time the "browser" button is 
     clicked */
  gtk_signal_connect(GTK_OBJECT(GNOME_FILE_ENTRY(ppdfile_fileentry)),
		     "browse-clicked", GTK_SIGNAL_FUNC(update_ppd_path),
		     (gpointer) local_ppd);


  /*--------------------------------------------------------------
    Attempt to tell when new combo entry was selected. I needed 
    to dig down in the GnomeFileEntry widget hierarchy, to find 
    some event to trap when a new entry was selected. The combo 
    box's popwin widget has an unmap event that seemed to work 
    the best, so we hook into that and call the 
    fileentry_combo_popdown function. That function calls the 
    three functions that are triggered by a FileEntry activate
    event. I couldn't simply emit an activate signal, as this has
    the side-effect of adding a duplicate entry in the combo box
    history list. (MLP 12/15/2000)
  --------------------------------------------------------------*/
  GLOBAL_ppdfile_fileentry = ppdfile_combo_entry;

  ppd_gnome_combo =
    gnome_file_entry_gnome_entry(GNOME_FILE_ENTRY(ppdfile_fileentry));
  gtk_widget_ref(ppd_gnome_combo);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "ppd_gnome_combo",
			   ppd_gnome_combo,
			   (GtkDestroyNotify) gtk_widget_unref);

  gtk_signal_connect(GTK_OBJECT(GTK_COMBO(ppd_gnome_combo)->popwin), "unmap",
		     GTK_SIGNAL_FUNC(fileentry_combo_popdown),
		     (gpointer) local_ppd);
  /* End MLP section. ----------------------------------------- */

  /* signal handler called every time the entry box text is 
     changed */
  gtk_signal_connect(GTK_OBJECT
		     (gnome_file_entry_gtk_entry
		      (GNOME_FILE_ENTRY(ppdfile_fileentry))), "activate",
		     GTK_SIGNAL_FUNC(grab_ppd_file), (gpointer) local_ppd);
  gtk_widget_show(ppdfile_combo_entry);

  /* Forces select printer menu to emit a signal so that default 
     ppd shows at start up */
  temp_menu2 = gtk_menu_get_active(GTK_MENU(printer_select_optionmenu_menu));
  gtk_signal_emit_by_name(GTK_OBJECT(temp_menu2), "activate");

  /* a container */
  hbox4 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox4);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox4", hbox4,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox4);
  gtk_box_pack_start(GTK_BOX(vbox2), hbox4, TRUE, TRUE, 0);

  /* a container */
  hbox5 = gtk_hbox_new(TRUE, 1);
  gtk_widget_ref(hbox5);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox5", hbox5,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox5);
  gtk_box_pack_start(GTK_BOX(hbox4), hbox5, TRUE, TRUE, 0);

  /* a container */
  vbox3 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox3);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox3", vbox3,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox3);
  gtk_box_pack_start(GTK_BOX(hbox5), vbox3, TRUE, TRUE, 0);

  /* frame around printer configuration objects */
  pconfig_frame = gtk_frame_new(_("Printer Configuration"));
  gtk_widget_ref(pconfig_frame);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "pconfig_frame",
			   pconfig_frame, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(pconfig_frame);
  gtk_box_pack_start(GTK_BOX(vbox3), pconfig_frame, TRUE, TRUE, 0);

  /* a container */
  hbox14 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox14);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox14", hbox14,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox14);
  gtk_container_add(GTK_CONTAINER(pconfig_frame), hbox14);

  /* printer configuration icon */
  pconfig_pixmap =
    create_pixmap_from_data(gpr_main_window, tuxprint_xpm, FALSE);

  gtk_widget_ref(pconfig_pixmap);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "pconfig_pixmap",
			   pconfig_pixmap,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(pconfig_pixmap);
  gtk_box_pack_start(GTK_BOX(hbox14), pconfig_pixmap, TRUE, TRUE, 0);


  /* buttonbox containing printer configuration control button */
  hbuttonbox5 = gtk_hbutton_box_new();
  gtk_widget_ref(hbuttonbox5);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbuttonbox5",
			   hbuttonbox5, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbuttonbox5);
  gtk_box_pack_start(GTK_BOX(hbox14), hbuttonbox5, TRUE, TRUE, 0);

  /* printer configuration button */
  pconfig_button = gtk_button_new_with_label(_("Configure\nPrinter"));
  gtk_widget_ref(pconfig_button);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "pconfig_button",
			   pconfig_button,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(pconfig_button);
  gtk_container_add(GTK_CONTAINER(hbuttonbox5), pconfig_button);
  GTK_WIDGET_SET_FLAGS(pconfig_button, GTK_CAN_DEFAULT);

  /* signal handler called when printer configuration button is 
     clicked */
  gtk_signal_connect_object(GTK_OBJECT(pconfig_button), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_show),
			    GTK_OBJECT(inst_opts_window));

  /* frame around saved settings objects */
  savesett_frame = gtk_frame_new(_("Saved Settings"));
  gtk_widget_ref(savesett_frame);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "savesett_frame",
			   savesett_frame,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(savesett_frame);
  gtk_box_pack_start(GTK_BOX(hbox5), savesett_frame, TRUE, TRUE, 0);

  /* a container */
  vbox4 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox4);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox4", vbox4,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox4);
  gtk_container_add(GTK_CONTAINER(savesett_frame), vbox4);
  gtk_container_set_border_width(GTK_CONTAINER(vbox4), 8);

  /* a container */
  hbox24 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox24);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox24", hbox24,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox24);
  gtk_container_add(GTK_CONTAINER(vbox4), hbox24);


  /* label for saved setting option menu */
  savesett_label1 = gtk_label_new(_("Retrieve Settings"));
  gtk_widget_ref(savesett_label1);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "savesett_label1",
			   savesett_label1,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(savesett_label1);
  gtk_box_pack_start(GTK_BOX(hbox24), savesett_label1, FALSE, FALSE, 5);

  /* printer selection option menu */
  local_ppd->savesett_optionmenu = gtk_option_menu_new();
  gtk_widget_ref(local_ppd->savesett_optionmenu);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "savesett_optionmenu",
			   local_ppd->savesett_optionmenu,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(local_ppd->savesett_optionmenu);
  gtk_box_pack_start(GTK_BOX(hbox24), local_ppd->savesett_optionmenu, TRUE,
		     TRUE, 0);

  temp_menu = gtk_menu_new();
  gtk_option_menu_set_menu(GTK_OPTION_MENU(local_ppd->savesett_optionmenu),
			   temp_menu);

  /* a container */
  hbox25 = gtk_hbox_new(TRUE, 0);
  gtk_widget_ref(hbox25);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox25", hbox25,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox25);
  gtk_container_add(GTK_CONTAINER(vbox4), hbox25);

  /* "Save Settings button */
  savesett_button = gtk_button_new_with_label(_("Save Settings"));
  gtk_widget_ref(savesett_button);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "savesett_button",
			   savesett_button,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(savesett_button);
  gtk_container_add(GTK_CONTAINER(hbox25), savesett_button);
  GTK_WIDGET_SET_FLAGS(savesett_button, GTK_CAN_DEFAULT);

  /* add a button click event handler here */
  gtk_signal_connect(GTK_OBJECT(savesett_button), "clicked",
		     GTK_SIGNAL_FUNC(save_sett), (gpointer) local_ppd);

  local_ppd->savesett_textentry = gtk_entry_new();
  gtk_widget_ref(local_ppd->savesett_textentry);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "savesett_textentry",
			   local_ppd->savesett_textentry,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(local_ppd->savesett_textentry);
  gtk_container_add(GTK_CONTAINER(hbox25), local_ppd->savesett_textentry);


  /* notebook tab1 label */
  main_notebook_label = gtk_label_new(_("Main"));
  gtk_widget_ref(main_notebook_label);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "main_notebook_label",
			   main_notebook_label,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(main_notebook_label);
  gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook1),
			     gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook1),
						       0), 
			     main_notebook_label);

  /* END NOTEBOOK TAB 1 ITEMS */

  /* a container */
  vbox5 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox5);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox5", vbox5,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox5);
  gtk_container_add(GTK_CONTAINER(notebook1), vbox5);

  /* a container */
  hbox8 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox8);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox8", hbox8,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox8);
  gtk_box_pack_start(GTK_BOX(vbox5), hbox8, FALSE, TRUE, 0);

  /* a container */
  hbox11 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox11);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox11", hbox11,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox11);
  gtk_box_pack_start(GTK_BOX(hbox8), hbox11, FALSE, FALSE, 0);

  /* label for the number of copies spinbox */
  numcopies_label = gtk_label_new(_("Copies"));
  gtk_widget_ref(numcopies_label);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "numcopies_label",
			   numcopies_label,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(numcopies_label);
  gtk_box_pack_start(GTK_BOX(hbox11), numcopies_label, FALSE, FALSE, 17);

  /* number of copies spinbutton widget */
  numcopies_spinbutton_adj = gtk_adjustment_new(1, 1, 99, 1, 10, 10);
  numcopies_spinbutton =
    gtk_spin_button_new(GTK_ADJUSTMENT(numcopies_spinbutton_adj), 1, 0);
  gtk_widget_ref(numcopies_spinbutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "numcopies_spinbutton",
			   numcopies_spinbutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(numcopies_spinbutton);
  gtk_box_pack_start(GTK_BOX(hbox11), numcopies_spinbutton, FALSE, TRUE, 20);

  /* signal handler called each time the item in the numcopies 
     box changes */
  gtk_signal_connect(GTK_OBJECT(numcopies_spinbutton), "changed",
		     GTK_SIGNAL_FUNC(update_num_copies), (gpointer) local_ppd);

  /* a container */
  vbox9 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox9);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox9", vbox9,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox9);
  gtk_box_pack_start(GTK_BOX(hbox8), vbox9, TRUE, TRUE, 0);

  /* a container */
  vbox6 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox6);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox6", vbox6,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox6);
  gtk_box_pack_start(GTK_BOX(vbox9), vbox6, FALSE, FALSE, 0);

  /* a container */
  hbox20 = gtk_hbox_new(FALSE, 10);
  gtk_widget_ref(hbox20);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox20", hbox20,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox20);
  gtk_box_pack_start(GTK_BOX(vbox6), hbox20, TRUE, TRUE, 24);

  /* label describing the page size option combo */
  pagesize_label = gtk_label_new(_("Media Size"));
  gtk_widget_ref(pagesize_label);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "pagesize_label",
			   pagesize_label,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(pagesize_label);
  gtk_box_pack_start(GTK_BOX(hbox20), pagesize_label, FALSE, FALSE, 0);

  /* page size option menu */ 
  local_ppd->pagesize_optionmenu = gtk_combo_new();
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(local_ppd->pagesize_optionmenu)->entry), FALSE);
  gtk_widget_ref(local_ppd->pagesize_optionmenu);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "pagesize_optionmenu",
			   local_ppd->pagesize_optionmenu,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(local_ppd->pagesize_optionmenu);
  gtk_box_pack_start(GTK_BOX(hbox20), local_ppd->pagesize_optionmenu, TRUE,
		     TRUE, 5);
  gtk_widget_set_usize(local_ppd->pagesize_optionmenu, 40, 20);

  /* a container */
  hbox7 = gtk_hbox_new(TRUE, 0);
  gtk_widget_ref(hbox7);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox7", hbox7,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox7);
  gtk_box_pack_start(GTK_BOX(vbox5), hbox7, TRUE, TRUE, 0);

  /* frame around page range objects */
  range_frame = gtk_frame_new(_("Page Ranges"));
  gtk_widget_ref(range_frame);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "range_frame",
			   range_frame, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(range_frame);
  gtk_box_pack_start(GTK_BOX(hbox7), range_frame, TRUE, TRUE, 0);

  /* a container */
  vbox10 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox10);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox10", vbox10,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox10);
  gtk_container_add(GTK_CONTAINER(range_frame), vbox10);
  gtk_container_set_border_width(GTK_CONTAINER(vbox10), 5);

  /* a container */
  hbox18 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox18);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox18", hbox18,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox18);
  gtk_box_pack_start(GTK_BOX(vbox10), hbox18, TRUE, TRUE, 0);

  /* radiobutton for printing all pages in the document */
  range_all_radiobutton =
    gtk_radio_button_new_with_label(page_range_group, _("All"));
  page_range_group =
    gtk_radio_button_group(GTK_RADIO_BUTTON(range_all_radiobutton));
  gtk_widget_ref(range_all_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),"range_all_radiobutton",
			   range_all_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(range_all_radiobutton);
  gtk_box_pack_start(GTK_BOX(hbox18), range_all_radiobutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(range_all_radiobutton), TRUE);

  /* radiobutton for printing only the odd pages in the doc */
  range_odd_radiobutton =
    gtk_radio_button_new_with_label(page_range_group, _("Odd"));
  page_range_group =
    gtk_radio_button_group(GTK_RADIO_BUTTON(range_odd_radiobutton));
  gtk_widget_ref(range_odd_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),"range_odd_radiobutton",
			   range_odd_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(range_odd_radiobutton);
  gtk_box_pack_start(GTK_BOX(vbox10), range_odd_radiobutton, FALSE, FALSE, 0);

  /* radiobutton for printing only the even pages in the document */
  range_even_radiobutton =
    gtk_radio_button_new_with_label(page_range_group, _("Even"));
  page_range_group =
    gtk_radio_button_group(GTK_RADIO_BUTTON(range_even_radiobutton));
  gtk_widget_ref(range_even_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),
			   "range_even_radiobutton", range_even_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(range_even_radiobutton);
  gtk_box_pack_start(GTK_BOX(vbox10), range_even_radiobutton, FALSE, FALSE, 0);

  hbox19 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox19);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox19", hbox19,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox19);
  gtk_box_pack_start(GTK_BOX(vbox10), hbox19, TRUE, TRUE, 0);

  /* radiobutton for printing a specified range of pages in the 
     document */
  range_from_radiobutton =
    gtk_radio_button_new_with_label(page_range_group, _("From"));
  page_range_group =
    gtk_radio_button_group(GTK_RADIO_BUTTON(range_from_radiobutton));
  gtk_widget_ref(range_from_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),
			   "range_from_radiobutton", range_from_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(range_from_radiobutton);
  gtk_box_pack_start(GTK_BOX(hbox19), range_from_radiobutton, FALSE, FALSE, 0);

  /* entry box for specifying the first page in the page range to
     print */
  range_from_entry = gtk_entry_new();
  gtk_widget_ref(range_from_entry);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "range_from_entry",
			   range_from_entry,
			   (GtkDestroyNotify) gtk_widget_unref);

  /* "grey-out" the entrybox by default */
  gtk_widget_set_sensitive(range_from_entry, FALSE);

  gtk_widget_show(range_from_entry);
  gtk_box_pack_start(GTK_BOX(hbox19), range_from_entry, FALSE, FALSE, 0);
  gtk_widget_set_usize(range_from_entry, 25, -2);

  /* label for the "To" portion of the range */
  range_to_label = gtk_label_new(_("To"));
  gtk_widget_ref(range_to_label);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "range_to_label",
			   range_to_label,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(range_to_label);
  gtk_box_pack_start(GTK_BOX(hbox19), range_to_label, FALSE, FALSE, 5);

  /* entry box for specifying the last page in the page range to 
     print */
  range_to_entry = gtk_entry_new();
  gtk_widget_ref(range_to_entry);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "range_to_entry",
			   range_to_entry,(GtkDestroyNotify) gtk_widget_unref);

  /* grey out entrybox by default */
  gtk_widget_set_sensitive(range_to_entry, FALSE);

  gtk_widget_show(range_to_entry);

  /* "ungrey" boxes when the "From...To" item is selected */
  gtk_signal_connect(GTK_OBJECT(range_from_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(ungrey_entrybox),
		     (gpointer) range_from_entry);

  gtk_signal_connect(GTK_OBJECT(range_from_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(ungrey_entrybox),
		     (gpointer) range_to_entry);
  /* "regrey" boxes when any other choice is selected */
  gtk_signal_connect(GTK_OBJECT(range_all_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(regrey_entrybox),
		     (gpointer) range_from_entry);

  gtk_signal_connect(GTK_OBJECT(range_all_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(regrey_entrybox),
		     (gpointer) range_to_entry);

  gtk_signal_connect(GTK_OBJECT(range_odd_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(regrey_entrybox),
		     (gpointer) range_from_entry);

  gtk_signal_connect(GTK_OBJECT(range_odd_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(regrey_entrybox),
		     (gpointer) range_to_entry);

  gtk_signal_connect(GTK_OBJECT(range_even_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(regrey_entrybox),
		     (gpointer) range_from_entry);

  gtk_signal_connect(GTK_OBJECT(range_even_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(regrey_entrybox),
		     (gpointer) range_to_entry);

  /* now handle the real work - specifying job settings */
  gtk_signal_connect(GTK_OBJECT(range_all_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(update_pageset_all),(gpointer) local_ppd);

  gtk_signal_connect(GTK_OBJECT(range_odd_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(update_pageset_odd),(gpointer) local_ppd);

  gtk_signal_connect(GTK_OBJECT(range_even_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(update_pageset_even),
		     (gpointer) local_ppd);


  /* handle page ranges */
  gtk_signal_connect(GTK_OBJECT(range_from_entry), "changed",
		     GTK_SIGNAL_FUNC(update_range_from), (gpointer) local_ppd);

  gtk_signal_connect(GTK_OBJECT(range_to_entry), "changed",
		     GTK_SIGNAL_FUNC(update_range_to), (gpointer) local_ppd);

  gtk_box_pack_start(GTK_BOX(hbox19), range_to_entry, FALSE, FALSE, 0);
  gtk_widget_set_usize(range_to_entry, 25, -2);

  /* frame around n-up objects */
  nup_frame = gtk_frame_new(_("N-Up Printing"));
  gtk_widget_ref(nup_frame);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "nup_frame", nup_frame,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(nup_frame);
  gtk_box_pack_start(GTK_BOX(hbox7), nup_frame, TRUE, TRUE, 0);

  /* a container */
  hbox12 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox12);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox12", hbox12,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox12);
  gtk_container_add(GTK_CONTAINER(nup_frame), hbox12);

  /* n-up icon */
  nup1up_pixmap = create_pixmap_from_data(gpr_main_window, nup1up_xpm, FALSE);
  gtk_widget_ref(nup1up_pixmap);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "nup1up_pixmap",
			   nup1up_pixmap, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(nup1up_pixmap);
  gtk_box_pack_start(GTK_BOX(hbox12), nup1up_pixmap, TRUE, TRUE, 0);

  nup2up_pixmap = create_pixmap_from_data(gpr_main_window, nup2up_xpm, FALSE);
  gtk_widget_ref(nup2up_pixmap);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "nup2up_pixmap",
			   nup2up_pixmap, (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start(GTK_BOX(hbox12), nup2up_pixmap, TRUE, TRUE, 0);

  nup4up_pixmap = create_pixmap_from_data(gpr_main_window, nup4up_xpm, FALSE);
  gtk_widget_ref(nup4up_pixmap);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "nup4up_pixmap",
			   nup4up_pixmap, (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start(GTK_BOX(hbox12), nup4up_pixmap, TRUE, TRUE, 0);

  /* a container */
  vbox8 = gtk_vbox_new(TRUE, 0);
  gtk_widget_ref(vbox8);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox8", vbox8,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox8);
  gtk_box_pack_start(GTK_BOX(hbox12), vbox8, TRUE, TRUE, 0);

  /* a container */
  vbox17 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox17);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox17", vbox17,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox17);
  gtk_box_pack_start(GTK_BOX(vbox8), vbox17, FALSE, FALSE, 0);

  /* radiobutton for choosing 1-up layout (default) */
  nup_1up_radiobutton = gtk_radio_button_new_with_label(n_up_group, _("1-Up"));
  n_up_group = gtk_radio_button_group(GTK_RADIO_BUTTON(nup_1up_radiobutton));
  gtk_widget_ref(nup_1up_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "nup_1up_radiobutton",
			   nup_1up_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(nup_1up_radiobutton);
  gtk_box_pack_start(GTK_BOX(vbox17), nup_1up_radiobutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(nup_1up_radiobutton), TRUE);

  /* radiobutton for choosing 2-up layout */
  nup_2up_radiobutton = gtk_radio_button_new_with_label(n_up_group, _("2-Up"));
  n_up_group = gtk_radio_button_group(GTK_RADIO_BUTTON(nup_2up_radiobutton));
  gtk_widget_ref(nup_2up_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "nup_2up_radiobutton",
			   nup_2up_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(nup_2up_radiobutton);
  gtk_box_pack_start(GTK_BOX(vbox17), nup_2up_radiobutton, FALSE, FALSE, 0);

  /* radiobutton for choosing 4-up layout */
  nup_4up_radiobutton = gtk_radio_button_new_with_label(n_up_group, _("4-Up"));
  n_up_group = gtk_radio_button_group(GTK_RADIO_BUTTON(nup_4up_radiobutton));
  gtk_widget_ref(nup_4up_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "nup_4up_radiobutton",
			   nup_4up_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(nup_4up_radiobutton);
  gtk_box_pack_start(GTK_BOX(vbox17), nup_4up_radiobutton, FALSE, FALSE, 0);

  /* signal handlers called when n-up buttons are clicked */
  gtk_signal_connect(GTK_OBJECT(nup_1up_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(update_nup_1up), (gpointer) local_ppd);

  gtk_signal_connect(GTK_OBJECT(nup_2up_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(update_nup_2up), (gpointer) local_ppd);

  gtk_signal_connect(GTK_OBJECT(nup_4up_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(update_nup_4up), (gpointer) local_ppd);

  /* Code to enable swicthing of icons */
  gtk_signal_connect_object(GTK_OBJECT(nup_1up_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_show),
			    GTK_OBJECT(nup1up_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(nup_1up_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(nup2up_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(nup_1up_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(nup4up_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(nup_2up_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_show),
			    GTK_OBJECT(nup2up_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(nup_2up_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(nup1up_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(nup_2up_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(nup4up_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(nup_4up_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_show),
			    GTK_OBJECT(nup4up_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(nup_4up_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(nup1up_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(nup_4up_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(nup2up_pixmap));

  /* a container */
  hbox17 = gtk_hbox_new(TRUE, 0);
  gtk_widget_ref(hbox17);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox17", hbox17,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox17);
  gtk_box_pack_start(GTK_BOX(vbox5), hbox17, TRUE, FALSE, 0);

  /* a container */
  hbox21 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox21);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox21", hbox21,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox21);
  gtk_box_pack_start(GTK_BOX(hbox17), hbox21, TRUE, TRUE, 0);

  /* frame around collate objects */
  collate_frame = gtk_frame_new(_("Collate"));
  gtk_widget_ref(collate_frame);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "collate_frame",
			   collate_frame, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(collate_frame);
  gtk_box_pack_start(GTK_BOX(hbox21), collate_frame, TRUE, TRUE, 0);

  /* a container */
  hbox22 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox22);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox22", hbox22,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox22);
  gtk_container_add(GTK_CONTAINER(collate_frame), hbox22);

  /* collate icon */
  collate_off_pixmap =
    create_pixmap_from_data(gpr_main_window, noncoll_xpm, FALSE);
  gtk_widget_ref(collate_off_pixmap);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "collate_off_pixmap",
			   collate_off_pixmap,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(collate_off_pixmap);
  gtk_box_pack_start(GTK_BOX(hbox22), collate_off_pixmap, TRUE, TRUE, 0);

  /* collate icon */
  collate_on_pixmap =
    create_pixmap_from_data(gpr_main_window, collate_xpm, FALSE);
  gtk_widget_ref(collate_on_pixmap);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "collate_on_pixmap",
			   collate_on_pixmap,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start(GTK_BOX(hbox22), collate_on_pixmap, TRUE, TRUE, 0);


  /* a container */
  vbox14 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox14);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox14", vbox14,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox14);
  gtk_box_pack_start(GTK_BOX(hbox22), vbox14, TRUE, TRUE, 0);

  /* radiobutton to select the collate option */
  collate_yes_radiobutton =
    gtk_radio_button_new_with_label(collate_group, _("Yes"));
  collate_group =
    gtk_radio_button_group(GTK_RADIO_BUTTON(collate_yes_radiobutton));
  gtk_widget_ref(collate_yes_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),
			   "collate_yes_radiobutton", collate_yes_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(collate_yes_radiobutton);
  gtk_box_pack_start(GTK_BOX(vbox14), collate_yes_radiobutton, FALSE, FALSE,0);

  /* radiobutton to de-select the collate option (default) */
  collate_no_radiobutton =
    gtk_radio_button_new_with_label(collate_group, _("No"));
  collate_group =
    gtk_radio_button_group(GTK_RADIO_BUTTON(collate_no_radiobutton));
  gtk_widget_ref(collate_no_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),
			   "collate_no_radiobutton", collate_no_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(collate_no_radiobutton);
  gtk_box_pack_start(GTK_BOX(vbox14), collate_no_radiobutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(collate_no_radiobutton),TRUE);

  /* signal handlers for collate choices */
  gtk_signal_connect(GTK_OBJECT(collate_yes_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(update_collate_yes),(gpointer) local_ppd);

  gtk_signal_connect(GTK_OBJECT(collate_no_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(update_collate_no), (gpointer) local_ppd);

  /* Code to enable swicthing of icons */
  gtk_signal_connect_object(GTK_OBJECT(collate_yes_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_show),
			    GTK_OBJECT(collate_on_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(collate_yes_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(collate_off_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(collate_no_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_show),
			    GTK_OBJECT(collate_off_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(collate_no_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(collate_on_pixmap));

  /* frame around reverse order objects */
  revordr_frame = gtk_frame_new(_("Reverse Order"));
  gtk_widget_ref(revordr_frame);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "revordr_frame",
			   revordr_frame, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(revordr_frame);
  gtk_box_pack_start(GTK_BOX(hbox21), revordr_frame, TRUE, TRUE, 0);

  /* a container */
  hbox23 = gtk_hbox_new(FALSE, 0);
  gtk_widget_ref(hbox23);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbox23", hbox23,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbox23);
  gtk_container_add(GTK_CONTAINER(revordr_frame), hbox23);

  /* reverse order icons */
  order_for_pixmap =
    create_pixmap_from_data(gpr_main_window, forward_xpm, FALSE);
  gtk_widget_ref(order_for_pixmap);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "order_for_pixmap",
			   order_for_pixmap,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(order_for_pixmap);
  gtk_box_pack_start(GTK_BOX(hbox23), order_for_pixmap, TRUE, TRUE, 0);

  order_rev_pixmap =
    create_pixmap_from_data(gpr_main_window, reverse_xpm, FALSE);
  gtk_widget_ref(order_rev_pixmap);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "order_rev_pixmap",
			   order_rev_pixmap,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start(GTK_BOX(hbox23), order_rev_pixmap, TRUE, TRUE, 0);

  /* a container */
  vbox15 = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(vbox15);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "vbox15", vbox15,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox15);
  gtk_box_pack_start(GTK_BOX(hbox23), vbox15, TRUE, TRUE, 0);

  /* radiobutton to enable reverse order printing */
  revordr_yes_radiobutton =
    gtk_radio_button_new_with_label(rev_order_group, _("Yes"));
  rev_order_group =
    gtk_radio_button_group(GTK_RADIO_BUTTON(revordr_yes_radiobutton));
  gtk_widget_ref(revordr_yes_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),
			   "revordr_yes_radiobutton", revordr_yes_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(revordr_yes_radiobutton);
  gtk_box_pack_start(GTK_BOX(vbox15), revordr_yes_radiobutton, FALSE, FALSE,0);

  /* radiobutton to disable reverse order printing (default) */
  revordr_no_radiobutton =
    gtk_radio_button_new_with_label(rev_order_group, _("No"));
  rev_order_group =
    gtk_radio_button_group(GTK_RADIO_BUTTON(revordr_no_radiobutton));
  gtk_widget_ref(revordr_no_radiobutton);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),
			   "revordr_no_radiobutton", revordr_no_radiobutton,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(revordr_no_radiobutton);
  gtk_box_pack_start(GTK_BOX(vbox15), revordr_no_radiobutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(revordr_no_radiobutton),TRUE);

  /* signal handlers for reverse order choices */
  gtk_signal_connect(GTK_OBJECT(revordr_yes_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(update_revordr_yes),(gpointer) local_ppd);

  gtk_signal_connect(GTK_OBJECT(revordr_no_radiobutton), "clicked",
		     GTK_SIGNAL_FUNC(update_revordr_no), (gpointer) local_ppd);
  /* Code to enable swicthing of icons */
  gtk_signal_connect_object(GTK_OBJECT(revordr_yes_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_show),
			    GTK_OBJECT(order_rev_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(revordr_yes_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(order_for_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(revordr_no_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_show),
			    GTK_OBJECT(order_for_pixmap));

  gtk_signal_connect_object(GTK_OBJECT(revordr_no_radiobutton), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(order_rev_pixmap));

  /* notebook tab 2 label */
  common_notebook_label = gtk_label_new(_("Common Options"));
  gtk_widget_ref(common_notebook_label);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),"common_notebook_label",
			   common_notebook_label,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(common_notebook_label);
  gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook1),
			     gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook1),
						       1),
			     common_notebook_label);
  /* END NOTEBOOK TAB 2 ITEMS */

  /* scrolled window for printer-specific options */
  local_ppd->opt_window = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_ref(local_ppd->opt_window);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),"local_ppd->opt_window",
			   local_ppd->opt_window,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(local_ppd->opt_window);
  gtk_container_add(GTK_CONTAINER(notebook1), local_ppd->opt_window);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(local_ppd->opt_window),
				 GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

  /* viewport for printer-specific options */
  local_ppd->opt_viewport = gtk_viewport_new(NULL, NULL);
  gtk_widget_ref(local_ppd->opt_viewport);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),
			   "local_ppd->opt_viewport", local_ppd->opt_viewport,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(local_ppd->opt_viewport);
  gtk_container_add(GTK_CONTAINER(local_ppd->opt_window),
		    local_ppd->opt_viewport);

  /* notebook 3 label */
  advanced_notebook_label = gtk_label_new(_("Printer"));
  gtk_widget_ref(advanced_notebook_label);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window),
			   "advanced_notebook_label", advanced_notebook_label,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(advanced_notebook_label);
  gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook1),
			     gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook1),
						       2),
			     advanced_notebook_label);

  /* buttonbox for "Print" and "Cancel" buttons */
  hbuttonbox1 = gtk_hbutton_box_new();
  gtk_widget_ref(hbuttonbox1);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "hbuttonbox1",
			   hbuttonbox1, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(hbuttonbox1);
  gtk_box_pack_start(GTK_BOX(vbox1), hbuttonbox1, FALSE, TRUE, 3);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox1), GTK_BUTTONBOX_END);

  /* print button */
  main_print_button = gtk_button_new_with_label(_("Print"));
  gtk_widget_ref(main_print_button);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "main_print_button",
			   main_print_button,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(main_print_button);
  gtk_container_add(GTK_CONTAINER(hbuttonbox1), main_print_button);
  GTK_WIDGET_SET_FLAGS(main_print_button, GTK_CAN_DEFAULT);

  /* cancel button */
  main_cancel_button = gnome_stock_button(GNOME_STOCK_BUTTON_CANCEL);
  gtk_widget_ref(main_cancel_button);
  gtk_object_set_data_full(GTK_OBJECT(gpr_main_window), "main_cancel_button",
			   main_cancel_button,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(main_cancel_button);
  gtk_container_add(GTK_CONTAINER(hbuttonbox1), main_cancel_button);
  GTK_WIDGET_SET_FLAGS(main_cancel_button, GTK_CAN_DEFAULT);

  /* signal handlers for print button */
  gtk_signal_connect(GTK_OBJECT(main_print_button), "clicked",
		     GTK_SIGNAL_FUNC(send_print), (gpointer) local_ppd);

  /*A Mennucc: clean up is called if and only if the program is closed*/
   gtk_signal_connect(GTK_OBJECT(main_print_button), "clicked",
		     GTK_SIGNAL_FUNC(if_no_errors_quit), NULL);
  
  /* signal handler for cancel button */
  gtk_signal_connect(GTK_OBJECT(main_cancel_button), "clicked",
		     GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

  /* signal handler for delete window event trapped from wm */
  gtk_signal_connect(GTK_OBJECT(gpr_main_window), "delete_event",
		     GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

  /* Signal handlers for ppd-file entry box. We put them down
     here because they can't be connected until after the 
     "Advanced Options" tab is created. Otherwise we'll have 
     problems initializing the ppd on startup */
  /* signal handler called when ppd_file entry is changed */
  gtk_signal_connect(GTK_OBJECT
		     (gnome_file_entry_gtk_entry
		      (GNOME_FILE_ENTRY(ppdfile_fileentry))), "activate",
		     GTK_SIGNAL_FUNC(init_ppd), (gpointer) local_ppd);

  /* 2nd signal handler called when ppd_file entry is changed */
  gtk_signal_connect_after(GTK_OBJECT
			   (gnome_file_entry_gtk_entry
			    (GNOME_FILE_ENTRY(ppdfile_fileentry))), "activate",
			   GTK_SIGNAL_FUNC(fill_option_menus),
			   (gpointer) local_ppd);

  /* now force the ppd_file entry to emit an activate signal to 
     handle inititialization * on startup */
  gtk_signal_emit_by_name(GTK_OBJECT
			  (gnome_file_entry_gtk_entry
			   (GNOME_FILE_ENTRY(ppdfile_fileentry))), "activate");

  return gpr_main_window;
}

/* Creates the Intallable Options popup window for printer 
   configuration */
GtkWidget *create_gpr_inst_options_window(ppd_struct * ppd)
{
  /* window widgets */
  GtkWidget *main_vbox;
  GtkWidget *ok_button;
  GtkWidget *main_buttonbox;
  GtkWidget *gpr_inst_options_window;

  /* local copy of ppd_struct */
  ppd_struct *local_ppd;

  local_ppd = ppd;

  /* main window */
  gpr_inst_options_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data(GTK_OBJECT(gpr_inst_options_window),
		      "gpr_inst_options_window", gpr_inst_options_window);

  /* gtk_widget_set_usize (gpr_inst_options_window, 395, 295);
     change the line below once we adjust size of viewport 
     contents */
  gtk_widget_set_usize(gpr_inst_options_window, 500, 295);
  gtk_window_set_title(GTK_WINDOW(gpr_inst_options_window),
		       _("Installable Options"));
  gtk_window_set_policy(GTK_WINDOW(gpr_inst_options_window), FALSE, FALSE,
			FALSE);

  /* a container */
  main_vbox = gtk_vbox_new(FALSE, 0);
  gtk_widget_ref(main_vbox);
  gtk_object_set_data_full(GTK_OBJECT(gpr_inst_options_window), "main_vbox",
			   main_vbox, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(main_vbox);
  gtk_container_add(GTK_CONTAINER(gpr_inst_options_window), main_vbox);

  /* installable options window */
  local_ppd->inst_opt_window = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_ref(local_ppd->inst_opt_window);
  gtk_object_set_data_full(GTK_OBJECT(gpr_inst_options_window),
			   "local_ppd->inst_opt_window",
			   local_ppd->inst_opt_window,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(local_ppd->inst_opt_window);
  // gtk_container_add (GTK_CONTAINER (gpr_inst_options_window),
  // local_ppd->inst_opt_window);
  gtk_box_pack_start(GTK_BOX(main_vbox), local_ppd->inst_opt_window, TRUE, 
		     TRUE,0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				 (local_ppd->inst_opt_window),GTK_POLICY_NEVER,
				 GTK_POLICY_AUTOMATIC);

  /* installable options viewport */
  local_ppd->inst_opt_viewport = gtk_viewport_new(NULL, NULL);
  gtk_widget_ref(local_ppd->inst_opt_viewport);
  gtk_object_set_data_full(GTK_OBJECT(gpr_inst_options_window),
			   "local_ppd->inst_opt_viewport",
			   local_ppd->inst_opt_viewport,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(local_ppd->inst_opt_viewport);
  gtk_container_add(GTK_CONTAINER(local_ppd->inst_opt_window),
		    local_ppd->inst_opt_viewport);

  /* buttonbox for "OK" button */
  main_buttonbox = gtk_hbutton_box_new();
  gtk_widget_ref(main_buttonbox);
  gtk_object_set_data_full(GTK_OBJECT(gpr_inst_options_window),
			   "main_buttonbox", main_buttonbox,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(main_buttonbox);
  gtk_box_pack_start(GTK_BOX(main_vbox), main_buttonbox, FALSE, TRUE, 0);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(main_buttonbox), GTK_BUTTONBOX_END);

  /* ok button to close window */
  ok_button = gnome_stock_button(GNOME_STOCK_BUTTON_OK);
  gtk_widget_ref(ok_button);
  gtk_object_set_data_full(GTK_OBJECT(gpr_inst_options_window), "ok_button",
			   ok_button, (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(ok_button);
  gtk_container_add(GTK_CONTAINER(main_buttonbox), ok_button);
  GTK_WIDGET_SET_FLAGS(ok_button, GTK_CAN_DEFAULT);

  /* signal handler for OK button */
  gtk_signal_connect_object(GTK_OBJECT(ok_button), "clicked",
			    GTK_SIGNAL_FUNC(gtk_widget_hide),
			    GTK_OBJECT(gpr_inst_options_window));

  /* signal handler for delete window event trapped from wm Force
     a hide instead of a delete */
  gtk_signal_connect(GTK_OBJECT(gpr_inst_options_window), "delete_event",
		     GTK_SIGNAL_FUNC(gtk_widget_hide),
		     GTK_OBJECT(gpr_inst_options_window));
  return gpr_inst_options_window;
}

/* Creates the popup dialogs which indicate that there are 
   conflicting choices */
/*A. Mennucc: when the error box is  created,
  sometimes a gtk_main_quit is immediatly following... so it is unreadable!!
  so by this simple trick, we avoid the problem
 */
int messages_refcount=0;

gboolean unref_constraint_messagebox(GtkWidget * w, gpointer  data)
{
  
  messages_refcount--;
  return FALSE;
}

GtkWidget *create_constraint_messagebox(gchar * message)
{
  /* dialog widgets */
  GtkWidget *constraint_messagebox;
  GtkWidget *dialog_vbox2;
  GtkWidget *constraint_button;
  GtkWidget *dialog_action_area2;

  /* main dialog */
  constraint_messagebox =
    gnome_message_box_new(message, GNOME_MESSAGE_BOX_WARNING, NULL);

  /*A.Mennucc*/
  messages_refcount++;
  gtk_signal_connect(GTK_OBJECT(constraint_messagebox), "close",
		     GTK_SIGNAL_FUNC(unref_constraint_messagebox), NULL);

  gtk_object_set_data(GTK_OBJECT(constraint_messagebox),
		      "constraint_messagebox", constraint_messagebox);
  gtk_window_set_policy(GTK_WINDOW(constraint_messagebox), FALSE, FALSE, 
			FALSE);
  gnome_dialog_set_close(GNOME_DIALOG(constraint_messagebox), TRUE);

  /* a container */
  dialog_vbox2 = GNOME_DIALOG(constraint_messagebox)->vbox;
  gtk_object_set_data(GTK_OBJECT(constraint_messagebox), "dialog_vbox2",
		      dialog_vbox2);
  gtk_widget_show(dialog_vbox2);

  gnome_dialog_append_button(GNOME_DIALOG(constraint_messagebox),
			     GNOME_STOCK_BUTTON_OK);

  /* OK button for constraint popup */
  constraint_button =
    g_list_last(GNOME_DIALOG(constraint_messagebox)->buttons)->data;
  gtk_widget_ref(constraint_button);
  gtk_object_set_data_full(GTK_OBJECT(constraint_messagebox),
			   "constraint_button", constraint_button,
			   (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(constraint_button);
  GTK_WIDGET_SET_FLAGS(constraint_button, GTK_CAN_DEFAULT);


  dialog_action_area2 = GNOME_DIALOG(constraint_messagebox)->action_area;
  gtk_widget_ref(dialog_action_area2);
  gtk_object_set_data_full(GTK_OBJECT(constraint_messagebox),
			   "dialog_action_area2", dialog_action_area2,
			   (GtkDestroyNotify) gtk_widget_unref);

  return constraint_messagebox;
}


/*----------------------------------------------------------------
  LPRng can be distinguished from lpr by their respective 
  responses to a bad command-line option and a null input file. 
  It would be nice if we could distinguish (via lpr) if it was 
  the hacked (-o) version or unhacked, but so far I've had no 
  luck. <-mpruett>
----------------------------------------------------------------*/
int get_spooler_type(void)
{
  FILE *fp;
  char buf[81];

  /* Open a pipe to lpr */
  fp = (FILE *) popen("lpr -= < /dev/null 2>&1", "r");
  if (fp) {
    
    fgets(buf, 80, fp);
    
    /* PDQ ("lpr" linked to "pdq") or CUPS? */
    if (strstr(buf, "Unknown option")) {
      fgets(buf, 80, fp);
      fgets(buf, 80, fp);
      /* Positive proof of PDQ ("lpr" linked to "pdq"). */
      if (strstr(buf, "[options]")) {
	return SPOOLER_PDQ;
      } else {
	/* Positive proof of CUPS. */
	return SPOOLER_CUPS;
      }
    }
    /* Positive proof of PPR ("lpr" linked to "ppr"). */
    else if (strstr(buf, "rejected")) {
      return SPOOLER_PPR;
    }
    /* Positive proof of LPRng. */
    else if (strstr(buf, "Illegal option")) {
      return SPOOLER_LPRNG;
    }
    /* Hacked or Unhacked version of lpr. */
    else if (strstr(buf, "empty input file")) {
      return SPOOLER_LPR;
    } else {
      return SPOOLER_UNKNOWN;
    }
    fclose(fp);
  } else {
    /* Open a pipe to ppr */
    fp = (FILE *) popen("ppr -= < /dev/null 2>&1", "r");
    if (fp) {
    
      fgets(buf, 50, fp);
      fclose(fp);
      return SPOOLER_PPR;
    } else {
      /* Open a pipe to pdq */
      fp = (FILE *) popen("pdq -= < /dev/null 2>&1", "r");
      if (fp) {
	
	fgets(buf, 50, fp);
	fclose(fp);
	return SPOOLER_PDQ;
      } else {
	/* Open a pipe to directomatic */
	fp = (FILE *) popen("directomatic -= < /dev/null 2>&1", "r");
	if (fp) {
    
	  fgets(buf, 50, fp);
	  fclose(fp);
	  return SPOOLER_FOOMATIC_DIRECT;
	} else {
	  return SPOOLER_UNKNOWN;
	}
      }
    }
  }
}

/*
 * Creates and displays a dialog for error messages
 */
void error_box(gchar * string)
{
  GtkWidget *error_dialog;

  error_dialog = create_constraint_messagebox(string);
  gtk_widget_show(error_dialog);
}

/*
 * BEGIN LOCAL FUNCTIONS
 */

/*
  * Read printcap to find names to fill printer menu and get 
  corresponding spool directories */
static GtkWidget *get_printer_menu(ppd_struct * ppd)
{
  char curr_line[100];		/* a line of text */
  char *end;			/* pointer to the end of a string */
  FILE *printcap;		/* file pointer to the printcap file */
  int num_printers;	    /* number of printers listedin printcap */
  char *printer_name;		/* name of a printer from printcap */
  char *spool_dir;	    /* spool directory associated with a given
			       printer */
  char *ppdfile = NULL;
  char targetstr[50];

  GtkWidget *current_printer_item = NULL;  /* menu of printers in 
					      printcap */
  GtkWidget *printer_menu; /* option menu containing list of 
			      printers */

  ppd_struct *local_ppd;	/* local copy of ppd_struct */

  /* redirect stderr to dialog */
  g_set_printerr_handler((GPrintFunc) error_box);

  local_ppd = ppd;

  printcap = fopen(PRINTCAP, "r");
  if (printcap == NULL) {
    g_printerr
      ("FATAL ERROR!\n\nCannot open %s.\n\nExit the program and ensure that a"
       "proper printcap file is present.",
       PRINTCAP);
    return NULL;
  }

  num_printers = 0;
  /* create an empty printer menu */
  printer_menu = gtk_menu_new();
  /* parse the printcap file for each printer and its spool 
     directory */
  for (;;) {
    if (fgets(curr_line, sizeof(curr_line), printcap) == NULL)	
      /* end of file */
      break;
    if (curr_line[0] == '#')	/* a printcap comment */
      continue;
    else if (curr_line[0] == 10)	/* a newline */
      continue;
    else if ((curr_line[0] == 9) || (curr_line[0] == 32)
	     || (curr_line[0] == 58)) {	/* space,tab or colon */
      if (num_printers == 0)
	continue;
      else {
	/* See if this entry is a spool_directory. */
	spool_dir = strstr(curr_line, ":sd");
	if (spool_dir != NULL) {
	  spool_dir = spool_dir + 4;	/* move 4 spaces to the right */
	  end = strchr(spool_dir, ':');
	  if(end)
	    *end = '\0';
	  else {
	    g_warning("\
The file /etc/printcap is not conformant. As 'man 5 termcap' tells,\n\
       Termcap  entries must be defined on a single logical line,\n\
       with `\\' used to suppress the newline.  Fields  are  sepa\n\
       rated by `:'.  The first field of each entry starts at the\n\
       left-hand margin, and contains a list  of  names  for  the\n\
       terminal, separated by '|'.\n\
It is actually customary to have one field for line, and to have ':\\'\n\
before the newline. gpr may have failed in parsing your /etc/printcap"); 
	    end = strchr(spool_dir, '\n');
	    if(end)
	      *end = '\0';
	  }

	  if (local_ppd->spool_dir == NULL)
	    local_ppd->spool_dir = g_strdup(spool_dir);

	  gtk_object_set_data(GTK_OBJECT(current_printer_item), SD,
			      g_strdup(spool_dir));
	} else {
	  strcpy(targetstr, ":ppdfile");
	  ppdfile = strstr(curr_line, targetstr);
	  if (ppdfile) {
	    ppdfile = ppdfile + strlen(targetstr) + 1;
	    end = strchr(ppdfile, ':');
	    if(end)
	      end[0] = '\0';

	    gtk_object_set_data(GTK_OBJECT(current_printer_item), PF,
				g_strdup(ppdfile));
	  }
	}

	if (spool_dir == NULL)
	  continue;
      }
    } else {/* only thing left is the printer's name */
      printer_name = curr_line;
      /* patch suggested by Dr. Sebastian Bunka to allow for 
	 multiple entries on one line Check to see if there is a 
	 '|' and take the first printer in the list of aliases  */
      if (strchr(printer_name, '|'))
	end = strchr(printer_name, '|');
      else
	/* now back to the original code */
	end = strchr(printer_name, ':');
      if(end)
	*end = '\0';
      else
	g_warning("\
The file /etc/printcap is not conformant. As 'man 5 termcap' tells,\n\
       Termcap  entries must be defined on a single logical line,\n\
       with `\\' used to suppress the newline.  Fields  are  sepa\n\
       rated by `:'.  The first field of each entry starts at the\n\
       left-hand margin, and contains a list  of  names  for  the\n\
       terminal, separated by '|'.\n\
It is actually customary to have one field for line, and to have ':\\'\n\
before the newline. gpr may have failed in parsing your /etc/printcap"); 

      current_printer_item = gtk_menu_item_new_with_label(printer_name);
      gtk_menu_append(GTK_MENU(printer_menu), current_printer_item);

      /* store the printer name string with the menu item for easy
	 retrieval later */
      gtk_object_set_data(GTK_OBJECT(current_printer_item), PN,
			  g_strdup(printer_name));
      /* deal with command-line options */
      if (local_ppd->printer_name == NULL)
	local_ppd->printer_name = g_strdup(printer_name);
      else if (strcmp(local_ppd->printer_name, printer_name)
	       == 0)
	gtk_menu_set_active(GTK_MENU(printer_menu), num_printers);

      gtk_widget_show(current_printer_item);

      /* call 3 functions each time a new printer is selected */
      gtk_signal_connect(GTK_OBJECT(current_printer_item), "activate",
			 GTK_SIGNAL_FUNC(set_printer_name),
			 (gpointer) local_ppd);

      gtk_signal_connect(GTK_OBJECT(current_printer_item), "activate",
			 GTK_SIGNAL_FUNC(set_spool_dir), (gpointer) local_ppd);

      gtk_signal_connect_after(GTK_OBJECT(current_printer_item), "activate",
			       GTK_SIGNAL_FUNC(grab_default_ppd),
			       (gpointer) local_ppd);

      ++num_printers;
    }
  }
  fclose(printcap);
  return (printer_menu);
}

/*----------------------------------------------------------------
  MLP
  TJH -  Can't move this to callabcks.c until we determine what 
  to do with the global.
----------------------------------------------------------------*/
static void fileentry_combo_popdown(GtkWidget * fileentry, ppd_struct * ppd)
{
  ppd_struct *local_ppd;	/* local copy of ppd struct */

  local_ppd = ppd;
  grab_ppd_file(GTK_ENTRY(GLOBAL_ppdfile_fileentry), (gpointer) local_ppd);
  init_ppd(NULL, (gpointer) local_ppd);
  fill_option_menus(NULL, (gpointer) local_ppd);
  return;

}

/* A tooltip helper function. Taken from Havoc Pennington's GGAD 
   book */
/* static void set_tooltip(GtkWidget * w, const gchar * tip){ */
/*   GtkTooltips *t = gtk_tooltips_new(); */

/*   gtk_tooltips_set_tip(t, w, tip, NULL); */
/* } */
// doesn't seem to be used anywhere. -ben 11-21-2001


