/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  engine-panel.c: Graphical control panel for the tracking engine.

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/
#include <gnome.h>
#include <gconf/gconf-client.h>
#include <libgnomeui/gnome-window-icon.h>
#include "satdata.h"  /* FIXME: nedded by engine.h? */
#include "engine.h"
#include "engine-panel.h"

#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif


/* control panel window */
static GtkWidget *window = NULL;

/* buttons */
static GtkWidget *forw,*bakw,*stop,*ffw,*fbw;


gint
engine_panel_open ()
{
	/* This function creates and opens a new control panel
	   window for the tracking engine.
	*/
	GtkWidget *hbox;

	if (window)
		return FALSE;

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (window), _("Engine Controls"));

	/* create buttons */

	/* Fast backwards */
	fbw = gtk_button_new ();
	gtk_container_add (GTK_CONTAINER (fbw),
			   gnome_stock_pixmap_widget (window, GNOME_STOCK_PIXMAP_FIRST));

	/* Backwards */
	bakw = gtk_button_new ();
	gtk_container_add (GTK_CONTAINER (bakw),
			   gnome_stock_pixmap_widget (window, GNOME_STOCK_PIXMAP_BACK));

	/* Stop button */
	stop = gtk_button_new ();
	gtk_container_add (GTK_CONTAINER (stop),
			   gnome_stock_pixmap_widget (window, GNOME_STOCK_PIXMAP_STOP));

	/* Forward */
	forw = gtk_button_new ();
	gtk_container_add (GTK_CONTAINER (forw),
			   gnome_stock_pixmap_widget (window, GNOME_STOCK_PIXMAP_FORWARD));

	/* Fast backwards */
	ffw = gtk_button_new ();
	gtk_container_add (GTK_CONTAINER (ffw),
			   gnome_stock_pixmap_widget (window, GNOME_STOCK_PIXMAP_LAST));

	/* horizontal box */
	hbox = gtk_hbox_new (TRUE, 0);
	gtk_box_pack_start_defaults (GTK_BOX (hbox), fbw);
	gtk_box_pack_start_defaults (GTK_BOX (hbox), bakw);
	gtk_box_pack_start_defaults (GTK_BOX (hbox), stop);
	gtk_box_pack_start_defaults (GTK_BOX (hbox), forw);
	gtk_box_pack_start_defaults (GTK_BOX (hbox), ffw);

	gtk_container_add (GTK_CONTAINER (window), hbox);

	gtk_widget_show_all (window);

	return TRUE;
}


void
engine_panel_close ()
{
	/* This function deletes and destroys the control panel
	   window.
	*/

}
