/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*

  qth.h:  Groundstation related stuff.

  Copyright (C)  2001-2003  Alexandru Csete.

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef QTH_H
#define QTH_H

/* append the id to this one... */
#define QTH_ROOT_PATH "/apps/gpredict/qth"

/* The zero'th QTH will have keys: QTH_ROOT_PATH/qth0_name, 
   QTH_ROOT_PATH/qth0.location and so on.
*/


typedef struct _qth_struc {
	gchar  *name;    /* Name eg. Callsign */
	gchar  *loc;     /* Location */
	gchar  *desc;    /* Short description */
	gchar  *qra;     /* QRA Locator */
	gchar  *wx;      /* weather station */
	gfloat  lat;     /* Lattitude */
	gfloat  lon;     /* Longitude */
	gint    alt;     /* Altitude */
} qth_struc;


gint qth_init_old (void);
gint qth_init (void);
void qth_close (void);

#endif
