/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  satmap.h: Graphical visualization module for Gnome Predict showing
            selected satellites on a map.


  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef SATMAP_H
#define SATMAP_H

#include <gconf/gconf-client.h>


/* Please ignore the next line ... */
#define MAPFILE "earth_800.jpg"
#define SATMAP_DEF_TIMER        5000    /* satmap updates */

/* The satmap-druid will issue a warning when the
   number of satellites is greater than this number.
   (Bug #555595)
*/
#define SATMAP_TOO_MANY_SATS 10


/* GConf paths */
#define SATMAP_ROOT_PATH   "/apps/gpredict/satmap"
#define SATMAP_TIMER_PATH  "/apps/gpredict/satmap/timer"
#define SATMAP_DEFMAP_PATH "/apps/gpredict/satmap/default_map"

/* Paths to gnome-config values */
#define SATMAP_SAT_LIST_PATH "/misc/satellites"
#define SATMAP_SAT_MAP_PATH  "/misc/map"

#define SATMAP_RANGE_CIRCLE_POINTS 180 /* one for each degree */

#define SATMAP_CANVAS_EXTRA_W  2   /*  CANVAS_WIDTH = MAP_WIDTH  + SATMAP_CANVAS_EXTRA_W */
#define SATMAP_CANVAS_EXTRA_H  30  /* CANVAS_HEIGHT = MAP_HEIGHT + SATMAP_CANVAS_EXTRA_H */

/* map preview size */
#define PREVIEW_SIZE_X 140
#define PREVIEW_SIZE_Y 70

/* ASCII code for degree sign */
#define SATMAP_DEGREE 176


/* convert lat/lon to canvas coordinates - OBSOLETED BY satmap_cx() and satmap_cy() */
/* #define CX(lon) ((180.0-lon)*SATMAP_MAP_WIDTH/360.0) */
/* #define CY(lat) ((90.0-lat)*SATMAP_MAP_HEIGHT/180.0) */


struct satmap_sat_struc {
	gchar *name;                 /* satellite name -> move to canvas item? */
	guint32 catnum;              /* catalog number */
	gint index;                  /* index in database */
	GnomeCanvasItem *group;      /* Canvas group (satellite) */
	GnomeCanvasItem *mark;       /* Satellite mark canvas item */
	GnomeCanvasItem *text;       /* Satellite name canvas item */
	GnomeCanvasItem *range[2*SATMAP_RANGE_CIRCLE_POINTS];      /* Range circle */
};

typedef struct satmap_sat_struc satmap_sat_t;

#define SATMAP_SAT(x) ((satmap_sat_t *)x)

void satmap_open_cb     (GtkWidget *, gpointer);
gint satmap_open        (gchar *, gboolean);

#endif
