/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  menubar.c: Menubar for Gnome Predict.

  Copyright (C)  2001-2005  Alexandru Csete.

  Authors:  Alexandru Csete <csete@users.sourceforge.net>


  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#include <gnome.h>
#include "satlog.h"
#include "satpref.h"
#include "satlist.h"
#include "satmap.h"
#include "satupdate.h"
#include "callbacks.h"

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif


GnomeUIInfo file_menu_new[] = {
	GNOMEUIINFO_ITEM_NONE (N_(" _List"),
			       N_("Create a new list"),
			       satlist_open_cb),
	GNOMEUIINFO_ITEM_NONE (N_(" _Map"),
			       N_("Create a new map"),
			       satmap_open_cb),
/* 	GNOMEUIINFO_ITEM_NONE (_(" _Skyview"), */
/* 			       _("Create a new sky view"), */
/* 			       not_finished), */
/* 	GNOMEUIINFO_ITEM_NONE (_(" S_atview"), */
/* 			       _("Create a new satellite view"), */
/* 			       not_finished), */
	GNOMEUIINFO_END
};


GnomeUIInfo file_menu_open[] = {
	GNOMEUIINFO_ITEM_NONE (N_(" _List"),
			       N_("Open an existing list"),
			       not_finished),
	GNOMEUIINFO_ITEM_NONE (N_(" _Map"),
			       N_("Open an existing map"),
			       not_finished),
/* 	GNOMEUIINFO_ITEM_NONE (_(" _Skyview"), */
/* 			       _("Open an existing sky view"), */
/* 			       not_finished), */
/* 	GNOMEUIINFO_ITEM_NONE (_(" S_atview"), */
/* 			       _("Open an existing satellite view"), */
/* 			       not_finished), */
	GNOMEUIINFO_END
};


/* File menu declaration */
GnomeUIInfo file_menu[] = {
	GNOMEUIINFO_SUBTREE_STOCK (N_(" _New"),
				   file_menu_new,
				   GNOME_STOCK_PIXMAP_NEW ),
	GNOMEUIINFO_SUBTREE_STOCK (N_(" _Open"),
				   file_menu_open,
				   GNOME_STOCK_PIXMAP_OPEN ),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_EXIT_ITEM (gtk_main_quit, NULL),
	GNOMEUIINFO_END
};


/* Satlist menu declaration */
GnomeUIInfo edit_menu[] = {
	GNOMEUIINFO_ITEM_STOCK (N_(" _Preferences"),
				NULL,
				satpref_open_cb,
				GNOME_STOCK_PIXMAP_PREFERENCES ),
	GNOMEUIINFO_ITEM_NONE (N_(" Show _Messages"),
			       N_("Open Message Window"),
			       satlog_show ),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_STOCK (N_(" _Update TLE"),
				NULL,
				satupdate_start_cb,
				GNOME_STOCK_PIXMAP_REFRESH),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_STOCK (N_(" _Stop Engine"),
				N_("Stop Tracking Engine"),
				timer_stop_callback,
				GNOME_STOCK_PIXMAP_STOP ),
	GNOMEUIINFO_ITEM_STOCK (N_(" Start _Engine"),
				N_("Start tracking Engine"),
				timer_start_callback,
				GNOME_STOCK_PIXMAP_FORWARD ),
	GNOMEUIINFO_END
};

/* Client menu declaration */
GnomeUIInfo predict_menu[] = {
	GNOMEUIINFO_ITEM_STOCK (N_(" _Predict Passes"),
				N_("Predict Satellite Passes"),
				timer_stop_callback,
				GNOME_STOCK_PIXMAP_ALIGN_JUSTIFY ),
	GNOMEUIINFO_END
};

/* Help menu declaration */
GnomeUIInfo help_menu[] = {
	GNOMEUIINFO_HELP ("gpredict"),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_ABOUT_ITEM (about_callback, NULL),
	GNOMEUIINFO_END
};

/* MENUBAR */
GnomeUIInfo menubar[] = {
	GNOMEUIINFO_MENU_FILE_TREE (file_menu),
	GNOMEUIINFO_SUBTREE (N_("_Edit"), edit_menu),
/*	GNOMEUIINFO_SUBTREE ("_Predict", predict_menu),	*/
	GNOMEUIINFO_MENU_HELP_TREE (help_menu),
	GNOMEUIINFO_END
};
