/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  rotlist-util.c:  Utility functions for obtaining a list of available
                   rotator drivers in hamlib.

  Copyright (C)  2001-2005  Alexandru Csete.

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/
#ifdef HAVE_CONFIG_H
#  include "../config.h"
#endif

/* leave file empty if we don't have hamlib */
#if defined (HAVE_HAMLIB)

#include <glib.h>
#include "rotlist-util.h"


#include <hamlib/rotator.h>
/* Do we need rotlist.h at all? */
#include <hamlib/rotlist.h>


gint rotlist_make_list (const struct rot_caps *, gpointer);


/* does it have to be global */
static GSList *rotlist = NULL;


GSList *rotlist_get_list ()
{
	/* This function returns a list with available
	   drivers from hamlib. The returned list is a
	   newly allocated singly linked GSList which
	   should be freed with g_slist_free() when no
	   longer needed.
	*/

	gint status;

	if (!rotlist) {
		rot_load_all_backends ();
		status = rot_list_foreach (rotlist_make_list, NULL);
	}

	return rotlist;
}




gint rotlist_make_list (const struct rot_caps *caps, gpointer data)
{
	/* This function appends a new entry in the driver
	   list. It is called by the rig_list_foreach()
	   function from hamlib.
	*/
	rotlist = g_slist_append (rotlist, (gpointer) caps);

	return 1;
}

#endif /* HAVE_HAMLIB */
